/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.r8.ir.code;

import com.android.tools.r8.cf.LoadStoreHelper;
import com.android.tools.r8.cf.TypeVerificationHelper;
import com.android.tools.r8.errors.Unreachable;
import com.android.tools.r8.graph.AppView;
import com.android.tools.r8.graph.DexType;
import com.android.tools.r8.graph.ProgramMethod;
import com.android.tools.r8.ir.analysis.type.TypeElement;
import com.android.tools.r8.ir.code.IRCode;
import com.android.tools.r8.ir.code.Instruction;
import com.android.tools.r8.ir.code.InstructionIterator;
import com.android.tools.r8.ir.code.InstructionListIterator;
import com.android.tools.r8.ir.code.InstructionVisitor;
import com.android.tools.r8.ir.code.Phi;
import com.android.tools.r8.ir.code.Value;
import com.android.tools.r8.ir.conversion.CfBuilder;
import com.android.tools.r8.ir.conversion.DexBuilder;
import com.android.tools.r8.ir.optimize.DeadCodeRemover;
import com.android.tools.r8.ir.optimize.Inliner;
import com.android.tools.r8.ir.optimize.InliningConstraints;
import java.util.Set;

public class Argument
extends Instruction {
    private final int index;
    private final boolean knownToBeBoolean;

    public Argument(Value outValue, int index, boolean knownToBeBoolean) {
        super(outValue);
        this.index = index;
        this.knownToBeBoolean = knownToBeBoolean;
    }

    public static Builder builder() {
        return new Builder();
    }

    private int getIndex(boolean verifyIndex) {
        assert (!verifyIndex || this.verifyIndex());
        return this.index;
    }

    private boolean verifyIndex() {
        int index = 0;
        InstructionIterator instructionIterator = this.getBlock().iterator();
        while (instructionIterator.hasNext()) {
            Instruction instruction = (Instruction)instructionIterator.next();
            assert (instruction.isArgument());
            if (instruction == this) {
                assert (index == this.index);
                return true;
            }
            ++index;
        }
        return false;
    }

    public int getIndex() {
        return this.getIndex(true);
    }

    public int getIndexRaw() {
        return this.getIndex(false);
    }

    @Override
    public int opcode() {
        return 5;
    }

    @Override
    public <T> T accept(InstructionVisitor<T> visitor) {
        return visitor.visit(this);
    }

    @Override
    public DeadCodeRemover.DeadInstructionResult canBeDeadCode(AppView<?> appview, IRCode code) {
        return DeadCodeRemover.DeadInstructionResult.notDead();
    }

    @Override
    public int maxInValueRegister() {
        assert (false) : "Argument has no register arguments.";
        return 0;
    }

    @Override
    public int maxOutValueRegister() {
        return 65535;
    }

    @Override
    public void buildDex(DexBuilder builder) {
        builder.addArgument(this);
    }

    @Override
    public boolean identicalNonValueNonPositionParts(Instruction other) {
        return other.isArgument();
    }

    @Override
    public boolean isArgument() {
        return true;
    }

    @Override
    public Argument asArgument() {
        return this;
    }

    @Override
    public Inliner.ConstraintWithTarget inliningConstraint(InliningConstraints inliningConstraints, ProgramMethod context) {
        return inliningConstraints.forArgument();
    }

    @Override
    public void insertLoadAndStores(InstructionListIterator it, LoadStoreHelper helper) {
    }

    @Override
    public DexType computeVerificationType(AppView<?> appView, TypeVerificationHelper helper) {
        throw new Unreachable();
    }

    @Override
    public void buildCf(CfBuilder builder) {
        builder.addArgument(this);
    }

    @Override
    public TypeElement evaluate(AppView<?> appView) {
        return this.outValue.getType();
    }

    @Override
    public boolean hasInvariantOutType() {
        return true;
    }

    @Override
    public boolean outTypeKnownToBeBoolean(Set<Phi> seen) {
        return this.knownToBeBoolean;
    }

    @Override
    public boolean instructionMayTriggerMethodInvocation(AppView<?> appView, ProgramMethod context) {
        return false;
    }

    public static class Builder
    extends Instruction.BuilderBase<Builder, Argument> {
        private int index;
        private boolean knownToBeBoolean;

        public Builder setIndex(int index) {
            this.index = index;
            return this;
        }

        @Override
        public Argument build() {
            return this.amend(new Argument(this.outValue, this.index, this.knownToBeBoolean));
        }

        @Override
        public Builder self() {
            return this;
        }
    }
}

