/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.r8.ir.code;

import com.android.tools.r8.cf.LoadStoreHelper;
import com.android.tools.r8.cf.TypeVerificationHelper;
import com.android.tools.r8.cf.code.CfArrayLoad;
import com.android.tools.r8.cf.code.CfInstruction;
import com.android.tools.r8.code.Aget;
import com.android.tools.r8.code.AgetBoolean;
import com.android.tools.r8.code.AgetByte;
import com.android.tools.r8.code.AgetChar;
import com.android.tools.r8.code.AgetObject;
import com.android.tools.r8.code.AgetShort;
import com.android.tools.r8.code.AgetWide;
import com.android.tools.r8.code.Format23x;
import com.android.tools.r8.errors.CompilationError;
import com.android.tools.r8.errors.Unreachable;
import com.android.tools.r8.graph.AppView;
import com.android.tools.r8.graph.DexItemFactory;
import com.android.tools.r8.graph.DexType;
import com.android.tools.r8.graph.ProgramMethod;
import com.android.tools.r8.ir.analysis.type.ArrayTypeElement;
import com.android.tools.r8.ir.analysis.type.TypeElement;
import com.android.tools.r8.ir.analysis.value.AbstractValue;
import com.android.tools.r8.ir.code.ArrayAccess;
import com.android.tools.r8.ir.code.Instruction;
import com.android.tools.r8.ir.code.InstructionListIterator;
import com.android.tools.r8.ir.code.InstructionVisitor;
import com.android.tools.r8.ir.code.MemberType;
import com.android.tools.r8.ir.code.Phi;
import com.android.tools.r8.ir.code.Value;
import com.android.tools.r8.ir.code.ValueTypeConstraint;
import com.android.tools.r8.ir.conversion.CfBuilder;
import com.android.tools.r8.ir.conversion.DexBuilder;
import com.android.tools.r8.ir.conversion.MethodConversionOptions;
import com.android.tools.r8.ir.conversion.TypeConstraintResolver;
import com.android.tools.r8.ir.optimize.Inliner;
import com.android.tools.r8.ir.optimize.InliningConstraints;
import com.android.tools.r8.ir.regalloc.RegisterAllocator;
import java.util.Arrays;
import java.util.Set;

public class ArrayGet
extends ArrayAccess {
    private MemberType type;

    public ArrayGet(MemberType type, Value dest, Value array, Value index) {
        super(dest, Arrays.asList(array, index));
        this.type = type;
    }

    private static TypeElement checkConstraint(Value value, ValueTypeConstraint constraint) {
        TypeElement latticeElement = value.constrainedType(constraint);
        if (latticeElement != null) {
            return latticeElement;
        }
        throw new CompilationError("Failure to constrain value: " + value + " by constraint: " + (Object)((Object)constraint));
    }

    @Override
    public int opcode() {
        return 6;
    }

    @Override
    public <T> T accept(InstructionVisitor<T> visitor) {
        return visitor.visit(this);
    }

    public Value dest() {
        return this.outValue;
    }

    @Override
    public MemberType getMemberType() {
        return this.type;
    }

    @Override
    public boolean couldIntroduceAnAlias(AppView<?> appView, Value root) {
        assert (root != null && root.getType().isReferenceType());
        assert (this.outValue != null);
        return this.outValue.getType().isReferenceType();
    }

    @Override
    public void buildDex(DexBuilder builder) {
        Format23x instruction;
        int dest = builder.allocatedRegister(this.dest(), this.getNumber());
        int array = builder.allocatedRegister(this.array(), this.getNumber());
        int index = builder.allocatedRegister(this.index(), this.getNumber());
        switch (this.type) {
            case INT: 
            case FLOAT: {
                instruction = new Aget(dest, array, index);
                break;
            }
            case LONG: 
            case DOUBLE: {
                assert (builder.getOptions().canUseSameArrayAndResultRegisterInArrayGetWide() || dest != array);
                instruction = new AgetWide(dest, array, index);
                break;
            }
            case OBJECT: {
                instruction = new AgetObject(dest, array, index);
                break;
            }
            case BOOLEAN_OR_BYTE: {
                ArrayTypeElement arrayType = this.array().getType().asArrayType();
                if (arrayType != null && arrayType.getMemberType() == TypeElement.getBoolean()) {
                    instruction = new AgetBoolean(dest, array, index);
                    break;
                }
                assert (this.array().getType().isDefinitelyNull() || arrayType.getMemberType() == TypeElement.getByte());
                instruction = new AgetByte(dest, array, index);
                break;
            }
            case CHAR: {
                instruction = new AgetChar(dest, array, index);
                break;
            }
            case SHORT: {
                instruction = new AgetShort(dest, array, index);
                break;
            }
            case INT_OR_FLOAT: 
            case LONG_OR_DOUBLE: {
                throw new Unreachable("Unexpected imprecise type: " + (Object)((Object)this.type));
            }
            default: {
                throw new Unreachable("Unexpected type " + (Object)((Object)this.type));
            }
        }
        builder.add((Instruction)this, (com.android.tools.r8.code.Instruction)instruction);
    }

    @Override
    public boolean identicalAfterRegisterAllocation(Instruction other, RegisterAllocator allocator, MethodConversionOptions conversionOptions) {
        return false;
    }

    @Override
    public boolean identicalNonValueNonPositionParts(Instruction other) {
        return other.isArrayGet() && other.asArrayGet().type == this.type;
    }

    @Override
    public int maxInValueRegister() {
        return 255;
    }

    @Override
    public int maxOutValueRegister() {
        return 255;
    }

    @Override
    public boolean isArrayGet() {
        return true;
    }

    @Override
    public ArrayGet asArrayGet() {
        return this;
    }

    @Override
    public Inliner.ConstraintWithTarget inliningConstraint(InliningConstraints inliningConstraints, ProgramMethod context) {
        return inliningConstraints.forArrayGet();
    }

    @Override
    public boolean hasInvariantOutType() {
        return false;
    }

    @Override
    public DexType computeVerificationType(AppView<?> appView, TypeVerificationHelper helper) {
        assert (this.outValue.getType().isReferenceType());
        DexType arrayType = helper.getDexType(this.array());
        if (arrayType == DexItemFactory.nullValueType) {
            return arrayType;
        }
        return arrayType.toArrayElementType(appView.dexItemFactory());
    }

    @Override
    public void insertLoadAndStores(InstructionListIterator it, LoadStoreHelper helper) {
        helper.loadInValues(this, it);
        helper.storeOutValue(this, it);
    }

    @Override
    public void buildCf(CfBuilder builder) {
        builder.add((CfInstruction)new CfArrayLoad(this.type), this);
    }

    @Override
    public TypeElement evaluate(AppView<?> appView) {
        ArrayTypeElement arrayTypeLattice = this.array().getType().isArrayType() ? this.array().getType().asArrayType() : null;
        switch (this.getMemberType()) {
            case OBJECT: {
                TypeElement valueType;
                TypeElement typeElement = valueType = arrayTypeLattice == null ? TypeElement.getNull() : arrayTypeLattice.getMemberTypeAsValueType();
                assert (valueType.isReferenceType());
                return valueType;
            }
            case INT: 
            case BOOLEAN_OR_BYTE: 
            case CHAR: 
            case SHORT: {
                assert (arrayTypeLattice == null || arrayTypeLattice.getMemberTypeAsValueType().isInt());
                return TypeElement.getInt();
            }
            case FLOAT: {
                assert (arrayTypeLattice == null || arrayTypeLattice.getMemberTypeAsValueType().isFloat());
                return TypeElement.getFloat();
            }
            case LONG: {
                assert (arrayTypeLattice == null || arrayTypeLattice.getMemberTypeAsValueType().isLong());
                return TypeElement.getLong();
            }
            case DOUBLE: {
                assert (arrayTypeLattice == null || arrayTypeLattice.getMemberTypeAsValueType().isDouble());
                return TypeElement.getDouble();
            }
            case INT_OR_FLOAT: {
                assert (arrayTypeLattice == null || arrayTypeLattice.getMemberTypeAsValueType().isSinglePrimitive());
                return ArrayGet.checkConstraint(this.dest(), ValueTypeConstraint.INT_OR_FLOAT);
            }
            case LONG_OR_DOUBLE: {
                assert (arrayTypeLattice == null || arrayTypeLattice.getMemberTypeAsValueType().isWidePrimitive());
                return ArrayGet.checkConstraint(this.dest(), ValueTypeConstraint.LONG_OR_DOUBLE);
            }
        }
        throw new Unreachable("Unexpected member type: " + (Object)((Object)this.getMemberType()));
    }

    @Override
    public boolean throwsNpeIfValueIsNull(Value value, AppView<?> appView, ProgramMethod context) {
        return this.array() == value;
    }

    @Override
    public boolean throwsOnNullInput() {
        return true;
    }

    @Override
    public Value getNonNullInput() {
        return this.array();
    }

    @Override
    public boolean outTypeKnownToBeBoolean(Set<Phi> seen) {
        return this.array().getType().isArrayType() && this.array().getType().asArrayType().getMemberType() == TypeElement.getBoolean();
    }

    @Override
    public void constrainType(TypeConstraintResolver constraintResolver) {
        constraintResolver.constrainArrayMemberType(this.type, this.dest(), this.array(), t -> {
            this.type = t;
        });
    }

    @Override
    public boolean instructionMayTriggerMethodInvocation(AppView<?> appView, ProgramMethod context) {
        return false;
    }

    @Override
    public ArrayAccess withMemberType(MemberType newMemberType) {
        return new ArrayGet(newMemberType, this.outValue(), this.array(), this.index());
    }

    @Override
    public boolean instructionMayHaveSideEffects(AppView<?> appView, ProgramMethod context, Instruction.SideEffectAssumption assumption) {
        if (this.array().isPhi() || !this.index().isConstant()) {
            return true;
        }
        AbstractValue abstractValue = this.array().getAliasedValue().getAbstractValue(appView, context);
        if (!abstractValue.hasKnownArrayLength()) {
            return true;
        }
        int newArraySize = abstractValue.getKnownArrayLength();
        int index = this.index().getConstInstruction().asConstNumber().getIntValue();
        return newArraySize <= 0 || index < 0 || newArraySize <= index;
    }
}

