/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.r8.ir.code;

import com.android.tools.r8.graph.DexMethod;
import com.android.tools.r8.ir.code.Position;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Supplier;

public class CanonicalPositions {
    private final Position callerPosition;
    private final Map<Position, Position> canonicalPositions;
    private final Position preamblePosition;
    private final boolean isCompilerSynthesizedInlinee;
    private Position syntheticPosition;

    public CanonicalPositions(Position callerPosition, int expectedPositionsCount, DexMethod method, boolean methodIsSynthesized) {
        this.canonicalPositions = new HashMap<Position, Position>(1 + (callerPosition == null ? 0 : 1) + expectedPositionsCount);
        if (callerPosition != null) {
            this.callerPosition = this.getCanonical(callerPosition);
            this.isCompilerSynthesizedInlinee = methodIsSynthesized;
            this.preamblePosition = methodIsSynthesized ? callerPosition : this.getCanonical(((Position.SourcePosition.SourcePositionBuilder)((Position.SourcePosition.SourcePositionBuilder)((Position.SourcePosition.SourcePositionBuilder)Position.SourcePosition.builder().setLine(0)).setMethod(method)).setCallerPosition(callerPosition)).build());
        } else {
            this.callerPosition = null;
            this.isCompilerSynthesizedInlinee = false;
            this.preamblePosition = this.getCanonical(((Position.SyntheticPosition.SyntheticPositionBuilder)((Position.SyntheticPosition.SyntheticPositionBuilder)Position.SyntheticPosition.builder().setLine(0)).setMethod(method)).build());
        }
    }

    public Position getPreamblePosition() {
        return this.preamblePosition;
    }

    public Position getCanonical(Position position) {
        Position canonical = this.canonicalPositions.putIfAbsent(position, position);
        return canonical != null ? canonical : position;
    }

    public Position canonicalizeCallerPosition(Position caller) {
        if (caller == null) {
            return this.callerPosition;
        }
        if (caller.callerPosition == null && this.callerPosition == null) {
            return this.getCanonical(caller);
        }
        if (caller.callerPosition == null && this.isCompilerSynthesizedInlinee) {
            return this.callerPosition;
        }
        Position callerOfCaller = this.canonicalizeCallerPosition(caller.callerPosition);
        return this.getCanonical(caller.isNone() ? ((Position.SourcePosition.SourcePositionBuilder)((Position.SourcePosition.SourcePositionBuilder)((Position.SourcePosition.SourcePositionBuilder)Position.SourcePosition.builder().setMethod(caller.method)).setCallerPosition(callerOfCaller)).disableLineCheck()).build() : ((Position.PositionBuilder)caller.builderWithCopy().setCallerPosition(callerOfCaller)).build());
    }

    public Position getExceptionalExitPosition(boolean debug, Supplier<Iterable<Position>> positions, DexMethod originalMethod) {
        if (this.syntheticPosition == null) {
            if (debug) {
                int min2 = Integer.MAX_VALUE;
                int max = Integer.MIN_VALUE;
                for (Position position : positions.get()) {
                    assert (position == position.getOutermostCaller());
                    int line = position.line;
                    min2 = Math.min(min2, line);
                    max = Math.max(max, line);
                }
                this.syntheticPosition = min2 == Integer.MAX_VALUE ? this.getPreamblePosition() : ((Position.SyntheticPosition.SyntheticPositionBuilder)((Position.SyntheticPosition.SyntheticPositionBuilder)((Position.SyntheticPosition.SyntheticPositionBuilder)Position.SyntheticPosition.builder().setLine(min2 < max ? min2 - 1 : min2)).setMethod(originalMethod)).setCallerPosition(this.callerPosition)).build();
            } else {
                this.syntheticPosition = Position.syntheticNone();
            }
        }
        return this.syntheticPosition;
    }
}

