/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.r8.ir.code;

import com.android.tools.r8.cf.LoadStoreHelper;
import com.android.tools.r8.cf.TypeVerificationHelper;
import com.android.tools.r8.cf.code.CfCheckCast;
import com.android.tools.r8.cf.code.CfInstruction;
import com.android.tools.r8.code.MoveObject;
import com.android.tools.r8.code.MoveObjectFrom16;
import com.android.tools.r8.graph.AccessControl;
import com.android.tools.r8.graph.AppInfo;
import com.android.tools.r8.graph.AppView;
import com.android.tools.r8.graph.DexClass;
import com.android.tools.r8.graph.DexType;
import com.android.tools.r8.graph.ProgramMethod;
import com.android.tools.r8.ir.analysis.VerifyTypesHelper;
import com.android.tools.r8.ir.analysis.type.ClassTypeElement;
import com.android.tools.r8.ir.analysis.type.Nullability;
import com.android.tools.r8.ir.analysis.type.TypeElement;
import com.android.tools.r8.ir.code.Instruction;
import com.android.tools.r8.ir.code.InstructionListIterator;
import com.android.tools.r8.ir.code.InstructionVisitor;
import com.android.tools.r8.ir.code.Value;
import com.android.tools.r8.ir.conversion.CfBuilder;
import com.android.tools.r8.ir.conversion.DexBuilder;
import com.android.tools.r8.ir.optimize.Inliner;
import com.android.tools.r8.ir.optimize.InliningConstraints;
import com.android.tools.r8.shaking.AppInfoWithLiveness;
import com.android.tools.r8.utils.InternalOptions;

public class CheckCast
extends Instruction {
    private final DexType type;
    private final boolean ignoreCompatRules;

    public CheckCast(Value dest, Value value, DexType type) {
        this(dest, value, type, false);
    }

    public CheckCast(Value dest, Value value, DexType type, boolean ignoreCompatRules) {
        super(dest, value);
        this.type = type;
        this.ignoreCompatRules = ignoreCompatRules;
    }

    public static Builder builder() {
        return new Builder();
    }

    public boolean isRefiningStaticType(InternalOptions options) {
        TypeElement inType = this.object().getType();
        if (inType.isNullType()) {
            return options.canHaveArtCheckCastVerifierBug() && this.getType().isArrayType() && this.getType().toBaseType(options.dexItemFactory()).isFloatType();
        }
        if (!inType.isClassType()) {
            assert (inType.isArrayType());
            return true;
        }
        ClassTypeElement inClassType = inType.asClassType();
        return this.type != inClassType.getClassType();
    }

    @Override
    public boolean ignoreCompatRules() {
        return this.ignoreCompatRules;
    }

    @Override
    public int opcode() {
        return 10;
    }

    @Override
    public <T> T accept(InstructionVisitor<T> visitor) {
        return visitor.visit(this);
    }

    public DexType getType() {
        return this.type;
    }

    public Value object() {
        return this.inValues().get(0);
    }

    @Override
    public void buildDex(DexBuilder builder) {
        int inRegister = builder.allocatedRegister((Value)this.inValues.get(0), this.getNumber());
        if (this.outValue == null) {
            builder.add((Instruction)this, (com.android.tools.r8.code.Instruction)this.createCheckCast(inRegister));
        } else {
            int outRegister = builder.allocatedRegister(this.outValue, this.getNumber());
            if (inRegister == outRegister) {
                builder.add((Instruction)this, (com.android.tools.r8.code.Instruction)this.createCheckCast(outRegister));
            } else {
                com.android.tools.r8.code.CheckCast cast = this.createCheckCast(outRegister);
                if (outRegister <= 15 && inRegister <= 15) {
                    builder.add((Instruction)this, new MoveObject(outRegister, inRegister), cast);
                } else {
                    builder.add((Instruction)this, new MoveObjectFrom16(outRegister, inRegister), cast);
                }
            }
        }
    }

    com.android.tools.r8.code.CheckCast createCheckCast(int register) {
        return new com.android.tools.r8.code.CheckCast(register, this.getType(), this.ignoreCompatRules());
    }

    @Override
    public boolean identicalNonValueNonPositionParts(Instruction other) {
        return other.isCheckCast() && other.asCheckCast().type == this.type;
    }

    @Override
    public int maxInValueRegister() {
        return 255;
    }

    @Override
    public int maxOutValueRegister() {
        return 255;
    }

    @Override
    public boolean instructionMayHaveSideEffects(AppView<?> appView, ProgramMethod context, Instruction.SideEffectAssumption assumption) {
        return this.instructionInstanceCanThrow(appView, context);
    }

    @Override
    public boolean instructionInstanceCanThrow(AppView<?> appView, ProgramMethod context) {
        if (appView.options().debug || !((AppInfo)appView.appInfo()).hasLiveness()) {
            return true;
        }
        if (this.type.isPrimitiveType()) {
            return true;
        }
        AppView<AppInfoWithLiveness> appViewWithLiveness = appView.withLiveness();
        DexType baseType = this.type.toBaseType(appView.dexItemFactory());
        if (baseType.isClassType()) {
            DexClass definition = appView.definitionFor(baseType);
            if (definition == null || !definition.isResolvable(appView)) {
                return true;
            }
            if (AccessControl.isClassAccessible(definition, context, appViewWithLiveness).isPossiblyFalse()) {
                return true;
            }
        }
        if (!appView.getOpenClosedInterfacesCollection().isDefinitelyInstanceOfStaticType(appViewWithLiveness, this.object())) {
            return true;
        }
        TypeElement castType = TypeElement.fromDexType(this.type, Nullability.definitelyNotNull(), appView);
        return !this.object().getDynamicUpperBoundType(appViewWithLiveness).lessThanOrEqualUpToNullability(castType, appView);
    }

    @Override
    public boolean instructionTypeCanThrow() {
        return true;
    }

    @Override
    public boolean isCheckCast() {
        return true;
    }

    @Override
    public CheckCast asCheckCast() {
        return this;
    }

    @Override
    public String toString() {
        return super.toString() + "; " + this.type;
    }

    @Override
    public Inliner.ConstraintWithTarget inliningConstraint(InliningConstraints inliningConstraints, ProgramMethod context) {
        return inliningConstraints.forCheckCast(this.type, context);
    }

    @Override
    public TypeElement evaluate(AppView<?> appView) {
        return TypeElement.fromDexType(this.type, this.object().getType().nullability(), appView);
    }

    @Override
    public boolean verifyTypes(AppView<?> appView, VerifyTypesHelper verifyTypesHelper) {
        assert (super.verifyTypes(appView, verifyTypesHelper));
        TypeElement inType = this.object().getType();
        assert (inType.isPreciseType());
        TypeElement outType = this.getOutType();
        TypeElement castType = TypeElement.fromDexType(this.getType(), inType.nullability(), appView);
        if (inType.lessThanOrEqual(castType, appView)) {
            assert (inType.lessThanOrEqual(outType, appView));
        } else {
            assert (outType.equalUpToNullability(castType));
            assert (inType.nullability() == outType.nullability());
            assert (!inType.isNullType());
        }
        return true;
    }

    @Override
    public void insertLoadAndStores(InstructionListIterator it, LoadStoreHelper helper) {
        helper.loadInValues(this, it);
        helper.storeOutValue(this, it);
    }

    @Override
    public boolean hasInvariantOutType() {
        return false;
    }

    @Override
    public DexType computeVerificationType(AppView<?> appView, TypeVerificationHelper helper) {
        return this.type;
    }

    @Override
    public void buildCf(CfBuilder builder) {
        builder.add((CfInstruction)new CfCheckCast(this.type), this);
    }

    @Override
    public boolean instructionMayTriggerMethodInvocation(AppView<?> appView, ProgramMethod context) {
        return false;
    }

    public static class Builder
    extends Instruction.BuilderBase<Builder, CheckCast> {
        protected DexType castType;
        protected Value object;

        public Builder setCastType(DexType castType) {
            this.castType = castType;
            return this;
        }

        public Builder setObject(Value object) {
            this.object = object;
            return this;
        }

        @Override
        public CheckCast build() {
            return this.amend(new CheckCast(this.outValue, this.object, this.castType));
        }

        @Override
        public Builder self() {
            return this;
        }
    }
}

