/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.r8.ir.code;

import com.android.tools.r8.graph.DexDefinitionSupplier;
import com.android.tools.r8.graph.DexReference;
import com.android.tools.r8.graph.DexType;
import com.android.tools.r8.ir.code.ConstString;
import com.android.tools.r8.ir.code.DexItemBasedConstString;
import com.android.tools.r8.ir.code.InvokeStatic;
import com.android.tools.r8.ir.code.Value;
import com.android.tools.r8.naming.IdentifierNameStringUtils;

public class ConstantValueUtils {
    public static DexType getDexTypeRepresentedByValue(Value value, DexDefinitionSupplier definitions) {
        InvokeStatic invoke;
        Value alias = value.getAliasedValue();
        if (alias.isPhi()) {
            return null;
        }
        if (alias.definition.isConstClass()) {
            return alias.definition.asConstClass().getValue();
        }
        if (alias.definition.isInvokeStatic() && definitions.dexItemFactory().classMethods.isReflectiveClassLookup((invoke = alias.definition.asInvokeStatic()).getInvokedMethod())) {
            return ConstantValueUtils.getDexTypeFromClassForName(invoke, definitions);
        }
        return null;
    }

    public static DexType getDexTypeFromClassForName(InvokeStatic invoke, DexDefinitionSupplier definitions) {
        assert (definitions.dexItemFactory().classMethods.isReflectiveClassLookup(invoke.getInvokedMethod()));
        if (invoke.arguments().size() == 1 || invoke.arguments().size() == 3) {
            DexItemBasedConstString constStringInstruction;
            DexReference item;
            Value argument = invoke.arguments().get(0);
            if (argument.isConstString()) {
                ConstString constStringInstruction2 = argument.getConstInstruction().asConstString();
                return IdentifierNameStringUtils.inferTypeFromNameString(definitions, constStringInstruction2.getValue());
            }
            if (argument.isDexItemBasedConstString() && (item = (constStringInstruction = argument.getConstInstruction().asDexItemBasedConstString()).getItem()).isDexType()) {
                return item.asDexType();
            }
        }
        return null;
    }
}

