/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.r8.ir.code;

import com.android.tools.r8.com.google.common.collect.ImmutableList;
import com.android.tools.r8.ir.code.BasicBlock;
import com.android.tools.r8.ir.code.IRCode;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;

public class DominatorTree
implements BasicBlock.BasicBlockChangeListener {
    private final BasicBlock[] sorted;
    private BasicBlock[] doms;
    private final BasicBlock normalExitBlock = new BasicBlock();
    private final int unreachableStartIndex;
    private boolean obsolete = false;

    public DominatorTree(IRCode code) {
        this(code, Assumption.NO_UNREACHABLE_BLOCKS);
    }

    public DominatorTree(IRCode code, Assumption assumption) {
        assert (assumption != null);
        assert (assumption == Assumption.MAY_HAVE_UNREACHABLE_BLOCKS || code.getUnreachableBlocks().isEmpty());
        ImmutableList<BasicBlock> blocks = code.topologicallySortedBlocks();
        for (BasicBlock block : blocks) {
            if (!block.exit().isReturn()) continue;
            this.normalExitBlock.getMutablePredecessors().add(block);
        }
        int numberOfBlocks = code.blocks.size();
        if (assumption == Assumption.MAY_HAVE_UNREACHABLE_BLOCKS) {
            this.sorted = new BasicBlock[numberOfBlocks + 1];
            int color = code.reserveMarkingColor();
            int i = 0;
            Iterator iterator2 = blocks.iterator();
            while (iterator2.hasNext()) {
                BasicBlock block;
                this.sorted[i] = block = (BasicBlock)iterator2.next();
                block.mark(color);
                ++i;
            }
            this.sorted[i] = this.normalExitBlock;
            this.unreachableStartIndex = ++i;
            for (BasicBlock block : code.blocks) {
                if (block.isMarked(color)) continue;
                this.sorted[i] = block;
                ++i;
            }
            code.returnMarkingColor(color);
        } else {
            this.sorted = blocks.toArray(new BasicBlock[numberOfBlocks + 1]);
            this.sorted[numberOfBlocks] = this.normalExitBlock;
            this.unreachableStartIndex = numberOfBlocks + 1;
        }
        this.numberBlocks();
        this.build();
        assert (this.recordChangesToControlFlowEdges(code.blocks));
    }

    private void numberBlocks() {
        for (int i = 0; i < this.sorted.length; ++i) {
            this.sorted[i].setNumber(i);
        }
    }

    private boolean postorderCompareLess(BasicBlock b1, BasicBlock b2) {
        return b1.getNumber() > b2.getNumber();
    }

    private void build() {
        this.doms = new BasicBlock[this.sorted.length];
        this.doms[0] = this.sorted[0];
        boolean changed = true;
        while (changed) {
            changed = false;
            for (int i = 1; i < this.sorted.length; ++i) {
                BasicBlock p;
                int j;
                BasicBlock b = this.sorted[i];
                BasicBlock newIDom = null;
                int picked = -1;
                for (j = 0; newIDom == null && j < b.getPredecessors().size(); ++j) {
                    p = b.getPredecessors().get(j);
                    if (this.doms[p.getNumber()] == null) continue;
                    picked = j;
                    newIDom = p;
                }
                for (j = 0; j < b.getPredecessors().size(); ++j) {
                    p = b.getPredecessors().get(j);
                    if (j == picked || this.doms[p.getNumber()] == null) continue;
                    newIDom = this.intersect(p, newIDom);
                }
                if (this.doms[b.getNumber()] == newIDom) continue;
                this.doms[b.getNumber()] = newIDom;
                changed = true;
            }
        }
    }

    private BasicBlock intersect(BasicBlock b1, BasicBlock b2) {
        BasicBlock finger1 = b1;
        BasicBlock finger2 = b2;
        while (finger1 != finger2) {
            while (this.postorderCompareLess(finger1, finger2)) {
                finger1 = this.doms[finger1.getNumber()];
            }
            while (this.postorderCompareLess(finger2, finger1)) {
                finger2 = this.doms[finger2.getNumber()];
            }
        }
        return finger1;
    }

    private boolean recordChangesToControlFlowEdges(List<BasicBlock> blocks) {
        for (BasicBlock block : blocks) {
            block.addControlFlowEdgesMayChangeListener(this);
        }
        return true;
    }

    public BasicBlock immediateDominator(BasicBlock block) {
        assert (!this.obsolete);
        return this.doms[block.getNumber()];
    }

    public boolean dominatedBy(BasicBlock subject, BasicBlock dominator) {
        assert (!this.obsolete);
        if (subject == dominator) {
            return true;
        }
        return this.strictlyDominatedBy(subject, dominator);
    }

    public boolean dominatesAllOf(BasicBlock dominator, Iterable<BasicBlock> subjects) {
        for (BasicBlock subject : subjects) {
            if (this.dominatedBy(subject, dominator)) continue;
            return false;
        }
        return true;
    }

    public boolean strictlyDominatedBy(BasicBlock subject, BasicBlock dominator) {
        assert (!this.obsolete);
        if (subject.getNumber() == 0 || subject == this.normalExitBlock) {
            return false;
        }
        BasicBlock idom;
        while ((idom = this.immediateDominator(subject)).getNumber() >= dominator.getNumber()) {
            if (idom == dominator) {
                return true;
            }
            subject = idom;
        }
        return false;
    }

    public BasicBlock closestDominator(Collection<BasicBlock> blocks) {
        assert (!this.obsolete);
        if (blocks.size() == 0) {
            return null;
        }
        Iterator<BasicBlock> it = blocks.iterator();
        BasicBlock dominator = it.next();
        while (it.hasNext()) {
            dominator = this.intersect(dominator, it.next());
        }
        return dominator;
    }

    public List<BasicBlock> dominatedBlocks(BasicBlock dominator) {
        return this.dominatedBlocks(dominator, new ArrayList());
    }

    public <T extends Collection<BasicBlock>> T dominatedBlocks(BasicBlock dominator, T dominatedBlocks) {
        assert (!this.obsolete);
        for (int i = dominator.getNumber(); i < this.unreachableStartIndex; ++i) {
            BasicBlock block = this.sorted[i];
            if (!this.dominatedBy(block, dominator)) continue;
            dominatedBlocks.add((BasicBlock)block);
        }
        return dominatedBlocks;
    }

    public Iterable<BasicBlock> dominatorBlocks(final BasicBlock dominated, Inclusive inclusive) {
        assert (!this.obsolete);
        return () -> {
            Iterator<BasicBlock> iterator2 = new Iterator<BasicBlock>(){
                private BasicBlock current;
                {
                    this.current = dominated;
                }

                @Override
                public boolean hasNext() {
                    return this.current != null;
                }

                @Override
                public BasicBlock next() {
                    if (!this.hasNext()) {
                        return null;
                    }
                    BasicBlock result = this.current;
                    if (this.current.getNumber() == 0) {
                        this.current = null;
                    } else {
                        this.current = DominatorTree.this.immediateDominator(this.current);
                        assert (this.current != result);
                    }
                    return result;
                }
            };
            if (inclusive == Inclusive.NO) {
                BasicBlock block = (BasicBlock)iterator2.next();
                assert (block == dominated);
            }
            return iterator2;
        };
    }

    public Iterable<BasicBlock> normalExitDominatorBlocks() {
        assert (!this.obsolete);
        return this.dominatorBlocks(this.normalExitBlock, Inclusive.NO);
    }

    public BasicBlock[] getSortedBlocks() {
        return this.sorted;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("Dominators\n");
        for (BasicBlock block : this.sorted) {
            builder.append(block.getNumber());
            builder.append(": ");
            builder.append(this.doms[block.getNumber()].getNumber());
            builder.append("\n");
        }
        return builder.toString();
    }

    @Override
    public void onSuccessorsMayChange(BasicBlock block) {
        this.obsolete = true;
    }

    @Override
    public void onPredecessorsMayChange(BasicBlock block) {
        this.obsolete = true;
    }

    public static enum Inclusive {
        YES,
        NO;

    }

    public static enum Assumption {
        NO_UNREACHABLE_BLOCKS,
        MAY_HAVE_UNREACHABLE_BLOCKS;

    }
}

