/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.r8.ir.code;

import com.android.tools.r8.graph.AppInfo;
import com.android.tools.r8.graph.AppInfoWithClassHierarchy;
import com.android.tools.r8.graph.AppView;
import com.android.tools.r8.graph.DexClass;
import com.android.tools.r8.graph.DexEncodedField;
import com.android.tools.r8.graph.DexEncodedMethod;
import com.android.tools.r8.graph.DexField;
import com.android.tools.r8.graph.DexItemFactory;
import com.android.tools.r8.graph.FieldResolutionResult;
import com.android.tools.r8.graph.ProgramDefinition;
import com.android.tools.r8.graph.ProgramMethod;
import com.android.tools.r8.ir.analysis.fieldvalueanalysis.AbstractFieldSet;
import com.android.tools.r8.ir.analysis.fieldvalueanalysis.ConcreteMutableFieldSet;
import com.android.tools.r8.ir.analysis.fieldvalueanalysis.EmptyFieldSet;
import com.android.tools.r8.ir.analysis.fieldvalueanalysis.UnknownFieldSet;
import com.android.tools.r8.ir.analysis.type.TypeElement;
import com.android.tools.r8.ir.analysis.value.AbstractValue;
import com.android.tools.r8.ir.analysis.value.SingleFieldValue;
import com.android.tools.r8.ir.analysis.value.UnknownValue;
import com.android.tools.r8.ir.code.FieldMemberType;
import com.android.tools.r8.ir.code.Instruction;
import com.android.tools.r8.ir.code.Value;
import com.android.tools.r8.shaking.AppInfoWithLiveness;
import java.util.Collections;
import java.util.List;

public abstract class FieldInstruction
extends Instruction {
    private final DexField field;

    protected FieldInstruction(DexField field, Value dest, Value value) {
        this(field, dest, Collections.singletonList(value));
    }

    protected FieldInstruction(DexField field, Value dest, List<Value> inValues) {
        super(dest, inValues);
        assert (field != null);
        this.field = field;
    }

    public abstract Value value();

    public FieldMemberType getType() {
        return FieldMemberType.fromDexType(this.field.type);
    }

    public DexField getField() {
        return this.field;
    }

    @Override
    public boolean isFieldInstruction() {
        return true;
    }

    @Override
    public FieldInstruction asFieldInstruction() {
        return this;
    }

    @Override
    public boolean instructionInstanceCanThrow(AppView<?> appView, ProgramMethod context) {
        return this.instructionInstanceCanThrow(appView, context, Instruction.SideEffectAssumption.NONE);
    }

    public boolean instructionInstanceCanThrow(AppView<?> appView, ProgramMethod context, Instruction.SideEffectAssumption assumption) {
        return this.internalInstructionInstanceCanThrow(appView, context, assumption, ((AppInfo)appView.appInfo()).resolveField(this.field, context));
    }

    boolean internalInstructionInstanceCanThrow(AppView<?> appView, ProgramMethod context, Instruction.SideEffectAssumption assumption, FieldResolutionResult resolutionResult) {
        boolean mayTriggerClassInitialization;
        Value receiver;
        if (!resolutionResult.isSingleFieldResolutionResult()) {
            return true;
        }
        FieldResolutionResult.SingleFieldResolutionResult<?> singleFieldResolutionResult = resolutionResult.asSingleFieldResolutionResult();
        DexEncodedField resolvedField = singleFieldResolutionResult.getResolvedField();
        if (resolvedField.isStatic() != this.isStaticFieldInstruction()) {
            return true;
        }
        if (singleFieldResolutionResult.getResolvedHolder() != context.getHolder() && singleFieldResolutionResult.isAccessibleFrom((ProgramDefinition)context, ((AppInfo)appView.appInfo()).withClassHierarchy()).isPossiblyFalse()) {
            return true;
        }
        if ((this.isInstanceGet() || this.isInstancePut()) && !assumption.canAssumeReceiverIsNotNull() && ((receiver = (Value)this.inValues.get(0)).isAlwaysNull(appView) || receiver.type.isNullable())) {
            return true;
        }
        if (!appView.enableWholeProgramOptimizations()) {
            return false;
        }
        boolean bl = mayTriggerClassInitialization = this.isStaticFieldInstruction() && !assumption.canAssumeClassIsAlreadyInitialized();
        if (mayTriggerClassInitialization) {
            if (((AppInfo)appView.appInfo()).hasLiveness()) {
                AppInfoWithLiveness appInfoWithLiveness = ((AppInfo)appView.appInfo()).withLiveness();
                if (appInfoWithLiveness.noSideEffects.containsKey(resolvedField.getReference())) {
                    return false;
                }
            }
            if (this.field.holder.classInitializationMayHaveSideEffectsInContext(appView, context)) {
                return true;
            }
        }
        return false;
    }

    @Override
    public boolean hasInvariantOutType() {
        return true;
    }

    @Override
    public AbstractFieldSet readSet(AppView<AppInfoWithLiveness> appView, ProgramMethod context) {
        if (this.instructionMayTriggerMethodInvocation(appView, context)) {
            return UnknownFieldSet.getInstance();
        }
        if (this.isFieldGet()) {
            DexField field = this.getField();
            DexEncodedField encodedField = null;
            if (appView.enableWholeProgramOptimizations()) {
                encodedField = appView.appInfo().resolveField(field).getResolvedField();
            } else {
                DexClass clazz = appView.definitionFor(field.holder);
                if (clazz != null) {
                    encodedField = clazz.lookupField(field);
                }
            }
            if (encodedField != null) {
                return new ConcreteMutableFieldSet(encodedField);
            }
            return UnknownFieldSet.getInstance();
        }
        assert (this.isFieldPut());
        return EmptyFieldSet.getInstance();
    }

    boolean isStoringObjectWithFinalizer(AppView<AppInfoWithLiveness> appView, DexEncodedField field) {
        TypeElement baseType;
        assert (this.isFieldPut());
        TypeElement type = this.value().getType();
        TypeElement typeElement = baseType = type.isArrayType() ? type.asArrayType().getBaseType() : type;
        if (!baseType.isClassType()) {
            return false;
        }
        AbstractValue abstractValue = field.getOptimizationInfo().getAbstractValue();
        if (abstractValue.isSingleValue()) {
            if (abstractValue.isSingleConstValue()) {
                return false;
            }
            if (abstractValue.isSingleFieldValue()) {
                SingleFieldValue singleFieldValue = abstractValue.asSingleFieldValue();
                return singleFieldValue.mayHaveFinalizeMethodDirectlyOrIndirectly(appView);
            }
        }
        AppInfoWithLiveness appInfo = appView.appInfo();
        Value root = this.value().getAliasedValue();
        if (!root.isPhi() && root.definition.isNewInstance()) {
            DexClass clazz = appView.definitionFor(root.definition.asNewInstance().clazz);
            if (clazz == null) {
                return true;
            }
            if (clazz.superType == null) {
                return false;
            }
            DexItemFactory dexItemFactory = appView.dexItemFactory();
            DexEncodedMethod resolutionResult = appInfo.resolveMethodOnClass(dexItemFactory.objectMembers.finalize, clazz).getSingleTarget();
            return resolutionResult != null && resolutionResult.isProgramMethod(appView);
        }
        return appInfo.mayHaveFinalizeMethodDirectlyOrIndirectly(baseType.asClassType());
    }

    @Override
    public AbstractValue getAbstractValue(AppView<? extends AppInfoWithClassHierarchy> appView, ProgramMethod context) {
        assert (this.isFieldGet());
        DexEncodedField field = appView.appInfo().resolveField(this.getField()).getResolvedField();
        if (field != null) {
            return field.getOptimizationInfo().getAbstractValue();
        }
        return UnknownValue.getInstance();
    }
}

