/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.r8.ir.code;

import com.android.tools.r8.cf.LoadStoreHelper;
import com.android.tools.r8.cf.code.CfGoto;
import com.android.tools.r8.cf.code.CfInstruction;
import com.android.tools.r8.ir.code.BasicBlock;
import com.android.tools.r8.ir.code.BasicBlockIterator;
import com.android.tools.r8.ir.code.IRCode;
import com.android.tools.r8.ir.code.Instruction;
import com.android.tools.r8.ir.code.InstructionListIterator;
import com.android.tools.r8.ir.code.InstructionVisitor;
import com.android.tools.r8.ir.code.JumpInstruction;
import com.android.tools.r8.ir.conversion.CfBuilder;
import com.android.tools.r8.ir.conversion.DexBuilder;
import com.android.tools.r8.utils.CfgPrinter;
import java.util.List;

public class Goto
extends JumpInstruction {
    public Goto() {
    }

    public Goto(BasicBlock block) {
        this();
        this.setBlock(block);
    }

    public static Builder builder() {
        return new Builder();
    }

    @Override
    public int opcode() {
        return 24;
    }

    @Override
    public <T> T accept(InstructionVisitor<T> visitor) {
        return visitor.visit(this);
    }

    public BasicBlock getTarget() {
        assert (this.getBlock().exit() == this);
        List<BasicBlock> successors = this.getBlock().getSuccessors();
        assert (successors.size() >= 1);
        return successors.get(successors.size() - 1);
    }

    public void setTarget(BasicBlock nextBlock) {
        assert (this.getBlock().exit() == this);
        List<BasicBlock> successors = this.getBlock().getMutableSuccessors();
        assert (successors.size() >= 1);
        BasicBlock target = successors.get(successors.size() - 1);
        target.getMutablePredecessors().remove(this.getBlock());
        successors.set(successors.size() - 1, nextBlock);
        nextBlock.getMutablePredecessors().add(this.getBlock());
    }

    @Override
    public void buildDex(DexBuilder builder) {
        builder.addGoto(this);
    }

    @Override
    public int maxInValueRegister() {
        assert (false) : "Goto has no register arguments.";
        return 0;
    }

    @Override
    public int maxOutValueRegister() {
        assert (false) : "Goto defines no values.";
        return 0;
    }

    @Override
    public String toString() {
        if (this.getBlock() != null && !this.getBlock().getSuccessors().isEmpty()) {
            return super.toString() + "block " + this.getTarget().getNumberAsString();
        }
        return super.toString() + "block <unknown>";
    }

    @Override
    public void print(CfgPrinter printer) {
        super.print(printer);
        printer.append(" B").append(this.getTarget().getNumber());
    }

    @Override
    public boolean identicalNonValueNonPositionParts(Instruction other) {
        return other.isGoto() && other.asGoto().getTarget() == this.getTarget();
    }

    @Override
    public boolean isGoto() {
        return true;
    }

    @Override
    public Goto asGoto() {
        return this;
    }

    @Override
    public void insertLoadAndStores(InstructionListIterator it, LoadStoreHelper helper) {
    }

    public boolean isTrivialGotoToTheNextBlock(IRCode code) {
        BasicBlock thisBlock = this.getBlock();
        BasicBlockIterator blockIterator = code.listIterator();
        while (blockIterator.hasNext()) {
            BasicBlock block = (BasicBlock)blockIterator.next();
            if (thisBlock != block) continue;
            return blockIterator.hasNext() && blockIterator.next() == this.getTarget();
        }
        return false;
    }

    @Override
    public void buildCf(CfBuilder builder) {
        builder.add((CfInstruction)new CfGoto(builder.getLabel(this.getTarget())), this);
    }

    @Override
    public boolean isAllowedAfterThrowingInstruction() {
        return true;
    }

    public static class Builder
    extends Instruction.BuilderBase<Builder, Goto> {
        private BasicBlock target;

        public Builder setTarget(BasicBlock target) {
            this.target = target;
            return this.self();
        }

        @Override
        public Goto build() {
            return this.amend(new Goto(this.target));
        }

        @Override
        public Builder self() {
            return this;
        }
    }
}

