/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.r8.ir.code;

import com.android.tools.r8.errors.Unimplemented;
import com.android.tools.r8.graph.AppInfoWithClassHierarchy;
import com.android.tools.r8.graph.AppView;
import com.android.tools.r8.graph.DebugLocalInfo;
import com.android.tools.r8.graph.DexField;
import com.android.tools.r8.graph.DexProgramClass;
import com.android.tools.r8.graph.DexString;
import com.android.tools.r8.graph.DexType;
import com.android.tools.r8.graph.ProgramMethod;
import com.android.tools.r8.ir.analysis.type.TypeElement;
import com.android.tools.r8.ir.code.BasicBlock;
import com.android.tools.r8.ir.code.BasicBlockIterator;
import com.android.tools.r8.ir.code.IRCode;
import com.android.tools.r8.ir.code.InitClass;
import com.android.tools.r8.ir.code.Instruction;
import com.android.tools.r8.ir.code.InstructionListIterator;
import com.android.tools.r8.ir.code.InvokeMethod;
import com.android.tools.r8.ir.code.Position;
import com.android.tools.r8.ir.code.Value;
import com.android.tools.r8.shaking.AppInfoWithLiveness;
import com.android.tools.r8.utils.InternalOptions;
import java.util.ListIterator;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.function.Consumer;

public class IRCodeInstructionListIterator
implements InstructionListIterator {
    private final ListIterator<BasicBlock> blockIterator;
    private InstructionListIterator instructionIterator;
    private final IRCode code;

    public IRCodeInstructionListIterator(IRCode code) {
        this.blockIterator = code.listIterator();
        this.code = code;
        this.instructionIterator = this.blockIterator.next().listIterator(code);
    }

    @Override
    public Value insertConstNumberInstruction(IRCode code, InternalOptions options, long value, TypeElement type) {
        return this.instructionIterator.insertConstNumberInstruction(code, options, value, type);
    }

    @Override
    public Value insertConstStringInstruction(AppView<?> appView, IRCode code, DexString value) {
        return this.instructionIterator.insertConstStringInstruction(appView, code, value);
    }

    @Override
    public InvokeMethod insertNullCheckInstruction(AppView<?> appView, IRCode code, BasicBlockIterator blockIterator, Value value, Position position) {
        return this.instructionIterator.insertNullCheckInstruction(appView, code, blockIterator, value, position);
    }

    @Override
    public boolean replaceCurrentInstructionByNullCheckIfPossible(AppView<?> appView, ProgramMethod context) {
        return this.instructionIterator.replaceCurrentInstructionByNullCheckIfPossible(appView, context);
    }

    @Override
    public boolean removeOrReplaceCurrentInstructionByInitClassIfPossible(AppView<AppInfoWithLiveness> appView, IRCode code, DexType type, Consumer<InitClass> consumer) {
        return this.instructionIterator.removeOrReplaceCurrentInstructionByInitClassIfPossible(appView, code, type, consumer);
    }

    @Override
    public void replaceCurrentInstructionWithConstClass(AppView<?> appView, IRCode code, DexType type, DebugLocalInfo localInfo) {
        this.instructionIterator.replaceCurrentInstructionWithConstClass(appView, code, type, localInfo);
    }

    @Override
    public void replaceCurrentInstructionWithConstInt(IRCode code, int value) {
        this.instructionIterator.replaceCurrentInstructionWithConstInt(code, value);
    }

    @Override
    public void replaceCurrentInstructionWithConstString(AppView<?> appView, IRCode code, DexString value) {
        this.instructionIterator.replaceCurrentInstructionWithConstString(appView, code, value);
    }

    @Override
    public void replaceCurrentInstructionWithStaticGet(AppView<?> appView, IRCode code, DexField field, Set<Value> affectedValues) {
        this.instructionIterator.replaceCurrentInstructionWithStaticGet(appView, code, field, affectedValues);
    }

    @Override
    public void removeInstructionIgnoreOutValue() {
        this.instructionIterator.removeInstructionIgnoreOutValue();
    }

    @Override
    public void replaceCurrentInstructionWithThrow(AppView<?> appView, IRCode code, ListIterator<BasicBlock> blockIterator, Value exceptionValue, Set<BasicBlock> blocksToRemove, Set<Value> affectedValues) {
        throw new Unimplemented();
    }

    @Override
    public void replaceCurrentInstructionWithThrowNull(AppView<? extends AppInfoWithClassHierarchy> appView, IRCode code, ListIterator<BasicBlock> blockIterator, Set<BasicBlock> blocksToRemove, Set<Value> affectedValues) {
        throw new Unimplemented();
    }

    @Override
    public BasicBlock split(IRCode code, ListIterator<BasicBlock> blockIterator, boolean keepCatchHandlers) {
        throw new Unimplemented();
    }

    @Override
    public BasicBlock split(IRCode code, int instructions, ListIterator<BasicBlock> blockIterator) {
        throw new Unimplemented();
    }

    @Override
    public BasicBlock splitCopyCatchHandlers(IRCode code, ListIterator<BasicBlock> blockIterator, InternalOptions options) {
        throw new Unimplemented();
    }

    @Override
    public BasicBlock inlineInvoke(AppView<?> appView, IRCode code, IRCode inlinee, ListIterator<BasicBlock> blockIterator, Set<BasicBlock> blocksToRemove, DexProgramClass downcast) {
        throw new Unimplemented();
    }

    @Override
    public boolean hasNext() {
        return this.instructionIterator.hasNext() || this.blockIterator.hasNext();
    }

    @Override
    public Instruction next() {
        if (this.instructionIterator.hasNext()) {
            return (Instruction)this.instructionIterator.next();
        }
        if (!this.blockIterator.hasNext()) {
            throw new NoSuchElementException();
        }
        this.instructionIterator = this.blockIterator.next().listIterator(this.code);
        assert (this.instructionIterator.hasNext());
        return (Instruction)this.instructionIterator.next();
    }

    @Override
    public boolean hasPrevious() {
        return this.instructionIterator.hasPrevious() || this.blockIterator.hasPrevious();
    }

    @Override
    public Instruction previous() {
        if (this.instructionIterator.hasPrevious()) {
            return (Instruction)this.instructionIterator.previous();
        }
        if (!this.blockIterator.hasPrevious()) {
            throw new NoSuchElementException();
        }
        BasicBlock block = this.blockIterator.previous();
        this.instructionIterator = block.listIterator(this.code, block.getInstructions().size());
        assert (this.instructionIterator.hasPrevious());
        return (Instruction)this.instructionIterator.previous();
    }

    @Override
    public int nextIndex() {
        throw new UnsupportedOperationException();
    }

    @Override
    public int previousIndex() {
        throw new UnsupportedOperationException();
    }

    @Override
    public void add(Instruction instruction) {
        this.instructionIterator.add(instruction);
    }

    @Override
    public void addThrowingInstructionToPossiblyThrowingBlock(IRCode code, ListIterator<BasicBlock> blockIterator, Instruction instruction, InternalOptions options) {
        this.instructionIterator.addThrowingInstructionToPossiblyThrowingBlock(code, blockIterator, instruction, options);
    }

    @Override
    public void remove() {
        this.instructionIterator.remove();
    }

    @Override
    public void set(Instruction instruction) {
        this.instructionIterator.set(instruction);
    }

    @Override
    public void replaceCurrentInstruction(Instruction newInstruction, Set<Value> affectedValues) {
        this.instructionIterator.replaceCurrentInstruction(newInstruction, affectedValues);
    }

    @Override
    public void removeOrReplaceByDebugLocalRead() {
        this.instructionIterator.removeOrReplaceByDebugLocalRead();
    }

    @Override
    public boolean hasInsertionPosition() {
        return this.instructionIterator.hasInsertionPosition();
    }

    @Override
    public void setInsertionPosition(Position position) {
        this.instructionIterator.setInsertionPosition(position);
    }

    @Override
    public void unsetInsertionPosition() {
        this.instructionIterator.unsetInsertionPosition();
    }
}

