/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.r8.ir.code;

import com.android.tools.r8.cf.LoadStoreHelper;
import com.android.tools.r8.cf.code.CfInitClass;
import com.android.tools.r8.cf.code.CfInstruction;
import com.android.tools.r8.code.DexInitClass;
import com.android.tools.r8.graph.AccessControl;
import com.android.tools.r8.graph.AppView;
import com.android.tools.r8.graph.DexClass;
import com.android.tools.r8.graph.DexType;
import com.android.tools.r8.graph.ProgramMethod;
import com.android.tools.r8.ir.analysis.ClassInitializationAnalysis;
import com.android.tools.r8.ir.analysis.type.TypeElement;
import com.android.tools.r8.ir.code.Instruction;
import com.android.tools.r8.ir.code.InstructionListIterator;
import com.android.tools.r8.ir.code.InstructionVisitor;
import com.android.tools.r8.ir.code.Value;
import com.android.tools.r8.ir.conversion.CfBuilder;
import com.android.tools.r8.ir.conversion.DexBuilder;
import com.android.tools.r8.ir.optimize.Inliner;
import com.android.tools.r8.ir.optimize.InliningConstraints;
import com.android.tools.r8.shaking.AppInfoWithLiveness;

public class InitClass
extends Instruction {
    private final DexType clazz;

    public InitClass(Value outValue, DexType clazz) {
        super(outValue);
        assert (this.hasOutValue());
        assert (outValue.getType().isInt());
        assert (clazz.isClassType());
        this.clazz = clazz;
    }

    public static Builder builder() {
        return new Builder();
    }

    public DexType getClassValue() {
        return this.clazz;
    }

    @Override
    public boolean isInitClass() {
        return true;
    }

    @Override
    public InitClass asInitClass() {
        return this;
    }

    @Override
    public TypeElement evaluate(AppView<?> appView) {
        return TypeElement.getInt();
    }

    @Override
    public int opcode() {
        return 27;
    }

    @Override
    public <T> T accept(InstructionVisitor<T> visitor) {
        return visitor.visit(this);
    }

    @Override
    public void buildDex(DexBuilder builder) {
        int dest = builder.allocatedRegister(this.outValue(), this.getNumber());
        builder.add((Instruction)this, (com.android.tools.r8.code.Instruction)new DexInitClass(dest, this.clazz));
    }

    @Override
    public void buildCf(CfBuilder builder) {
        builder.add((CfInstruction)new CfInitClass(this.clazz), this);
    }

    @Override
    public boolean definitelyTriggersClassInitialization(DexType clazz, ProgramMethod context, AppView<AppInfoWithLiveness> appView, ClassInitializationAnalysis.Query mode, ClassInitializationAnalysis.AnalysisAssumption assumption) {
        return ClassInitializationAnalysis.InstructionUtils.forInitClass(this, clazz, appView, mode, assumption);
    }

    @Override
    public boolean identicalNonValueNonPositionParts(Instruction other) {
        return other.isInitClass() && this.clazz == other.asInitClass().clazz;
    }

    @Override
    public boolean instructionInstanceCanThrow(AppView<?> appView, ProgramMethod context) {
        assert (appView.enableWholeProgramOptimizations());
        AppView<AppInfoWithLiveness> appViewWithLiveness = appView.withLiveness();
        DexClass definition = appView.definitionFor(this.clazz);
        if (definition == null) {
            return true;
        }
        if (AccessControl.isClassAccessible(definition, context, appViewWithLiveness).isPossiblyFalse()) {
            return true;
        }
        return this.clazz.classInitializationMayHaveSideEffectsInContext(appView, context);
    }

    @Override
    public boolean instructionMayHaveSideEffects(AppView<?> appView, ProgramMethod context, Instruction.SideEffectAssumption assumption) {
        return this.instructionInstanceCanThrow(appView, context);
    }

    @Override
    public boolean instructionMayTriggerMethodInvocation(AppView<?> appView, ProgramMethod context) {
        if (appView.enableWholeProgramOptimizations()) {
            return this.clazz.classInitializationMayHaveSideEffectsInContext(appView, context);
        }
        return this.clazz != context.getHolderType();
    }

    @Override
    public boolean instructionTypeCanThrow() {
        return true;
    }

    @Override
    public int maxInValueRegister() {
        return 255;
    }

    @Override
    public int maxOutValueRegister() {
        return 255;
    }

    @Override
    public Inliner.ConstraintWithTarget inliningConstraint(InliningConstraints inliningConstraints, ProgramMethod context) {
        return inliningConstraints.forInitClass(this.clazz, context);
    }

    @Override
    public void insertLoadAndStores(InstructionListIterator it, LoadStoreHelper helper) {
        helper.storeOutValue(this, it);
    }

    @Override
    public boolean hasInvariantOutType() {
        return true;
    }

    @Override
    public String toString() {
        return super.toString() + "; " + this.clazz.toSourceString();
    }

    public static class Builder
    extends Instruction.BuilderBase<Builder, InitClass> {
        private DexType type;

        private Builder() {
        }

        public Builder setType(DexType type) {
            this.type = type;
            return this;
        }

        @Override
        public InitClass build() {
            return this.amend(new InitClass(this.outValue, this.type));
        }

        @Override
        public Builder self() {
            return this;
        }
    }
}

