/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.r8.ir.code;

import com.android.tools.r8.cf.LoadStoreHelper;
import com.android.tools.r8.cf.TypeVerificationHelper;
import com.android.tools.r8.cf.code.CfInstanceFieldRead;
import com.android.tools.r8.cf.code.CfInstruction;
import com.android.tools.r8.code.Iget;
import com.android.tools.r8.code.IgetBoolean;
import com.android.tools.r8.code.IgetByte;
import com.android.tools.r8.code.IgetChar;
import com.android.tools.r8.code.IgetObject;
import com.android.tools.r8.code.IgetOrIput;
import com.android.tools.r8.code.IgetShort;
import com.android.tools.r8.code.IgetWide;
import com.android.tools.r8.errors.Unreachable;
import com.android.tools.r8.graph.AppView;
import com.android.tools.r8.graph.DexField;
import com.android.tools.r8.graph.DexType;
import com.android.tools.r8.graph.ProgramMethod;
import com.android.tools.r8.ir.analysis.ClassInitializationAnalysis;
import com.android.tools.r8.ir.analysis.type.Nullability;
import com.android.tools.r8.ir.analysis.type.TypeElement;
import com.android.tools.r8.ir.code.FieldGet;
import com.android.tools.r8.ir.code.FieldInstruction;
import com.android.tools.r8.ir.code.InstanceFieldInstruction;
import com.android.tools.r8.ir.code.Instruction;
import com.android.tools.r8.ir.code.InstructionListIterator;
import com.android.tools.r8.ir.code.InstructionVisitor;
import com.android.tools.r8.ir.code.Phi;
import com.android.tools.r8.ir.code.Value;
import com.android.tools.r8.ir.conversion.CfBuilder;
import com.android.tools.r8.ir.conversion.DexBuilder;
import com.android.tools.r8.ir.optimize.Inliner;
import com.android.tools.r8.ir.optimize.InliningConstraints;
import com.android.tools.r8.shaking.AppInfoWithLiveness;
import java.util.Set;

public class InstanceGet
extends FieldInstruction
implements FieldGet,
InstanceFieldInstruction {
    public InstanceGet(Value dest, Value object, DexField field) {
        super(field, dest, object);
    }

    @Override
    public int opcode() {
        return 28;
    }

    @Override
    public boolean outTypeKnownToBeBoolean(Set<Phi> seen) {
        return this.getField().type.isBooleanType();
    }

    @Override
    public <T> T accept(InstructionVisitor<T> visitor) {
        return visitor.visit(this);
    }

    public Value dest() {
        return this.outValue;
    }

    @Override
    public Value object() {
        assert (this.inValues.size() == 1);
        return (Value)this.inValues.get(0);
    }

    @Override
    public Value value() {
        return this.outValue;
    }

    @Override
    public boolean couldIntroduceAnAlias(AppView<?> appView, Value root) {
        assert (root != null && root.getType().isReferenceType());
        assert (this.outValue != null);
        return this.outValue.getType().isReferenceType();
    }

    @Override
    public void buildDex(DexBuilder builder) {
        IgetOrIput instruction;
        int destRegister = builder.allocatedRegister(this.dest(), this.getNumber());
        int objectRegister = builder.allocatedRegister(this.object(), this.getNumber());
        DexField field = this.getField();
        switch (this.getType()) {
            case INT: 
            case FLOAT: {
                instruction = new Iget(destRegister, objectRegister, field);
                break;
            }
            case LONG: 
            case DOUBLE: {
                instruction = new IgetWide(destRegister, objectRegister, field);
                break;
            }
            case OBJECT: {
                instruction = new IgetObject(destRegister, objectRegister, field);
                break;
            }
            case BOOLEAN: {
                instruction = new IgetBoolean(destRegister, objectRegister, field);
                break;
            }
            case BYTE: {
                instruction = new IgetByte(destRegister, objectRegister, field);
                break;
            }
            case CHAR: {
                instruction = new IgetChar(destRegister, objectRegister, field);
                break;
            }
            case SHORT: {
                instruction = new IgetShort(destRegister, objectRegister, field);
                break;
            }
            default: {
                throw new Unreachable("Unexpected type: " + (Object)((Object)this.getType()));
            }
        }
        builder.add((Instruction)this, (com.android.tools.r8.code.Instruction)instruction);
    }

    @Override
    public boolean instructionTypeCanThrow() {
        return true;
    }

    @Override
    public boolean instructionMayHaveSideEffects(AppView<?> appView, ProgramMethod context, Instruction.SideEffectAssumption assumption) {
        return this.instructionInstanceCanThrow(appView, context, assumption);
    }

    @Override
    public int maxInValueRegister() {
        return 15;
    }

    @Override
    public int maxOutValueRegister() {
        return 15;
    }

    @Override
    public boolean identicalNonValueNonPositionParts(Instruction other) {
        if (!other.isInstanceGet()) {
            return false;
        }
        InstanceGet o = other.asInstanceGet();
        return o.getField() == this.getField() && o.getType() == this.getType();
    }

    @Override
    public Inliner.ConstraintWithTarget inliningConstraint(InliningConstraints inliningConstraints, ProgramMethod context) {
        return inliningConstraints.forInstanceGet(this.getField(), context);
    }

    @Override
    public boolean isFieldGet() {
        return true;
    }

    @Override
    public FieldGet asFieldGet() {
        return this;
    }

    @Override
    public boolean isInstanceFieldInstruction() {
        return true;
    }

    @Override
    public InstanceFieldInstruction asInstanceFieldInstruction() {
        return this;
    }

    @Override
    public boolean isInstanceGet() {
        return true;
    }

    @Override
    public InstanceGet asInstanceGet() {
        return this;
    }

    @Override
    public String toString() {
        return super.toString() + "; field: " + this.getField().toSourceString();
    }

    @Override
    public TypeElement evaluate(AppView<?> appView) {
        return TypeElement.fromDexType(this.getField().type, Nullability.maybeNull(), appView);
    }

    @Override
    public DexType computeVerificationType(AppView<?> appView, TypeVerificationHelper helper) {
        return this.getField().type;
    }

    @Override
    public void insertLoadAndStores(InstructionListIterator it, LoadStoreHelper helper) {
        helper.loadInValues(this, it);
        helper.storeOutValue(this, it);
    }

    @Override
    public void buildCf(CfBuilder builder) {
        builder.add((CfInstruction)new CfInstanceFieldRead(this.getField(), builder.resolveField(this.getField())), this);
    }

    @Override
    public boolean throwsNpeIfValueIsNull(Value value, AppView<?> appView, ProgramMethod context) {
        return this.object() == value;
    }

    @Override
    public boolean throwsOnNullInput() {
        return true;
    }

    @Override
    public Value getNonNullInput() {
        return this.object();
    }

    @Override
    public boolean definitelyTriggersClassInitialization(DexType clazz, ProgramMethod context, AppView<AppInfoWithLiveness> appView, ClassInitializationAnalysis.Query mode, ClassInitializationAnalysis.AnalysisAssumption assumption) {
        return ClassInitializationAnalysis.InstructionUtils.forInstanceGet(this, clazz, appView, mode, assumption);
    }

    @Override
    public boolean instructionMayTriggerMethodInvocation(AppView<?> appView, ProgramMethod context) {
        return false;
    }
}

