/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.r8.ir.code;

import com.android.tools.r8.cf.LoadStoreHelper;
import com.android.tools.r8.cf.code.CfInstanceOf;
import com.android.tools.r8.cf.code.CfInstruction;
import com.android.tools.r8.graph.AppView;
import com.android.tools.r8.graph.DexType;
import com.android.tools.r8.graph.ProgramMethod;
import com.android.tools.r8.ir.analysis.type.TypeElement;
import com.android.tools.r8.ir.code.Instruction;
import com.android.tools.r8.ir.code.InstructionListIterator;
import com.android.tools.r8.ir.code.InstructionVisitor;
import com.android.tools.r8.ir.code.Phi;
import com.android.tools.r8.ir.code.Value;
import com.android.tools.r8.ir.conversion.CfBuilder;
import com.android.tools.r8.ir.conversion.DexBuilder;
import com.android.tools.r8.ir.optimize.Inliner;
import com.android.tools.r8.ir.optimize.InliningConstraints;
import java.util.Set;

public class InstanceOf
extends Instruction {
    private final DexType type;

    public InstanceOf(Value dest, Value value, DexType type) {
        super(dest, value);
        this.type = type;
    }

    @Override
    public int opcode() {
        return 29;
    }

    @Override
    public <T> T accept(InstructionVisitor<T> visitor) {
        return visitor.visit(this);
    }

    public DexType type() {
        return this.type;
    }

    public Value dest() {
        return this.outValue;
    }

    public Value value() {
        return (Value)this.inValues.get(0);
    }

    @Override
    public void buildDex(DexBuilder builder) {
        int dest = builder.allocatedRegister(this.dest(), this.getNumber());
        int value = builder.allocatedRegister(this.value(), this.getNumber());
        builder.addInstanceOf(this, new com.android.tools.r8.code.InstanceOf(dest, value, this.type));
    }

    @Override
    public int maxInValueRegister() {
        return 15;
    }

    @Override
    public int maxOutValueRegister() {
        return 15;
    }

    @Override
    public boolean instructionTypeCanThrow() {
        return true;
    }

    @Override
    public boolean identicalNonValueNonPositionParts(Instruction other) {
        return other.isInstanceOf() && other.asInstanceOf().type == this.type;
    }

    @Override
    public boolean isInstanceOf() {
        return true;
    }

    @Override
    public InstanceOf asInstanceOf() {
        return this;
    }

    @Override
    public Inliner.ConstraintWithTarget inliningConstraint(InliningConstraints inliningConstraints, ProgramMethod context) {
        return inliningConstraints.forInstanceOf(this.type, context);
    }

    @Override
    public TypeElement evaluate(AppView<?> appView) {
        return TypeElement.getInt();
    }

    @Override
    public boolean hasInvariantOutType() {
        return true;
    }

    @Override
    public void insertLoadAndStores(InstructionListIterator it, LoadStoreHelper helper) {
        helper.loadInValues(this, it);
        helper.storeOutValue(this, it);
    }

    @Override
    public void buildCf(CfBuilder builder) {
        builder.add((CfInstruction)new CfInstanceOf(this.type), this);
    }

    @Override
    public boolean outTypeKnownToBeBoolean(Set<Phi> seen) {
        return true;
    }

    @Override
    public boolean instructionMayTriggerMethodInvocation(AppView<?> appView, ProgramMethod context) {
        return false;
    }

    @Override
    public String toString() {
        StringBuilder builder = new StringBuilder(super.toString());
        return builder.append("; ").append(this.type.toSourceString()).toString();
    }
}

