/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.r8.ir.code;

import com.android.tools.r8.cf.LoadStoreHelper;
import com.android.tools.r8.cf.code.CfInstanceFieldWrite;
import com.android.tools.r8.cf.code.CfInstruction;
import com.android.tools.r8.code.IgetOrIput;
import com.android.tools.r8.code.Iput;
import com.android.tools.r8.code.IputBoolean;
import com.android.tools.r8.code.IputByte;
import com.android.tools.r8.code.IputChar;
import com.android.tools.r8.code.IputObject;
import com.android.tools.r8.code.IputShort;
import com.android.tools.r8.code.IputWide;
import com.android.tools.r8.errors.Unreachable;
import com.android.tools.r8.graph.AppInfo;
import com.android.tools.r8.graph.AppView;
import com.android.tools.r8.graph.DexEncodedField;
import com.android.tools.r8.graph.DexField;
import com.android.tools.r8.graph.DexType;
import com.android.tools.r8.graph.FieldResolutionResult;
import com.android.tools.r8.graph.ProgramMethod;
import com.android.tools.r8.ir.analysis.ClassInitializationAnalysis;
import com.android.tools.r8.ir.code.FieldInstruction;
import com.android.tools.r8.ir.code.FieldPut;
import com.android.tools.r8.ir.code.InstanceFieldInstruction;
import com.android.tools.r8.ir.code.Instruction;
import com.android.tools.r8.ir.code.InstructionListIterator;
import com.android.tools.r8.ir.code.InstructionVisitor;
import com.android.tools.r8.ir.code.Value;
import com.android.tools.r8.ir.code.ValueType;
import com.android.tools.r8.ir.conversion.CfBuilder;
import com.android.tools.r8.ir.conversion.DexBuilder;
import com.android.tools.r8.ir.conversion.MethodConversionOptions;
import com.android.tools.r8.ir.optimize.Inliner;
import com.android.tools.r8.ir.optimize.InliningConstraints;
import com.android.tools.r8.ir.regalloc.RegisterAllocator;
import com.android.tools.r8.shaking.AppInfoWithLiveness;
import java.util.Arrays;

public class InstancePut
extends FieldInstruction
implements FieldPut,
InstanceFieldInstruction {
    public InstancePut(DexField field, Value object, Value value) {
        this(field, object, value, false);
    }

    public static InstancePut createPotentiallyInvalid(DexField field, Value object, Value value) {
        return new InstancePut(field, object, value, true);
    }

    private InstancePut(DexField field, Value object, Value value, boolean skipAssertion) {
        super(field, null, Arrays.asList(object, value));
        if (!skipAssertion) {
            assert (this.object().verifyCompatible(ValueType.OBJECT));
            assert (this.value().verifyCompatible(ValueType.fromDexType(field.type)));
        }
    }

    @Override
    public int opcode() {
        return 30;
    }

    @Override
    public <T> T accept(InstructionVisitor<T> visitor) {
        return visitor.visit(this);
    }

    @Override
    public int getValueIndex() {
        return 1;
    }

    @Override
    public Value object() {
        return (Value)this.inValues.get(0);
    }

    @Override
    public Value value() {
        return (Value)this.inValues.get(this.getValueIndex());
    }

    @Override
    public void setValue(Value value) {
        this.replaceValue(1, value);
    }

    @Override
    public void buildDex(DexBuilder builder) {
        IgetOrIput instruction;
        int valueRegister = builder.allocatedRegister(this.value(), this.getNumber());
        int objectRegister = builder.allocatedRegister(this.object(), this.getNumber());
        DexField field = this.getField();
        switch (this.getType()) {
            case INT: 
            case FLOAT: {
                instruction = new Iput(valueRegister, objectRegister, field);
                break;
            }
            case LONG: 
            case DOUBLE: {
                instruction = new IputWide(valueRegister, objectRegister, field);
                break;
            }
            case OBJECT: {
                instruction = new IputObject(valueRegister, objectRegister, field);
                break;
            }
            case BOOLEAN: {
                instruction = new IputBoolean(valueRegister, objectRegister, field);
                break;
            }
            case BYTE: {
                instruction = new IputByte(valueRegister, objectRegister, field);
                break;
            }
            case CHAR: {
                instruction = new IputChar(valueRegister, objectRegister, field);
                break;
            }
            case SHORT: {
                instruction = new IputShort(valueRegister, objectRegister, field);
                break;
            }
            default: {
                throw new Unreachable("Unexpected type: " + (Object)((Object)this.getType()));
            }
        }
        builder.add((Instruction)this, (com.android.tools.r8.code.Instruction)instruction);
    }

    @Override
    public boolean instructionTypeCanThrow() {
        return true;
    }

    @Override
    public boolean instructionMayHaveSideEffects(AppView<?> appView, ProgramMethod context, Instruction.SideEffectAssumption assumption) {
        if (((AppInfo)appView.appInfo()).hasLiveness()) {
            AppView<AppInfoWithLiveness> appViewWithLiveness = appView.withLiveness();
            AppInfoWithLiveness appInfoWithLiveness = appViewWithLiveness.appInfo();
            FieldResolutionResult resolutionResult = appInfoWithLiveness.resolveField(this.getField());
            if (this.internalInstructionInstanceCanThrow(appView, context, assumption, resolutionResult)) {
                return true;
            }
            DexEncodedField encodedField = resolutionResult.getResolvedField();
            assert (encodedField != null) : "NoSuchFieldError (resolution failure) should be caught.";
            if (encodedField.type().isAlwaysNull(appViewWithLiveness)) {
                return false;
            }
            return appInfoWithLiveness.isFieldRead(encodedField) || this.isStoringObjectWithFinalizer(appViewWithLiveness, encodedField);
        }
        return true;
    }

    @Override
    public boolean identicalAfterRegisterAllocation(Instruction other, RegisterAllocator allocator, MethodConversionOptions conversionOptions) {
        if (!super.identicalAfterRegisterAllocation(other, allocator, conversionOptions)) {
            return false;
        }
        if (allocator.options().canHaveIncorrectJoinForArrayOfInterfacesBug()) {
            InstancePut instancePut = other.asInstancePut();
            if (this.value().getType().isArrayType() && this.value() != instancePut.value()) {
                return false;
            }
        }
        return true;
    }

    @Override
    public boolean identicalNonValueNonPositionParts(Instruction other) {
        if (!other.isInstancePut()) {
            return false;
        }
        InstancePut o = other.asInstancePut();
        return o.getField() == this.getField() && o.getType() == this.getType();
    }

    @Override
    public int maxInValueRegister() {
        return 15;
    }

    @Override
    public int maxOutValueRegister() {
        assert (false) : "InstancePut instructions define no values.";
        return 0;
    }

    @Override
    public Inliner.ConstraintWithTarget inliningConstraint(InliningConstraints inliningConstraints, ProgramMethod context) {
        return inliningConstraints.forInstancePut(this.getField(), context);
    }

    @Override
    public boolean isFieldPut() {
        return true;
    }

    @Override
    public FieldPut asFieldPut() {
        return this;
    }

    @Override
    public boolean isInstanceFieldInstruction() {
        return true;
    }

    @Override
    public InstanceFieldInstruction asInstanceFieldInstruction() {
        return this;
    }

    @Override
    public boolean isInstancePut() {
        return true;
    }

    @Override
    public InstancePut asInstancePut() {
        return this;
    }

    @Override
    public String toString() {
        return super.toString() + "; field: " + this.getField().toSourceString();
    }

    @Override
    public void insertLoadAndStores(InstructionListIterator it, LoadStoreHelper helper) {
        helper.loadInValues(this, it);
    }

    @Override
    public void buildCf(CfBuilder builder) {
        builder.add((CfInstruction)new CfInstanceFieldWrite(this.getField(), builder.resolveField(this.getField())), this);
    }

    @Override
    public boolean throwsNpeIfValueIsNull(Value value, AppView<?> appView, ProgramMethod context) {
        return this.object() == value;
    }

    @Override
    public boolean throwsOnNullInput() {
        return true;
    }

    @Override
    public Value getNonNullInput() {
        return this.object();
    }

    @Override
    public boolean definitelyTriggersClassInitialization(DexType clazz, ProgramMethod context, AppView<AppInfoWithLiveness> appView, ClassInitializationAnalysis.Query mode, ClassInitializationAnalysis.AnalysisAssumption assumption) {
        return ClassInitializationAnalysis.InstructionUtils.forInstancePut(this, clazz, appView, mode, assumption);
    }

    @Override
    public boolean instructionMayTriggerMethodInvocation(AppView<?> appView, ProgramMethod context) {
        return false;
    }
}

