/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.r8.ir.code;

import com.android.tools.r8.com.google.common.collect.Iterables;
import com.android.tools.r8.graph.AppInfo;
import com.android.tools.r8.graph.AppInfoWithClassHierarchy;
import com.android.tools.r8.graph.AppView;
import com.android.tools.r8.graph.DexClass;
import com.android.tools.r8.graph.DexClassAndMethod;
import com.android.tools.r8.graph.DexEncodedMethod;
import com.android.tools.r8.graph.DexMethod;
import com.android.tools.r8.graph.DexProgramClass;
import com.android.tools.r8.graph.DexType;
import com.android.tools.r8.graph.MethodResolutionResult;
import com.android.tools.r8.graph.ProgramDefinition;
import com.android.tools.r8.graph.ProgramMethod;
import com.android.tools.r8.ir.analysis.ClassInitializationAnalysis;
import com.android.tools.r8.ir.analysis.VerifyTypesHelper;
import com.android.tools.r8.ir.analysis.type.ClassTypeElement;
import com.android.tools.r8.ir.analysis.type.DynamicType;
import com.android.tools.r8.ir.analysis.type.DynamicTypeWithUpperBound;
import com.android.tools.r8.ir.analysis.type.TypeAnalysis;
import com.android.tools.r8.ir.analysis.type.TypeElement;
import com.android.tools.r8.ir.code.Instruction;
import com.android.tools.r8.ir.code.InvokeMethod;
import com.android.tools.r8.ir.code.Value;
import com.android.tools.r8.ir.optimize.DefaultInliningOracle;
import com.android.tools.r8.ir.optimize.Inliner;
import com.android.tools.r8.ir.optimize.info.MethodOptimizationInfo;
import com.android.tools.r8.ir.optimize.info.initializer.InstanceInitializerInfo;
import com.android.tools.r8.ir.optimize.inliner.WhyAreYouNotInliningReporter;
import com.android.tools.r8.shaking.AppInfoWithLiveness;
import java.util.List;

public abstract class InvokeMethodWithReceiver
extends InvokeMethod {
    InvokeMethodWithReceiver(DexMethod target, Value result, List<Value> arguments) {
        super(target, result, arguments);
    }

    private boolean upperBoundAssumedByCallSiteOptimizationAndNoLongerInstantiated(AppView<AppInfoWithLiveness> appViewWithLiveness, DexType upperBoundType, DexType lowerBoundType) {
        if (!this.getReceiver().getAliasedValue().isArgument()) {
            return false;
        }
        if (!this.getReceiver().isDefinedByInstructionSatisfying(Instruction::isAssumeWithDynamicTypeAssumption)) {
            return false;
        }
        DexProgramClass upperBound = appViewWithLiveness.definitionForProgramType(upperBoundType);
        if (upperBound == null) {
            return false;
        }
        if (appViewWithLiveness.appInfo().isInstantiatedDirectlyOrIndirectly(upperBound)) {
            return false;
        }
        DexClass lowerBound = appViewWithLiveness.definitionFor(lowerBoundType);
        return lowerBound != null && lowerBound.isEffectivelyFinal(appViewWithLiveness);
    }

    public Iterable<Value> getNonReceiverArguments() {
        return Iterables.skip(this.arguments(), 1);
    }

    @Override
    public boolean isInvokeMethodWithReceiver() {
        return true;
    }

    @Override
    public InvokeMethodWithReceiver asInvokeMethodWithReceiver() {
        return this;
    }

    public Value getReceiver() {
        assert (this.inValues.size() > 0);
        return (Value)this.inValues.get(0);
    }

    @Override
    public final Inliner.InlineAction computeInlining(ProgramMethod singleTarget, Inliner.Reason reason, DefaultInliningOracle decider, ClassInitializationAnalysis classInitializationAnalysis, WhyAreYouNotInliningReporter whyAreYouNotInliningReporter) {
        return decider.computeForInvokeWithReceiver(this, singleTarget, reason, whyAreYouNotInliningReporter);
    }

    @Override
    public final DexClassAndMethod lookupSingleTarget(AppView<?> appView, ProgramMethod context) {
        DynamicTypeWithUpperBound dynamicReceiverType = appView.hasLiveness() ? this.getReceiver().getDynamicType(appView.withLiveness()) : DynamicType.unknown();
        return this.lookupSingleTarget(appView, context, dynamicReceiverType);
    }

    public abstract DexClassAndMethod lookupSingleTarget(AppView<?> var1, ProgramMethod var2, DynamicType var3);

    public final ProgramMethod lookupSingleProgramTarget(AppView<?> appView, ProgramMethod context, DynamicType dynamicReceiverType) {
        return DexClassAndMethod.asProgramMethodOrNull(this.lookupSingleTarget(appView, context, dynamicReceiverType));
    }

    @Override
    public boolean throwsNpeIfValueIsNull(Value value, AppView<?> appView, ProgramMethod context) {
        return value == this.getReceiver() || super.throwsNpeIfValueIsNull(value, appView, context);
    }

    @Override
    public boolean throwsOnNullInput() {
        return true;
    }

    @Override
    public Value getNonNullInput() {
        return this.getReceiver();
    }

    @Override
    public boolean verifyTypes(AppView<?> appView, VerifyTypesHelper verifyTypesHelper) {
        AppView<AppInfoWithLiveness> appViewWithLiveness;
        ClassTypeElement receiverLowerBoundType;
        assert (super.verifyTypes(appView, verifyTypesHelper));
        Value receiver = this.getReceiver();
        TypeElement receiverType = receiver.getType();
        assert (receiverType.isPreciseType());
        if (((AppInfo)appView.appInfo()).hasLiveness() && (receiverLowerBoundType = receiver.getDynamicLowerBoundType(appViewWithLiveness = appView.withLiveness())) != null) {
            DexType refinedReceiverType = TypeAnalysis.getRefinedReceiverType(appViewWithLiveness, this);
            assert (appViewWithLiveness.appInfo().isSubtype(receiverLowerBoundType.getClassType(), refinedReceiverType) || appView.options().testing.allowTypeErrors || receiver.getDynamicUpperBoundType(appViewWithLiveness).isNullType() || receiverLowerBoundType.isBasedOnMissingClass(appViewWithLiveness) || this.upperBoundAssumedByCallSiteOptimizationAndNoLongerInstantiated(appViewWithLiveness, refinedReceiverType, receiverLowerBoundType.getClassType())) : "The receiver lower bound does not match the receiver type";
        }
        return true;
    }

    @Override
    public boolean instructionMayHaveSideEffects(AppView<?> appView, ProgramMethod context, Instruction.SideEffectAssumption assumption) {
        if (appView.options().debug) {
            return true;
        }
        Value receiver = this.getReceiver();
        if (!assumption.canAssumeReceiverIsNotNull() && receiver.getType().isNullable()) {
            return true;
        }
        if (this.getInvokedMethod().holder.isArrayType() && this.getInvokedMethod().match(appView.dexItemFactory().objectMembers.clone)) {
            return !this.isInvokeVirtual();
        }
        if (appView.getLibraryMethodSideEffectModelCollection().isCallToSideEffectFreeFinalMethod(this)) {
            return false;
        }
        if (!appView.enableWholeProgramOptimizations()) {
            return true;
        }
        assert (((AppInfo)appView.appInfo()).hasClassHierarchy());
        AppView<AppInfoWithClassHierarchy> appViewWithClassHierarchy = appView.withClassHierarchy();
        MethodResolutionResult.SingleResolutionResult resolutionResult = appViewWithClassHierarchy.appInfo().resolveMethod(this.getInvokedMethod(), this.getInterfaceBit()).asSingleResolution();
        if (resolutionResult == null) {
            return true;
        }
        if (resolutionResult.isAccessibleFrom((ProgramDefinition)context, appViewWithClassHierarchy).isPossiblyFalse()) {
            return true;
        }
        if (assumption.canAssumeInvokedMethodDoesNotHaveSideEffects()) {
            return false;
        }
        DexClassAndMethod resolvedMethod = resolutionResult.getResolutionPair();
        if (appView.hasLiveness() && (appView.appInfoWithLiveness().isAssumeNoSideEffectsMethod(this.getInvokedMethod()) || appView.appInfoWithLiveness().isAssumeNoSideEffectsMethod(resolvedMethod))) {
            return false;
        }
        DexClassAndMethod singleTarget = this.lookupSingleTarget(appView, context);
        if (singleTarget == null) {
            return true;
        }
        if (singleTarget.isLibraryMethod() && appView.getLibraryMethodSideEffectModelCollection().isSideEffectFree(this, singleTarget.asLibraryMethod())) {
            return false;
        }
        if (appView.hasLiveness() && appView.appInfoWithLiveness().isAssumeNoSideEffectsMethod(singleTarget)) {
            return false;
        }
        DexEncodedMethod singleTargetDefinition = (DexEncodedMethod)singleTarget.getDefinition();
        MethodOptimizationInfo optimizationInfo = singleTargetDefinition.getOptimizationInfo();
        if (assumption.canIgnoreInstanceFieldAssignmentsToReceiver() && singleTargetDefinition.isInstanceInitializer()) {
            assert (this.isInvokeDirect());
            InstanceInitializerInfo initializerInfo = optimizationInfo.getInstanceInitializerInfo(this.asInvokeDirect());
            if (!initializerInfo.mayHaveOtherSideEffectsThanInstanceFieldAssignments()) {
                return !this.isInvokeDirect();
            }
        }
        return optimizationInfo.mayHaveSideEffects(this, appView.options());
    }
}

