/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.r8.ir.code;

import com.android.tools.r8.com.google.common.collect.Sets;
import com.android.tools.r8.graph.AppInfoWithClassHierarchy;
import com.android.tools.r8.graph.AppView;
import com.android.tools.r8.graph.DebugLocalInfo;
import com.android.tools.r8.graph.DexField;
import com.android.tools.r8.graph.DexProgramClass;
import com.android.tools.r8.graph.DexString;
import com.android.tools.r8.graph.DexType;
import com.android.tools.r8.graph.ProgramMethod;
import com.android.tools.r8.ir.analysis.type.TypeElement;
import com.android.tools.r8.ir.code.BasicBlock;
import com.android.tools.r8.ir.code.BasicBlockIterator;
import com.android.tools.r8.ir.code.Goto;
import com.android.tools.r8.ir.code.IRCode;
import com.android.tools.r8.ir.code.InitClass;
import com.android.tools.r8.ir.code.Instruction;
import com.android.tools.r8.ir.code.InstructionListIterator;
import com.android.tools.r8.ir.code.InvokeMethod;
import com.android.tools.r8.ir.code.Position;
import com.android.tools.r8.ir.code.Value;
import com.android.tools.r8.shaking.AppInfoWithLiveness;
import com.android.tools.r8.utils.InternalOptions;
import java.util.ListIterator;
import java.util.Set;
import java.util.function.Consumer;

public class LinearFlowInstructionListIterator
implements InstructionListIterator {
    private final IRCode code;
    private BasicBlock currentBlock;
    private InstructionListIterator currentBlockIterator;
    private Set<BasicBlock> seenBlocks = Sets.newIdentityHashSet();

    public LinearFlowInstructionListIterator(IRCode code, BasicBlock block) {
        this(code, block, 0);
    }

    public LinearFlowInstructionListIterator(IRCode code, BasicBlock block, int index) {
        this.code = code;
        this.currentBlock = block;
        this.currentBlockIterator = block.listIterator(code, index);
        this.seenBlocks.add(block);
        if (index > 0) {
            this.previous();
            this.next();
        }
    }

    private boolean isLinearEdge(BasicBlock pred, BasicBlock succ) {
        assert (pred.getSuccessors().contains(succ));
        assert (succ.getPredecessors().contains(pred));
        Goto exit = pred.exit().asGoto();
        return exit != null && exit.getTarget() == succ && succ.getPredecessors().size() == 1;
    }

    private BasicBlock getBeginningOfTrivialLinearGotoChain(BasicBlock block) {
        if (block.getPredecessors().size() != 1 || !this.isLinearEdge(block.getPredecessors().get(0), block)) {
            return null;
        }
        BasicBlock target = block.getPredecessors().get(0);
        while (target.getPredecessors().size() == 1 && this.isLinearEdge(target.getPredecessors().get(0), target) && target.isTrivialGoto()) {
            target = target.getPredecessors().get(0);
        }
        return target.isTrivialGoto() ? null : target;
    }

    public boolean hasVisitedBlock(BasicBlock basicBlock) {
        return this.seenBlocks.contains(basicBlock);
    }

    public Set<BasicBlock> getSeenBlocks() {
        return this.seenBlocks;
    }

    @Override
    public void replaceCurrentInstruction(Instruction newInstruction, Set<Value> affectedValues) {
        this.currentBlockIterator.replaceCurrentInstruction(newInstruction, affectedValues);
    }

    @Override
    public Value insertConstNumberInstruction(IRCode code, InternalOptions options, long value, TypeElement type) {
        return this.currentBlockIterator.insertConstNumberInstruction(code, options, value, type);
    }

    @Override
    public Value insertConstStringInstruction(AppView<?> appView, IRCode code, DexString value) {
        return this.currentBlockIterator.insertConstStringInstruction(appView, code, value);
    }

    @Override
    public InvokeMethod insertNullCheckInstruction(AppView<?> appView, IRCode code, BasicBlockIterator blockIterator, Value value, Position position) {
        return this.currentBlockIterator.insertNullCheckInstruction(appView, code, blockIterator, value, position);
    }

    @Override
    public boolean replaceCurrentInstructionByNullCheckIfPossible(AppView<?> appView, ProgramMethod context) {
        return this.currentBlockIterator.replaceCurrentInstructionByNullCheckIfPossible(appView, context);
    }

    @Override
    public boolean removeOrReplaceCurrentInstructionByInitClassIfPossible(AppView<AppInfoWithLiveness> appView, IRCode code, DexType type, Consumer<InitClass> consumer) {
        return this.currentBlockIterator.removeOrReplaceCurrentInstructionByInitClassIfPossible(appView, code, type, consumer);
    }

    @Override
    public void replaceCurrentInstructionWithConstClass(AppView<?> appView, IRCode code, DexType type, DebugLocalInfo localInfo) {
        this.currentBlockIterator.replaceCurrentInstructionWithConstClass(appView, code, type, localInfo);
    }

    @Override
    public void replaceCurrentInstructionWithConstInt(IRCode code, int value) {
        this.currentBlockIterator.replaceCurrentInstructionWithConstInt(code, value);
    }

    @Override
    public void replaceCurrentInstructionWithConstString(AppView<?> appView, IRCode code, DexString value) {
        this.currentBlockIterator.replaceCurrentInstructionWithConstString(appView, code, value);
    }

    @Override
    public void replaceCurrentInstructionWithStaticGet(AppView<?> appView, IRCode code, DexField field, Set<Value> affectedValues) {
        this.currentBlockIterator.replaceCurrentInstructionWithStaticGet(appView, code, field, affectedValues);
    }

    @Override
    public void replaceCurrentInstructionWithThrow(AppView<?> appView, IRCode code, ListIterator<BasicBlock> blockIterator, Value exceptionValue, Set<BasicBlock> blocksToRemove, Set<Value> affectedValues) {
        this.currentBlockIterator.replaceCurrentInstructionWithThrow(appView, code, blockIterator, exceptionValue, blocksToRemove, affectedValues);
    }

    @Override
    public void replaceCurrentInstructionWithThrowNull(AppView<? extends AppInfoWithClassHierarchy> appView, IRCode code, ListIterator<BasicBlock> blockIterator, Set<BasicBlock> blocksToRemove, Set<Value> affectedValues) {
        this.currentBlockIterator.replaceCurrentInstructionWithThrowNull(appView, code, blockIterator, blocksToRemove, affectedValues);
    }

    @Override
    public BasicBlock split(IRCode code, ListIterator<BasicBlock> blockIterator, boolean keepCatchHandlers) {
        return this.currentBlockIterator.split(code, blockIterator, keepCatchHandlers);
    }

    @Override
    public BasicBlock split(IRCode code, int instructions, ListIterator<BasicBlock> blockIterator) {
        return this.currentBlockIterator.split(code, instructions, blockIterator);
    }

    @Override
    public BasicBlock splitCopyCatchHandlers(IRCode code, ListIterator<BasicBlock> blockIterator, InternalOptions options) {
        return this.currentBlockIterator.splitCopyCatchHandlers(code, blockIterator, options);
    }

    @Override
    public BasicBlock inlineInvoke(AppView<?> appView, IRCode code, IRCode inlinee, ListIterator<BasicBlock> blockIterator, Set<BasicBlock> blocksToRemove, DexProgramClass downcast) {
        return this.currentBlockIterator.inlineInvoke(appView, code, inlinee, blockIterator, blocksToRemove, downcast);
    }

    @Override
    public void add(Instruction instruction) {
        this.currentBlockIterator.add(instruction);
    }

    @Override
    public void addThrowingInstructionToPossiblyThrowingBlock(IRCode code, ListIterator<BasicBlock> blockIterator, Instruction instruction, InternalOptions options) {
        this.currentBlockIterator.addThrowingInstructionToPossiblyThrowingBlock(code, blockIterator, instruction, options);
    }

    @Override
    public void removeOrReplaceByDebugLocalRead() {
        this.currentBlockIterator.removeOrReplaceByDebugLocalRead();
    }

    @Override
    public boolean hasNext() {
        return this.currentBlockIterator.hasNext();
    }

    @Override
    public Instruction next() {
        BasicBlock candidate;
        Instruction current = (Instruction)this.currentBlockIterator.next();
        if (!current.isGoto()) {
            return current;
        }
        BasicBlock target = current.asGoto().getTarget();
        if (!this.isLinearEdge(this.currentBlock, target)) {
            return current;
        }
        while (target.isTrivialGoto() && this.isLinearEdge(target, candidate = target.exit().asGoto().getTarget())) {
            this.seenBlocks.add(target);
            target = candidate;
        }
        this.currentBlock = target;
        this.seenBlocks.add(target);
        this.currentBlockIterator = this.currentBlock.listIterator(this.code);
        return (Instruction)this.currentBlockIterator.next();
    }

    @Override
    public boolean hasPrevious() {
        if (this.currentBlockIterator.hasPrevious()) {
            return true;
        }
        return this.getBeginningOfTrivialLinearGotoChain(this.currentBlock) != null;
    }

    @Override
    public Instruction previous() {
        if (this.currentBlockIterator.hasPrevious()) {
            return (Instruction)this.currentBlockIterator.previous();
        }
        BasicBlock target = this.getBeginningOfTrivialLinearGotoChain(this.currentBlock);
        if (target == null) {
            return (Instruction)this.currentBlockIterator.previous();
        }
        this.currentBlock = target;
        this.seenBlocks.add(target);
        this.currentBlockIterator = this.currentBlock.listIterator(this.code, this.currentBlock.getInstructions().size());
        this.currentBlockIterator.previous();
        return (Instruction)this.currentBlockIterator.previous();
    }

    @Override
    public int nextIndex() {
        throw new UnsupportedOperationException();
    }

    @Override
    public int previousIndex() {
        throw new UnsupportedOperationException();
    }

    @Override
    public void remove() {
        this.currentBlockIterator.remove();
    }

    @Override
    public void set(Instruction instruction) {
        this.currentBlockIterator.set(instruction);
    }
}

