/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.r8.ir.code;

import com.android.tools.r8.cf.code.CfInstruction;
import com.android.tools.r8.cf.code.CfLogicalBinop;
import com.android.tools.r8.errors.Unreachable;
import com.android.tools.r8.ir.analysis.constant.Bottom;
import com.android.tools.r8.ir.analysis.constant.ConstLatticeElement;
import com.android.tools.r8.ir.analysis.constant.LatticeElement;
import com.android.tools.r8.ir.analysis.type.TypeElement;
import com.android.tools.r8.ir.code.Binop;
import com.android.tools.r8.ir.code.ConstNumber;
import com.android.tools.r8.ir.code.IRCode;
import com.android.tools.r8.ir.code.Instruction;
import com.android.tools.r8.ir.code.NumericType;
import com.android.tools.r8.ir.code.Value;
import com.android.tools.r8.ir.conversion.CfBuilder;
import com.android.tools.r8.ir.conversion.DexBuilder;
import java.util.function.Function;

public abstract class LogicalBinop
extends Binop {
    public LogicalBinop(NumericType type, Value dest, Value left, Value right) {
        super(type, dest, left, right);
    }

    public abstract com.android.tools.r8.code.Instruction CreateInt(int var1, int var2, int var3);

    public abstract com.android.tools.r8.code.Instruction CreateLong(int var1, int var2, int var3);

    public abstract com.android.tools.r8.code.Instruction CreateInt2Addr(int var1, int var2);

    public abstract com.android.tools.r8.code.Instruction CreateLong2Addr(int var1, int var2);

    public abstract com.android.tools.r8.code.Instruction CreateIntLit8(int var1, int var2, int var3);

    public abstract com.android.tools.r8.code.Instruction CreateIntLit16(int var1, int var2, int var3);

    @Override
    public boolean canBeFolded() {
        return this.leftValue().isConstant() && this.rightValue().isConstant();
    }

    @Override
    public boolean needsValueInRegister(Value value) {
        if (value == this.leftValue()) {
            return true;
        }
        assert (value == this.rightValue());
        return !this.fitsInDexInstruction(value);
    }

    @Override
    public void buildDex(DexBuilder builder) {
        com.android.tools.r8.code.Instruction instruction;
        int left = builder.allocatedRegister(this.leftValue(), this.getNumber());
        int dest = builder.allocatedRegister(this.outValue, this.getNumber());
        if (this.isTwoAddr(builder.getRegisterAllocator())) {
            int right = builder.allocatedRegister(this.rightValue(), this.getNumber());
            if (left != dest) {
                assert (this.isCommutative());
                assert (right == dest);
                right = left;
            }
            switch (this.type) {
                case INT: {
                    instruction = this.CreateInt2Addr(dest, right);
                    break;
                }
                case LONG: {
                    instruction = this.CreateLong2Addr(dest, right);
                    break;
                }
                default: {
                    throw new Unreachable("Unexpected type " + (Object)((Object)this.type));
                }
            }
        } else if (!this.needsValueInRegister(this.rightValue())) {
            assert (this.fitsInDexInstruction(this.rightValue()));
            ConstNumber right = this.rightValue().getConstInstruction().asConstNumber();
            if (right.is8Bit()) {
                instruction = this.CreateIntLit8(dest, left, right.getIntValue());
            } else {
                assert (right.is16Bit());
                instruction = this.CreateIntLit16(dest, left, right.getIntValue());
            }
        } else {
            int right = builder.allocatedRegister(this.rightValue(), this.getNumber());
            switch (this.type) {
                case INT: {
                    instruction = this.CreateInt(dest, left, right);
                    break;
                }
                case LONG: {
                    instruction = this.CreateLong(dest, left, right);
                    break;
                }
                default: {
                    throw new Unreachable("Unexpected type " + (Object)((Object)this.type));
                }
            }
        }
        builder.add((Instruction)this, instruction);
    }

    @Override
    public boolean isLogicalBinop() {
        return true;
    }

    @Override
    public LogicalBinop asLogicalBinop() {
        return this;
    }

    @Override
    public LatticeElement evaluate(IRCode code, Function<Value, LatticeElement> getLatticeElement) {
        LatticeElement leftLattice = getLatticeElement.apply(this.leftValue());
        LatticeElement rightLattice = getLatticeElement.apply(this.rightValue());
        if (leftLattice.isConst() && rightLattice.isConst()) {
            ConstNumber newConst;
            ConstNumber leftConst = leftLattice.asConst().getConstNumber();
            ConstNumber rightConst = rightLattice.asConst().getConstNumber();
            if (this.type == NumericType.INT) {
                int result = this.foldIntegers(leftConst.getIntValue(), rightConst.getIntValue());
                Value value = code.createValue(TypeElement.getInt(), this.getLocalInfo());
                newConst = new ConstNumber(value, result);
            } else {
                assert (this.type == NumericType.LONG);
                long right = this.isShl() || this.isShr() || this.isUshr() ? (long)rightConst.getIntValue() : rightConst.getLongValue();
                long result = this.foldLongs(leftConst.getLongValue(), right);
                Value value = code.createValue(TypeElement.getLong(), this.getLocalInfo());
                newConst = new ConstNumber(value, result);
            }
            return new ConstLatticeElement(newConst);
        }
        return Bottom.getInstance();
    }

    abstract CfLogicalBinop.Opcode getCfOpcode();

    @Override
    public void buildCf(CfBuilder builder) {
        builder.add((CfInstruction)new CfLogicalBinop(this.getCfOpcode(), this.type), this);
    }
}

