/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.r8.ir.code;

import com.android.tools.r8.cf.LoadStoreHelper;
import com.android.tools.r8.cf.TypeVerificationHelper;
import com.android.tools.r8.cf.code.CfInstruction;
import com.android.tools.r8.cf.code.CfNewArray;
import com.android.tools.r8.code.NewArray;
import com.android.tools.r8.graph.AppInfoWithClassHierarchy;
import com.android.tools.r8.graph.AppView;
import com.android.tools.r8.graph.DexType;
import com.android.tools.r8.graph.ProgramMethod;
import com.android.tools.r8.ir.analysis.type.Nullability;
import com.android.tools.r8.ir.analysis.type.TypeElement;
import com.android.tools.r8.ir.analysis.value.AbstractValue;
import com.android.tools.r8.ir.analysis.value.StatefulObjectValue;
import com.android.tools.r8.ir.analysis.value.UnknownValue;
import com.android.tools.r8.ir.code.IRCode;
import com.android.tools.r8.ir.code.Instruction;
import com.android.tools.r8.ir.code.InstructionListIterator;
import com.android.tools.r8.ir.code.InstructionVisitor;
import com.android.tools.r8.ir.code.Value;
import com.android.tools.r8.ir.conversion.CfBuilder;
import com.android.tools.r8.ir.conversion.DexBuilder;
import com.android.tools.r8.ir.optimize.DeadCodeRemover;
import com.android.tools.r8.ir.optimize.Inliner;
import com.android.tools.r8.ir.optimize.InliningConstraints;

public class NewArrayEmpty
extends Instruction {
    public final DexType type;

    public NewArrayEmpty(Value dest, Value size, DexType type) {
        super(dest, size);
        this.type = type;
    }

    @Override
    public int opcode() {
        return 47;
    }

    @Override
    public <T> T accept(InstructionVisitor<T> visitor) {
        return visitor.visit(this);
    }

    @Override
    public String toString() {
        return super.toString() + " " + this.type.toString();
    }

    public Value dest() {
        return this.outValue;
    }

    public Value size() {
        return (Value)this.inValues.get(0);
    }

    @Override
    public void buildDex(DexBuilder builder) {
        int size = builder.allocatedRegister(this.size(), this.getNumber());
        int dest = builder.allocatedRegister(this.dest(), this.getNumber());
        builder.add((Instruction)this, (com.android.tools.r8.code.Instruction)new NewArray(dest, size, this.type));
    }

    @Override
    public int maxInValueRegister() {
        return 15;
    }

    @Override
    public int maxOutValueRegister() {
        return 15;
    }

    @Override
    public boolean instructionTypeCanThrow() {
        return true;
    }

    @Override
    public boolean instructionInstanceCanThrow() {
        return this.size().definition == null || !this.size().definition.isConstNumber() || this.size().definition.asConstNumber().getRawValue() < 0L || this.size().definition.asConstNumber().getRawValue() >= Integer.MAX_VALUE;
    }

    @Override
    public AbstractValue getAbstractValue(AppView<? extends AppInfoWithClassHierarchy> appView, ProgramMethod context) {
        if (!this.instructionMayHaveSideEffects(appView, context) && this.size().getType().isInt()) {
            assert (!this.instructionInstanceCanThrow());
            return StatefulObjectValue.create(appView.abstractValueFactory().createKnownLengthArrayState(this.size().definition.asConstNumber().getIntValue()));
        }
        return UnknownValue.getInstance();
    }

    @Override
    public DeadCodeRemover.DeadInstructionResult canBeDeadCode(AppView<?> appView, IRCode code) {
        if (this.instructionInstanceCanThrow()) {
            return DeadCodeRemover.DeadInstructionResult.notDead();
        }
        DexType baseType = this.type.toBaseType(appView.dexItemFactory());
        if (baseType.isPrimitiveType() || appView.definitionFor(baseType) != null) {
            return DeadCodeRemover.DeadInstructionResult.deadIfOutValueIsDead();
        }
        return DeadCodeRemover.DeadInstructionResult.notDead();
    }

    @Override
    public boolean identicalNonValueNonPositionParts(Instruction other) {
        return other.isNewArrayEmpty() && other.asNewArrayEmpty().type == this.type;
    }

    @Override
    public boolean isNewArrayEmpty() {
        return true;
    }

    @Override
    public NewArrayEmpty asNewArrayEmpty() {
        return this;
    }

    @Override
    public Inliner.ConstraintWithTarget inliningConstraint(InliningConstraints inliningConstraints, ProgramMethod context) {
        return inliningConstraints.forNewArrayEmpty(this.type, context);
    }

    @Override
    public boolean hasInvariantOutType() {
        return true;
    }

    @Override
    public DexType computeVerificationType(AppView<?> appView, TypeVerificationHelper helper) {
        return this.type;
    }

    @Override
    public void insertLoadAndStores(InstructionListIterator it, LoadStoreHelper helper) {
        helper.loadInValues(this, it);
        helper.storeOutValue(this, it);
    }

    @Override
    public void buildCf(CfBuilder builder) {
        assert (this.type.isArrayType());
        builder.add((CfInstruction)new CfNewArray(this.type), this);
    }

    @Override
    public TypeElement evaluate(AppView<?> appView) {
        return TypeElement.fromDexType(this.type, Nullability.definitelyNotNull(), appView);
    }

    @Override
    public boolean instructionMayTriggerMethodInvocation(AppView<?> appView, ProgramMethod context) {
        return false;
    }
}

