/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.r8.ir.code;

import com.android.tools.r8.cf.LoadStoreHelper;
import com.android.tools.r8.code.FillArrayData;
import com.android.tools.r8.code.FillArrayDataPayload;
import com.android.tools.r8.errors.Unreachable;
import com.android.tools.r8.graph.AppInfoWithClassHierarchy;
import com.android.tools.r8.graph.AppView;
import com.android.tools.r8.graph.ProgramMethod;
import com.android.tools.r8.ir.analysis.value.AbstractValue;
import com.android.tools.r8.ir.analysis.value.StatefulObjectValue;
import com.android.tools.r8.ir.analysis.value.UnknownValue;
import com.android.tools.r8.ir.code.Instruction;
import com.android.tools.r8.ir.code.InstructionListIterator;
import com.android.tools.r8.ir.code.InstructionVisitor;
import com.android.tools.r8.ir.code.Value;
import com.android.tools.r8.ir.conversion.CfBuilder;
import com.android.tools.r8.ir.conversion.DexBuilder;
import com.android.tools.r8.ir.optimize.Inliner;
import com.android.tools.r8.ir.optimize.InliningConstraints;
import java.util.Arrays;

public class NewArrayFilledData
extends Instruction {
    private static final String ERROR_MESSAGE = "Conversion from DEX to classfile not supported for NewArrayFilledData";
    public final int element_width;
    public final long size;
    public final short[] data;

    public NewArrayFilledData(Value src, int element_width, long size, short[] data2) {
        super(null, src);
        this.element_width = element_width;
        this.size = size;
        this.data = data2;
    }

    @Override
    public int opcode() {
        return 48;
    }

    @Override
    public <T> T accept(InstructionVisitor<T> visitor) {
        return visitor.visit(this);
    }

    public Value src() {
        return (Value)this.inValues.get(0);
    }

    public FillArrayDataPayload createPayload() {
        return new FillArrayDataPayload(this.element_width, this.size, this.data);
    }

    @Override
    public void buildDex(DexBuilder builder) {
        int src = builder.allocatedRegister(this.src(), this.getNumber());
        builder.addFillArrayData(this, new FillArrayData(src));
    }

    @Override
    public void buildCf(CfBuilder builder) {
        throw new Unreachable(ERROR_MESSAGE);
    }

    @Override
    public boolean identicalNonValueNonPositionParts(Instruction other) {
        if (!other.isNewArrayFilledData()) {
            return false;
        }
        NewArrayFilledData o = other.asNewArrayFilledData();
        return o.element_width == this.element_width && o.size == this.size && Arrays.equals(o.data, this.data);
    }

    @Override
    public int maxInValueRegister() {
        return 255;
    }

    @Override
    public int maxOutValueRegister() {
        assert (false) : "NewArrayFilledData defines no values.";
        return 0;
    }

    @Override
    public boolean instructionTypeCanThrow() {
        return true;
    }

    @Override
    public boolean isNewArrayFilledData() {
        return true;
    }

    @Override
    public NewArrayFilledData asNewArrayFilledData() {
        return this;
    }

    @Override
    public Inliner.ConstraintWithTarget inliningConstraint(InliningConstraints inliningConstraints, ProgramMethod context) {
        return inliningConstraints.forNewArrayFilledData();
    }

    @Override
    public void insertLoadAndStores(InstructionListIterator it, LoadStoreHelper helper) {
        throw new Unreachable(ERROR_MESSAGE);
    }

    @Override
    public boolean hasInvariantOutType() {
        return true;
    }

    @Override
    public boolean instructionInstanceCanThrow(AppView<?> appView, ProgramMethod context) {
        return appView.options().debug || this.src().getType().isNullable();
    }

    @Override
    public AbstractValue getAbstractValue(AppView<? extends AppInfoWithClassHierarchy> appView, ProgramMethod context) {
        if (!this.instructionMayHaveSideEffects(appView, context) && this.size <= Integer.MAX_VALUE) {
            assert (!this.instructionInstanceCanThrow());
            return StatefulObjectValue.create(appView.abstractValueFactory().createKnownLengthArrayState((int)this.size));
        }
        return UnknownValue.getInstance();
    }

    @Override
    public boolean instructionMayHaveSideEffects(AppView<?> appView, ProgramMethod context, Instruction.SideEffectAssumption assumption) {
        if (this.instructionInstanceCanThrow(appView, context) || this.src().numberOfAllUsers() > 1) {
            return true;
        }
        assert (this.src().singleUniqueUser() == this);
        assert (!this.src().isPhi());
        assert (this.src().definition.isNewArrayEmpty());
        return false;
    }

    @Override
    public boolean instructionMayTriggerMethodInvocation(AppView<?> appView, ProgramMethod context) {
        return false;
    }
}

