/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.r8.ir.code;

import com.android.tools.r8.cf.TypeVerificationHelper;
import com.android.tools.r8.com.google.common.collect.Sets;
import com.android.tools.r8.errors.CompilationError;
import com.android.tools.r8.errors.InvalidDebugInfoException;
import com.android.tools.r8.graph.AppInfoWithClassHierarchy;
import com.android.tools.r8.graph.AppView;
import com.android.tools.r8.graph.DebugLocalInfo;
import com.android.tools.r8.graph.DexMethod;
import com.android.tools.r8.graph.DexType;
import com.android.tools.r8.ir.analysis.type.Nullability;
import com.android.tools.r8.ir.analysis.type.TypeElement;
import com.android.tools.r8.ir.code.BasicBlock;
import com.android.tools.r8.ir.code.Instruction;
import com.android.tools.r8.ir.code.InstructionOrPhi;
import com.android.tools.r8.ir.code.Value;
import com.android.tools.r8.ir.code.ValueTypeConstraint;
import com.android.tools.r8.ir.conversion.IRBuilder;
import com.android.tools.r8.ir.conversion.TypeConstraintResolver;
import com.android.tools.r8.origin.Origin;
import com.android.tools.r8.utils.CfgPrinter;
import com.android.tools.r8.utils.DequeUtils;
import com.android.tools.r8.utils.ListUtils;
import com.android.tools.r8.utils.Reporter;
import com.android.tools.r8.utils.SetUtils;
import com.android.tools.r8.utils.StringUtils;
import java.util.ArrayList;
import java.util.Deque;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Predicate;

public class Phi
extends Value
implements InstructionOrPhi {
    private final BasicBlock block;
    private final List<Value> operands = new ArrayList<Value>();
    private RegisterReadType readType;
    private boolean isStackPhi;
    private List<Map<Integer, Value>> definitionUsers = new ArrayList<Map<Integer, Value>>();

    public Phi(int number, BasicBlock block, TypeElement type, DebugLocalInfo local, RegisterReadType readType) {
        super(number, type, local);
        this.block = block;
        this.readType = readType;
        block.addPhi(this);
    }

    private void abortOnInvalidDebugInfo(ValueTypeConstraint constraint) {
        if (this.constrainedType(constraint) == null) {
            throw new InvalidDebugInfoException("Type information in locals-table is inconsistent. Cannot constrain type: " + this.type + " for value: " + this + " by constraint " + (Object)((Object)constraint) + ".");
        }
    }

    private void throwUndefinedValueError() {
        throw new CompilationError("Undefined value encountered during compilation. This is typically caused by invalid dex input that uses a register that is not defined on all control-flow paths leading to the use.");
    }

    private boolean verifyIsStackPhi(Set<Phi> seenPhis) {
        seenPhis.add(this);
        this.operands.forEach(v -> {
            if (v.isPhi() ? !$assertionsDisabled && !seenPhis.contains(v) && !v.asPhi().verifyIsStackPhi(seenPhis) : !$assertionsDisabled && v.isValueOnStack() != this.isStackPhi) {
                throw new AssertionError();
            }
        });
        return true;
    }

    @Override
    public boolean isDefinedByInstructionSatisfying(Predicate<Instruction> predicate) {
        return false;
    }

    @Override
    public boolean isPhi() {
        return true;
    }

    @Override
    public Phi asPhi() {
        return this;
    }

    @Override
    public BasicBlock getBlock() {
        return this.block;
    }

    @Override
    public void constrainType(ValueTypeConstraint constraint, DexMethod method, Origin origin, Reporter reporter) {
        if (this.readType == RegisterReadType.DEBUG) {
            this.abortOnInvalidDebugInfo(constraint);
        }
        super.constrainType(constraint, method, origin, reporter);
    }

    public void addOperands(IRBuilder builder, int register) {
        assert (this.operands.isEmpty());
        if (this.block.getPredecessors().size() == 0) {
            this.throwUndefinedValueError();
        }
        ValueTypeConstraint readConstraint = TypeConstraintResolver.constraintForType(this.type);
        ArrayList<Value> operands = new ArrayList<Value>(this.block.getPredecessors().size());
        for (BasicBlock pred : this.block.getPredecessors()) {
            BasicBlock.EdgeType edgeType = pred.getEdgeType(this.block);
            Value operand = builder.readRegister(register, readConstraint, pred, edgeType, this.readType);
            operands.add(operand);
        }
        if (this.readType == RegisterReadType.DEBUG) {
            for (Value operand : operands) {
                TypeElement type = operand.getType();
                ValueTypeConstraint constraint = TypeConstraintResolver.constraintForType(type);
                this.abortOnInvalidDebugInfo(constraint);
            }
        }
        for (Value operand : operands) {
            builder.constrainType(operand, readConstraint);
            this.appendOperand(operand);
        }
        this.removeTrivialPhi(builder, null);
    }

    public void addOperands(List<Value> operands) {
        this.addOperands(operands, true);
    }

    public void addOperands(List<Value> operands, boolean removeTrivialPhi) {
        assert (this.operands.isEmpty());
        if (operands.size() == 0) {
            this.throwUndefinedValueError();
        }
        for (Value operand : operands) {
            this.appendOperand(operand);
        }
        if (removeTrivialPhi) {
            this.removeTrivialPhi();
        }
    }

    @Override
    public void markNonDebugLocalRead() {
        this.readType = RegisterReadType.NORMAL;
    }

    public void appendOperand(Value operand) {
        this.operands.add(operand);
        operand.addPhiUser(this);
    }

    public Value getOperand(int predIndex) {
        return this.operands.get(predIndex);
    }

    public List<Value> getOperands() {
        return this.operands;
    }

    public void removeOperand(int index) {
        this.operands.get(index).removePhiUser(this);
        this.operands.remove(index);
    }

    public void removeOperandsByIndex(List<Integer> operandsToRemove) {
        if (operandsToRemove.isEmpty()) {
            return;
        }
        ArrayList<Value> copy = new ArrayList<Value>(this.operands);
        this.operands.clear();
        int current = 0;
        for (int i : operandsToRemove) {
            this.operands.addAll(copy.subList(current, i));
            ((Value)copy.get(i)).removePhiUser(this);
            current = i + 1;
        }
        this.operands.addAll(copy.subList(current, copy.size()));
    }

    public void replaceOperandAt(int predIndex, Value newValue) {
        Value current = this.operands.get(predIndex);
        this.operands.set(predIndex, newValue);
        newValue.addPhiUser(this);
        current.removePhiUser(this);
    }

    public void replaceOperand(Value current, Value newValue) {
        for (int i = 0; i < this.operands.size(); ++i) {
            if (this.operands.get(i) != current) continue;
            this.operands.set(i, newValue);
            newValue.addPhiUser(this);
        }
    }

    public boolean isTrivialPhi() {
        Value same = null;
        for (Value op : this.operands) {
            if (op == same || op == this) continue;
            if (same != null) {
                return false;
            }
            same = op;
        }
        return true;
    }

    public boolean removeTrivialPhi() {
        return this.removeTrivialPhi(null, null);
    }

    public boolean removeTrivialPhi(IRBuilder builder, Set<Value> affectedValues) {
        Value same = null;
        for (Value value : this.operands) {
            if (value == same || value == this) continue;
            if (same != null) {
                assert (!this.isTrivialPhi());
                return false;
            }
            same = value;
        }
        assert (this.isTrivialPhi());
        if (same == null) {
            return false;
        }
        if (this.getLocalInfo() != same.getLocalInfo() && this.getLocalInfo() != null) {
            if (same.getLocalInfo() == null) {
                same.setLocalInfo(this.getLocalInfo());
            } else {
                assert (this.hasLocalInfo() && same.hasLocalInfo());
                return false;
            }
        }
        if (builder != null && this.type.isPreciseType() && !this.type.isBottom()) {
            builder.constrainType(same, ValueTypeConstraint.fromTypeLattice(this.type));
        }
        if (affectedValues != null) {
            affectedValues.addAll(this.affectedValues());
        }
        for (Value value : this.operands) {
            value.removePhiUser(this);
        }
        if (this.definitionUsers != null) {
            for (Map map : this.definitionUsers) {
                for (Map.Entry entry : map.entrySet()) {
                    if (entry.getValue() != this) continue;
                    entry.setValue(same);
                    if (!same.isPhi()) continue;
                    same.asPhi().addDefinitionsUser(map);
                }
            }
        }
        Set<Phi> phiUsersToSimplify = this.uniquePhiUsers();
        this.replaceUsers(same);
        for (Phi user : phiUsersToSimplify) {
            user.removeTrivialPhi(builder, affectedValues);
        }
        this.block.removePhi(this);
        return true;
    }

    public void removeDeadPhi() {
        assert (!this.hasUsers());
        for (Value operand : this.getOperands()) {
            operand.removePhiUser(this);
        }
        this.getBlock().removePhi(this);
    }

    public String printPhi() {
        StringBuilder builder = new StringBuilder();
        builder.append("v");
        builder.append(this.number);
        if (this.hasLocalInfo()) {
            builder.append("(").append(this.getLocalInfo()).append(")");
        }
        builder.append(" <- phi");
        StringUtils.append(builder, ListUtils.map(this.operands, Value::toString));
        builder.append(" : ").append(this.getType());
        return builder.toString();
    }

    public void print(CfgPrinter printer) {
        int uses = this.numberOfPhiUsers() + this.numberOfUsers();
        printer.print("0 ").append(uses).append(" v").append(this.number).append(" Phi");
        for (Value operand : this.operands) {
            printer.append(" v").append(operand.number);
        }
    }

    public void addDefinitionsUser(Map<Integer, Value> currentDefinitions) {
        this.definitionUsers.add(currentDefinitions);
    }

    public void removeDefinitionsUser(Map<Integer, Value> currentDefinitions) {
        this.definitionUsers.remove(currentDefinitions);
    }

    public void clearDefinitionsUsers() {
        this.definitionUsers = null;
    }

    @Override
    public boolean isConstant() {
        return false;
    }

    @Override
    public boolean isValueOnStack() {
        assert (this.verifyIsStackPhi(Sets.newIdentityHashSet()));
        return this.isStackPhi;
    }

    public void setIsStackPhi(boolean isStackPhi) {
        this.isStackPhi = isStackPhi;
    }

    @Override
    public boolean needsRegister() {
        return !this.isValueOnStack();
    }

    public boolean usesValueOneTime(Value usedValue) {
        return this.operands.indexOf(usedValue) == this.operands.lastIndexOf(usedValue);
    }

    public DexType computeVerificationType(AppView<?> appView, TypeVerificationHelper helper) {
        assert (this.outType().isObject());
        HashSet<DexType> operandTypes = new HashSet<DexType>(this.operands.size());
        for (Value operand : this.operands) {
            DexType operandType = helper.getDexType(operand);
            if (operandType == null) continue;
            operandTypes.add(operandType);
        }
        return helper.join(operandTypes);
    }

    public TypeElement computePhiType(AppView<?> appView) {
        TypeElement result = TypeElement.getBottom();
        for (Value operand : this.getOperands()) {
            result = result.join(operand.getType(), appView);
        }
        return result;
    }

    @Override
    public TypeElement getDynamicUpperBoundType(AppView<? extends AppInfoWithClassHierarchy> appView) {
        Set<Phi> reachablePhis = SetUtils.newIdentityHashSet(this);
        Deque<Phi> worklist = DequeUtils.newArrayDeque(this);
        while (!worklist.isEmpty()) {
            Phi phi = worklist.removeFirst();
            assert (reachablePhis.contains(phi));
            for (Value operand : phi.getOperands()) {
                Phi candidate = operand.getAliasedValue().asPhi();
                if (candidate == null || !reachablePhis.add(candidate)) continue;
                worklist.addLast(candidate);
            }
        }
        Set<Value> visitedOperands = Sets.newIdentityHashSet();
        TypeElement result = TypeElement.getBottom();
        for (Phi phi : reachablePhis) {
            for (Value operand : phi.getOperands()) {
                if (operand.getAliasedValue().isPhi() || !visitedOperands.add(operand)) continue;
                result = result.join(operand.getDynamicUpperBoundType(appView), appView);
            }
        }
        if (this.getType().isReferenceType() && this.getType().isDefinitelyNotNull()) {
            return result.asReferenceType().asMeetWithNotNull();
        }
        return result;
    }

    public static class StackMapPhi
    extends Phi {
        public StackMapPhi(int number, BasicBlock block, TypeElement type, DebugLocalInfo local, RegisterReadType readType) {
            super(number, block, type, local, readType);
        }

        @Override
        public DexType computeVerificationType(AppView<?> appView, TypeVerificationHelper helper) {
            assert (!appView.enableWholeProgramOptimizations());
            if (this.type.isPrimitiveType()) {
                return this.type.asPrimitiveType().toDexType(appView.dexItemFactory());
            }
            if (this.type.isArrayType()) {
                return this.type.asArrayType().toDexType(appView.dexItemFactory());
            }
            assert (this.type.isClassType());
            return this.type.asClassType().getClassType();
        }

        @Override
        public TypeElement computePhiType(AppView<?> appView) {
            assert (!appView.enableWholeProgramOptimizations());
            if (this.type.isPrimitiveType()) {
                return this.type;
            }
            assert (this.type.isReferenceType());
            Nullability nullability = Nullability.bottom();
            for (Value operand : this.getOperands()) {
                nullability = nullability.join(operand.type.nullability());
            }
            return this.type.asReferenceType().getOrCreateVariant(nullability);
        }

        @Override
        public boolean isStackMapPhi() {
            return true;
        }
    }

    public static enum RegisterReadType {
        NORMAL,
        DEBUG;

    }
}

