/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.r8.ir.code;

import com.android.tools.r8.cf.LoadStoreHelper;
import com.android.tools.r8.cf.code.CfInstruction;
import com.android.tools.r8.cf.code.CfRecordFieldValues;
import com.android.tools.r8.code.DexRecordFieldValues;
import com.android.tools.r8.graph.AppView;
import com.android.tools.r8.graph.DexField;
import com.android.tools.r8.graph.ProgramMethod;
import com.android.tools.r8.ir.analysis.type.Nullability;
import com.android.tools.r8.ir.analysis.type.TypeElement;
import com.android.tools.r8.ir.code.Instruction;
import com.android.tools.r8.ir.code.InstructionListIterator;
import com.android.tools.r8.ir.code.InstructionVisitor;
import com.android.tools.r8.ir.code.Value;
import com.android.tools.r8.ir.conversion.CfBuilder;
import com.android.tools.r8.ir.conversion.DexBuilder;
import com.android.tools.r8.ir.optimize.Inliner;
import com.android.tools.r8.ir.optimize.InliningConstraints;
import java.util.Arrays;
import java.util.List;

public class RecordFieldValues
extends Instruction {
    private final DexField[] fields;

    public RecordFieldValues(DexField[] fields, Value outValue, List<Value> fieldValues) {
        super(outValue, fieldValues);
        this.fields = fields;
    }

    public DexField[] getFields() {
        return this.fields;
    }

    @Override
    public int opcode() {
        return 70;
    }

    @Override
    public <T> T accept(InstructionVisitor<T> visitor) {
        return visitor.visit(this);
    }

    @Override
    public RecordFieldValues asRecordFieldValues() {
        return this;
    }

    @Override
    public boolean isRecordFieldValues() {
        return true;
    }

    @Override
    public void buildDex(DexBuilder builder) {
        int[] arguments = new int[this.inValues().size()];
        for (int i = 0; i < this.inValues().size(); ++i) {
            arguments[i] = builder.allocatedRegister(this.inValues().get(i), this.getNumber());
        }
        int dest = builder.allocatedRegister(this.outValue(), this.getNumber());
        builder.add((Instruction)this, (com.android.tools.r8.code.Instruction)new DexRecordFieldValues(dest, arguments, this.fields));
    }

    @Override
    public TypeElement evaluate(AppView<?> appView) {
        return TypeElement.fromDexType(appView.dexItemFactory().objectArrayType, Nullability.definitelyNotNull(), appView);
    }

    @Override
    public void buildCf(CfBuilder builder) {
        builder.add((CfInstruction)new CfRecordFieldValues(this.fields), this);
    }

    @Override
    public boolean identicalNonValueNonPositionParts(Instruction other) {
        if (!other.isRecordFieldValues()) {
            return false;
        }
        RecordFieldValues o = other.asRecordFieldValues();
        return Arrays.equals(o.fields, this.fields);
    }

    @Override
    public boolean instructionMayTriggerMethodInvocation(AppView<?> appView, ProgramMethod context) {
        return false;
    }

    @Override
    public int maxInValueRegister() {
        return 65535;
    }

    @Override
    public int maxOutValueRegister() {
        return 65535;
    }

    @Override
    public Inliner.ConstraintWithTarget inliningConstraint(InliningConstraints inliningConstraints, ProgramMethod context) {
        return inliningConstraints.forRecordFieldValues();
    }

    @Override
    public void insertLoadAndStores(InstructionListIterator it, LoadStoreHelper helper) {
        helper.loadInValues(this, it);
        helper.storeOutValue(this, it);
    }

    @Override
    public boolean hasInvariantOutType() {
        return true;
    }
}

