/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.r8.ir.code;

import com.android.tools.r8.cf.LoadStoreHelper;
import com.android.tools.r8.errors.Unreachable;
import com.android.tools.r8.graph.AppView;
import com.android.tools.r8.graph.DexString;
import com.android.tools.r8.ir.code.BasicBlock;
import com.android.tools.r8.ir.code.IRCode;
import com.android.tools.r8.ir.code.Instruction;
import com.android.tools.r8.ir.code.InstructionListIterator;
import com.android.tools.r8.ir.code.InstructionVisitor;
import com.android.tools.r8.ir.code.Switch;
import com.android.tools.r8.ir.code.Value;
import com.android.tools.r8.ir.conversion.CfBuilder;
import com.android.tools.r8.ir.conversion.DexBuilder;
import com.android.tools.r8.utils.ThrowingBiConsumer;
import com.android.tools.r8.utils.ThrowingConsumer;

public class StringSwitch
extends Switch {
    private final DexString[] keys;

    public StringSwitch(Value value, DexString[] keys2, int[] targetBlockIndices, int fallthroughBlockIndex) {
        super(value, targetBlockIndices, fallthroughBlockIndex);
        this.keys = keys2;
        assert (this.valid());
    }

    public DexString getFirstKey() {
        return this.keys[0];
    }

    @Override
    public int opcode() {
        return 62;
    }

    @Override
    public <T> T accept(InstructionVisitor<T> visitor) {
        return visitor.visit(this);
    }

    public <E extends Throwable> void forEachKey(ThrowingConsumer<DexString, E> fn) throws E {
        for (DexString key : this.keys) {
            fn.accept(key);
        }
    }

    public <E extends Throwable> void forEachCase(ThrowingBiConsumer<DexString, BasicBlock, E> fn) throws E {
        for (int i = 0; i < this.keys.length; ++i) {
            fn.accept(this.getKey(i), this.targetBlock(i));
        }
    }

    @Override
    public Instruction materializeFirstKey(AppView<?> appView, IRCode code) {
        return code.createStringConstant(appView, this.getFirstKey());
    }

    @Override
    public boolean valid() {
        assert (super.valid());
        assert (this.keys.length >= 1);
        assert (this.keys.length <= 65535);
        assert (this.keys.length == this.numberOfKeys());
        return true;
    }

    @Override
    public boolean isStringSwitch() {
        return true;
    }

    @Override
    public StringSwitch asStringSwitch() {
        return this;
    }

    public DexString getKey(int index) {
        return this.keys[index];
    }

    @Override
    public String toString() {
        StringBuilder builder = new StringBuilder(super.toString()).append(System.lineSeparator());
        for (int i = 0; i < this.numberOfKeys(); ++i) {
            builder.append("          \"").append(this.getKey(i)).append("\" -> ").append(this.targetBlock(i).getNumberAsString()).append(System.lineSeparator());
        }
        return builder.append("          F -> ").append(this.fallthroughBlock().getNumber()).toString();
    }

    @Override
    public void buildCf(CfBuilder builder) {
        throw new Unreachable();
    }

    @Override
    public void buildDex(DexBuilder builder) {
        throw new Unreachable();
    }

    @Override
    public boolean identicalNonValueNonPositionParts(Instruction other) {
        throw new Unreachable();
    }

    @Override
    public void insertLoadAndStores(InstructionListIterator it, LoadStoreHelper helper) {
        throw new Unreachable();
    }

    @Override
    public int maxInValueRegister() {
        throw new Unreachable();
    }

    @Override
    public int maxOutValueRegister() {
        throw new Unreachable();
    }
}

