/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.r8.ir.code;

import com.android.tools.r8.errors.InternalCompilerError;
import com.android.tools.r8.errors.Unreachable;
import com.android.tools.r8.graph.DexType;
import com.android.tools.r8.ir.analysis.type.PrimitiveTypeElement;
import com.android.tools.r8.ir.analysis.type.TypeElement;
import com.android.tools.r8.ir.code.MemberType;
import com.android.tools.r8.ir.code.NumericType;
import com.android.tools.r8.utils.structural.StructuralItem;
import com.android.tools.r8.utils.structural.StructuralMapping;
import com.android.tools.r8.utils.structural.StructuralSpecification;

public enum ValueType implements StructuralItem<ValueType>
{
    OBJECT,
    INT,
    FLOAT,
    LONG,
    DOUBLE;


    private static void specify(StructuralSpecification<ValueType, ?> spec) {
        spec.withInt(Enum::ordinal);
    }

    public static ValueType fromMemberType(MemberType type) {
        switch (type) {
            case BOOLEAN_OR_BYTE: 
            case CHAR: 
            case SHORT: 
            case INT: {
                return INT;
            }
            case FLOAT: {
                return FLOAT;
            }
            case LONG: {
                return LONG;
            }
            case DOUBLE: {
                return DOUBLE;
            }
            case OBJECT: {
                return OBJECT;
            }
            case INT_OR_FLOAT: 
            case LONG_OR_DOUBLE: {
                throw new Unreachable("Unexpected imprecise type: " + (Object)((Object)type));
            }
        }
        throw new Unreachable("Unexpected member type: " + (Object)((Object)type));
    }

    public static ValueType fromTypeDescriptorChar(char descriptor) {
        switch (descriptor) {
            case 'L': 
            case '[': {
                return OBJECT;
            }
            case 'B': 
            case 'C': 
            case 'I': 
            case 'S': 
            case 'Z': {
                return INT;
            }
            case 'F': {
                return FLOAT;
            }
            case 'J': {
                return LONG;
            }
            case 'D': {
                return DOUBLE;
            }
            case 'V': {
                throw new InternalCompilerError("No value type for void type.");
            }
        }
        throw new Unreachable("Invalid descriptor char '" + descriptor + "'");
    }

    public static ValueType fromDexType(DexType type) {
        return ValueType.fromTypeDescriptorChar((char)type.descriptor.content[0]);
    }

    public static ValueType fromNumericType(NumericType type) {
        switch (type) {
            case BYTE: 
            case CHAR: 
            case SHORT: 
            case INT: {
                return INT;
            }
            case FLOAT: {
                return FLOAT;
            }
            case LONG: {
                return LONG;
            }
            case DOUBLE: {
                return DOUBLE;
            }
        }
        throw new Unreachable("Invalid numeric type '" + (Object)((Object)type) + "'");
    }

    public static ValueType fromType(TypeElement type) {
        if (type.isReferenceType()) {
            return OBJECT;
        }
        if (type.isInt()) {
            return INT;
        }
        if (type.isFloat()) {
            return FLOAT;
        }
        if (type.isLong()) {
            return LONG;
        }
        if (type.isDouble()) {
            return DOUBLE;
        }
        throw new Unreachable("Unexpected conversion of imprecise type: " + type);
    }

    @Override
    public ValueType self() {
        return this;
    }

    @Override
    public StructuralMapping<ValueType> getStructuralMapping() {
        return ValueType::specify;
    }

    public boolean isObject() {
        return this == OBJECT;
    }

    public boolean isSingle() {
        return this == INT || this == FLOAT;
    }

    public boolean isWide() {
        return this == LONG || this == DOUBLE;
    }

    public int requiredRegisters() {
        return this.isWide() ? 2 : 1;
    }

    public PrimitiveTypeElement toPrimitiveType() {
        switch (this) {
            case INT: {
                return TypeElement.getInt();
            }
            case FLOAT: {
                return TypeElement.getFloat();
            }
            case LONG: {
                return TypeElement.getLong();
            }
            case DOUBLE: {
                return TypeElement.getDouble();
            }
        }
        throw new Unreachable("Unexpected type in conversion to primitive: " + this);
    }
}

