/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.r8.ir.conversion;

import com.android.tools.r8.contexts.CompilationContext;
import com.android.tools.r8.ir.code.IRCode;
import com.android.tools.r8.ir.conversion.MethodProcessor;
import com.android.tools.r8.ir.optimize.info.OptimizationFeedback;
import java.util.Arrays;
import java.util.Collection;
import java.util.function.Consumer;

public interface CodeOptimization {
    public static CodeOptimization from(Consumer<IRCode> consumer) {
        return (code, feedback, methodProcessor, methodProcessingContext) -> consumer.accept(code);
    }

    public static CodeOptimization sequence(CodeOptimization ... codeOptimizations) {
        return CodeOptimization.sequence(Arrays.asList(codeOptimizations));
    }

    public static CodeOptimization sequence(Collection<CodeOptimization> codeOptimizations) {
        return (code, feedback, methodProcessor, methodProcessingContext) -> {
            for (CodeOptimization codeOptimization : codeOptimizations) {
                codeOptimization.optimize(code, feedback, methodProcessor, methodProcessingContext);
            }
        };
    }

    public void optimize(IRCode var1, OptimizationFeedback var2, MethodProcessor var3, CompilationContext.MethodProcessingContext var4);
}

