/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.r8.ir.conversion;

import com.android.tools.r8.graph.AppView;
import com.android.tools.r8.graph.DexCode;
import com.android.tools.r8.graph.DexEncodedMethod;
import com.android.tools.r8.graph.bytecodemetadata.BytecodeMetadataProvider;
import com.android.tools.r8.ir.code.IRCode;
import com.android.tools.r8.ir.conversion.DexBuilder;
import com.android.tools.r8.ir.conversion.IRFinalizer;
import com.android.tools.r8.ir.optimize.CodeRewriter;
import com.android.tools.r8.ir.optimize.DeadCodeRemover;
import com.android.tools.r8.ir.optimize.PeepholeOptimizer;
import com.android.tools.r8.ir.optimize.RuntimeWorkaroundCodeRewriter;
import com.android.tools.r8.ir.regalloc.LinearScanRegisterAllocator;
import com.android.tools.r8.ir.regalloc.RegisterAllocator;
import com.android.tools.r8.logging.Log;
import com.android.tools.r8.utils.InternalOptions;
import com.android.tools.r8.utils.Timing;

public class IRToDexFinalizer
extends IRFinalizer<DexCode> {
    private static final int PEEPHOLE_OPTIMIZATION_PASSES = 2;
    private final CodeRewriter codeRewriter;
    private final InternalOptions options;

    public IRToDexFinalizer(AppView<?> appView, CodeRewriter codeRewriter, DeadCodeRemover deadCodeRemover) {
        super(appView, deadCodeRemover);
        this.codeRewriter = codeRewriter;
        this.options = appView.options();
    }

    private RegisterAllocator performRegisterAllocation(IRCode code, DexEncodedMethod method, Timing timing) {
        assert (this.deadCodeRemover.verifyNoDeadCode(code));
        timing.begin("Allocate registers");
        LinearScanRegisterAllocator registerAllocator = new LinearScanRegisterAllocator(this.appView, code);
        registerAllocator.allocateRegisters();
        timing.end();
        if (code.getConversionOptions().isPeepholeOptimizationsEnabled()) {
            timing.begin("Peephole optimize");
            for (int i = 0; i < 2; ++i) {
                CodeRewriter.collapseTrivialGotos(this.appView, code);
                PeepholeOptimizer.optimize(this.appView, code, registerAllocator);
            }
            timing.end();
        }
        timing.begin("Clean up");
        CodeRewriter.removeUnneededMovesOnExitingPaths(code, registerAllocator);
        CodeRewriter.collapseTrivialGotos(this.appView, code);
        timing.end();
        if (Log.ENABLED) {
            Log.debug(this.getClass(), "Final (non-SSA) flow graph for %s:\n%s", method.toSourceString(), code);
        }
        return registerAllocator;
    }

    @Override
    public DexCode finalizeCode(IRCode code, BytecodeMetadataProvider bytecodeMetadataProvider, Timing timing) {
        DexEncodedMethod method = code.method();
        code.traceBlocks();
        RuntimeWorkaroundCodeRewriter.workaroundNumberConversionRegisterAllocationBug(code, this.options);
        RuntimeWorkaroundCodeRewriter.workaroundDex2OatInliningIssue(this.appView, code);
        RuntimeWorkaroundCodeRewriter.workaroundSwitchMaxIntBug(code, this.codeRewriter, this.options);
        RuntimeWorkaroundCodeRewriter.workaroundDex2OatLinkedListBug(code, this.options);
        RuntimeWorkaroundCodeRewriter.workaroundForwardingInitializerBug(code, this.options);
        RuntimeWorkaroundCodeRewriter.workaroundExceptionTargetingLoopHeaderBug(code, this.options);
        RegisterAllocator registerAllocator = this.performRegisterAllocation(code, method, timing);
        return new DexBuilder(code, bytecodeMetadataProvider, registerAllocator, this.options).build();
    }
}

