/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.r8.ir.conversion;

import com.android.tools.r8.com.google.common.collect.Sets;
import com.android.tools.r8.errors.CompilationError;
import com.android.tools.r8.errors.Unreachable;
import com.android.tools.r8.graph.AccessControl;
import com.android.tools.r8.graph.AppInfoWithClassHierarchy;
import com.android.tools.r8.graph.AppView;
import com.android.tools.r8.graph.DebugLocalInfo;
import com.android.tools.r8.graph.DexCallSite;
import com.android.tools.r8.graph.DexClass;
import com.android.tools.r8.graph.DexClassAndField;
import com.android.tools.r8.graph.DexEncodedField;
import com.android.tools.r8.graph.DexEncodedMethod;
import com.android.tools.r8.graph.DexField;
import com.android.tools.r8.graph.DexItemFactory;
import com.android.tools.r8.graph.DexMethod;
import com.android.tools.r8.graph.DexMethodHandle;
import com.android.tools.r8.graph.DexType;
import com.android.tools.r8.graph.GraphLens;
import com.android.tools.r8.graph.ProgramMethod;
import com.android.tools.r8.graph.UseRegistry;
import com.android.tools.r8.graph.classmerging.VerticallyMergedClasses;
import com.android.tools.r8.graph.proto.ArgumentInfo;
import com.android.tools.r8.graph.proto.ArgumentInfoCollection;
import com.android.tools.r8.graph.proto.RemovedArgumentInfo;
import com.android.tools.r8.graph.proto.RewrittenPrototypeDescription;
import com.android.tools.r8.graph.proto.RewrittenTypeInfo;
import com.android.tools.r8.ir.analysis.type.DestructivePhiTypeUpdater;
import com.android.tools.r8.ir.analysis.type.Nullability;
import com.android.tools.r8.ir.analysis.type.TypeElement;
import com.android.tools.r8.ir.analysis.value.SingleNumberValue;
import com.android.tools.r8.ir.analysis.value.SingleValue;
import com.android.tools.r8.ir.code.Argument;
import com.android.tools.r8.ir.code.BasicBlock;
import com.android.tools.r8.ir.code.BasicBlockIterator;
import com.android.tools.r8.ir.code.CatchHandlers;
import com.android.tools.r8.ir.code.CheckCast;
import com.android.tools.r8.ir.code.ConstClass;
import com.android.tools.r8.ir.code.ConstMethodHandle;
import com.android.tools.r8.ir.code.FieldInstruction;
import com.android.tools.r8.ir.code.FieldPut;
import com.android.tools.r8.ir.code.IRCode;
import com.android.tools.r8.ir.code.InitClass;
import com.android.tools.r8.ir.code.InstanceGet;
import com.android.tools.r8.ir.code.InstanceOf;
import com.android.tools.r8.ir.code.InstancePut;
import com.android.tools.r8.ir.code.Instruction;
import com.android.tools.r8.ir.code.InstructionListIterator;
import com.android.tools.r8.ir.code.Invoke;
import com.android.tools.r8.ir.code.InvokeCustom;
import com.android.tools.r8.ir.code.InvokeDirect;
import com.android.tools.r8.ir.code.InvokeMethod;
import com.android.tools.r8.ir.code.InvokeMultiNewArray;
import com.android.tools.r8.ir.code.InvokeNewArray;
import com.android.tools.r8.ir.code.MoveException;
import com.android.tools.r8.ir.code.NewArrayEmpty;
import com.android.tools.r8.ir.code.NewInstance;
import com.android.tools.r8.ir.code.Phi;
import com.android.tools.r8.ir.code.Position;
import com.android.tools.r8.ir.code.Return;
import com.android.tools.r8.ir.code.SafeCheckCast;
import com.android.tools.r8.ir.code.StaticGet;
import com.android.tools.r8.ir.code.StaticPut;
import com.android.tools.r8.ir.code.TypeAndLocalInfoSupplier;
import com.android.tools.r8.ir.code.UnusedArgument;
import com.android.tools.r8.ir.code.Value;
import com.android.tools.r8.ir.code.ValueType;
import com.android.tools.r8.ir.conversion.ExtraParameter;
import com.android.tools.r8.ir.conversion.LensCodeRewriterUtils;
import com.android.tools.r8.ir.conversion.MethodProcessor;
import com.android.tools.r8.ir.optimize.enums.EnumUnboxer;
import com.android.tools.r8.optimize.MemberRebindingAnalysis;
import com.android.tools.r8.optimize.argumentpropagation.lenscoderewriter.NullCheckInserter;
import com.android.tools.r8.utils.InternalOptions;
import com.android.tools.r8.utils.LazyBox;
import com.android.tools.r8.utils.ObjectUtils;
import com.android.tools.r8.verticalclassmerging.InterfaceTypeToClassTypeLensCodeRewriterHelper;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Deque;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Set;
import java.util.function.BiFunction;

public class LensCodeRewriter {
    private final AppView<? extends AppInfoWithClassHierarchy> appView;
    private final DexItemFactory factory;
    private final EnumUnboxer enumUnboxer;
    private final InternalOptions options;

    LensCodeRewriter(AppView<? extends AppInfoWithClassHierarchy> appView, EnumUnboxer enumUnboxer) {
        this.appView = appView;
        this.factory = appView.dexItemFactory();
        this.enumUnboxer = enumUnboxer;
        this.options = appView.options();
    }

    private Value makeOutValue(Instruction insn, IRCode code, GraphLens.NonIdentityGraphLens graphLens, GraphLens codeLens) {
        if (insn.hasOutValue()) {
            TypeElement oldType = insn.getOutType();
            TypeElement newType = oldType.rewrittenWithLens(this.appView, graphLens, codeLens);
            return code.createValue(newType, insn.getLocalInfo());
        }
        return null;
    }

    private Value makeOutValue(FieldInstruction insn, IRCode code, DexField rewrittenField) {
        if (insn.hasOutValue()) {
            Nullability nullability = insn.getOutType().nullability();
            TypeElement newType = TypeElement.fromDexType(rewrittenField.getType(), nullability, this.appView);
            return code.createValue(newType, insn.getLocalInfo());
        }
        return null;
    }

    private void rewritePartial(IRCode code, ProgramMethod method, DexMethod originalMethodReference, MethodProcessor methodProcessor, GraphLens.NonIdentityGraphLens graphLens, GraphLens codeLens, RewrittenPrototypeDescription prototypeChanges) {
        Set<Phi> affectedPhis = Sets.newIdentityHashSet();
        Set<UnusedArgument> unusedArguments = Sets.newIdentityHashSet();
        this.rewriteArguments(code, originalMethodReference, prototypeChanges, affectedPhis, unusedArguments);
        if (graphLens.hasCustomCodeRewritings()) {
            assert (graphLens.isEnumUnboxerLens());
            assert (graphLens.getPrevious() == codeLens);
            affectedPhis.addAll(this.enumUnboxer.rewriteCode(code, methodProcessor, prototypeChanges));
        }
        this.rewritePartialDefault(code, method, graphLens, codeLens, prototypeChanges, affectedPhis, unusedArguments);
    }

    private void rewritePartialDefault(IRCode code, ProgramMethod method, final GraphLens.NonIdentityGraphLens graphLens, final GraphLens codeLens, RewrittenPrototypeDescription prototypeChangesForMethod, Set<Phi> affectedPhis, Set<UnusedArgument> unusedArguments) {
        BasicBlockIterator blocks = code.listIterator();
        LazyBox<LensCodeRewriterUtils> helper = new LazyBox<LensCodeRewriterUtils>(() -> new LensCodeRewriterUtils(this.appView, graphLens, codeLens));
        InterfaceTypeToClassTypeLensCodeRewriterHelper interfaceTypeToClassTypeRewriterHelper = InterfaceTypeToClassTypeLensCodeRewriterHelper.create(this.appView, code, graphLens, codeLens);
        NullCheckInserter nullCheckInserter = NullCheckInserter.create(this.appView, code, graphLens, codeLens);
        boolean mayHaveUnreachableBlocks = false;
        while (blocks.hasNext()) {
            boolean anyGuardsRenamed;
            BasicBlock block = blocks.next();
            if (block.hasCatchHandlers() && this.options.enableVerticalClassMerging && (anyGuardsRenamed = block.renameGuardsInCatchHandlers(graphLens, codeLens))) {
                mayHaveUnreachableBlocks |= this.unlinkDeadCatchHandlers(block, graphLens, codeLens);
            }
            InstructionListIterator iterator2 = block.listIterator(code);
            block23: while (iterator2.hasNext()) {
                Instruction current = (Instruction)iterator2.next();
                switch (current.opcode()) {
                    case 32: {
                        InvokeCustom invokeCustom = current.asInvokeCustom();
                        DexCallSite callSite = invokeCustom.getCallSite();
                        DexCallSite newCallSite = helper.computeIfAbsent().rewriteCallSite(callSite, method);
                        if (newCallSite == callSite) continue block23;
                        Value newOutValue = this.makeOutValue(invokeCustom, code, graphLens, codeLens);
                        InvokeCustom newInvokeCustom = new InvokeCustom(newCallSite, newOutValue, invokeCustom.inValues());
                        iterator2.replaceCurrentInstruction(newInvokeCustom);
                        if (newOutValue == null || newOutValue.getType() == invokeCustom.getOutType()) continue block23;
                        affectedPhis.addAll(newOutValue.uniquePhiUsers());
                        break;
                    }
                    case 13: {
                        DexMethodHandle handle = current.asConstMethodHandle().getValue();
                        DexMethodHandle newHandle = helper.computeIfAbsent().rewriteDexMethodHandle(handle, UseRegistry.MethodHandleUse.NOT_ARGUMENT_TO_LAMBDA_METAFACTORY, method);
                        if (newHandle == handle) continue block23;
                        Value newOutValue = this.makeOutValue(current, code, graphLens, codeLens);
                        iterator2.replaceCurrentInstruction(new ConstMethodHandle(newOutValue, newHandle));
                        if (newOutValue == null || newOutValue.getType() == current.getOutType()) continue block23;
                        affectedPhis.addAll(newOutValue.uniquePhiUsers());
                        break;
                    }
                    case 27: {
                        InitClass initClass = current.asInitClass();
                        new InstructionReplacer(code, current, iterator2, affectedPhis).replaceInstructionIfTypeChanged(initClass.getClassValue(), (t, v) -> new InitClass((Value)v, (DexType)t), graphLens, codeLens);
                        break;
                    }
                    case 33: 
                    case 34: 
                    case 37: 
                    case 38: 
                    case 39: 
                    case 40: {
                        Value newOutValue;
                        List<Value> newInValues;
                        final InvokeMethod invoke = current.asInvokeMethod();
                        final DexMethod invokedMethod = invoke.getInvokedMethod();
                        DexType invokedHolder = invokedMethod.holder;
                        if (invokedHolder.isArrayType()) {
                            DexType baseType = invokedHolder.toBaseType(this.factory);
                            new InstructionReplacer(code, current, iterator2, affectedPhis).replaceInstructionIfTypeChanged(baseType, (t, v) -> {
                                DexType mappedHolder = invokedHolder.replaceBaseType((DexType)t, this.factory);
                                DexMethod actualTarget = this.factory.createMethod(mappedHolder, invokedMethod.proto, invokedMethod.name);
                                return Invoke.create(Invoke.Type.VIRTUAL, actualTarget, null, v, invoke.inValues());
                            }, graphLens, codeLens);
                            continue block23;
                        }
                        if (!invokedHolder.isClassType()) {
                            assert (false);
                            continue block23;
                        }
                        if (invoke.isInvokeDirect()) {
                            this.checkInvokeDirect((DexMethod)method.getReference(), invoke.asInvokeDirect());
                        }
                        GraphLens.MethodLookupResult lensLookup = graphLens.lookupMethod(invokedMethod, (DexMethod)method.getReference(), invoke.getType(), codeLens);
                        DexMethod actualTarget = (DexMethod)lensLookup.getReference();
                        Invoke.Type actualInvokeType = lensLookup.getType();
                        int numberOfArguments = actualTarget.getNumberOfArguments(actualInvokeType.isStatic());
                        iterator2 = this.insertCastsForInvokeArgumentsIfNeeded(code, blocks, iterator2, invoke, lensLookup);
                        RewrittenPrototypeDescription prototypeChanges = lensLookup.getPrototypeChanges();
                        if (!prototypeChanges.requiresRewritingAtCallSite() && invoke.getType() == actualInvokeType && actualTarget == invokedMethod) continue block23;
                        ArgumentInfoCollection argumentInfoCollection = prototypeChanges.getArgumentInfoCollection();
                        if (argumentInfoCollection.isEmpty()) {
                            if (prototypeChanges.hasExtraParameters()) {
                                newInValues = new ArrayList<Value>(numberOfArguments);
                                newInValues.addAll(invoke.arguments());
                                prototypeChanges.getExtraParameters().forEach(ignore -> newInValues.add(null));
                            } else {
                                newInValues = invoke.arguments();
                            }
                        } else {
                            newInValues = Arrays.asList(new Value[numberOfArguments]);
                            int numberOfRemovedArguments = 0;
                            for (int argumentIndex = 0; argumentIndex < invoke.arguments().size(); ++argumentIndex) {
                                Object newArgument;
                                ArgumentInfo argumentInfo = argumentInfoCollection.getArgumentInfo(argumentIndex);
                                if (argumentInfo.isRemovedArgumentInfo()) {
                                    ++numberOfRemovedArguments;
                                    continue;
                                }
                                int newArgumentIndex = argumentInfoCollection.getNewArgumentIndex(argumentIndex, numberOfRemovedArguments);
                                if (argumentInfo.isRewrittenTypeInfo()) {
                                    RewrittenTypeInfo argInfo = argumentInfo.asRewrittenTypeInfo();
                                    newArgument = this.rewriteValueIfDefault(code, iterator2, argInfo.getOldType(), argInfo.getNewType(), invoke.getArgument(argumentIndex));
                                } else {
                                    newArgument = invoke.getArgument(argumentIndex);
                                }
                                newInValues.set(newArgumentIndex, (Value)newArgument);
                            }
                        }
                        Instruction constantReturnMaterializingInstruction = null;
                        if (invoke.hasOutValue()) {
                            if (invoke.hasUnusedOutValue()) {
                                invoke.clearOutValue();
                            } else if (prototypeChanges.hasBeenChangedToReturnVoid()) {
                                TypeAndLocalInfoSupplier typeAndLocalInfo = new TypeAndLocalInfoSupplier(){

                                    @Override
                                    public DebugLocalInfo getLocalInfo() {
                                        return invoke.getLocalInfo();
                                    }

                                    @Override
                                    public TypeElement getOutType() {
                                        return graphLens.lookupType(invokedMethod.getReturnType(), codeLens).toTypeElement(LensCodeRewriter.this.appView);
                                    }
                                };
                                assert (prototypeChanges.verifyConstantReturnAccessibleInContext(this.appView.withLiveness(), method, graphLens));
                                constantReturnMaterializingInstruction = prototypeChanges.getConstantReturn(this.appView.withLiveness(), code, invoke.getPosition(), typeAndLocalInfo);
                                if (invoke.outValue().hasLocalInfo()) {
                                    constantReturnMaterializingInstruction.outValue().setLocalInfo(invoke.outValue().getLocalInfo());
                                }
                                invoke.outValue().replaceUsers(constantReturnMaterializingInstruction.outValue());
                                if (invoke.getOutType() != constantReturnMaterializingInstruction.getOutType()) {
                                    affectedPhis.addAll(constantReturnMaterializingInstruction.outValue().uniquePhiUsers());
                                }
                            }
                        }
                        if (prototypeChanges.hasRewrittenReturnInfo()) {
                            if (invoke.hasOutValue() && !prototypeChanges.hasBeenChangedToReturnVoid()) {
                                TypeElement newReturnType = prototypeChanges.getRewrittenReturnInfo().getNewType().toTypeElement(this.appView);
                                newOutValue = code.createValue(newReturnType, invoke.getLocalInfo());
                                affectedPhis.addAll(invoke.outValue().uniquePhiUsers());
                            } else {
                                newOutValue = null;
                            }
                        } else {
                            newOutValue = this.makeOutValue(invoke, code, graphLens, codeLens);
                        }
                        IdentityHashMap<SingleNumberValue, Map> parameterMap = new IdentityHashMap<SingleNumberValue, Map>();
                        int extraArgumentIndex = numberOfArguments - prototypeChanges.getExtraParameters().size();
                        for (ExtraParameter parameter : prototypeChanges.getExtraParameters()) {
                            int newExtraArgumentIndex = argumentInfoCollection.getNewArgumentIndex(extraArgumentIndex, 0);
                            DexType extraArgumentType = actualTarget.getArgumentType(newExtraArgumentIndex, actualInvokeType.isStatic());
                            SingleNumberValue numberValue = parameter.getValue(this.appView);
                            InstructionListIterator finalIterator = iterator2;
                            Value value = parameterMap.computeIfAbsent(numberValue, ignore -> new IdentityHashMap()).computeIfAbsent(extraArgumentType, ignore -> {
                                finalIterator.previous();
                                Instruction instruction = numberValue.createMaterializingInstruction(this.appView, code, TypeAndLocalInfoSupplier.create(parameter.getTypeElement(this.appView, extraArgumentType), null));
                                assert (!instruction.instructionTypeCanThrow());
                                instruction.setPosition(this.options.debug ? invoke.getPosition() : Position.none());
                                finalIterator.add(instruction);
                                finalIterator.next();
                                return instruction.outValue();
                            });
                            newInValues.set(newExtraArgumentIndex, value);
                            if (newInValues.size() > 255) {
                                throw new CompilationError("The addition of extra unused null parameters in R8 led to the overflow of the number of arguments of the method " + actualTarget);
                            }
                            ++extraArgumentIndex;
                        }
                        boolean isInterface = ObjectUtils.getBooleanOrElse(this.appView.definitionFor(actualTarget.holder), DexClass::isInterface, false);
                        InvokeMethod newInvoke = InvokeMethod.create(actualInvokeType, actualTarget, newOutValue, newInValues, isInterface);
                        iterator2.replaceCurrentInstruction(newInvoke);
                        interfaceTypeToClassTypeRewriterHelper.insertCastsForOperandsIfNeeded(invoke, newInvoke, lensLookup, blocks, block, iterator2);
                        nullCheckInserter.insertNullCheckForInvokeReceiverIfNeeded(invoke, newInvoke, lensLookup);
                        if (newOutValue != null && newOutValue.getType() != current.getOutType()) {
                            affectedPhis.addAll(newOutValue.uniquePhiUsers());
                        }
                        if (constantReturnMaterializingInstruction == null) continue block23;
                        if (block.hasCatchHandlers()) {
                            iterator2.split(code, blocks).listIterator(code).add(constantReturnMaterializingInstruction);
                            break;
                        }
                        iterator2.add(constantReturnMaterializingInstruction);
                        break;
                    }
                    case 28: {
                        CheckCast checkCast;
                        TypeElement castType;
                        InstanceGet instanceGet = current.asInstanceGet();
                        DexField field = instanceGet.getField();
                        GraphLens.FieldLookupResult lookup = graphLens.lookupFieldResult(field, codeLens);
                        DexField rewrittenField = this.rewriteFieldReference(lookup, method);
                        Value newOutValue = null;
                        if (rewrittenField != field) {
                            newOutValue = this.makeOutValue(instanceGet, code, rewrittenField);
                            iterator2.replaceCurrentInstruction(new InstanceGet(newOutValue, instanceGet.object(), rewrittenField));
                        }
                        if (newOutValue == null) continue block23;
                        if (lookup.hasReadCastType() && newOutValue.hasNonDebugUsers()) {
                            castType = TypeElement.fromDexType(lookup.getReadCastType(), newOutValue.getType().nullability(), this.appView);
                            Value castOutValue = code.createValue(castType);
                            newOutValue.replaceUsers(castOutValue);
                            checkCast = ((CheckCast.Builder)((CheckCast.Builder)SafeCheckCast.builder().setCastType(lookup.getReadCastType()).setObject(newOutValue).setOutValue(castOutValue)).setPosition(instanceGet)).build();
                            iterator2.addThrowingInstructionToPossiblyThrowingBlock(code, blocks, checkCast, this.options);
                            affectedPhis.addAll(checkCast.outValue().uniquePhiUsers());
                            break;
                        }
                        if (newOutValue.getType() == instanceGet.getOutType()) continue block23;
                        affectedPhis.addAll(newOutValue.uniquePhiUsers());
                        break;
                    }
                    case 30: {
                        InstancePut instancePut = current.asInstancePut();
                        DexField field = instancePut.getField();
                        GraphLens.FieldLookupResult lookup = graphLens.lookupFieldResult(field, codeLens);
                        iterator2 = this.insertCastForFieldAssignmentIfNeeded(code, blocks, iterator2, instancePut, lookup);
                        DexField rewrittenField = this.rewriteFieldReference(lookup, method);
                        if (rewrittenField == field) continue block23;
                        Value rewrittenValue = this.rewriteValueIfDefault(code, iterator2, field.type, rewrittenField.type, instancePut.value());
                        InstancePut newInstancePut = InstancePut.createPotentiallyInvalid(rewrittenField, instancePut.object(), rewrittenValue);
                        iterator2.replaceCurrentInstruction(newInstancePut);
                        interfaceTypeToClassTypeRewriterHelper.insertCastsForOperandsIfNeeded((FieldPut)instancePut, newInstancePut, blocks, block, iterator2);
                        break;
                    }
                    case 59: {
                        CheckCast checkCast;
                        TypeElement castType;
                        StaticGet staticGet = current.asStaticGet();
                        DexField field = staticGet.getField();
                        GraphLens.FieldLookupResult lookup = graphLens.lookupFieldResult(field, codeLens);
                        DexField rewrittenField = this.rewriteFieldReference(lookup, method);
                        Value newOutValue = null;
                        if (rewrittenField != field) {
                            newOutValue = this.makeOutValue(staticGet, code, rewrittenField);
                            iterator2.replaceCurrentInstruction(new StaticGet(newOutValue, rewrittenField));
                        }
                        if (newOutValue == null) continue block23;
                        if (lookup.hasReadCastType() && newOutValue.hasNonDebugUsers()) {
                            castType = TypeElement.fromDexType(lookup.getReadCastType(), newOutValue.getType().nullability(), this.appView);
                            Value castOutValue = code.createValue(castType);
                            newOutValue.replaceUsers(castOutValue);
                            checkCast = ((CheckCast.Builder)((CheckCast.Builder)SafeCheckCast.builder().setCastType(lookup.getReadCastType()).setObject(newOutValue).setOutValue(castOutValue)).setPosition(staticGet)).build();
                            iterator2.addThrowingInstructionToPossiblyThrowingBlock(code, blocks, checkCast, this.options);
                            affectedPhis.addAll(checkCast.outValue().uniquePhiUsers());
                            break;
                        }
                        if (newOutValue.getType() == staticGet.getOutType()) continue block23;
                        affectedPhis.addAll(newOutValue.uniquePhiUsers());
                        break;
                    }
                    case 60: {
                        StaticPut staticPut = current.asStaticPut();
                        DexField field = staticPut.getField();
                        GraphLens.FieldLookupResult lookup = graphLens.lookupFieldResult(field, codeLens);
                        iterator2 = this.insertCastForFieldAssignmentIfNeeded(code, blocks, iterator2, staticPut, lookup);
                        DexField actualField = this.rewriteFieldReference(lookup, method);
                        if (actualField == field) continue block23;
                        Value rewrittenValue = this.rewriteValueIfDefault(code, iterator2, field.type, actualField.type, staticPut.value());
                        StaticPut replacement = new StaticPut(rewrittenValue, actualField);
                        iterator2.replaceCurrentInstruction(replacement);
                        interfaceTypeToClassTypeRewriterHelper.insertCastsForOperandsIfNeeded((FieldPut)staticPut, replacement, blocks, block, iterator2);
                        break;
                    }
                    case 10: {
                        CheckCast checkCast = current.asCheckCast();
                        new InstructionReplacer(code, current, iterator2, affectedPhis).replaceInstructionIfTypeChanged(checkCast.getType(), (t, v) -> new CheckCast((Value)v, checkCast.object(), (DexType)t, checkCast.ignoreCompatRules()), graphLens, codeLens);
                        break;
                    }
                    case 12: {
                        ConstClass constClass = current.asConstClass();
                        new InstructionReplacer(code, current, iterator2, affectedPhis).replaceInstructionIfTypeChanged(constClass.getValue(), (t, v) -> new ConstClass((Value)v, (DexType)t), graphLens, codeLens);
                        break;
                    }
                    case 29: {
                        InstanceOf instanceOf = current.asInstanceOf();
                        new InstructionReplacer(code, current, iterator2, affectedPhis).replaceInstructionIfTypeChanged(instanceOf.type(), (t, v) -> new InstanceOf((Value)v, instanceOf.value(), (DexType)t), graphLens, codeLens);
                        break;
                    }
                    case 35: {
                        InvokeMultiNewArray multiNewArray = current.asInvokeMultiNewArray();
                        new InstructionReplacer(code, current, iterator2, affectedPhis).replaceInstructionIfTypeChanged(multiNewArray.getArrayType(), (t, v) -> new InvokeMultiNewArray((DexType)t, (Value)v, multiNewArray.inValues()), graphLens, codeLens);
                        break;
                    }
                    case 36: {
                        InvokeNewArray newArray = current.asInvokeNewArray();
                        new InstructionReplacer(code, current, iterator2, affectedPhis).replaceInstructionIfTypeChanged(newArray.getArrayType(), (t, v) -> new InvokeNewArray((DexType)t, (Value)v, newArray.inValues()), graphLens, codeLens);
                        break;
                    }
                    case 44: {
                        MoveException moveException = current.asMoveException();
                        new InstructionReplacer(code, current, iterator2, affectedPhis).replaceInstructionIfTypeChanged(moveException.getExceptionType(), (t, v) -> new MoveException((Value)v, (DexType)t, this.options), graphLens, codeLens);
                        break;
                    }
                    case 47: {
                        NewArrayEmpty newArrayEmpty = current.asNewArrayEmpty();
                        new InstructionReplacer(code, current, iterator2, affectedPhis).replaceInstructionIfTypeChanged(newArrayEmpty.type, (t, v) -> new NewArrayEmpty((Value)v, newArrayEmpty.size(), (DexType)t), graphLens, codeLens);
                        break;
                    }
                    case 49: {
                        Object type = current.asNewInstance().clazz;
                        new InstructionReplacer(code, current, iterator2, affectedPhis).replaceInstructionIfTypeChanged((DexType)type, NewInstance::new, graphLens, codeLens);
                        break;
                    }
                    case 50: {
                        break;
                    }
                    case 56: {
                        Return rewrittenReturn;
                        Return ret = current.asReturn();
                        if (ret.isReturnVoid()) break;
                        this.insertCastForReturnIfNeeded(code, blocks, iterator2, ret, prototypeChangesForMethod);
                        DexType returnType = code.context().getReturnType();
                        Value retValue = ret.returnValue();
                        DexType initialType = retValue.getType().isPrimitiveType() ? retValue.getType().asPrimitiveType().toDexType(this.factory) : this.factory.objectType;
                        Value rewrittenValue = this.rewriteValueIfDefault(code, iterator2, initialType, returnType, retValue);
                        if (retValue != rewrittenValue) {
                            rewrittenReturn = new Return(rewrittenValue);
                            iterator2.replaceCurrentInstruction(rewrittenReturn);
                        } else {
                            rewrittenReturn = ret;
                        }
                        interfaceTypeToClassTypeRewriterHelper.insertCastsForOperandsIfNeeded(rewrittenReturn, blocks, block, iterator2);
                        break;
                    }
                    case 5: {
                        break;
                    }
                    case 9: {
                        assert (false);
                        continue block23;
                    }
                    default: {
                        TypeElement substituted;
                        Object type;
                        if (!current.hasOutValue() || (substituted = ((TypeElement)(type = current.getOutType())).rewrittenWithLens(this.appView, graphLens, codeLens)) == type) continue block23;
                        current.outValue().setType(substituted);
                        affectedPhis.addAll(current.outValue().uniquePhiUsers());
                    }
                }
            }
        }
        if (mayHaveUnreachableBlocks) {
            code.removeUnreachableBlocks();
        }
        if (!affectedPhis.isEmpty()) {
            new DestructivePhiTypeUpdater(this.appView, graphLens, codeLens).recomputeAndPropagateTypes(code, affectedPhis);
        }
        nullCheckInserter.processWorklist();
        code.removeAllDeadAndTrivialPhis();
        this.removeUnusedArguments(method, code, unusedArguments);
        interfaceTypeToClassTypeRewriterHelper.processWorklist();
        assert (code.isConsistentSSABeforeTypesAreCorrect(this.appView));
    }

    private void rewriteArguments(IRCode code, DexMethod originalMethodReference, RewrittenPrototypeDescription prototypeChanges, Set<Phi> affectedPhis, Set<UnusedArgument> unusedArguments) {
        Instruction instruction;
        ArgumentInfoCollection argumentInfoCollection = prototypeChanges.getArgumentInfoCollection();
        LinkedList<Instruction> argumentPostlude = new LinkedList<Instruction>();
        int oldArgumentIndex = 0;
        int nextArgumentIndex = 0;
        int numberOfRemovedArguments = 0;
        InstructionListIterator instructionIterator = code.entryBlock().listIterator(code);
        while (instructionIterator.hasNext() && (instruction = (Instruction)instructionIterator.next()).isArgument()) {
            Argument argument = instruction.asArgument();
            ArgumentInfo argumentInfo = argumentInfoCollection.getArgumentInfo(oldArgumentIndex);
            if (argumentInfo.isRemovedArgumentInfo()) {
                this.rewriteRemovedArgument(code, instructionIterator, originalMethodReference, argument, argumentInfo.asRemovedArgumentInfo(), affectedPhis, argumentPostlude, unusedArguments);
                ++numberOfRemovedArguments;
            } else {
                Argument replacement;
                int newArgumentIndex = argumentInfoCollection.getNewArgumentIndex(oldArgumentIndex, numberOfRemovedArguments);
                if (argumentInfo.isRewrittenTypeInfo()) {
                    replacement = this.rewriteArgumentType(code, argument, argumentInfo.asRewrittenTypeInfo(), affectedPhis, newArgumentIndex);
                    argument.outValue().replaceUsers(replacement.outValue());
                } else if (newArgumentIndex != oldArgumentIndex) {
                    replacement = ((Argument.Builder)((Argument.Builder)Argument.builder().setIndex(newArgumentIndex).setFreshOutValue(code, argument.getOutType(), argument.getLocalInfo())).setPosition(argument.getPosition())).build();
                    argument.outValue().replaceUsers(replacement.outValue());
                } else {
                    replacement = argument;
                }
                if (newArgumentIndex == nextArgumentIndex) {
                    if (replacement != argument) {
                        instructionIterator.replaceCurrentInstruction(replacement);
                    }
                    ++nextArgumentIndex;
                } else {
                    instructionIterator.removeInstructionIgnoreOutValue();
                    ListIterator<Argument> argumentPostludeIterator = argumentPostlude.listIterator();
                    while (argumentPostludeIterator.hasNext()) {
                        Instruction current = (Instruction)argumentPostludeIterator.next();
                        if (current.isArgument() && replacement.getIndexRaw() >= current.asArgument().getIndexRaw()) continue;
                        argumentPostludeIterator.previous();
                        break;
                    }
                    argumentPostludeIterator.add(replacement);
                }
            }
            ++oldArgumentIndex;
        }
        instructionIterator.previous();
        if (!argumentPostlude.isEmpty()) {
            for (Instruction instruction2 : argumentPostlude) {
                instructionIterator.add(instruction2);
            }
        }
    }

    private void rewriteRemovedArgument(IRCode code, InstructionListIterator instructionIterator, DexMethod originalMethodReference, Argument argument, RemovedArgumentInfo removedArgumentInfo, Set<Phi> affectedPhis, List<Instruction> argumentPostlude, Set<UnusedArgument> unusedArguments) {
        Instruction replacement;
        if (removedArgumentInfo.hasSingleValue()) {
            SingleValue singleValue = removedArgumentInfo.getSingleValue();
            TypeElement type = removedArgumentInfo.getType().isReferenceType() && singleValue.isNull() ? TypeElement.getNull() : removedArgumentInfo.getType().toTypeElement(this.appView);
            replacement = singleValue.createMaterializingInstruction(this.appView, code, TypeAndLocalInfoSupplier.create(type, argument.getLocalInfo()));
            replacement.setPosition(((Position.SourcePosition.SourcePositionBuilder)((Position.SourcePosition.SourcePositionBuilder)Position.SourcePosition.builder().setLine(0)).setMethod(originalMethodReference)).build());
        } else {
            TypeElement unusedArgumentType = removedArgumentInfo.getType().toTypeElement(this.appView);
            replacement = new UnusedArgument(code.createValue(unusedArgumentType));
            replacement.setPosition(Position.none());
            unusedArguments.add(replacement.asUnusedArgument());
        }
        argument.outValue().replaceUsers(replacement.outValue());
        affectedPhis.addAll(replacement.outValue().uniquePhiUsers());
        argumentPostlude.add(replacement);
        instructionIterator.removeOrReplaceByDebugLocalRead();
    }

    private Argument rewriteArgumentType(IRCode code, Argument argument, RewrittenTypeInfo rewrittenTypeInfo, Set<Phi> affectedPhis, int newArgumentIndex) {
        TypeElement rewrittenType = rewrittenTypeInfo.getNewType().toTypeElement(this.appView);
        Argument replacement = ((Argument.Builder)((Argument.Builder)Argument.builder().setIndex(newArgumentIndex).setFreshOutValue(code, rewrittenType, argument.getLocalInfo())).setPosition(argument.getPosition())).build();
        affectedPhis.addAll(argument.outValue().uniquePhiUsers());
        return replacement;
    }

    private void removeUnusedArguments(ProgramMethod method, IRCode code, Set<UnusedArgument> unusedArguments) {
        for (UnusedArgument unusedArgument : unusedArguments) {
            if (unusedArgument.outValue().hasAnyUsers()) {
                throw new Unreachable("Unused argument with users in " + method.toSourceString());
            }
            InstructionListIterator instructionIterator = unusedArgument.getBlock().listIterator(code);
            instructionIterator.nextUntil(instruction -> instruction == unusedArgument);
            instructionIterator.removeOrReplaceByDebugLocalRead();
        }
    }

    private Deque<GraphLensInterval> getUnappliedLenses(ProgramMethod method) {
        ArrayDeque<GraphLensInterval> unappliedLenses = new ArrayDeque<GraphLensInterval>(8);
        GraphLens codeLens = ((DexEncodedMethod)method.getDefinition()).getCode().getCodeLens(this.appView);
        GraphLens currentLens = this.appView.graphLens();
        DexMethod currentMethod = (DexMethod)method.getReference();
        while (currentLens != codeLens) {
            GraphLens.NonIdentityGraphLens currentNonIdentityLens;
            assert (currentLens.isNonIdentityLens());
            GraphLens.NonIdentityGraphLens fromInclusiveLens = currentNonIdentityLens = currentLens.asNonIdentityLens();
            if (!currentNonIdentityLens.hasCustomCodeRewritings()) {
                GraphLens fromInclusiveLensPredecessor = fromInclusiveLens.getPrevious();
                while (fromInclusiveLensPredecessor.isNonIdentityLens() && !fromInclusiveLensPredecessor.hasCustomCodeRewritings() && fromInclusiveLensPredecessor != codeLens) {
                    fromInclusiveLens = fromInclusiveLensPredecessor.asNonIdentityLens();
                    fromInclusiveLensPredecessor = fromInclusiveLens.getPrevious();
                }
            }
            GraphLensInterval unappliedLens = new GraphLensInterval(currentNonIdentityLens, fromInclusiveLens.getPrevious(), currentMethod);
            unappliedLenses.addLast(unappliedLens);
            currentLens = unappliedLens.getCodeLens();
            currentMethod = currentNonIdentityLens.getOriginalMethodSignature(currentMethod, currentLens);
        }
        assert (unappliedLenses.size() <= 8);
        return unappliedLenses;
    }

    private InstructionListIterator insertCastForFieldAssignmentIfNeeded(IRCode code, BasicBlockIterator blocks, InstructionListIterator iterator2, FieldPut fieldPut, GraphLens.FieldLookupResult lookup) {
        if (lookup.hasWriteCastType()) {
            iterator2.previous();
            CheckCast checkCast = ((CheckCast.Builder)((CheckCast.Builder)SafeCheckCast.builder().setObject(fieldPut.value()).setFreshOutValue(code, lookup.getWriteCastType().toTypeElement(this.appView))).setCastType(lookup.getWriteCastType()).setPosition(fieldPut.getPosition())).build();
            iterator2.add(checkCast);
            fieldPut.setValue(checkCast.outValue());
            if (checkCast.getBlock().hasCatchHandlers()) {
                BasicBlock splitBlock = iterator2.splitCopyCatchHandlers(code, blocks, this.appView.options());
                BasicBlock previousBlock = blocks.previousUntil(block -> block == splitBlock);
                assert (previousBlock == splitBlock);
                blocks.next();
                iterator2 = splitBlock.listIterator(code);
            }
            Instruction next = (Instruction)iterator2.next();
            assert (next == fieldPut);
        }
        return iterator2;
    }

    private InstructionListIterator insertCastsForInvokeArgumentsIfNeeded(IRCode code, BasicBlockIterator blocks, InstructionListIterator iterator2, InvokeMethod invoke, GraphLens.MethodLookupResult lookup) {
        RewrittenPrototypeDescription prototypeChanges = lookup.getPrototypeChanges();
        if (prototypeChanges.isEmpty()) {
            return iterator2;
        }
        for (int argumentIndex = 0; argumentIndex < invoke.arguments().size(); ++argumentIndex) {
            RewrittenTypeInfo rewrittenTypeInfo = prototypeChanges.getArgumentInfoCollection().getArgumentInfo(argumentIndex).asRewrittenTypeInfo();
            if (rewrittenTypeInfo == null || !rewrittenTypeInfo.hasCastType()) continue;
            iterator2.previous();
            Value object = invoke.getArgument(argumentIndex);
            CheckCast checkCast = ((CheckCast.Builder)((CheckCast.Builder)SafeCheckCast.builder().setObject(object).setFreshOutValue(code, rewrittenTypeInfo.getCastType().toTypeElement(this.appView, object.getType().nullability()))).setCastType(rewrittenTypeInfo.getCastType()).setPosition(invoke.getPosition())).build();
            iterator2.add(checkCast);
            invoke.replaceValue(argumentIndex, checkCast.outValue());
            if (checkCast.getBlock().hasCatchHandlers()) {
                BasicBlock splitBlock = iterator2.splitCopyCatchHandlers(code, blocks, this.appView.options());
                BasicBlock previousBlock = blocks.previousUntil(block -> block == splitBlock);
                assert (previousBlock == splitBlock);
                blocks.next();
                iterator2 = splitBlock.listIterator(code);
            }
            Instruction next = (Instruction)iterator2.next();
            assert (next == invoke);
        }
        return iterator2;
    }

    private InstructionListIterator insertCastForReturnIfNeeded(IRCode code, BasicBlockIterator blocks, InstructionListIterator iterator2, Return ret, RewrittenPrototypeDescription prototypeChanges) {
        if (!prototypeChanges.hasRewrittenReturnInfo() || !prototypeChanges.getRewrittenReturnInfo().hasCastType()) {
            return iterator2;
        }
        iterator2.previous();
        if (ret.getBlock().hasCatchHandlers()) {
            BasicBlock splitBlock = iterator2.splitCopyCatchHandlers(code, blocks, this.options);
            BasicBlock previousBlock = blocks.previousUntil(block -> block == splitBlock);
            assert (previousBlock != null);
            blocks.next();
            iterator2 = splitBlock.listIterator(code);
        }
        DexType castType = prototypeChanges.getRewrittenReturnInfo().getCastType();
        Value returnValue = ret.returnValue();
        CheckCast checkCast = ((CheckCast.Builder)((CheckCast.Builder)SafeCheckCast.builder().setObject(returnValue).setFreshOutValue(code, castType.toTypeElement(this.appView, returnValue.getType().nullability()))).setCastType(castType).setPosition(ret.getPosition())).build();
        iterator2.add(checkCast);
        ret.replaceValue(0, checkCast.outValue());
        Instruction next = (Instruction)iterator2.next();
        assert (next == ret);
        return iterator2;
    }

    private DexField rewriteFieldReference(GraphLens.FieldLookupResult lookup, ProgramMethod context) {
        if (lookup.hasReboundReference()) {
            DexClassAndField field;
            DexClass holder = this.appView.definitionFor(((DexField)lookup.getReboundReference()).getHolderType());
            DexEncodedField definition = ((DexField)lookup.getReboundReference()).lookupOnClass(holder);
            if (definition != null && AccessControl.isMemberAccessible(field = DexClassAndField.create(holder, definition), holder, context, this.appView).isTrue()) {
                return MemberRebindingAnalysis.validMemberRebindingTargetFor(this.appView, field, (DexField)lookup.getReference());
            }
        }
        return (DexField)lookup.getReference();
    }

    private Value rewriteValueIfDefault(IRCode code, InstructionListIterator iterator2, DexType oldType, DexType newType, Value initialValue) {
        if (initialValue.getType().isNullType() && this.defaultValueHasChanged(oldType, newType)) {
            assert (newType.isIntType());
            iterator2.previous();
            Value rewrittenDefaultValue = iterator2.insertConstNumberInstruction(code, this.options, 0L, this.defaultValueLatticeElement(newType));
            iterator2.next();
            return rewrittenDefaultValue;
        }
        return initialValue;
    }

    private boolean defaultValueHasChanged(DexType oldType, DexType newType) {
        if (newType.isPrimitiveType()) {
            if (oldType.isPrimitiveType()) {
                return ValueType.fromDexType(newType) != ValueType.fromDexType(oldType);
            }
            return true;
        }
        if (oldType.isPrimitiveType()) {
            return true;
        }
        assert (newType.isReferenceType());
        assert (oldType.isReferenceType());
        return false;
    }

    private TypeElement defaultValueLatticeElement(DexType type) {
        if (type.isPrimitiveType()) {
            return TypeElement.fromDexType(type, null, this.appView);
        }
        return TypeElement.getNull();
    }

    private void checkInvokeDirect(DexMethod method, InvokeDirect invoke) {
        VerticallyMergedClasses verticallyMergedClasses = this.appView.verticallyMergedClasses();
        if (verticallyMergedClasses == null) {
            return;
        }
        DexMethod invokedMethod = invoke.getInvokedMethod();
        if (invokedMethod.name != this.factory.constructorMethodName) {
            return;
        }
        if (invoke.arguments().isEmpty()) {
            return;
        }
        Value receiver = invoke.arguments().get(0);
        if (!receiver.isPhi() && receiver.definition.isNewInstance()) {
            NewInstance newInstance = receiver.definition.asNewInstance();
            if (newInstance.clazz != invokedMethod.holder && verticallyMergedClasses.hasBeenMergedIntoSubtype(invokedMethod.holder)) {
                throw this.appView.options().reporter.fatalError(String.format("Unable to rewrite `invoke-direct %s.<init>(new %s, ...)` in method `%s` after type `%s` was merged into `%s`. Please add the following rule to your Proguard configuration file: `-keep,allowobfuscation class %s`.", invokedMethod.holder.toSourceString(), newInstance.clazz, method.toSourceString(), invokedMethod.holder, verticallyMergedClasses.getTargetFor(invokedMethod.holder), invokedMethod.holder.toSourceString()));
            }
        }
    }

    private boolean unlinkDeadCatchHandlers(BasicBlock block, GraphLens.NonIdentityGraphLens graphLens, GraphLens codeLens) {
        assert (block.hasCatchHandlers());
        CatchHandlers<BasicBlock> catchHandlers = block.getCatchHandlers();
        List<DexType> guards = catchHandlers.getGuards();
        List<BasicBlock> targets = catchHandlers.getAllTargets();
        HashSet<DexType> previouslySeenGuards = new HashSet<DexType>();
        ArrayList<BasicBlock> deadCatchHandlers = new ArrayList<BasicBlock>();
        for (int i = 0; i < guards.size(); ++i) {
            boolean guardSeenBefore;
            DexType guard = graphLens.lookupType(guards.get(i), codeLens);
            boolean bl = guardSeenBefore = !previouslySeenGuards.add(guard);
            if (!guardSeenBefore) continue;
            deadCatchHandlers.add(targets.get(i));
        }
        for (BasicBlock deadCatchHandler : deadCatchHandlers) {
            deadCatchHandler.unlinkCatchHandler();
        }
        assert (block.consistentCatchHandlers());
        return !deadCatchHandlers.isEmpty();
    }

    public void rewrite(IRCode code, ProgramMethod method, MethodProcessor methodProcessor) {
        Deque<GraphLensInterval> unappliedLenses = this.getUnappliedLenses(method);
        DexMethod originalMethodReference = this.appView.graphLens().getOriginalMethodSignature((DexMethod)method.getReference());
        while (!unappliedLenses.isEmpty()) {
            GraphLensInterval unappliedLens = unappliedLenses.removeLast();
            RewrittenPrototypeDescription prototypeChanges = unappliedLens.getGraphLens().lookupPrototypeChangesForMethodDefinition(unappliedLens.getMethod(), unappliedLens.getCodeLens());
            this.rewritePartial(code, method, originalMethodReference, methodProcessor, unappliedLens.getGraphLens(), unappliedLens.getCodeLens(), prototypeChanges);
        }
        assert (code.hasNoMergedClasses(this.appView));
    }

    class InstructionReplacer {
        private final IRCode code;
        private final Instruction current;
        private final InstructionListIterator iterator;
        private final Set<Phi> affectedPhis;

        InstructionReplacer(IRCode code, Instruction current, InstructionListIterator iterator2, Set<Phi> affectedPhis) {
            this.code = code;
            this.current = current;
            this.iterator = iterator2;
            this.affectedPhis = affectedPhis;
        }

        void replaceInstructionIfTypeChanged(DexType type, BiFunction<DexType, Value, Instruction> constructor, GraphLens.NonIdentityGraphLens graphLens, GraphLens codeLens) {
            DexType newType = graphLens.lookupType(type, codeLens);
            if (newType != type) {
                Value newOutValue = LensCodeRewriter.this.makeOutValue(this.current, this.code, graphLens, codeLens);
                Instruction newInstruction = constructor.apply(newType, newOutValue);
                this.iterator.replaceCurrentInstruction(newInstruction);
                if (newOutValue != null) {
                    if (newOutValue.getType() != this.current.getOutType()) {
                        this.affectedPhis.addAll(newOutValue.uniquePhiUsers());
                    } else {
                        assert (this.current.hasInvariantOutType());
                        assert (this.current.isConstClass() || this.current.isInitClass() || this.current.isInstanceOf() || this.current.isInvokeVirtual() && this.current.asInvokeVirtual().getInvokedMethod().holder.isArrayType());
                    }
                }
            }
        }
    }

    private static class GraphLensInterval {
        private final GraphLens.NonIdentityGraphLens graphLens;
        private final GraphLens codeLens;
        private final DexMethod method;

        GraphLensInterval(GraphLens.NonIdentityGraphLens graphLens, GraphLens codeLens, DexMethod method) {
            this.graphLens = graphLens;
            this.codeLens = codeLens;
            this.method = method;
        }

        public GraphLens.NonIdentityGraphLens getGraphLens() {
            return this.graphLens;
        }

        public GraphLens getCodeLens() {
            return this.codeLens;
        }

        public DexMethod getMethod() {
            return this.method;
        }
    }
}

