/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.r8.ir.conversion;

import com.android.tools.r8.graph.AppView;
import com.android.tools.r8.graph.DexCallSite;
import com.android.tools.r8.graph.DexClass;
import com.android.tools.r8.graph.DexDefinitionSupplier;
import com.android.tools.r8.graph.DexField;
import com.android.tools.r8.graph.DexItemFactory;
import com.android.tools.r8.graph.DexMethod;
import com.android.tools.r8.graph.DexMethodHandle;
import com.android.tools.r8.graph.DexProto;
import com.android.tools.r8.graph.DexString;
import com.android.tools.r8.graph.DexType;
import com.android.tools.r8.graph.DexValue;
import com.android.tools.r8.graph.GraphLens;
import com.android.tools.r8.graph.ProgramMethod;
import com.android.tools.r8.graph.UseRegistry;
import com.android.tools.r8.ir.code.Invoke;
import com.android.tools.r8.ir.desugar.LambdaDescriptor;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class LensCodeRewriterUtils {
    private final DexDefinitionSupplier definitions;
    private final GraphLens graphLens;
    private final GraphLens codeLens;
    private final Map<DexProto, DexProto> protoFixupCache = new ConcurrentHashMap<DexProto, DexProto>();
    private final Map<DexCallSite, DexCallSite> rewrittenCallSiteCache;

    public LensCodeRewriterUtils(AppView<?> appView) {
        this(appView, appView.graphLens(), appView.codeLens());
    }

    public LensCodeRewriterUtils(AppView<?> appView, boolean enableCallSiteCaching) {
        this.definitions = appView;
        this.graphLens = appView.graphLens();
        this.codeLens = appView.codeLens();
        this.rewrittenCallSiteCache = enableCallSiteCaching ? new ConcurrentHashMap() : null;
    }

    public LensCodeRewriterUtils(DexDefinitionSupplier definitions, GraphLens graphLens, GraphLens codeLens) {
        this.definitions = definitions;
        this.graphLens = graphLens;
        this.codeLens = codeLens;
        this.rewrittenCallSiteCache = null;
    }

    private DexCallSite rewriteCallSiteInternal(DexCallSite callSite, ProgramMethod context) {
        DexItemFactory dexItemFactory = this.definitions.dexItemFactory();
        DexProto newMethodProto = this.rewriteProto(callSite.methodProto);
        DexMethodHandle newBootstrapMethod = this.rewriteDexMethodHandle(callSite.bootstrapMethod, UseRegistry.MethodHandleUse.NOT_ARGUMENT_TO_LAMBDA_METAFACTORY, context);
        boolean isLambdaMetaFactory = dexItemFactory.isLambdaMetafactoryMethod(callSite.bootstrapMethod.asMethod());
        UseRegistry.MethodHandleUse methodHandleUse = isLambdaMetaFactory ? UseRegistry.MethodHandleUse.ARGUMENT_TO_LAMBDA_METAFACTORY : UseRegistry.MethodHandleUse.NOT_ARGUMENT_TO_LAMBDA_METAFACTORY;
        List<DexValue> newArgs = this.rewriteBootstrapArguments(callSite.bootstrapArgs, methodHandleUse, context);
        DexString newMethodName = this.computeNewMethodName(callSite, context, isLambdaMetaFactory);
        if (!newMethodProto.equals(callSite.methodProto) || newMethodName != callSite.methodName || newBootstrapMethod != callSite.bootstrapMethod || !newArgs.equals(callSite.bootstrapArgs)) {
            return dexItemFactory.createCallSite(newMethodName, newMethodProto, newBootstrapMethod, newArgs);
        }
        return callSite;
    }

    private DexString computeNewMethodName(DexCallSite callSite, ProgramMethod context, boolean isLambdaMetaFactory) {
        if (!isLambdaMetaFactory) {
            return callSite.methodName;
        }
        assert (callSite.getBootstrapArgs().size() > 0);
        assert (callSite.getBootstrapArgs().get(0).isDexValueMethodType());
        DexMethod method = LambdaDescriptor.getMainFunctionalInterfaceMethodReference(callSite, this.definitions.dexItemFactory());
        return ((DexMethod)this.graphLens.lookupMethod(method, (DexMethod)context.getReference(), Invoke.Type.INTERFACE, this.codeLens).getReference()).getName();
    }

    private List<DexValue> rewriteBootstrapArguments(List<DexValue> bootstrapArgs, UseRegistry.MethodHandleUse use, ProgramMethod context) {
        List<DexValue> newBootstrapArgs = null;
        boolean changed = false;
        for (int i = 0; i < bootstrapArgs.size(); ++i) {
            DexValue argument = bootstrapArgs.get(i);
            DexValue newArgument = this.rewriteBootstrapArgument(argument, use, context);
            if (newArgument != argument) {
                if (newBootstrapArgs == null) {
                    newBootstrapArgs = new ArrayList<DexValue>(bootstrapArgs.subList(0, i));
                }
                newBootstrapArgs.add(newArgument);
                changed = true;
                continue;
            }
            if (newBootstrapArgs == null) continue;
            newBootstrapArgs.add(newArgument);
        }
        return changed ? newBootstrapArgs : bootstrapArgs;
    }

    private DexValue.DexValueMethodType rewriteDexMethodType(DexValue.DexValueMethodType type) {
        DexProto oldProto = (DexProto)type.value;
        DexProto newProto = this.rewriteProto(oldProto);
        return newProto != oldProto ? new DexValue.DexValueMethodType(newProto) : type;
    }

    private DexValue rewriteBootstrapArgument(DexValue value, UseRegistry.MethodHandleUse use, ProgramMethod context) {
        switch (value.getValueKind()) {
            case METHOD_HANDLE: {
                return this.rewriteDexValueMethodHandle(value.asDexValueMethodHandle(), use, context);
            }
            case METHOD_TYPE: {
                return this.rewriteDexMethodType(value.asDexValueMethodType());
            }
            case TYPE: {
                DexType oldType = (DexType)value.asDexValueType().value;
                DexType newType = this.graphLens.lookupType(oldType, this.codeLens);
                return newType != oldType ? new DexValue.DexValueType(newType) : value;
            }
        }
        return value;
    }

    private DexValue.DexValueMethodHandle rewriteDexValueMethodHandle(DexValue.DexValueMethodHandle methodHandle, UseRegistry.MethodHandleUse use, ProgramMethod context) {
        DexMethodHandle oldHandle = (DexMethodHandle)methodHandle.value;
        DexMethodHandle newHandle = this.rewriteDexMethodHandle(oldHandle, use, context);
        return newHandle != oldHandle ? new DexValue.DexValueMethodHandle(newHandle) : methodHandle;
    }

    public DexItemFactory dexItemFactory() {
        return this.definitions.dexItemFactory();
    }

    public DexCallSite rewriteCallSite(DexCallSite callSite, ProgramMethod context) {
        if (this.rewrittenCallSiteCache == null) {
            return this.rewriteCallSiteInternal(callSite, context);
        }
        return this.rewrittenCallSiteCache.computeIfAbsent(callSite, ignored -> this.rewriteCallSiteInternal(callSite, context));
    }

    public DexMethodHandle rewriteDexMethodHandle(DexMethodHandle methodHandle, UseRegistry.MethodHandleUse use, ProgramMethod context) {
        if (methodHandle.isMethodHandle()) {
            DexMethodHandle.MethodHandleType newType;
            DexMethod actualTarget;
            DexMethod invokedMethod = methodHandle.asMethod();
            DexMethodHandle.MethodHandleType oldType = methodHandle.type;
            GraphLens.MethodLookupResult lensLookup = this.graphLens.lookupMethod(invokedMethod, (DexMethod)context.getReference(), oldType.toInvokeType(), this.codeLens);
            DexMethod rewrittenTarget = (DexMethod)lensLookup.getReference();
            if (use == UseRegistry.MethodHandleUse.ARGUMENT_TO_LAMBDA_METAFACTORY) {
                actualTarget = rewrittenTarget;
                newType = lensLookup.getType().toMethodHandle(actualTarget);
            } else {
                assert (use == UseRegistry.MethodHandleUse.NOT_ARGUMENT_TO_LAMBDA_METAFACTORY);
                actualTarget = this.definitions.dexItemFactory().createMethod(this.graphLens.lookupType(invokedMethod.holder, this.codeLens), rewrittenTarget.proto, rewrittenTarget.name);
                newType = oldType;
                if (oldType.isInvokeDirect()) {
                    assert (rewrittenTarget.holder == actualTarget.holder);
                    newType = lensLookup.getType().toMethodHandle(actualTarget);
                    assert (newType == DexMethodHandle.MethodHandleType.INVOKE_DIRECT || newType == DexMethodHandle.MethodHandleType.INVOKE_INSTANCE);
                }
            }
            if (newType != oldType || actualTarget != invokedMethod || rewrittenTarget != actualTarget) {
                DexClass holder = this.definitions.definitionFor(actualTarget.holder, context);
                boolean isInterface = holder != null ? holder.isInterface() : methodHandle.isInterface;
                return this.definitions.dexItemFactory().createMethodHandle(newType, actualTarget, isInterface, rewrittenTarget != actualTarget ? rewrittenTarget : null);
            }
        } else {
            DexField field = methodHandle.asField();
            DexField actualField = this.graphLens.lookupField(field, this.codeLens);
            if (actualField != field) {
                return this.definitions.dexItemFactory().createMethodHandle(methodHandle.type, actualField, methodHandle.isInterface);
            }
        }
        return methodHandle;
    }

    public DexProto rewriteProto(DexProto proto) {
        return this.definitions.dexItemFactory().applyClassMappingToProto(proto, type -> this.graphLens.lookupType((DexType)type, this.codeLens), this.protoFixupCache);
    }
}

