/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.r8.ir.conversion;

import com.android.tools.r8.contexts.CompilationContext;
import com.android.tools.r8.graph.AppView;
import com.android.tools.r8.graph.DexEncodedMethod;
import com.android.tools.r8.graph.DexMethod;
import com.android.tools.r8.graph.DexProgramClass;
import com.android.tools.r8.graph.GraphLens;
import com.android.tools.r8.graph.ProgramMethod;
import com.android.tools.r8.ir.conversion.MethodProcessorWithWave;
import com.android.tools.r8.ir.conversion.PrimaryMethodProcessor;
import com.android.tools.r8.ir.conversion.callgraph.CallGraph;
import com.android.tools.r8.ir.conversion.callgraph.PartialCallGraphBuilder;
import com.android.tools.r8.ir.optimize.info.OptimizationFeedbackDelayed;
import com.android.tools.r8.logging.Log;
import com.android.tools.r8.shaking.AppInfoWithLiveness;
import com.android.tools.r8.utils.ThreadUtils;
import com.android.tools.r8.utils.Timing;
import com.android.tools.r8.utils.collections.LongLivedProgramMethodSetBuilder;
import com.android.tools.r8.utils.collections.ProgramMethodSet;
import java.util.ArrayDeque;
import java.util.Collection;
import java.util.Deque;
import java.util.Set;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;

public class PostMethodProcessor
extends MethodProcessorWithWave {
    private final CompilationContext.ProcessorContext processorContext;
    private final Deque<ProgramMethodSet> waves;
    private final ProgramMethodSet processed = ProgramMethodSet.create();

    private PostMethodProcessor(AppView<AppInfoWithLiveness> appView, CallGraph callGraph) {
        this.processorContext = appView.createProcessorContext();
        this.waves = this.createWaves(callGraph);
    }

    private Deque<ProgramMethodSet> createWaves(CallGraph callGraph) {
        ArrayDeque<ProgramMethodSet> waves = new ArrayDeque<ProgramMethodSet>();
        int waveCount = 1;
        while (!callGraph.isEmpty()) {
            ProgramMethodSet wave = callGraph.extractLeaves();
            waves.addLast(wave);
            if (!Log.ENABLED || !Log.isLoggingEnabledFor(PostMethodProcessor.class)) continue;
            Log.info(this.getClass(), "Wave #%d: %d", waveCount++, wave.size());
        }
        return waves;
    }

    @Override
    public CompilationContext.MethodProcessingContext createMethodProcessingContext(ProgramMethod method) {
        return this.processorContext.createMethodProcessingContext(method);
    }

    @Override
    public boolean isPostMethodProcessor() {
        return true;
    }

    @Override
    public boolean shouldApplyCodeRewritings(ProgramMethod method) {
        assert (!this.wave.contains(method));
        return !this.processed.contains(method);
    }

    <E extends Exception> void forEachMethod(PrimaryMethodProcessor.MethodAction<E> consumer, OptimizationFeedbackDelayed feedback, ExecutorService executorService, Timing timing) throws ExecutionException {
        Timing.TimingMerger merger = timing.beginMerger("secondary-processor", ThreadUtils.getNumberOfThreads(executorService));
        while (!this.waves.isEmpty()) {
            this.wave = this.waves.removeFirst();
            assert (!this.wave.isEmpty());
            assert (this.waveExtension.isEmpty());
            do {
                assert (feedback.noUpdatesLeft());
                Collection<Timing> timings = ThreadUtils.processItemsWithResults(this.wave, method -> {
                    Timing time = consumer.apply((ProgramMethod)method, this.createMethodProcessingContext((ProgramMethod)method));
                    time.end();
                    return time;
                }, executorService);
                merger.add(timings);
                feedback.updateVisibleOptimizationInfo();
                this.processed.addAll(this.wave);
                this.prepareForWaveExtensionProcessing();
            } while (!this.wave.isEmpty());
        }
        merger.end();
    }

    public static class Builder {
        private final LongLivedProgramMethodSetBuilder<ProgramMethodSet> methodsToReprocessBuilder;

        Builder(GraphLens graphLensForPrimaryOptimizationPass) {
            this.methodsToReprocessBuilder = LongLivedProgramMethodSetBuilder.createForIdentitySet(graphLensForPrimaryOptimizationPass);
        }

        public void add(ProgramMethod method) {
            this.methodsToReprocessBuilder.add(method);
        }

        public void add(ProgramMethod method, GraphLens currentGraphLens) {
            this.methodsToReprocessBuilder.add(method, currentGraphLens);
        }

        public void addAll(Collection<ProgramMethod> methods, GraphLens currentGraphLens) {
            methods.forEach(method -> this.add((ProgramMethod)method, currentGraphLens));
        }

        public boolean contains(ProgramMethod method, GraphLens currentGraphLens) {
            return this.methodsToReprocessBuilder.contains(method, currentGraphLens);
        }

        public Builder merge(LongLivedProgramMethodSetBuilder<ProgramMethodSet> otherMethodsToReprocessBuilder) {
            this.methodsToReprocessBuilder.merge(otherMethodsToReprocessBuilder);
            return this;
        }

        public void put(ProgramMethodSet methodsToRevisit) {
            methodsToRevisit.forEach(this::add);
        }

        public void remove(ProgramMethod method, GraphLens graphLens) {
            this.methodsToReprocessBuilder.remove((DexMethod)method.getReference(), graphLens);
        }

        public Builder removeAll(Collection<DexMethod> methods) {
            this.methodsToReprocessBuilder.removeAll(methods);
            return this;
        }

        public Builder rewrittenWithLens(AppView<AppInfoWithLiveness> appView) {
            this.methodsToReprocessBuilder.rewrittenWithLens(appView);
            return this;
        }

        public Builder rewrittenWithLens(GraphLens graphLens) {
            this.methodsToReprocessBuilder.rewrittenWithLens(graphLens);
            return this;
        }

        PostMethodProcessor build(AppView<AppInfoWithLiveness> appView, ExecutorService executorService, Timing timing) throws ExecutionException {
            Set<DexMethod> reprocessMethods = appView.appInfo().getReprocessMethods();
            if (!reprocessMethods.isEmpty()) {
                ProgramMethodSet set = ProgramMethodSet.create();
                reprocessMethods.forEach(reference -> {
                    DexProgramClass clazz = DexProgramClass.asProgramClassOrNull(appView.definitionForHolder(reference));
                    DexEncodedMethod definition = reference.lookupOnClass(clazz);
                    if (definition != null) {
                        set.createAndAdd(clazz, definition);
                    }
                });
                this.put(set);
            }
            if (this.methodsToReprocessBuilder.isEmpty()) {
                return null;
            }
            ProgramMethodSet methodsToReprocess = this.methodsToReprocessBuilder.build(appView);
            CallGraph callGraph = new PartialCallGraphBuilder(appView, methodsToReprocess).build(executorService, timing);
            return new PostMethodProcessor(appView, callGraph);
        }
    }
}

