/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.r8.ir.conversion;

import com.android.tools.r8.contexts.CompilationContext;
import com.android.tools.r8.graph.AppView;
import com.android.tools.r8.graph.DexEncodedMethod;
import com.android.tools.r8.graph.ProgramMethod;
import com.android.tools.r8.ir.conversion.MethodProcessorWithWave;
import com.android.tools.r8.ir.conversion.callgraph.CallGraph;
import com.android.tools.r8.ir.conversion.callgraph.CallSiteInformation;
import com.android.tools.r8.logging.Log;
import com.android.tools.r8.shaking.AppInfoWithLiveness;
import com.android.tools.r8.utils.InternalOptions;
import com.android.tools.r8.utils.ThreadUtils;
import com.android.tools.r8.utils.Timing;
import com.android.tools.r8.utils.collections.ProgramMethodSet;
import java.util.ArrayDeque;
import java.util.Collection;
import java.util.Deque;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;

public class PrimaryMethodProcessor
extends MethodProcessorWithWave {
    private final AppView<?> appView;
    private final CallSiteInformation callSiteInformation;
    private final Deque<ProgramMethodSet> waves;
    private CompilationContext.ProcessorContext processorContext;

    private PrimaryMethodProcessor(AppView<AppInfoWithLiveness> appView, CallGraph callGraph) {
        this.appView = appView;
        this.callSiteInformation = callGraph.createCallSiteInformation(appView);
        this.waves = this.createWaves(appView, callGraph);
    }

    static PrimaryMethodProcessor create(AppView<AppInfoWithLiveness> appView, ExecutorService executorService, Timing timing) throws ExecutionException {
        CallGraph callGraph = CallGraph.builder(appView).build(executorService, timing);
        return new PrimaryMethodProcessor(appView, callGraph);
    }

    private Deque<ProgramMethodSet> createWaves(AppView<?> appView, CallGraph callGraph) {
        InternalOptions options = appView.options();
        ArrayDeque<ProgramMethodSet> waves = new ArrayDeque<ProgramMethodSet>();
        Collection nodes = callGraph.getNodes();
        int waveCount = 1;
        while (!nodes.isEmpty()) {
            ProgramMethodSet wave = callGraph.extractLeaves();
            waves.addLast(wave);
            if (!Log.ENABLED || !Log.isLoggingEnabledFor(PrimaryMethodProcessor.class)) continue;
            Log.info(this.getClass(), "Wave #%d: %d", waveCount++, wave.size());
        }
        options.testing.waveModifier.accept(waves);
        return waves;
    }

    @Override
    public CompilationContext.MethodProcessingContext createMethodProcessingContext(ProgramMethod method) {
        return this.processorContext.createMethodProcessingContext(method);
    }

    @Override
    public boolean isPrimaryMethodProcessor() {
        return true;
    }

    @Override
    public PrimaryMethodProcessor asPrimaryMethodProcessor() {
        return this;
    }

    @Override
    public boolean shouldApplyCodeRewritings(ProgramMethod method) {
        assert (!this.wave.contains(method));
        return !((DexEncodedMethod)method.getDefinition()).isProcessed();
    }

    @Override
    public CallSiteInformation getCallSiteInformation() {
        return this.callSiteInformation;
    }

    <E extends Exception> void forEachMethod(MethodAction<E> consumer, WaveStartAction waveStartAction, WaveDoneAction waveDoneAction, Timing timing, ExecutorService executorService) throws ExecutionException {
        Timing.TimingMerger merger = timing.beginMerger("primary-processor", ThreadUtils.getNumberOfThreads(executorService));
        while (!this.waves.isEmpty()) {
            this.processorContext = this.appView.createProcessorContext();
            this.wave = this.waves.removeFirst();
            assert (!this.wave.isEmpty());
            assert (this.waveExtension.isEmpty());
            do {
                waveStartAction.notifyWaveStart(this.wave);
                Collection<Timing> timings = ThreadUtils.processItemsWithResults(this.wave, method -> {
                    Timing time = consumer.apply((ProgramMethod)method, this.createMethodProcessingContext((ProgramMethod)method));
                    time.end();
                    return time;
                }, executorService);
                merger.add(timings);
                waveDoneAction.notifyWaveDone(this.wave, executorService);
                this.prepareForWaveExtensionProcessing();
            } while (!this.wave.isEmpty());
        }
        merger.end();
    }

    @FunctionalInterface
    public static interface MethodAction<E extends Exception> {
        public Timing apply(ProgramMethod var1, CompilationContext.MethodProcessingContext var2) throws E;
    }

    static interface WaveDoneAction {
        public void notifyWaveDone(ProgramMethodSet var1, ExecutorService var2) throws ExecutionException;
    }

    static interface WaveStartAction {
        public void notifyWaveStart(ProgramMethodSet var1);
    }
}

