/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.r8.ir.conversion.callgraph;

import com.android.tools.r8.com.google.common.collect.Sets;
import com.android.tools.r8.graph.AppView;
import com.android.tools.r8.graph.DexMethod;
import com.android.tools.r8.ir.conversion.callgraph.CallGraphBase;
import com.android.tools.r8.ir.conversion.callgraph.CallGraphBuilder;
import com.android.tools.r8.ir.conversion.callgraph.CallSiteInformation;
import com.android.tools.r8.ir.conversion.callgraph.CycleEliminator;
import com.android.tools.r8.ir.conversion.callgraph.Node;
import com.android.tools.r8.shaking.AppInfoWithLiveness;
import com.android.tools.r8.utils.collections.ProgramMethodSet;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;

public class CallGraph
extends CallGraphBase<Node> {
    private final CycleEliminator.CycleEliminationResult cycleEliminationResult;

    CallGraph(Map<DexMethod, Node> nodes) {
        this(nodes, null);
    }

    CallGraph(Map<DexMethod, Node> nodes, CycleEliminator.CycleEliminationResult cycleEliminationResult) {
        super(nodes);
        this.cycleEliminationResult = cycleEliminationResult;
    }

    public static CallGraphBuilder builder(AppView<AppInfoWithLiveness> appView) {
        return new CallGraphBuilder(appView);
    }

    public static CallGraph createForTesting(Collection<Node> nodes) {
        return new CallGraph(nodes.stream().collect(Collectors.toMap(node -> (DexMethod)node.getProgramMethod().getReference(), Function.identity())));
    }

    private ProgramMethodSet extractNodes(Predicate<Node> predicate, Consumer<Node> clean) {
        ProgramMethodSet result = ProgramMethodSet.create();
        Set<Node> removed = Sets.newIdentityHashSet();
        Iterator nodeIterator = this.nodes.values().iterator();
        while (nodeIterator.hasNext()) {
            Node node = (Node)nodeIterator.next();
            if (!predicate.test(node)) continue;
            result.add(node.getProgramMethod());
            nodeIterator.remove();
            removed.add(node);
        }
        removed.forEach(clean);
        assert (!result.isEmpty());
        return result;
    }

    public CallSiteInformation createCallSiteInformation(AppView<AppInfoWithLiveness> appView) {
        return appView.options().isShrinking() ? new CallSiteInformation.CallGraphBasedCallSiteInformation(appView, this) : CallSiteInformation.empty();
    }

    public ProgramMethodSet extractLeaves() {
        return this.extractNodes(Node::isLeaf, Node::cleanCallersAndReadersForRemoval);
    }

    public ProgramMethodSet extractRoots() {
        return this.extractNodes(Node::isRoot, Node::cleanCalleesAndWritersForRemoval);
    }
}

