/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.r8.ir.conversion.callgraph;

import com.android.tools.r8.com.google.common.base.Predicates;
import com.android.tools.r8.graph.AppView;
import com.android.tools.r8.graph.DexEncodedMethod;
import com.android.tools.r8.graph.DexProgramClass;
import com.android.tools.r8.graph.ProgramMethod;
import com.android.tools.r8.ir.conversion.callgraph.IRProcessingCallGraphBuilderBase;
import com.android.tools.r8.ir.conversion.callgraph.IRProcessingCallGraphUseRegistry;
import com.android.tools.r8.ir.conversion.callgraph.Node;
import com.android.tools.r8.shaking.AppInfoWithLiveness;
import com.android.tools.r8.utils.ThreadUtils;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;

public class CallGraphBuilder
extends IRProcessingCallGraphBuilderBase {
    public CallGraphBuilder(AppView<AppInfoWithLiveness> appView) {
        super(appView);
    }

    private void processClass(DexProgramClass clazz) {
        clazz.forEachProgramMethodMatching(DexEncodedMethod::hasCode, this::processMethod);
    }

    private void processMethod(ProgramMethod method) {
        IRProcessingCallGraphUseRegistry<Node> registry = new IRProcessingCallGraphUseRegistry<Node>(this.appView, (Node)this.getOrCreateNode(method), this::getOrCreateNode, this.possibleProgramTargetsCache, Predicates.alwaysTrue());
        method.registerCodeReferences(registry);
    }

    @Override
    void populateGraph(ExecutorService executorService) throws ExecutionException {
        ThreadUtils.processItems(((AppInfoWithLiveness)this.appView.appInfo()).classes(), this::processClass, executorService);
    }

    @Override
    boolean verifyAllMethodsWithCodeExists() {
        for (DexProgramClass clazz : ((AppInfoWithLiveness)this.appView.appInfo()).classes()) {
            for (DexEncodedMethod method : clazz.methods()) {
                assert (method.hasCode() == (this.nodes.get(method.getReference()) != null));
            }
        }
        return true;
    }
}

