/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.r8.ir.conversion.callgraph;

import com.android.tools.r8.com.google.common.collect.Iterators;
import com.android.tools.r8.com.google.common.collect.Sets;
import com.android.tools.r8.errors.CompilationError;
import com.android.tools.r8.graph.DexEncodedMethod;
import com.android.tools.r8.ir.conversion.callgraph.Node;
import com.android.tools.r8.logging.Log;
import com.android.tools.r8.utils.collections.ProgramMethodSet;
import java.util.ArrayDeque;
import java.util.Collection;
import java.util.Deque;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.Map;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Predicate;

public class CycleEliminator {
    public static final String CYCLIC_FORCE_INLINING_MESSAGE = "Unable to satisfy force inlining constraints due to cyclic force inlining";
    private Deque<Node> stack = new ArrayDeque<Node>();
    private Map<Node, StackEntryInfo> stackEntryInfo = new IdentityHashMap<Node, StackEntryInfo>();
    private Deque<Node> clinitCallStack = new ArrayDeque<Node>();
    private Deque<Node> writerStack = new ArrayDeque<Node>();
    private Set<Node> marked = Sets.newIdentityHashSet();
    private Map<Node, Set<Node>> calleesToBeRemoved = new IdentityHashMap<Node, Set<Node>>();
    private Map<Node, Set<Node>> writersToBeRemoved = new IdentityHashMap<Node, Set<Node>>();
    private Map<DexEncodedMethod, ProgramMethodSet> removedCallEdges = new IdentityHashMap<DexEncodedMethod, ProgramMethodSet>();
    private LinkedHashSet<Node> revisit = new LinkedHashSet();

    private void prepareForNewTraversal() {
        assert (this.calleesToBeRemoved.isEmpty());
        assert (this.clinitCallStack.isEmpty());
        assert (this.stack.isEmpty());
        assert (this.stackEntryInfo.isEmpty());
        assert (this.writersToBeRemoved.isEmpty());
        assert (this.writerStack.isEmpty());
        this.marked.clear();
        this.revisit = new LinkedHashSet();
    }

    private void reset() {
        assert (this.clinitCallStack.isEmpty());
        assert (this.marked.isEmpty());
        assert (this.revisit.isEmpty());
        assert (this.stack.isEmpty());
        assert (this.stackEntryInfo.isEmpty());
        assert (this.writerStack.isEmpty());
        this.removedCallEdges = new IdentityHashMap<DexEncodedMethod, ProgramMethodSet>();
    }

    private void traverse(Collection<Node> roots) {
        ArrayDeque<WorkItem> workItems = new ArrayDeque<WorkItem>(roots.size());
        for (Node node : roots) {
            workItems.addLast(new NodeWorkItem(node));
        }
        while (!workItems.isEmpty()) {
            Collection writersToBeRemovedFromReader;
            WorkItem workItem = (WorkItem)workItems.removeFirst();
            if (workItem.isNode()) {
                Node node;
                node = workItem.asNode().node;
                if (this.marked.contains(node)) continue;
                Node predecessor = this.stack.isEmpty() ? null : this.stack.peek();
                this.push(node, predecessor);
                Iterator<Node> calleesAndWriterIterator = Iterators.concat(node.getCalleesWithDeterministicOrder().iterator(), node.getWritersWithDeterministicOrder().iterator());
                workItems.addFirst(new IteratorWorkItem(node, calleesAndWriterIterator));
                continue;
            }
            assert (workItem.isIterator());
            IteratorWorkItem iteratorWorkItem = workItem.asIterator();
            Node newCallerOrReader = this.iterateCalleesAndWriters(iteratorWorkItem.calleesAndWriters, iteratorWorkItem.callerOrReader);
            if (newCallerOrReader != null) {
                workItems.addFirst(iteratorWorkItem);
                workItems.addFirst(new NodeWorkItem(newCallerOrReader));
                continue;
            }
            assert (!iteratorWorkItem.calleesAndWriters.hasNext());
            this.pop(iteratorWorkItem.callerOrReader);
            this.marked.add(iteratorWorkItem.callerOrReader);
            Collection calleesToBeRemovedFromCaller = this.calleesToBeRemoved.remove(iteratorWorkItem.callerOrReader);
            if (calleesToBeRemovedFromCaller != null) {
                calleesToBeRemovedFromCaller.forEach(callee -> {
                    callee.removeCaller(iteratorWorkItem.callerOrReader);
                    this.recordCallEdgeRemoval(iteratorWorkItem.callerOrReader, (Node)callee);
                });
            }
            if ((writersToBeRemovedFromReader = (Collection)this.writersToBeRemoved.remove(iteratorWorkItem.callerOrReader)) == null) continue;
            writersToBeRemovedFromReader.forEach(writer -> writer.removeReader(iteratorWorkItem.callerOrReader));
        }
    }

    private Node iterateCalleesAndWriters(Iterator<Node> calleeOrWriterIterator, Node callerOrReader) {
        while (calleeOrWriterIterator.hasNext()) {
            boolean foundCycle;
            Node calleeOrWriter = calleeOrWriterIterator.next();
            StackEntryInfo calleeOrWriterStackEntryInfo = this.stackEntryInfo.get(calleeOrWriter);
            boolean bl = foundCycle = calleeOrWriterStackEntryInfo != null;
            if (!foundCycle) {
                return calleeOrWriter;
            }
            boolean isFieldReadEdge = calleeOrWriter.hasReader(callerOrReader);
            if (isFieldReadEdge) {
                this.removeFieldReadEdge(callerOrReader, calleeOrWriter);
                continue;
            }
            if (!this.writerStack.isEmpty() && this.removeIncomingEdgeOnStack(this.writerStack.peek(), calleeOrWriter, calleeOrWriterStackEntryInfo, this::removeFieldReadEdge)) continue;
            if (calleeOrWriter.getMethod().isClassInitializer()) {
                assert (CycleEliminator.callEdgeRemovalIsSafe(callerOrReader, calleeOrWriter));
                this.removeCallEdge(callerOrReader, calleeOrWriter);
                continue;
            }
            if (!this.clinitCallStack.isEmpty() && this.removeIncomingEdgeOnStack(this.clinitCallStack.peek(), calleeOrWriter, calleeOrWriterStackEntryInfo, this::removeCallEdge)) continue;
            if (CycleEliminator.callEdgeRemovalIsSafe(callerOrReader, calleeOrWriter)) {
                this.removeCallEdge(callerOrReader, calleeOrWriter);
                continue;
            }
            LinkedList<Node> cycle = this.extractCycle(calleeOrWriter);
            CallEdge edge = this.findCallEdgeForRemoval(cycle);
            if (edge != null) {
                assert (CycleEliminator.callEdgeRemovalIsSafe(edge.caller, edge.callee));
                this.removeCallEdge(edge.caller, edge.callee);
                this.revisit.add(edge.callee);
            }
            this.recoverStack(cycle);
        }
        return null;
    }

    private void push(Node node, Node predecessor) {
        this.stack.push(node);
        assert (!this.stackEntryInfo.containsKey(node));
        this.stackEntryInfo.put(node, new StackEntryInfo(this.stack.size() - 1, predecessor));
        if (predecessor != null) {
            if (node.getMethod().isClassInitializer() && node.hasCaller(predecessor)) {
                this.clinitCallStack.push(node);
            } else if (predecessor.getWritersWithDeterministicOrder().contains(node)) {
                this.writerStack.push(node);
            }
        }
    }

    private void pop(Node node) {
        Node popped = this.stack.pop();
        assert (popped == node);
        assert (this.stackEntryInfo.containsKey(node));
        this.stackEntryInfo.remove(node);
        if (this.clinitCallStack.peek() == popped) {
            assert (this.writerStack.peek() != popped);
            this.clinitCallStack.pop();
        } else if (this.writerStack.peek() == popped) {
            this.writerStack.pop();
        }
    }

    private void removeCallEdge(Node caller, Node callee) {
        this.calleesToBeRemoved.computeIfAbsent(caller, ignore -> Sets.newIdentityHashSet()).add(callee);
    }

    private void removeFieldReadEdge(Node reader, Node writer) {
        this.writersToBeRemoved.computeIfAbsent(reader, ignore -> Sets.newIdentityHashSet()).add(writer);
    }

    private boolean removeIncomingEdgeOnStack(Node target, Node currentCalleeOrWriter, StackEntryInfo currentCalleeOrWriterStackEntryInfo, BiConsumer<Node, Node> edgeRemover) {
        boolean cycleContainsTarget;
        StackEntryInfo targetStackEntryInfo = this.stackEntryInfo.get(target);
        boolean bl = cycleContainsTarget = targetStackEntryInfo.index > currentCalleeOrWriterStackEntryInfo.index;
        if (cycleContainsTarget) {
            assert (this.verifyCycleSatisfies(currentCalleeOrWriter, cycle -> cycle.contains(target) && cycle.contains(targetStackEntryInfo.predecessor)));
            if (!targetStackEntryInfo.processed) {
                edgeRemover.accept(targetStackEntryInfo.predecessor, target);
                this.revisit.add(target);
                targetStackEntryInfo.processed = true;
            }
            return true;
        }
        return false;
    }

    private LinkedList<Node> extractCycle(Node entry) {
        LinkedList<Node> cycle = new LinkedList<Node>();
        do {
            assert (!this.stack.isEmpty());
            cycle.add(this.stack.pop());
        } while (cycle.getLast() != entry);
        return cycle;
    }

    private boolean verifyCycleSatisfies(Node entry, Predicate<LinkedList<Node>> predicate) {
        LinkedList<Node> cycle = this.extractCycle(entry);
        assert (predicate.test(cycle));
        this.recoverStack(cycle);
        return true;
    }

    private CallEdge findCallEdgeForRemoval(LinkedList<Node> extractedCycle) {
        Node callee = extractedCycle.getLast();
        for (Node caller : extractedCycle) {
            if (caller.hasWriter(callee)) {
                assert (!caller.hasCallee(callee));
                assert (!callee.hasCaller(caller));
                callee = caller;
                continue;
            }
            if (!caller.hasCallee(callee)) {
                assert (!callee.hasCaller(caller));
                return null;
            }
            if (CycleEliminator.callEdgeRemovalIsSafe(caller, callee)) {
                return new CallEdge(caller, callee);
            }
            callee = caller;
        }
        throw new CompilationError(CYCLIC_FORCE_INLINING_MESSAGE);
    }

    private static boolean callEdgeRemovalIsSafe(Node callerOrReader, Node calleeOrWriter) {
        assert (calleeOrWriter.hasCaller(callerOrReader));
        return !calleeOrWriter.getMethod().getOptimizationInfo().forceInline();
    }

    private void recordCallEdgeRemoval(Node caller, Node callee) {
        this.removedCallEdges.computeIfAbsent(callee.getMethod(), ignore -> ProgramMethodSet.create(2)).add(caller.getProgramMethod());
    }

    private void recoverStack(LinkedList<Node> extractedCycle) {
        Iterator<Node> descendingIt = extractedCycle.descendingIterator();
        while (descendingIt.hasNext()) {
            this.stack.push(descendingIt.next());
        }
    }

    public CycleEliminationResult breakCycles(Collection<Node> roots) {
        do {
            this.traverse(roots);
            roots = this.revisit;
            this.prepareForNewTraversal();
        } while (!roots.isEmpty());
        CycleEliminationResult result = new CycleEliminationResult(this.removedCallEdges);
        if (Log.ENABLED) {
            Log.info(this.getClass(), "# call graph cycles broken: %s", result.numberOfRemovedCallEdges());
        }
        this.reset();
        return result;
    }

    private static class IteratorWorkItem
    extends WorkItem {
        private final Node callerOrReader;
        private final Iterator<Node> calleesAndWriters;

        IteratorWorkItem(Node callerOrReader, Iterator<Node> calleesAndWriters) {
            this.callerOrReader = callerOrReader;
            this.calleesAndWriters = calleesAndWriters;
        }

        @Override
        boolean isIterator() {
            return true;
        }

        @Override
        IteratorWorkItem asIterator() {
            return this;
        }
    }

    private static class NodeWorkItem
    extends WorkItem {
        private final Node node;

        NodeWorkItem(Node node) {
            this.node = node;
        }

        @Override
        boolean isNode() {
            return true;
        }

        @Override
        NodeWorkItem asNode() {
            return this;
        }
    }

    private static class WorkItem {
        private WorkItem() {
        }

        boolean isNode() {
            return false;
        }

        NodeWorkItem asNode() {
            return null;
        }

        boolean isIterator() {
            return false;
        }

        IteratorWorkItem asIterator() {
            return null;
        }
    }

    public static class CycleEliminationResult {
        private Map<DexEncodedMethod, ProgramMethodSet> removedCallEdges;

        CycleEliminationResult(Map<DexEncodedMethod, ProgramMethodSet> removedCallEdges) {
            this.removedCallEdges = removedCallEdges;
        }

        public int numberOfRemovedCallEdges() {
            int numberOfRemovedCallEdges = 0;
            for (ProgramMethodSet nodes : this.removedCallEdges.values()) {
                numberOfRemovedCallEdges += nodes.size();
            }
            return numberOfRemovedCallEdges;
        }
    }

    static class StackEntryInfo {
        final int index;
        final Node predecessor;
        boolean processed;

        StackEntryInfo(int index, Node predecessor) {
            this.index = index;
            this.predecessor = predecessor;
        }
    }

    private static class CallEdge {
        private final Node caller;
        private final Node callee;

        CallEdge(Node caller, Node callee) {
            this.caller = caller;
            this.callee = callee;
        }
    }
}

