/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.r8.ir.conversion.callgraph;

import com.android.tools.r8.com.google.common.collect.Sets;
import com.android.tools.r8.graph.AppView;
import com.android.tools.r8.graph.ProgramMethod;
import com.android.tools.r8.ir.conversion.callgraph.CallGraph;
import com.android.tools.r8.ir.conversion.callgraph.CallGraphBuilderBase;
import com.android.tools.r8.ir.conversion.callgraph.CycleEliminator;
import com.android.tools.r8.ir.conversion.callgraph.Node;
import com.android.tools.r8.shaking.AppInfoWithLiveness;
import com.android.tools.r8.utils.Timing;
import java.util.TreeSet;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;

abstract class IRProcessingCallGraphBuilderBase
extends CallGraphBuilderBase<Node> {
    IRProcessingCallGraphBuilderBase(AppView<AppInfoWithLiveness> appView) {
        super(appView);
    }

    private boolean verifyNoRedundantFieldReadEdges() {
        for (Node writer : this.nodes.values()) {
            for (Node reader : writer.getReadersWithDeterministicOrder()) {
                assert (!writer.hasCaller(reader));
            }
        }
        return true;
    }

    public CallGraph build(ExecutorService executorService, Timing timing) throws ExecutionException {
        timing.begin("Build IR processing order constraints");
        timing.begin("Build call graph");
        this.populateGraph(executorService);
        assert (this.verifyNoRedundantFieldReadEdges());
        timing.end();
        assert (this.verifyAllMethodsWithCodeExists());
        this.appView.withGeneratedMessageLiteBuilderShrinker(shrinker -> shrinker.preprocessCallGraphBeforeCycleElimination(this.nodes));
        timing.begin("Cycle elimination");
        TreeSet<Node> nodesWithDeterministicOrder = Sets.newTreeSet(this.nodes.values());
        CycleEliminator cycleEliminator = new CycleEliminator();
        CycleEliminator.CycleEliminationResult cycleEliminationResult = cycleEliminator.breakCycles(nodesWithDeterministicOrder);
        timing.end();
        timing.end();
        assert (cycleEliminator.breakCycles(nodesWithDeterministicOrder).numberOfRemovedCallEdges() == 0);
        return new CallGraph(this.nodes, cycleEliminationResult);
    }

    @Override
    protected Node createNode(ProgramMethod method) {
        return new Node(method);
    }

    abstract void populateGraph(ExecutorService var1) throws ExecutionException;

    abstract boolean verifyAllMethodsWithCodeExists();
}

