/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.r8.ir.conversion.callgraph;

import com.android.tools.r8.graph.AppView;
import com.android.tools.r8.graph.DexCallSite;
import com.android.tools.r8.graph.DexClass;
import com.android.tools.r8.graph.DexClassAndMethod;
import com.android.tools.r8.graph.DexEncodedMethod;
import com.android.tools.r8.graph.DexField;
import com.android.tools.r8.graph.DexMethod;
import com.android.tools.r8.graph.DexType;
import com.android.tools.r8.graph.GraphLens;
import com.android.tools.r8.graph.LookupResult;
import com.android.tools.r8.graph.MethodResolutionResult;
import com.android.tools.r8.graph.ProgramMethod;
import com.android.tools.r8.graph.UseRegistry;
import com.android.tools.r8.ir.code.Invoke;
import com.android.tools.r8.ir.conversion.callgraph.NodeBase;
import com.android.tools.r8.shaking.AppInfoWithLiveness;
import com.android.tools.r8.utils.collections.ProgramMethodSet;
import java.util.Map;
import java.util.function.Function;
import java.util.function.Predicate;

public class InvokeExtractor<N extends NodeBase<N>>
extends UseRegistry<ProgramMethod> {
    protected final AppView<AppInfoWithLiveness> appView;
    protected final N currentMethod;
    protected final Function<ProgramMethod, N> nodeFactory;
    protected final Map<DexMethod, ProgramMethodSet> possibleProgramTargetsCache;
    protected final Predicate<ProgramMethod> targetTester;

    public InvokeExtractor(AppView<AppInfoWithLiveness> appView, N currentMethod, Function<ProgramMethod, N> nodeFactory, Map<DexMethod, ProgramMethodSet> possibleProgramTargetsCache, Predicate<ProgramMethod> targetTester) {
        super(appView, ((NodeBase)currentMethod).getProgramMethod());
        this.appView = appView;
        this.currentMethod = currentMethod;
        this.nodeFactory = nodeFactory;
        this.possibleProgramTargetsCache = possibleProgramTargetsCache;
        this.targetTester = targetTester;
    }

    private void processInvoke(Invoke.Type originalType, DexMethod originalMethod) {
        ProgramMethod context = ((NodeBase)this.currentMethod).getProgramMethod();
        GraphLens.MethodLookupResult result = this.appView.graphLens().lookupMethod(originalMethod, (DexMethod)context.getReference(), originalType, this.getCodeLens());
        DexMethod method = (DexMethod)result.getReference();
        Invoke.Type type = result.getType();
        if (type == Invoke.Type.INTERFACE || type == Invoke.Type.VIRTUAL) {
            MethodResolutionResult resolutionResult = this.appView.appInfo().resolveMethod(method, type == Invoke.Type.INTERFACE);
            DexClassAndMethod target = resolutionResult.getResolutionPair();
            if (target != null) {
                this.processInvokeWithDynamicDispatch(type, target, context);
            }
        } else {
            ProgramMethod singleTarget = this.appView.appInfo().lookupSingleProgramTarget(this.appView, type, method, context, this.appView);
            if (singleTarget != null) {
                this.processSingleTarget(singleTarget, context);
            }
        }
    }

    protected void addCallEdge(ProgramMethod callee, boolean likelySpuriousCallEdge) {
        if (!this.targetTester.test(callee)) {
            return;
        }
        if (((DexEncodedMethod)callee.getDefinition()).isAbstract()) {
            return;
        }
        if (((DexEncodedMethod)callee.getDefinition()).isNative()) {
            return;
        }
        if (!this.appView.getKeepInfo(callee).isOptimizationAllowed(this.appView.options())) {
            return;
        }
        ((NodeBase)this.nodeFactory.apply(callee)).addCallerConcurrently(this.currentMethod, likelySpuriousCallEdge);
    }

    protected void processSingleTarget(ProgramMethod singleTarget, ProgramMethod context) {
        assert (!((DexEncodedMethod)context.getDefinition()).isBridge() || singleTarget.getDefinition() != context.getDefinition());
        this.addCallEdge(singleTarget, false);
    }

    protected void processInvokeWithDynamicDispatch(Invoke.Type type, DexClassAndMethod encodedTarget, ProgramMethod context) {
        DexMethod target = (DexMethod)encodedTarget.getReference();
        DexClass clazz = encodedTarget.getHolder();
        if (!this.appView.options().testing.addCallEdgesForLibraryInvokes && clazz.isLibraryClass()) {
            return;
        }
        boolean isInterface = type == Invoke.Type.INTERFACE;
        ProgramMethodSet possibleProgramTargets = this.possibleProgramTargetsCache.computeIfAbsent(target, method -> {
            LookupResult lookupResult;
            MethodResolutionResult resolution = this.appView.appInfo().resolveMethod((DexMethod)method, isInterface);
            if (resolution.isVirtualTarget() && (lookupResult = resolution.lookupVirtualDispatchTargets(context.getHolder(), this.appView.appInfo())).isLookupResultSuccess()) {
                ProgramMethodSet targets = ProgramMethodSet.create();
                lookupResult.asLookupResultSuccess().forEach(methodTarget -> {
                    if (methodTarget.isProgramMethod()) {
                        targets.add(methodTarget.asProgramMethod());
                    }
                }, lambdaTarget -> {
                    DexClassAndMethod implementationMethod = lambdaTarget.getImplementationMethod();
                    if (implementationMethod.isProgramMethod()) {
                        targets.add(implementationMethod.asProgramMethod());
                    }
                });
                return targets;
            }
            return null;
        });
        if (possibleProgramTargets != null) {
            boolean likelySpuriousCallEdge = possibleProgramTargets.size() >= this.appView.options().callGraphLikelySpuriousCallEdgeThreshold;
            for (ProgramMethod possibleTarget : possibleProgramTargets) {
                this.addCallEdge(possibleTarget, likelySpuriousCallEdge);
            }
        }
    }

    @Override
    public void registerCallSite(DexCallSite callSite) {
        this.registerMethodHandle(callSite.bootstrapMethod, UseRegistry.MethodHandleUse.NOT_ARGUMENT_TO_LAMBDA_METAFACTORY);
    }

    @Override
    public void registerInvokeDirect(DexMethod method) {
        this.processInvoke(Invoke.Type.DIRECT, method);
    }

    @Override
    public void registerInvokeInterface(DexMethod method) {
        this.processInvoke(Invoke.Type.INTERFACE, method);
    }

    @Override
    public void registerInvokeStatic(DexMethod method) {
        this.processInvoke(Invoke.Type.STATIC, method);
    }

    @Override
    public void registerInvokeSuper(DexMethod method) {
        this.processInvoke(Invoke.Type.SUPER, method);
    }

    @Override
    public void registerInvokeVirtual(DexMethod method) {
        this.processInvoke(Invoke.Type.VIRTUAL, method);
    }

    @Override
    public void registerInitClass(DexType type) {
    }

    @Override
    public void registerInstanceFieldRead(DexField field) {
    }

    @Override
    public void registerInstanceFieldWrite(DexField field) {
    }

    @Override
    public void registerStaticFieldRead(DexField field) {
    }

    @Override
    public void registerStaticFieldWrite(DexField field) {
    }

    @Override
    public void registerTypeReference(DexType type) {
    }
}

