/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.r8.ir.desugar;

import com.android.tools.r8.androidapi.ComputedApiLevel;
import com.android.tools.r8.cf.code.CfInstruction;
import com.android.tools.r8.cf.code.CfInvoke;
import com.android.tools.r8.com.google.common.collect.ImmutableList;
import com.android.tools.r8.com.google.common.collect.ImmutableMap;
import com.android.tools.r8.contexts.CompilationContext;
import com.android.tools.r8.dex.ApplicationReader;
import com.android.tools.r8.errors.Unreachable;
import com.android.tools.r8.graph.AppInfo;
import com.android.tools.r8.graph.AppView;
import com.android.tools.r8.graph.CfCode;
import com.android.tools.r8.graph.Code;
import com.android.tools.r8.graph.DexItemFactory;
import com.android.tools.r8.graph.DexMethod;
import com.android.tools.r8.graph.DexProto;
import com.android.tools.r8.graph.DexReference;
import com.android.tools.r8.graph.DexString;
import com.android.tools.r8.graph.DexType;
import com.android.tools.r8.graph.LazyLoadedDexApplication;
import com.android.tools.r8.graph.MethodAccessFlags;
import com.android.tools.r8.graph.ProgramMethod;
import com.android.tools.r8.ir.desugar.CfInstructionDesugaring;
import com.android.tools.r8.ir.desugar.CfInstructionDesugaringCollection;
import com.android.tools.r8.ir.desugar.CfInstructionDesugaringEventConsumer;
import com.android.tools.r8.ir.desugar.FreshLocalProvider;
import com.android.tools.r8.ir.desugar.LocalStackAllocator;
import com.android.tools.r8.ir.desugar.TypeRewriter;
import com.android.tools.r8.ir.desugar.backports.BackportedMethodDesugaringEventConsumer;
import com.android.tools.r8.ir.desugar.backports.BackportedMethods;
import com.android.tools.r8.ir.desugar.backports.BooleanMethodRewrites;
import com.android.tools.r8.ir.desugar.backports.CollectionMethodGenerators;
import com.android.tools.r8.ir.desugar.backports.CollectionMethodRewrites;
import com.android.tools.r8.ir.desugar.backports.FloatMethodRewrites;
import com.android.tools.r8.ir.desugar.backports.LongMethodRewrites;
import com.android.tools.r8.ir.desugar.backports.NumericMethodRewrites;
import com.android.tools.r8.ir.desugar.backports.ObjectsMethodRewrites;
import com.android.tools.r8.ir.desugar.backports.OptionalMethodRewrites;
import com.android.tools.r8.ir.desugar.backports.SparseArrayMethodRewrites;
import com.android.tools.r8.ir.desugar.desugaredlibrary.retargeter.DesugaredLibraryRetargeter;
import com.android.tools.r8.synthesis.SyntheticNaming;
import com.android.tools.r8.utils.AndroidApiLevel;
import com.android.tools.r8.utils.AndroidApp;
import com.android.tools.r8.utils.InternalOptions;
import com.android.tools.r8.utils.Timing;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.function.Consumer;

public final class BackportedMethodRewriter
implements CfInstructionDesugaring {
    private final AppView<?> appView;
    private final RewritableMethods rewritableMethods;

    public BackportedMethodRewriter(AppView<?> appView) {
        assert (appView.options().desugarState.isOn());
        this.appView = appView;
        this.rewritableMethods = new RewritableMethods(appView.options(), appView);
    }

    public static List<DexMethod> generateListOfBackportedMethods(AndroidApp androidApp, InternalOptions options, ExecutorService executor) throws IOException {
        ArrayList<DexMethod> methods = new ArrayList<DexMethod>();
        AppInfo appInfo = null;
        if (androidApp != null) {
            LazyLoadedDexApplication app = new ApplicationReader(androidApp, options, Timing.empty()).read(executor);
            options.loadMachineDesugaredLibrarySpecification(Timing.empty(), app);
            appInfo = AppInfo.createInitialAppInfo(app);
        }
        TypeRewriter typeRewriter = options.getTypeRewriter();
        AppView<Object> appView = AppView.createForD8(appInfo, typeRewriter, Timing.empty());
        RewritableMethods rewritableMethods = new RewritableMethods(options, appView);
        rewritableMethods.visit(methods::add);
        if (appInfo != null) {
            DesugaredLibraryRetargeter desugaredLibraryRetargeter = new DesugaredLibraryRetargeter(appView);
            desugaredLibraryRetargeter.visit(methods::add);
        }
        return methods;
    }

    public static void registerAssumedLibraryTypes(InternalOptions options) {
        BackportedMethods.registerSynthesizedCodeReferences(options.itemFactory);
    }

    private MethodProvider getMethodProviderOrNull(DexMethod method) {
        DexMethod original = this.appView.graphLens().getOriginalMethodSignature(method);
        assert (original != null);
        MethodProvider provider = this.rewritableMethods.getProvider(original);
        Map<DexType, DexType> legacyBackport = this.appView.options().machineDesugaredLibrarySpecification.getLegacyBackport();
        if (provider == null && this.appView.options().isDesugaredLibraryCompilation() && legacyBackport.containsKey(method.holder)) {
            DexType newHolder = legacyBackport.get(method.holder);
            DexMethod backportedMethod = this.appView.dexItemFactory().createMethod(newHolder, method.proto, method.name);
            provider = this.rewritableMethods.getProvider(backportedMethod);
        }
        return provider;
    }

    public boolean hasBackports() {
        return !this.rewritableMethods.isEmpty();
    }

    @Override
    public Collection<CfInstruction> desugarInstruction(CfInstruction instruction, FreshLocalProvider freshLocalProvider, LocalStackAllocator localStackAllocator, CfInstructionDesugaringEventConsumer eventConsumer, ProgramMethod context, CompilationContext.MethodProcessingContext methodProcessingContext, CfInstructionDesugaringCollection desugaringCollection, DexItemFactory dexItemFactory) {
        if (!instruction.isInvoke()) {
            return null;
        }
        CfInvoke invoke = instruction.asInvoke();
        MethodProvider methodProvider = this.getMethodProviderOrNull(invoke.getMethod());
        return methodProvider != null ? methodProvider.rewriteInvoke(invoke, this.appView, eventConsumer, methodProcessingContext, localStackAllocator) : null;
    }

    @Override
    public boolean needsDesugaring(CfInstruction instruction, ProgramMethod context) {
        return instruction.isInvoke() && this.getMethodProviderOrNull(instruction.asInvoke().getMethod()) != null && !this.appView.getSyntheticItems().isSyntheticOfKind(context.getContextType(), kinds -> kinds.BACKPORT_WITH_FORWARDING);
    }

    public static abstract class FullMethodInvokeRewriter
    implements MethodInvokeRewriter {
        @Override
        public final CfInstruction rewriteSingle(CfInvoke invoke, DexItemFactory factory) {
            throw new Unreachable();
        }

        @Override
        public abstract Collection<CfInstruction> rewrite(CfInvoke var1, DexItemFactory var2, LocalStackAllocator var3);
    }

    public static interface MethodInvokeRewriter {
        public CfInstruction rewriteSingle(CfInvoke var1, DexItemFactory var2);

        default public Collection<CfInstruction> rewrite(CfInvoke invoke, DexItemFactory factory, LocalStackAllocator localStackAllocator) {
            return ImmutableList.of(this.rewriteSingle(invoke, factory));
        }
    }

    private static interface TemplateMethodFactory {
        public CfCode create(InternalOptions var1, DexMethod var2);
    }

    private static class StatifyingMethodWithForwardingGenerator
    extends StatifyingMethodGenerator {
        StatifyingMethodWithForwardingGenerator(DexMethod method, TemplateMethodFactory factory, String methodName, DexType receiverType) {
            super(method, factory, methodName, receiverType);
        }

        @Override
        protected SyntheticNaming.SyntheticKind getSyntheticKind(SyntheticNaming naming) {
            return naming.BACKPORT_WITH_FORWARDING;
        }
    }

    private static class StatifyingMethodGenerator
    extends MethodGenerator {
        private final DexType receiverType;

        StatifyingMethodGenerator(DexMethod method, TemplateMethodFactory factory, String methodName, DexType receiverType) {
            super(method, factory, methodName);
            this.receiverType = receiverType;
        }

        @Override
        public DexProto getProto(DexItemFactory itemFactory) {
            return itemFactory.prependTypeToProto(this.receiverType, super.getProto(itemFactory));
        }
    }

    private static class MethodGenerator
    extends MethodProvider {
        private final TemplateMethodFactory factory;
        private final String methodName;

        MethodGenerator(DexMethod method, TemplateMethodFactory factory) {
            this(method, factory, method.name.toString());
        }

        MethodGenerator(DexMethod method, TemplateMethodFactory factory, String methodName) {
            super(method);
            this.factory = factory;
            this.methodName = methodName;
        }

        private ProgramMethod getSyntheticMethod(AppView<?> appView, CompilationContext.MethodProcessingContext methodProcessingContext) {
            return appView.getSyntheticItems().createMethod(this::getSyntheticKind, methodProcessingContext.createUniqueContext(), appView, builder -> builder.disableAndroidApiLevelCheck().setProto(this.getProto(appView.dexItemFactory())).setAccessFlags(MethodAccessFlags.createPublicStaticSynthetic()).setCode(methodSig -> this.generateTemplateMethod(appView.options(), methodSig)));
        }

        protected SyntheticNaming.SyntheticKind getSyntheticKind(SyntheticNaming naming) {
            return naming.BACKPORT;
        }

        @Override
        public Collection<CfInstruction> rewriteInvoke(CfInvoke invoke, AppView<?> appView, BackportedMethodDesugaringEventConsumer eventConsumer, CompilationContext.MethodProcessingContext methodProcessingContext, LocalStackAllocator localStackAllocator) {
            ProgramMethod method = this.getSyntheticMethod(appView, methodProcessingContext);
            eventConsumer.acceptBackportedMethod(method, methodProcessingContext.getMethodContext());
            return ImmutableList.of(new CfInvoke(184, (DexMethod)method.getReference(), false));
        }

        public DexProto getProto(DexItemFactory itemFactory) {
            return this.method.proto;
        }

        public Code generateTemplateMethod(InternalOptions options, DexMethod method) {
            return this.factory.create(options, method);
        }
    }

    private static final class InvokeRewriter
    extends MethodProvider {
        private final MethodInvokeRewriter rewriter;

        InvokeRewriter(DexMethod method, MethodInvokeRewriter rewriter) {
            super(method);
            this.rewriter = rewriter;
        }

        @Override
        public Collection<CfInstruction> rewriteInvoke(CfInvoke invoke, AppView<?> appView, BackportedMethodDesugaringEventConsumer eventConsumer, CompilationContext.MethodProcessingContext methodProcessingContext, LocalStackAllocator localStackAllocator) {
            return this.rewriter.rewrite(invoke, appView.dexItemFactory(), localStackAllocator);
        }
    }

    public static abstract class MethodProvider {
        final DexMethod method;

        public MethodProvider(DexMethod method) {
            this.method = method;
        }

        public abstract Collection<CfInstruction> rewriteInvoke(CfInvoke var1, AppView<?> var2, BackportedMethodDesugaringEventConsumer var3, CompilationContext.MethodProcessingContext var4, LocalStackAllocator var5);
    }

    private static final class RewritableMethods {
        private final Map<DexType, AndroidApiLevel> typeMinApi;
        private final AppView<?> appView;
        private final Map<DexMethod, MethodProvider> rewritable = new IdentityHashMap<DexMethod, MethodProvider>();

        RewritableMethods(InternalOptions options, AppView<?> appView) {
            this.appView = appView;
            this.typeMinApi = this.initializeTypeMinApi(appView.dexItemFactory());
            if (!options.shouldBackportMethods()) {
                return;
            }
            DexItemFactory factory = options.itemFactory;
            if (options.getMinApiLevel().isLessThan(AndroidApiLevel.K)) {
                this.initializeAndroidKMethodProviders(factory);
                if (this.typeIsAbsentOrPresentWithoutBackportsFrom(factory.objectsType, AndroidApiLevel.K)) {
                    this.initializeAndroidKObjectsMethodProviders(factory);
                }
            }
            if (options.getMinApiLevel().isLessThan(AndroidApiLevel.N)) {
                this.initializeAndroidNMethodProviders(factory);
                if (this.typeIsAbsentOrPresentWithoutBackportsFrom(factory.objectsType, AndroidApiLevel.N)) {
                    this.initializeAndroidNObjectsMethodProviders(factory);
                    if (this.typeIsPresent(factory.supplierType)) {
                        this.initializeAndroidNObjectsMethodProviderWithSupplier(factory);
                    }
                }
            }
            if (options.getMinApiLevel().isLessThan(AndroidApiLevel.O)) {
                this.initializeAndroidOMethodProviders(factory);
            }
            if (options.getMinApiLevel().isLessThan(AndroidApiLevel.R)) {
                if (this.typeIsPresentWithoutBackportsFrom(factory.setType, AndroidApiLevel.R)) {
                    this.initializeAndroidRSetListMapMethodProviders(factory);
                }
                if (this.typeIsAbsentOrPresentWithoutBackportsFrom(factory.objectsType, AndroidApiLevel.R)) {
                    this.initializeAndroidRObjectsMethodProviders(factory);
                    if (this.typeIsPresent(factory.supplierType)) {
                        this.initializeAndroidRObjectsMethodProviderWithSupplier(factory);
                    }
                }
            }
            if (options.getMinApiLevel().isLessThan(AndroidApiLevel.S)) {
                this.initializeAndroidSMethodProviders(factory);
                if (this.typeIsPresentWithoutBackportsFrom(factory.setType, AndroidApiLevel.S)) {
                    this.initializeAndroidSSetListMapMethodProviders(factory);
                }
            }
            if (options.getMinApiLevel().isLessThan(AndroidApiLevel.Sv2)) {
                this.initializeAndroidSv2MethodProviders(factory);
            }
            if (options.getMinApiLevel().isLessThan(AndroidApiLevel.T)) {
                this.initializeAndroidTMethodProviders(factory);
                if (this.typeIsPresentWithoutBackportsFrom(factory.optionalType, AndroidApiLevel.T)) {
                    this.initializeAndroidOptionalTMethodProviders(factory);
                }
            }
            if (this.typeIsPresentWithoutNeverIntroducedBackports(factory.streamType)) {
                this.initializeStreamMethodProviders(factory);
            }
            if (this.typeIsPresentWithoutNeverIntroducedBackports(factory.predicateType)) {
                this.initializePredicateMethodProviders(factory);
            }
            this.initializeJava9MethodProviders(factory);
            this.initializeJava10MethodProviders(factory);
            this.initializeJava11MethodProviders(factory);
        }

        private Map<DexType, AndroidApiLevel> initializeTypeMinApi(DexItemFactory factory) {
            ImmutableMap.Builder<DexType, AndroidApiLevel> builder = ImmutableMap.builder();
            builder.put(factory.objectsType, AndroidApiLevel.K);
            builder.put(factory.optionalType, AndroidApiLevel.N);
            builder.put(factory.predicateType, AndroidApiLevel.N);
            builder.put(factory.setType, AndroidApiLevel.B);
            builder.put(factory.streamType, AndroidApiLevel.N);
            builder.put(factory.supplierType, AndroidApiLevel.N);
            ImmutableMap<DexType, AndroidApiLevel> typeMinApi = builder.build();
            assert (this.minApiMatchDatabaseMinApi(typeMinApi));
            return typeMinApi;
        }

        private boolean minApiMatchDatabaseMinApi(ImmutableMap<DexType, AndroidApiLevel> typeMinApi) {
            typeMinApi.forEach((type, api) -> {
                ComputedApiLevel apiLevel = this.appView.apiLevelCompute().computeApiLevelForLibraryReference((DexReference)type, ComputedApiLevel.unknown());
                if (!apiLevel.isKnownApiLevel()) {
                    return;
                }
                AndroidApiLevel theApi = apiLevel.asKnownApiLevel().getApiLevel();
                if (this.appView.typeRewriter.hasRewrittenType((DexType)type, this.appView)) {
                    assert (theApi.equals(this.appView.options().getMinApiLevel()));
                    return;
                }
                assert (theApi.equals(api.max(this.appView.options().getMinApiLevel())));
            });
            return true;
        }

        private boolean typeIsAbsentOrPresentWithoutBackportsFrom(DexType type, AndroidApiLevel apiLevel) {
            return !this.typeIsPresent(type) || this.typeIsPresentWithoutBackportsFrom(type, apiLevel);
        }

        private boolean typeIsPresentWithoutNeverIntroducedBackports(DexType type) {
            return this.typeIsPresentWithoutBackportsFrom(type, AndroidApiLevel.ANDROID_PLATFORM);
        }

        private boolean typeIsPresentWithoutBackportsFrom(DexType type, AndroidApiLevel methodsMinAPI) {
            if (this.appView.typeRewriter.hasRewrittenType(type, this.appView)) {
                return methodsMinAPI.isGreaterThan(AndroidApiLevel.N) && !this.appView.options().machineDesugaredLibrarySpecification.includesJDK11Methods();
            }
            if (!this.appView.options().getMinApiLevel().isGreaterThanOrEqualTo(this.typeMinApi.get(type))) {
                return false;
            }
            return this.appView.options().getMinApiLevel().isLessThan(methodsMinAPI);
        }

        private boolean typeIsPresent(DexType type) {
            return this.appView.options().getMinApiLevel().isGreaterThanOrEqualTo(this.typeMinApi.get(type)) || this.appView.typeRewriter.hasRewrittenType(type, this.appView);
        }

        private void initializeAndroidKObjectsMethodProviders(DexItemFactory factory) {
            DexType type = factory.objectsType;
            DexString name = factory.createString("compare");
            DexProto proto = factory.createProto(factory.intType, factory.objectType, factory.objectType, factory.comparatorType);
            DexMethod method = factory.createMethod(type, proto, name);
            this.addProvider(new MethodGenerator(method, BackportedMethods::ObjectsMethods_compare));
            name = factory.createString("deepEquals");
            proto = factory.createProto(factory.booleanType, factory.objectType, factory.objectType);
            method = factory.createMethod(type, proto, name);
            this.addProvider(new MethodGenerator(method, BackportedMethods::ObjectsMethods_deepEquals));
            name = factory.createString("equals");
            proto = factory.createProto(factory.booleanType, factory.objectType, factory.objectType);
            method = factory.createMethod(type, proto, name);
            this.addProvider(new MethodGenerator(method, BackportedMethods::ObjectsMethods_equals));
            name = factory.createString("hash");
            proto = factory.createProto(factory.intType, factory.objectArrayType);
            method = factory.createMethod(type, proto, name);
            this.addProvider(new InvokeRewriter(method, ObjectsMethodRewrites.rewriteToArraysHashCode()));
            name = factory.createString("hashCode");
            proto = factory.createProto(factory.intType, factory.objectType);
            method = factory.createMethod(type, proto, name);
            this.addProvider(new MethodGenerator(method, BackportedMethods::ObjectsMethods_hashCode));
            method = factory.objectsMethods.requireNonNull;
            this.addProvider(new InvokeRewriter(method, ObjectsMethodRewrites.rewriteRequireNonNull()));
            name = factory.createString("requireNonNull");
            proto = factory.createProto(factory.objectType, factory.objectType, factory.stringType);
            method = factory.createMethod(type, proto, name);
            this.addProvider(new MethodGenerator(method, BackportedMethods::ObjectsMethods_requireNonNullMessage, "requireNonNullMessage"));
            name = factory.createString("toString");
            proto = factory.createProto(factory.stringType, factory.objectType);
            method = factory.createMethod(type, proto, name);
            this.addProvider(new MethodGenerator(method, BackportedMethods::ObjectsMethods_toString));
            name = factory.createString("toString");
            proto = factory.createProto(factory.stringType, factory.objectType, factory.stringType);
            method = factory.createMethod(type, proto, name);
            this.addProvider(new MethodGenerator(method, BackportedMethods::ObjectsMethods_toStringDefault, "toStringDefault"));
        }

        private void initializeAndroidKMethodProviders(DexItemFactory factory) {
            DexType type = factory.boxedByteType;
            DexString name = factory.createString("compare");
            DexProto proto = factory.createProto(factory.intType, factory.byteType, factory.byteType);
            DexMethod method = factory.createMethod(type, proto, name);
            this.addProvider(new MethodGenerator(method, BackportedMethods::ByteMethods_compare));
            type = factory.boxedShortType;
            name = factory.createString("compare");
            proto = factory.createProto(factory.intType, factory.shortType, factory.shortType);
            method = factory.createMethod(type, proto, name);
            this.addProvider(new MethodGenerator(method, BackportedMethods::ShortMethods_compare));
            type = factory.boxedIntType;
            name = factory.createString("compare");
            proto = factory.createProto(factory.intType, factory.intType, factory.intType);
            method = factory.createMethod(type, proto, name);
            this.addProvider(new MethodGenerator(method, BackportedMethods::IntegerMethods_compare));
            type = factory.boxedLongType;
            name = factory.createString("compare");
            proto = factory.createProto(factory.intType, factory.longType, factory.longType);
            method = factory.createMethod(type, proto, name);
            this.addProvider(new InvokeRewriter(method, LongMethodRewrites.rewriteCompare()));
            type = factory.boxedBooleanType;
            name = factory.createString("compare");
            proto = factory.createProto(factory.intType, factory.booleanType, factory.booleanType);
            method = factory.createMethod(type, proto, name);
            this.addProvider(new MethodGenerator(method, BackportedMethods::BooleanMethods_compare));
            type = factory.boxedCharType;
            name = factory.createString("compare");
            proto = factory.createProto(factory.intType, factory.charType, factory.charType);
            method = factory.createMethod(type, proto, name);
            this.addProvider(new MethodGenerator(method, BackportedMethods::CharacterMethods_compare));
            type = factory.collectionsType;
            name = factory.createString("emptyEnumeration");
            proto = factory.createProto(factory.enumerationType, new DexType[0]);
            method = factory.createMethod(type, proto, name);
            this.addProvider(new MethodGenerator(method, BackportedMethods::CollectionsMethods_emptyEnumeration));
            name = factory.createString("emptyIterator");
            proto = factory.createProto(factory.iteratorType, new DexType[0]);
            method = factory.createMethod(type, proto, name);
            this.addProvider(new MethodGenerator(method, BackportedMethods::CollectionsMethods_emptyIterator));
            name = factory.createString("emptyListIterator");
            proto = factory.createProto(factory.listIteratorType, new DexType[0]);
            method = factory.createMethod(type, proto, name);
            this.addProvider(new MethodGenerator(method, BackportedMethods::CollectionsMethods_emptyListIterator));
        }

        private void initializeAndroidNObjectsMethodProviders(DexItemFactory factory) {
            DexType type = factory.objectsType;
            DexString name = factory.createString("isNull");
            DexProto proto = factory.createProto(factory.booleanType, factory.objectType);
            DexMethod method = factory.createMethod(type, proto, name);
            this.addProvider(new MethodGenerator(method, BackportedMethods::ObjectsMethods_isNull));
            name = factory.createString("nonNull");
            proto = factory.createProto(factory.booleanType, factory.objectType);
            method = factory.createMethod(type, proto, name);
            this.addProvider(new MethodGenerator(method, BackportedMethods::ObjectsMethods_nonNull));
        }

        private void initializeAndroidNMethodProviders(DexItemFactory factory) {
            DexType[] mathTypes;
            DexType type = factory.boxedByteType;
            DexString name = factory.createString("hashCode");
            DexProto proto = factory.createProto(factory.intType, factory.byteType);
            DexMethod method = factory.createMethod(type, proto, name);
            this.addProvider(new InvokeRewriter(method, NumericMethodRewrites.rewriteAsIdentity()));
            type = factory.boxedShortType;
            name = factory.createString("hashCode");
            proto = factory.createProto(factory.intType, factory.shortType);
            method = factory.createMethod(type, proto, name);
            this.addProvider(new InvokeRewriter(method, NumericMethodRewrites.rewriteAsIdentity()));
            type = factory.boxedIntType;
            name = factory.createString("hashCode");
            proto = factory.createProto(factory.intType, factory.intType);
            method = factory.createMethod(type, proto, name);
            this.addProvider(new InvokeRewriter(method, NumericMethodRewrites.rewriteAsIdentity()));
            name = factory.createString("max");
            proto = factory.createProto(factory.intType, factory.intType, factory.intType);
            method = factory.createMethod(type, proto, name);
            this.addProvider(new InvokeRewriter(method, NumericMethodRewrites.rewriteToInvokeMath()));
            name = factory.createString("min");
            proto = factory.createProto(factory.intType, factory.intType, factory.intType);
            method = factory.createMethod(type, proto, name);
            this.addProvider(new InvokeRewriter(method, NumericMethodRewrites.rewriteToInvokeMath()));
            name = factory.createString("sum");
            proto = factory.createProto(factory.intType, factory.intType, factory.intType);
            method = factory.createMethod(type, proto, name);
            this.addProvider(new InvokeRewriter(method, NumericMethodRewrites.rewriteToAddInstruction()));
            type = factory.boxedDoubleType;
            name = factory.createString("hashCode");
            proto = factory.createProto(factory.intType, factory.doubleType);
            method = factory.createMethod(type, proto, name);
            this.addProvider(new MethodGenerator(method, BackportedMethods::DoubleMethods_hashCode));
            name = factory.createString("max");
            proto = factory.createProto(factory.doubleType, factory.doubleType, factory.doubleType);
            method = factory.createMethod(type, proto, name);
            this.addProvider(new InvokeRewriter(method, NumericMethodRewrites.rewriteToInvokeMath()));
            name = factory.createString("min");
            proto = factory.createProto(factory.doubleType, factory.doubleType, factory.doubleType);
            method = factory.createMethod(type, proto, name);
            this.addProvider(new InvokeRewriter(method, NumericMethodRewrites.rewriteToInvokeMath()));
            name = factory.createString("sum");
            proto = factory.createProto(factory.doubleType, factory.doubleType, factory.doubleType);
            method = factory.createMethod(type, proto, name);
            this.addProvider(new InvokeRewriter(method, NumericMethodRewrites.rewriteToAddInstruction()));
            name = factory.createString("isFinite");
            proto = factory.createProto(factory.booleanType, factory.doubleType);
            method = factory.createMethod(type, proto, name);
            this.addProvider(new MethodGenerator(method, BackportedMethods::DoubleMethods_isFinite));
            type = factory.boxedFloatType;
            name = factory.createString("hashCode");
            proto = factory.createProto(factory.intType, factory.floatType);
            method = factory.createMethod(type, proto, name);
            this.addProvider(new InvokeRewriter(method, FloatMethodRewrites.rewriteHashCode()));
            name = factory.createString("max");
            proto = factory.createProto(factory.floatType, factory.floatType, factory.floatType);
            method = factory.createMethod(type, proto, name);
            this.addProvider(new InvokeRewriter(method, NumericMethodRewrites.rewriteToInvokeMath()));
            name = factory.createString("min");
            proto = factory.createProto(factory.floatType, factory.floatType, factory.floatType);
            method = factory.createMethod(type, proto, name);
            this.addProvider(new InvokeRewriter(method, NumericMethodRewrites.rewriteToInvokeMath()));
            name = factory.createString("sum");
            proto = factory.createProto(factory.floatType, factory.floatType, factory.floatType);
            method = factory.createMethod(type, proto, name);
            this.addProvider(new InvokeRewriter(method, NumericMethodRewrites.rewriteToAddInstruction()));
            name = factory.createString("isFinite");
            proto = factory.createProto(factory.booleanType, factory.floatType);
            method = factory.createMethod(type, proto, name);
            this.addProvider(new MethodGenerator(method, BackportedMethods::FloatMethods_isFinite));
            type = factory.boxedBooleanType;
            name = factory.createString("hashCode");
            proto = factory.createProto(factory.intType, factory.booleanType);
            method = factory.createMethod(type, proto, name);
            this.addProvider(new MethodGenerator(method, BackportedMethods::BooleanMethods_hashCode));
            name = factory.createString("logicalAnd");
            proto = factory.createProto(factory.booleanType, factory.booleanType, factory.booleanType);
            method = factory.createMethod(type, proto, name);
            this.addProvider(new InvokeRewriter(method, BooleanMethodRewrites.rewriteLogicalAnd()));
            name = factory.createString("logicalOr");
            proto = factory.createProto(factory.booleanType, factory.booleanType, factory.booleanType);
            method = factory.createMethod(type, proto, name);
            this.addProvider(new InvokeRewriter(method, BooleanMethodRewrites.rewriteLogicalOr()));
            name = factory.createString("logicalXor");
            proto = factory.createProto(factory.booleanType, factory.booleanType, factory.booleanType);
            method = factory.createMethod(type, proto, name);
            this.addProvider(new InvokeRewriter(method, BooleanMethodRewrites.rewriteLogicalXor()));
            type = factory.boxedLongType;
            name = factory.createString("hashCode");
            proto = factory.createProto(factory.intType, factory.longType);
            method = factory.createMethod(type, proto, name);
            this.addProvider(new MethodGenerator(method, BackportedMethods::LongMethods_hashCode));
            name = factory.createString("max");
            proto = factory.createProto(factory.longType, factory.longType, factory.longType);
            method = factory.createMethod(type, proto, name);
            this.addProvider(new InvokeRewriter(method, NumericMethodRewrites.rewriteToInvokeMath()));
            name = factory.createString("min");
            proto = factory.createProto(factory.longType, factory.longType, factory.longType);
            method = factory.createMethod(type, proto, name);
            this.addProvider(new InvokeRewriter(method, NumericMethodRewrites.rewriteToInvokeMath()));
            name = factory.createString("sum");
            proto = factory.createProto(factory.longType, factory.longType, factory.longType);
            method = factory.createMethod(type, proto, name);
            this.addProvider(new InvokeRewriter(method, NumericMethodRewrites.rewriteToAddInstruction()));
            type = factory.boxedCharType;
            name = factory.createString("hashCode");
            proto = factory.createProto(factory.intType, factory.charType);
            method = factory.createMethod(type, proto, name);
            this.addProvider(new InvokeRewriter(method, NumericMethodRewrites.rewriteAsIdentity()));
            for (DexType mathType : mathTypes = new DexType[]{factory.mathType, factory.strictMathType}) {
                name = factory.createString("addExact");
                proto = factory.createProto(factory.intType, factory.intType, factory.intType);
                method = factory.createMethod(mathType, proto, name);
                this.addProvider(new MethodGenerator(method, BackportedMethods::MathMethods_addExactInt, "addExactInt"));
                name = factory.createString("addExact");
                proto = factory.createProto(factory.longType, factory.longType, factory.longType);
                method = factory.createMethod(mathType, proto, name);
                this.addProvider(new MethodGenerator(method, BackportedMethods::MathMethods_addExactLong, "addExactLong"));
                name = factory.createString("floorDiv");
                proto = factory.createProto(factory.intType, factory.intType, factory.intType);
                method = factory.createMethod(mathType, proto, name);
                this.addProvider(new MethodGenerator(method, BackportedMethods::MathMethods_floorDivInt, "floorDivInt"));
                name = factory.createString("floorDiv");
                proto = factory.createProto(factory.longType, factory.longType, factory.longType);
                method = factory.createMethod(mathType, proto, name);
                this.addProvider(new MethodGenerator(method, BackportedMethods::MathMethods_floorDivLong, "floorDivLong"));
                name = factory.createString("floorMod");
                proto = factory.createProto(factory.intType, factory.intType, factory.intType);
                method = factory.createMethod(mathType, proto, name);
                this.addProvider(new MethodGenerator(method, BackportedMethods::MathMethods_floorModInt, "floorModInt"));
                name = factory.createString("floorMod");
                proto = factory.createProto(factory.longType, factory.longType, factory.longType);
                method = factory.createMethod(mathType, proto, name);
                this.addProvider(new MethodGenerator(method, BackportedMethods::MathMethods_floorModLong, "floorModLong"));
                name = factory.createString("multiplyExact");
                proto = factory.createProto(factory.intType, factory.intType, factory.intType);
                method = factory.createMethod(mathType, proto, name);
                this.addProvider(new MethodGenerator(method, BackportedMethods::MathMethods_multiplyExactInt, "multiplyExactInt"));
                name = factory.createString("multiplyExact");
                proto = factory.createProto(factory.longType, factory.longType, factory.longType);
                method = factory.createMethod(mathType, proto, name);
                this.addProvider(new MethodGenerator(method, BackportedMethods::MathMethods_multiplyExactLong, "multiplyExactLong"));
                name = factory.createString("nextDown");
                proto = factory.createProto(factory.doubleType, factory.doubleType);
                method = factory.createMethod(mathType, proto, name);
                this.addProvider(new MethodGenerator(method, BackportedMethods::MathMethods_nextDownDouble, "nextDownDouble"));
                name = factory.createString("nextDown");
                proto = factory.createProto(factory.floatType, factory.floatType);
                method = factory.createMethod(mathType, proto, name);
                this.addProvider(new MethodGenerator(method, BackportedMethods::MathMethods_nextDownFloat, "nextDownFloat"));
                name = factory.createString("subtractExact");
                proto = factory.createProto(factory.intType, factory.intType, factory.intType);
                method = factory.createMethod(mathType, proto, name);
                this.addProvider(new MethodGenerator(method, BackportedMethods::MathMethods_subtractExactInt, "subtractExactInt"));
                name = factory.createString("subtractExact");
                proto = factory.createProto(factory.longType, factory.longType, factory.longType);
                method = factory.createMethod(mathType, proto, name);
                this.addProvider(new MethodGenerator(method, BackportedMethods::MathMethods_subtractExactLong, "subtractExactLong"));
                name = factory.createString("toIntExact");
                proto = factory.createProto(factory.intType, factory.longType);
                method = factory.createMethod(mathType, proto, name);
                this.addProvider(new MethodGenerator(method, BackportedMethods::MathMethods_toIntExact));
            }
            type = factory.mathType;
            name = factory.createString("decrementExact");
            proto = factory.createProto(factory.intType, factory.intType);
            method = factory.createMethod(type, proto, name);
            this.addProvider(new MethodGenerator(method, BackportedMethods::MathMethods_decrementExactInt, "decrementExactInt"));
            name = factory.createString("decrementExact");
            proto = factory.createProto(factory.longType, factory.longType);
            method = factory.createMethod(type, proto, name);
            this.addProvider(new MethodGenerator(method, BackportedMethods::MathMethods_decrementExactLong, "decrementExactLong"));
            name = factory.createString("incrementExact");
            proto = factory.createProto(factory.intType, factory.intType);
            method = factory.createMethod(type, proto, name);
            this.addProvider(new MethodGenerator(method, BackportedMethods::MathMethods_incrementExactInt, "incrementExactInt"));
            name = factory.createString("incrementExact");
            proto = factory.createProto(factory.longType, factory.longType);
            method = factory.createMethod(type, proto, name);
            this.addProvider(new MethodGenerator(method, BackportedMethods::MathMethods_incrementExactLong, "incrementExactLong"));
            name = factory.createString("negateExact");
            proto = factory.createProto(factory.intType, factory.intType);
            method = factory.createMethod(type, proto, name);
            this.addProvider(new MethodGenerator(method, BackportedMethods::MathMethods_negateExactInt, "negateExactInt"));
            name = factory.createString("negateExact");
            proto = factory.createProto(factory.longType, factory.longType);
            method = factory.createMethod(type, proto, name);
            this.addProvider(new MethodGenerator(method, BackportedMethods::MathMethods_negateExactLong, "negateExactLong"));
        }

        private void initializeAndroidOMethodProviders(DexItemFactory factory) {
            DexType type = factory.boxedByteType;
            DexString name = factory.createString("toUnsignedInt");
            DexProto proto = factory.createProto(factory.intType, factory.byteType);
            DexMethod method = factory.createMethod(type, proto, name);
            this.addProvider(new MethodGenerator(method, BackportedMethods::ByteMethods_toUnsignedInt));
            name = factory.createString("toUnsignedLong");
            proto = factory.createProto(factory.longType, factory.byteType);
            method = factory.createMethod(type, proto, name);
            this.addProvider(new MethodGenerator(method, BackportedMethods::ByteMethods_toUnsignedLong));
            type = factory.boxedShortType;
            name = factory.createString("toUnsignedInt");
            proto = factory.createProto(factory.intType, factory.shortType);
            method = factory.createMethod(type, proto, name);
            this.addProvider(new MethodGenerator(method, BackportedMethods::ShortMethods_toUnsignedInt));
            name = factory.createString("toUnsignedLong");
            proto = factory.createProto(factory.longType, factory.shortType);
            method = factory.createMethod(type, proto, name);
            this.addProvider(new MethodGenerator(method, BackportedMethods::ShortMethods_toUnsignedLong));
            type = factory.boxedIntType;
            name = factory.createString("divideUnsigned");
            proto = factory.createProto(factory.intType, factory.intType, factory.intType);
            method = factory.createMethod(type, proto, name);
            this.addProvider(new MethodGenerator(method, BackportedMethods::IntegerMethods_divideUnsigned));
            name = factory.createString("remainderUnsigned");
            proto = factory.createProto(factory.intType, factory.intType, factory.intType);
            method = factory.createMethod(type, proto, name);
            this.addProvider(new MethodGenerator(method, BackportedMethods::IntegerMethods_remainderUnsigned));
            name = factory.createString("compareUnsigned");
            proto = factory.createProto(factory.intType, factory.intType, factory.intType);
            method = factory.createMethod(type, proto, name);
            this.addProvider(new MethodGenerator(method, BackportedMethods::IntegerMethods_compareUnsigned));
            name = factory.createString("toUnsignedLong");
            proto = factory.createProto(factory.longType, factory.intType);
            method = factory.createMethod(type, proto, name);
            this.addProvider(new MethodGenerator(method, BackportedMethods::IntegerMethods_toUnsignedLong));
            name = factory.createString("parseUnsignedInt");
            proto = factory.createProto(factory.intType, factory.stringType);
            method = factory.createMethod(type, proto, name);
            this.addProvider(new MethodGenerator(method, BackportedMethods::IntegerMethods_parseUnsignedInt));
            name = factory.createString("parseUnsignedInt");
            proto = factory.createProto(factory.intType, factory.stringType, factory.intType);
            method = factory.createMethod(type, proto, name);
            this.addProvider(new MethodGenerator(method, BackportedMethods::IntegerMethods_parseUnsignedIntWithRadix, "parseUnsignedIntWithRadix"));
            name = factory.createString("toUnsignedString");
            proto = factory.createProto(factory.stringType, factory.intType);
            method = factory.createMethod(type, proto, name);
            this.addProvider(new MethodGenerator(method, BackportedMethods::IntegerMethods_toUnsignedString));
            name = factory.createString("toUnsignedString");
            proto = factory.createProto(factory.stringType, factory.intType, factory.intType);
            method = factory.createMethod(type, proto, name);
            this.addProvider(new MethodGenerator(method, BackportedMethods::IntegerMethods_toUnsignedStringWithRadix, "toUnsignedStringWithRadix"));
            type = factory.boxedLongType;
            name = factory.createString("divideUnsigned");
            proto = factory.createProto(factory.longType, factory.longType, factory.longType);
            method = factory.createMethod(type, proto, name);
            this.addProvider(new MethodGenerator(method, BackportedMethods::LongMethods_divideUnsigned));
            name = factory.createString("remainderUnsigned");
            proto = factory.createProto(factory.longType, factory.longType, factory.longType);
            method = factory.createMethod(type, proto, name);
            this.addProvider(new MethodGenerator(method, BackportedMethods::LongMethods_remainderUnsigned));
            name = factory.createString("compareUnsigned");
            proto = factory.createProto(factory.intType, factory.longType, factory.longType);
            method = factory.createMethod(type, proto, name);
            this.addProvider(new MethodGenerator(method, BackportedMethods::LongMethods_compareUnsigned));
            name = factory.createString("parseUnsignedLong");
            proto = factory.createProto(factory.longType, factory.stringType);
            method = factory.createMethod(type, proto, name);
            this.addProvider(new MethodGenerator(method, BackportedMethods::LongMethods_parseUnsignedLong));
            name = factory.createString("parseUnsignedLong");
            proto = factory.createProto(factory.longType, factory.stringType, factory.intType);
            method = factory.createMethod(type, proto, name);
            this.addProvider(new MethodGenerator(method, BackportedMethods::LongMethods_parseUnsignedLongWithRadix, "parseUnsignedLongWithRadix"));
            name = factory.createString("toUnsignedString");
            proto = factory.createProto(factory.stringType, factory.longType);
            method = factory.createMethod(type, proto, name);
            this.addProvider(new MethodGenerator(method, BackportedMethods::LongMethods_toUnsignedString));
            name = factory.createString("toUnsignedString");
            proto = factory.createProto(factory.stringType, factory.longType, factory.intType);
            method = factory.createMethod(type, proto, name);
            this.addProvider(new MethodGenerator(method, BackportedMethods::LongMethods_toUnsignedStringWithRadix, "toUnsignedStringWithRadix"));
            type = factory.stringType;
            name = factory.createString("join");
            proto = factory.createProto(factory.stringType, factory.charSequenceType, factory.charSequenceArrayType);
            method = factory.createMethod(type, proto, name);
            this.addProvider(new MethodGenerator(method, BackportedMethods::StringMethods_joinArray, "joinArray"));
            name = factory.createString("join");
            proto = factory.createProto(factory.stringType, factory.charSequenceType, factory.iterableType);
            method = factory.createMethod(type, proto, name);
            this.addProvider(new MethodGenerator(method, BackportedMethods::StringMethods_joinIterable, "joinIterable"));
        }

        private void initializeAndroidRObjectsMethodProviderWithSupplier(DexItemFactory factory) {
            DexType type = factory.objectsType;
            DexString name = factory.createString("requireNonNullElseGet");
            DexProto proto = factory.createProto(factory.objectType, factory.objectType, factory.supplierType);
            DexMethod method = factory.createMethod(type, proto, name);
            this.addProvider(new MethodGenerator(method, BackportedMethods::ObjectsMethods_requireNonNullElseGet));
        }

        private void initializeAndroidRObjectsMethodProviders(DexItemFactory factory) {
            DexType type = factory.objectsType;
            DexString name = factory.createString("requireNonNullElse");
            DexProto proto = factory.createProto(factory.objectType, factory.objectType, factory.objectType);
            DexMethod method = factory.createMethod(type, proto, name);
            this.addProvider(new MethodGenerator(method, BackportedMethods::ObjectsMethods_requireNonNullElse));
            name = factory.createString("checkIndex");
            proto = factory.createProto(factory.intType, factory.intType, factory.intType);
            method = factory.createMethod(type, proto, name);
            this.addProvider(new MethodGenerator(method, BackportedMethods::ObjectsMethods_checkIndex));
            name = factory.createString("checkFromToIndex");
            proto = factory.createProto(factory.intType, factory.intType, factory.intType, factory.intType);
            method = factory.createMethod(type, proto, name);
            this.addProvider(new MethodGenerator(method, BackportedMethods::ObjectsMethods_checkFromToIndex));
            name = factory.createString("checkFromIndexSize");
            proto = factory.createProto(factory.intType, factory.intType, factory.intType, factory.intType);
            method = factory.createMethod(type, proto, name);
            this.addProvider(new MethodGenerator(method, BackportedMethods::ObjectsMethods_checkFromIndexSize));
        }

        private void initializeAndroidRSetListMapMethodProviders(DexItemFactory factory) {
            DexMethod method;
            DexProto proto;
            int formalCount;
            int i;
            DexType type = factory.listType;
            DexString name = factory.createString("of");
            for (i = 0; i <= 10; ++i) {
                formalCount = i;
                proto = factory.createProto(type, Collections.nCopies(i, factory.objectType));
                method = factory.createMethod(type, proto, name);
                this.addProvider(i == 0 ? new InvokeRewriter(method, CollectionMethodRewrites.rewriteListOfEmpty()) : new MethodGenerator(method, (options, methodArg) -> CollectionMethodGenerators.generateListOf(options, methodArg, formalCount)));
            }
            proto = factory.createProto(type, factory.objectArrayType);
            method = factory.createMethod(type, proto, name);
            this.addProvider(new MethodGenerator(method, BackportedMethods::CollectionMethods_listOfArray, "ofArray"));
            type = factory.setType;
            name = factory.createString("of");
            for (i = 0; i <= 10; ++i) {
                formalCount = i;
                proto = factory.createProto(type, Collections.nCopies(i, factory.objectType));
                method = factory.createMethod(type, proto, name);
                this.addProvider(i == 0 ? new InvokeRewriter(method, CollectionMethodRewrites.rewriteSetOfEmpty()) : new MethodGenerator(method, (options, methodArg) -> CollectionMethodGenerators.generateSetOf(options, methodArg, formalCount)));
            }
            proto = factory.createProto(type, factory.objectArrayType);
            method = factory.createMethod(type, proto, name);
            this.addProvider(new MethodGenerator(method, BackportedMethods::CollectionMethods_setOfArray, "ofArray"));
            type = factory.mapType;
            name = factory.createString("of");
            for (i = 0; i <= 10; ++i) {
                formalCount = i;
                proto = factory.createProto(type, Collections.nCopies(i * 2, factory.objectType));
                method = factory.createMethod(type, proto, name);
                this.addProvider(i == 0 ? new InvokeRewriter(method, CollectionMethodRewrites.rewriteMapOfEmpty()) : new MethodGenerator(method, (options, methodArg) -> CollectionMethodGenerators.generateMapOf(options, methodArg, formalCount)));
            }
            proto = factory.createProto(type, factory.createArrayType(1, factory.mapEntryType));
            method = factory.createMethod(type, proto, "ofEntries");
            this.addProvider(new MethodGenerator(method, BackportedMethods::CollectionMethods_mapOfEntries, "ofEntries"));
            type = factory.mapType;
            proto = factory.createProto(factory.mapEntryType, factory.objectType, factory.objectType);
            method = factory.createMethod(type, proto, "entry");
            this.addProvider(new MethodGenerator(method, BackportedMethods::CollectionMethods_mapEntry));
        }

        private void initializeAndroidSSetListMapMethodProviders(DexItemFactory factory) {
            DexType type = factory.listType;
            DexString name = factory.createString("copyOf");
            DexProto proto = factory.createProto(factory.listType, factory.collectionType);
            DexMethod method = factory.createMethod(type, proto, name);
            this.addProvider(new MethodGenerator(method, BackportedMethods::CollectionsMethods_copyOfList, "copyOfList"));
            type = factory.setType;
            name = factory.createString("copyOf");
            proto = factory.createProto(factory.setType, factory.collectionType);
            method = factory.createMethod(type, proto, name);
            this.addProvider(new MethodGenerator(method, BackportedMethods::CollectionsMethods_copyOfSet, "copyOfSet"));
            type = factory.mapType;
            name = factory.createString("copyOf");
            proto = factory.createProto(factory.mapType, factory.mapType);
            method = factory.createMethod(type, proto, name);
            this.addProvider(new MethodGenerator(method, BackportedMethods::CollectionsMethods_copyOfMap, "copyOfMap"));
        }

        private void initializeAndroidSMethodProviders(DexItemFactory factory) {
            DexType[] mathTypes;
            DexType type = factory.boxedByteType;
            DexString name = factory.createString("compareUnsigned");
            DexProto proto = factory.createProto(factory.intType, factory.byteType, factory.byteType);
            DexMethod method = factory.createMethod(type, proto, name);
            this.addProvider(new MethodGenerator(method, BackportedMethods::ByteMethods_compareUnsigned));
            type = factory.boxedShortType;
            name = factory.createString("compareUnsigned");
            proto = factory.createProto(factory.intType, factory.shortType, factory.shortType);
            method = factory.createMethod(type, proto, name);
            this.addProvider(new MethodGenerator(method, BackportedMethods::ShortMethods_compareUnsigned));
            for (DexType mathType : mathTypes = new DexType[]{factory.mathType, factory.strictMathType}) {
                name = factory.createString("multiplyExact");
                proto = factory.createProto(factory.longType, factory.longType, factory.intType);
                method = factory.createMethod(mathType, proto, name);
                this.addProvider(new MethodGenerator(method, BackportedMethods::MathMethods_multiplyExactLongInt, "multiplyExactLongInt"));
                name = factory.createString("multiplyFull");
                proto = factory.createProto(factory.longType, factory.intType, factory.intType);
                method = factory.createMethod(mathType, proto, name);
                this.addProvider(new MethodGenerator(method, BackportedMethods::MathMethods_multiplyFull));
                name = factory.createString("multiplyHigh");
                proto = factory.createProto(factory.longType, factory.longType, factory.longType);
                method = factory.createMethod(mathType, proto, name);
                this.addProvider(new MethodGenerator(method, BackportedMethods::MathMethods_multiplyHigh));
                name = factory.createString("floorDiv");
                proto = factory.createProto(factory.longType, factory.longType, factory.intType);
                method = factory.createMethod(mathType, proto, name);
                this.addProvider(new MethodGenerator(method, BackportedMethods::MathMethods_floorDivLongInt, "floorDivLongInt"));
                name = factory.createString("floorMod");
                proto = factory.createProto(factory.intType, factory.longType, factory.intType);
                method = factory.createMethod(mathType, proto, name);
                this.addProvider(new MethodGenerator(method, BackportedMethods::MathMethods_floorModLongInt, "floorModLongInt"));
            }
            this.addProvider(new InvokeRewriter(factory.androidUtilSparseArrayMembers.set, SparseArrayMethodRewrites.rewriteSet()));
        }

        private void initializeAndroidSv2MethodProviders(DexItemFactory factory) {
            DexType type = factory.unsafeType;
            DexString name = factory.createString("compareAndSwapObject");
            DexProto proto = factory.createProto(factory.booleanType, factory.objectType, factory.longType, factory.objectType, factory.objectType);
            DexMethod method = factory.createMethod(type, proto, name);
            this.addProvider(new StatifyingMethodWithForwardingGenerator(method, BackportedMethods::UnsafeMethods_compareAndSwapObject, "compareAndSwapObject", type));
            type = factory.createType("Ljava/util/concurrent/atomic/AtomicReference;");
            name = factory.createString("compareAndSet");
            proto = factory.createProto(factory.booleanType, factory.objectType, factory.objectType);
            method = factory.createMethod(type, proto, name);
            this.addProvider(new StatifyingMethodWithForwardingGenerator(method, BackportedMethods::AtomicReferenceMethods_compareAndSet, "compareAndSet", type));
            type = factory.createType("Ljava/util/concurrent/atomic/AtomicReferenceArray;");
            name = factory.createString("compareAndSet");
            proto = factory.createProto(factory.booleanType, factory.intType, factory.objectType, factory.objectType);
            method = factory.createMethod(type, proto, name);
            this.addProvider(new StatifyingMethodWithForwardingGenerator(method, BackportedMethods::AtomicReferenceArrayMethods_compareAndSet, "compareAndSet", type));
            type = factory.createType("Ljava/util/concurrent/atomic/AtomicReferenceFieldUpdater;");
            name = factory.createString("compareAndSet");
            proto = factory.createProto(factory.booleanType, factory.objectType, factory.objectType, factory.objectType);
            method = factory.createMethod(type, proto, name);
            this.addProvider(new StatifyingMethodWithForwardingGenerator(method, BackportedMethods::AtomicReferenceFieldUpdaterMethods_compareAndSet, "compareAndSet", type));
        }

        private void initializeAndroidTMethodProviders(DexItemFactory factory) {
            DexType type = factory.boxedIntType;
            DexString name = factory.createString("parseInt");
            DexProto proto = factory.createProto(factory.intType, factory.charSequenceType, factory.intType, factory.intType, factory.intType);
            DexMethod method = factory.createMethod(type, proto, name);
            this.addProvider(this.appView.options().canParseNumbersWithPlusPrefix() ? new MethodGenerator(method, BackportedMethods::IntegerMethods_parseIntSubsequenceWithRadix, "parseIntSubsequenceWithRadix") : new MethodGenerator(method, BackportedMethods::IntegerMethods_parseIntSubsequenceWithRadixDalvik, "parseIntSubsequenceWithRadix"));
            type = factory.boxedIntType;
            name = factory.createString("parseUnsignedInt");
            proto = factory.createProto(factory.intType, factory.charSequenceType, factory.intType, factory.intType, factory.intType);
            method = factory.createMethod(type, proto, name);
            this.addProvider(new MethodGenerator(method, BackportedMethods::IntegerMethods_parseUnsignedIntSubsequenceWithRadix, "parseIntSubsequenceWithRadix"));
            type = factory.boxedLongType;
            name = factory.createString("parseLong");
            proto = factory.createProto(factory.longType, factory.charSequenceType, factory.intType, factory.intType, factory.intType);
            method = factory.createMethod(type, proto, name);
            this.addProvider(this.appView.options().canParseNumbersWithPlusPrefix() ? new MethodGenerator(method, BackportedMethods::LongMethods_parseLongSubsequenceWithRadix, "parseLongSubsequenceWithRadix") : new MethodGenerator(method, BackportedMethods::LongMethods_parseLongSubsequenceWithRadixDalvik, "parseLongSubsequenceWithRadix"));
            type = factory.boxedLongType;
            name = factory.createString("parseUnsignedLong");
            proto = factory.createProto(factory.longType, factory.charSequenceType, factory.intType, factory.intType, factory.intType);
            method = factory.createMethod(type, proto, name);
            this.addProvider(new MethodGenerator(method, BackportedMethods::LongMethods_parseUnsignedLongSubsequenceWithRadix, "parseUnsignedLongSubsequenceWithRadix"));
            type = factory.stringType;
            name = factory.createString("repeat");
            proto = factory.createProto(factory.stringType, factory.intType);
            method = factory.createMethod(type, proto, name);
            this.addProvider(new StatifyingMethodGenerator(method, BackportedMethods::StringMethods_repeat, "repeat", type));
            type = factory.stringType;
            name = factory.createString("isBlank");
            proto = factory.createProto(factory.booleanType, new DexType[0]);
            method = factory.createMethod(type, proto, name);
            this.addProvider(new StatifyingMethodGenerator(method, BackportedMethods::StringMethods_isBlank, "isBlank", type));
            type = factory.stringType;
            name = factory.createString("strip");
            proto = factory.createProto(factory.stringType, new DexType[0]);
            method = factory.createMethod(type, proto, name);
            this.addProvider(new StatifyingMethodGenerator(method, BackportedMethods::StringMethods_strip, "strip", type));
            type = factory.stringType;
            name = factory.createString("stripLeading");
            proto = factory.createProto(factory.stringType, new DexType[0]);
            method = factory.createMethod(type, proto, name);
            this.addProvider(new StatifyingMethodGenerator(method, BackportedMethods::StringMethods_stripLeading, "stripLeading", type));
            type = factory.stringType;
            name = factory.createString("stripTrailing");
            proto = factory.createProto(factory.stringType, new DexType[0]);
            method = factory.createMethod(type, proto, name);
            this.addProvider(new StatifyingMethodGenerator(method, BackportedMethods::StringMethods_stripTrailing, "stripTrailing", type));
        }

        private void initializeAndroidOptionalTMethodProviders(DexItemFactory factory) {
            DexMethod method;
            DexProto proto;
            int i;
            DexType optionalType = factory.optionalType;
            DexType[] optionalTypes = new DexType[]{factory.optionalType, factory.optionalDoubleType, factory.optionalLongType, factory.optionalIntType};
            DexString name = factory.createString("or");
            DexProto proto2 = factory.createProto(optionalType, factory.supplierType);
            DexMethod method2 = factory.createMethod(optionalType, proto2, name);
            this.addProvider(new StatifyingMethodGenerator(method2, BackportedMethods::OptionalMethods_or, "or", optionalType));
            DexType[] streamReturnTypes = new DexType[]{factory.streamType, factory.createType(factory.createString("Ljava/util/stream/DoubleStream;")), factory.createType(factory.createString("Ljava/util/stream/LongStream;")), factory.createType(factory.createString("Ljava/util/stream/IntStream;"))};
            TemplateMethodFactory[] streamMethodFactories = new TemplateMethodFactory[]{BackportedMethods::OptionalMethods_stream, BackportedMethods::OptionalMethods_streamDouble, BackportedMethods::OptionalMethods_streamLong, BackportedMethods::OptionalMethods_streamInt};
            DexString name2 = factory.createString("stream");
            for (i = 0; i < optionalTypes.length; ++i) {
                DexType optional = optionalTypes[i];
                DexType streamReturnType = streamReturnTypes[i];
                proto = factory.createProto(streamReturnType, new DexType[0]);
                method = factory.createMethod(optional, proto, name2);
                this.addProvider(new StatifyingMethodGenerator(method, streamMethodFactories[i], "stream", optional));
            }
            DexType[] consumerTypes = new DexType[]{factory.consumerType, factory.doubleConsumer, factory.longConsumer, factory.intConsumer};
            TemplateMethodFactory[] methodFactories = new TemplateMethodFactory[]{BackportedMethods::OptionalMethods_ifPresentOrElse, BackportedMethods::OptionalMethods_ifPresentOrElseDouble, BackportedMethods::OptionalMethods_ifPresentOrElseLong, BackportedMethods::OptionalMethods_ifPresentOrElseInt};
            for (int i2 = 0; i2 < optionalTypes.length; ++i2) {
                DexType optional = optionalTypes[i2];
                DexType consumer = consumerTypes[i2];
                DexString name3 = factory.createString("ifPresentOrElse");
                proto = factory.createProto(factory.voidType, consumer, factory.runnableType);
                method = factory.createMethod(optional, proto, name3);
                this.addProvider(new StatifyingMethodGenerator(method, methodFactories[i2], "ifPresentOrElse", optional));
            }
            DexType[] returnTypes = new DexType[]{factory.objectType, factory.doubleType, factory.longType, factory.intType};
            MethodInvokeRewriter[] rewriters = new MethodInvokeRewriter[]{OptionalMethodRewrites.rewriteOrElseGet(), OptionalMethodRewrites.rewriteDoubleOrElseGet(), OptionalMethodRewrites.rewriteLongOrElseGet(), OptionalMethodRewrites.rewriteIntOrElseGet()};
            name = factory.createString("orElseThrow");
            for (i = 0; i < optionalTypes.length; ++i) {
                DexProto proto3 = factory.createProto(returnTypes[i], new DexType[0]);
                DexMethod method3 = factory.createMethod(optionalTypes[i], proto3, name);
                this.addProvider(new InvokeRewriter(method3, rewriters[i]));
            }
            TemplateMethodFactory[] methodFactories2 = new TemplateMethodFactory[]{BackportedMethods::OptionalMethods_isEmpty, BackportedMethods::OptionalMethods_isEmptyDouble, BackportedMethods::OptionalMethods_isEmptyLong, BackportedMethods::OptionalMethods_isEmptyInt};
            DexString name4 = factory.createString("isEmpty");
            for (int i3 = 0; i3 < optionalTypes.length; ++i3) {
                DexProto proto4 = factory.createProto(factory.booleanType, new DexType[0]);
                DexMethod method4 = factory.createMethod(optionalTypes[i3], proto4, name4);
                this.addProvider(new StatifyingMethodGenerator(method4, methodFactories2[i3], "isEmpty", optionalTypes[i3]));
            }
        }

        private void initializeJava9MethodProviders(DexItemFactory factory) {
        }

        private void initializeJava10MethodProviders(DexItemFactory factory) {
        }

        private void initializeJava11MethodProviders(DexItemFactory factory) {
            DexType type = factory.boxedCharType;
            DexString name = factory.createString("toString");
            DexProto proto = factory.createProto(factory.stringType, factory.intType);
            DexMethod method = factory.createMethod(type, proto, name);
            this.addProvider(new MethodGenerator(method, BackportedMethods::CharacterMethods_toStringCodepoint, "toStringCodepoint"));
            type = factory.charSequenceType;
            name = factory.createString("compare");
            proto = factory.createProto(factory.intType, factory.charSequenceType, factory.charSequenceType);
            method = factory.createMethod(type, proto, name);
            this.addProvider(new MethodGenerator(method, BackportedMethods::CharSequenceMethods_compare, "compare"));
        }

        private void initializeStreamMethodProviders(DexItemFactory factory) {
            DexType streamType = factory.streamType;
            DexString name = factory.createString("ofNullable");
            DexProto proto = factory.createProto(factory.streamType, factory.objectType);
            DexMethod method = factory.createMethod(streamType, proto, name);
            this.addProvider(new MethodGenerator(method, BackportedMethods::StreamMethods_ofNullable, "ofNullable"));
        }

        private void initializePredicateMethodProviders(DexItemFactory factory) {
            DexType predicateType = factory.predicateType;
            DexString name = factory.createString("not");
            DexProto proto = factory.createProto(predicateType, predicateType);
            DexMethod method = factory.createMethod(predicateType, proto, name);
            this.addProvider(new MethodGenerator(method, BackportedMethods::PredicateMethods_not, "not"));
        }

        private void initializeAndroidNObjectsMethodProviderWithSupplier(DexItemFactory factory) {
            DexType type = factory.objectsType;
            DexString name = factory.createString("requireNonNull");
            DexProto proto = factory.createProto(factory.objectType, factory.objectType, factory.supplierType);
            DexMethod method = factory.createMethod(type, proto, name);
            this.addProvider(new MethodGenerator(method, BackportedMethods::ObjectsMethods_requireNonNullSupplier));
        }

        private void addProvider(MethodProvider generator) {
            MethodProvider replaced = this.rewritable.put(generator.method, generator);
            assert (replaced == null);
        }

        boolean isEmpty() {
            return this.rewritable.isEmpty();
        }

        public void visit(Consumer<DexMethod> consumer) {
            this.rewritable.keySet().forEach(consumer);
        }

        MethodProvider getProvider(DexMethod method) {
            return this.rewritable.get(method);
        }
    }
}

