/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.r8.ir.desugar;

import com.android.tools.r8.com.google.common.base.Predicates;
import com.android.tools.r8.errors.CompilationError;
import com.android.tools.r8.graph.DexAnnotation;
import com.android.tools.r8.graph.DexAnnotationElement;
import com.android.tools.r8.graph.DexApplication;
import com.android.tools.r8.graph.DexClass;
import com.android.tools.r8.graph.DexEncodedAnnotation;
import com.android.tools.r8.graph.DexEncodedMethod;
import com.android.tools.r8.graph.DexItemFactory;
import com.android.tools.r8.graph.DexMethod;
import com.android.tools.r8.graph.DexProgramClass;
import com.android.tools.r8.graph.DexProto;
import com.android.tools.r8.graph.DexType;
import com.android.tools.r8.graph.DexValue;
import com.android.tools.r8.graph.MethodAccessFlags;
import com.android.tools.r8.graph.ProgramMethod;
import com.android.tools.r8.ir.conversion.IRConverter;
import com.android.tools.r8.ir.synthetic.ForwardMethodBuilder;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;

public final class CovariantReturnTypeAnnotationTransformer {
    private final IRConverter converter;
    private final DexItemFactory factory;

    public CovariantReturnTypeAnnotationTransformer(IRConverter converter, DexItemFactory factory) {
        this.converter = converter;
        this.factory = factory;
    }

    private void updateClass(DexClass clazz, List<DexEncodedMethod> methodsWithCovariantReturnTypeAnnotation, List<DexEncodedMethod> covariantReturnTypeMethods) {
        for (DexEncodedMethod syntheticMethod : covariantReturnTypeMethods) {
            if (!CovariantReturnTypeAnnotationTransformer.hasVirtualMethodWithSignature(clazz, syntheticMethod)) continue;
            throw new CompilationError(String.format("Cannot process CovariantReturnType annotation: Class %s already has a method \"%s\"", clazz.getType(), syntheticMethod.toSourceString()));
        }
        for (DexEncodedMethod method : methodsWithCovariantReturnTypeAnnotation) {
            method.setAnnotations(method.annotations().keepIf(x -> !this.isCovariantReturnTypeAnnotation(x.annotation)));
        }
        clazz.addVirtualMethods(covariantReturnTypeMethods);
    }

    private void buildCovariantReturnTypeMethodsForClass(DexProgramClass clazz, List<DexEncodedMethod> methodsWithCovariantReturnTypeAnnotation, List<DexEncodedMethod> covariantReturnTypeMethods) {
        clazz.forEachProgramVirtualMethod(method -> {
            if (this.methodHasCovariantReturnTypeAnnotation((DexEncodedMethod)method.getDefinition())) {
                methodsWithCovariantReturnTypeAnnotation.add((DexEncodedMethod)method.getDefinition());
                this.buildCovariantReturnTypeMethodsForMethod((ProgramMethod)method, covariantReturnTypeMethods);
            }
        });
    }

    private boolean methodHasCovariantReturnTypeAnnotation(DexEncodedMethod method) {
        for (DexAnnotation annotation : method.annotations().annotations) {
            if (!this.isCovariantReturnTypeAnnotation(annotation.annotation)) continue;
            return true;
        }
        return false;
    }

    private void buildCovariantReturnTypeMethodsForMethod(ProgramMethod method, List<DexEncodedMethod> covariantReturnTypeMethods) {
        assert (this.methodHasCovariantReturnTypeAnnotation((DexEncodedMethod)method.getDefinition()));
        for (DexType covariantReturnType : this.getCovariantReturnTypes(method)) {
            DexEncodedMethod covariantReturnTypeMethod = this.buildCovariantReturnTypeMethod(method, covariantReturnType);
            covariantReturnTypeMethods.add(covariantReturnTypeMethod);
        }
    }

    private DexEncodedMethod buildCovariantReturnTypeMethod(ProgramMethod method, DexType covariantReturnType) {
        DexProgramClass methodHolder = method.getHolder();
        DexMethod methodReference = (DexMethod)method.getReference();
        DexEncodedMethod methodDefinition = (DexEncodedMethod)method.getDefinition();
        DexProto newProto = this.factory.createProto(covariantReturnType, methodReference.proto.parameters, methodReference.proto.shorty);
        MethodAccessFlags newAccessFlags = methodDefinition.accessFlags.copy();
        newAccessFlags.setBridge();
        newAccessFlags.setSynthetic();
        DexMethod newMethod = this.factory.createMethod(methodHolder.getType(), newProto, methodReference.getName());
        ForwardMethodBuilder forwardMethodBuilder = ForwardMethodBuilder.builder(this.factory).setNonStaticSource(newMethod).setVirtualTarget(methodReference, methodHolder.isInterface()).setCastResult();
        DexEncodedMethod newVirtualMethod = DexEncodedMethod.syntheticBuilder().setMethod(newMethod).setAccessFlags(newAccessFlags).setGenericSignature(methodDefinition.getGenericSignature()).setAnnotations(methodDefinition.annotations().keepIf(x -> !this.isCovariantReturnTypeAnnotation(x.annotation))).setParameterAnnotations(methodDefinition.parameterAnnotationsList.keepIf(Predicates.alwaysTrue())).setCode(forwardMethodBuilder.build()).setApiLevelForDefinition(methodDefinition.getApiLevelForDefinition()).setApiLevelForCode(methodDefinition.getApiLevelForCode()).build();
        ProgramMethod programMethod = new ProgramMethod(methodHolder, newVirtualMethod);
        this.converter.optimizeSynthesizedMethod(programMethod);
        return newVirtualMethod;
    }

    private Set<DexType> getCovariantReturnTypes(ProgramMethod method) {
        HashSet<DexType> covariantReturnTypes = new HashSet<DexType>();
        for (DexAnnotation annotation : ((DexEncodedMethod)method.getDefinition()).annotations().annotations) {
            if (!this.isCovariantReturnTypeAnnotation(annotation.annotation)) continue;
            this.getCovariantReturnTypesFromAnnotation(method.getHolder(), (DexEncodedMethod)method.getDefinition(), annotation.annotation, covariantReturnTypes);
        }
        return covariantReturnTypes;
    }

    private void getCovariantReturnTypesFromAnnotation(DexClass clazz, DexEncodedMethod method, DexEncodedAnnotation annotation, Set<DexType> covariantReturnTypes) {
        assert (this.isCovariantReturnTypeAnnotation(annotation));
        boolean hasPresentAfterElement = false;
        for (DexAnnotationElement element : annotation.elements) {
            String name = element.name.toString();
            if (annotation.type == this.factory.annotationCovariantReturnType) {
                if (name.equals("returnType")) {
                    DexValue.DexValueType dexValueType = element.value.asDexValueType();
                    if (dexValueType == null) {
                        throw new CompilationError(String.format("Expected element \"returnType\" of CovariantReturnType annotation to reference a type (method: \"%s\", was: %s)", method.toSourceString(), element.value.getClass().getCanonicalName()));
                    }
                    covariantReturnTypes.add((DexType)dexValueType.value);
                    continue;
                }
                if (!name.equals("presentAfter")) continue;
                hasPresentAfterElement = true;
                continue;
            }
            if (!name.equals("value")) continue;
            DexValue.DexValueArray array = element.value.asDexValueArray();
            if (array == null) {
                throw new CompilationError(String.format("Expected element \"value\" of CovariantReturnTypes annotation to be an array (method: \"%s\", was: %s)", method.toSourceString(), element.value.getClass().getCanonicalName()));
            }
            for (DexValue value : array.getValues()) {
                assert (value.isDexValueAnnotation());
                DexValue.DexValueAnnotation innerAnnotation = value.asDexValueAnnotation();
                this.getCovariantReturnTypesFromAnnotation(clazz, method, innerAnnotation.value, covariantReturnTypes);
            }
        }
        if (annotation.type == this.factory.annotationCovariantReturnType && !hasPresentAfterElement) {
            throw new CompilationError(String.format("CovariantReturnType annotation for method \"%s\" is missing mandatory element \"presentAfter\" (class %s)", clazz.getType(), method.toSourceString()));
        }
    }

    private boolean isCovariantReturnTypeAnnotation(DexEncodedAnnotation annotation) {
        return CovariantReturnTypeAnnotationTransformer.isCovariantReturnTypeAnnotation(annotation.type, this.factory);
    }

    public static boolean isCovariantReturnTypeAnnotation(DexType type, DexItemFactory factory) {
        return type == factory.annotationCovariantReturnType || type == factory.annotationCovariantReturnTypes;
    }

    private static boolean hasVirtualMethodWithSignature(DexClass clazz, DexEncodedMethod method) {
        for (DexEncodedMethod existingMethod : clazz.virtualMethods()) {
            if (!((DexMethod)existingMethod.getReference()).equals(method.getReference())) continue;
            return true;
        }
        return false;
    }

    public void process(DexApplication.Builder<?> builder) {
        LinkedList<DexEncodedMethod> methodsWithCovariantReturnTypeAnnotation = new LinkedList<DexEncodedMethod>();
        LinkedList<DexEncodedMethod> covariantReturnTypeMethods = new LinkedList<DexEncodedMethod>();
        for (DexProgramClass clazz : builder.getProgramClasses()) {
            this.buildCovariantReturnTypeMethodsForClass(clazz, methodsWithCovariantReturnTypeAnnotation, covariantReturnTypeMethods);
            if (covariantReturnTypeMethods.isEmpty()) continue;
            this.updateClass(clazz, methodsWithCovariantReturnTypeAnnotation, covariantReturnTypeMethods);
            methodsWithCovariantReturnTypeAnnotation.clear();
            covariantReturnTypeMethods.clear();
        }
    }
}

