/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.r8.ir.desugar;

import com.android.tools.r8.errors.Unimplemented;
import com.android.tools.r8.errors.Unreachable;
import com.android.tools.r8.graph.AppView;
import com.android.tools.r8.graph.DexEncodedField;
import com.android.tools.r8.graph.DexEncodedMethod;
import com.android.tools.r8.graph.DexField;
import com.android.tools.r8.graph.DexItemFactory;
import com.android.tools.r8.graph.DexMethod;
import com.android.tools.r8.graph.DexMethodHandle;
import com.android.tools.r8.graph.DexProgramClass;
import com.android.tools.r8.graph.DexProto;
import com.android.tools.r8.graph.DexString;
import com.android.tools.r8.graph.DexType;
import com.android.tools.r8.graph.DexValue;
import com.android.tools.r8.graph.FieldAccessFlags;
import com.android.tools.r8.graph.MethodAccessFlags;
import com.android.tools.r8.graph.MethodResolutionResult;
import com.android.tools.r8.graph.ProgramMethod;
import com.android.tools.r8.ir.code.Invoke;
import com.android.tools.r8.ir.desugar.AccessorMethodSourceCode;
import com.android.tools.r8.ir.desugar.LambdaBridgeMethodSourceCode;
import com.android.tools.r8.ir.desugar.LambdaClassConstructorSourceCode;
import com.android.tools.r8.ir.desugar.LambdaConstructorSourceCode;
import com.android.tools.r8.ir.desugar.LambdaDescriptor;
import com.android.tools.r8.ir.desugar.LambdaMainMethodSourceCode;
import com.android.tools.r8.ir.desugar.lambda.ForcefullyMovedLambdaMethodConsumer;
import com.android.tools.r8.ir.desugar.lambda.LambdaInstructionDesugaring;
import com.android.tools.r8.ir.optimize.info.OptimizationFeedback;
import com.android.tools.r8.ir.optimize.info.OptimizationFeedbackSimple;
import com.android.tools.r8.synthesis.SyntheticProgramClassBuilder;
import com.android.tools.r8.utils.ConsumerUtils;
import com.android.tools.r8.utils.DesugarUtils;
import java.util.ArrayList;
import java.util.Collections;
import java.util.function.Consumer;

public final class LambdaClass {
    public static final String LAMBDA_INSTANCE_FIELD_NAME = "INSTANCE";
    public static final String JAVAC_EXPECTED_LAMBDA_METHOD_PREFIX = "lambda$";
    public static final String R8_LAMBDA_ACCESSOR_METHOD_PREFIX = "$r8$lambda$";
    private static final OptimizationFeedback feedback = OptimizationFeedbackSimple.getInstance();
    final AppView<?> appView;
    final LambdaInstructionDesugaring desugaring;
    public final DexType type;
    public LambdaDescriptor descriptor;
    public final DexMethod constructor;
    final DexMethod classConstructor;
    public final DexField lambdaField;
    public final Target target;
    private DexProgramClass clazz = null;

    public LambdaClass(SyntheticProgramClassBuilder builder, AppView<?> appView, LambdaInstructionDesugaring desugaring, ProgramMethod accessedFrom, LambdaDescriptor descriptor, LambdaInstructionDesugaring.DesugarInvoke desugarInvoke) {
        assert (desugaring != null);
        assert (descriptor != null);
        this.type = builder.getType();
        this.appView = appView;
        this.desugaring = desugaring;
        this.descriptor = descriptor;
        DexItemFactory factory = builder.getFactory();
        DexProto constructorProto = factory.createProto(factory.voidType, descriptor.captures.values);
        this.constructor = factory.createMethod(this.type, constructorProto, factory.constructorMethodName);
        this.target = this.createTarget(accessedFrom);
        boolean statelessSingleton = this.isStatelessSingleton();
        this.classConstructor = statelessSingleton ? factory.createMethod(this.type, constructorProto, factory.classConstructorMethodName) : null;
        this.lambdaField = statelessSingleton ? factory.createField(this.type, this.type, factory.lambdaInstanceFieldName) : null;
        this.synthesizeLambdaClass(builder, desugarInvoke);
    }

    private void synthesizeLambdaClass(SyntheticProgramClassBuilder builder, LambdaInstructionDesugaring.DesugarInvoke desugarInvoke) {
        builder.setInterfaces(this.descriptor.interfaces);
        this.synthesizeStaticFields(builder);
        this.synthesizeInstanceFields(builder);
        this.synthesizeDirectMethods(builder);
        this.synthesizeVirtualMethods(builder, desugarInvoke);
    }

    private void synthesizeVirtualMethods(SyntheticProgramClassBuilder builder, LambdaInstructionDesugaring.DesugarInvoke desugarInvoke) {
        DexMethod mainMethod = this.appView.dexItemFactory().createMethod(this.type, this.descriptor.erasedProto, this.descriptor.name);
        ArrayList<DexEncodedMethod> methods = new ArrayList<DexEncodedMethod>(1 + this.descriptor.bridges.size());
        methods.add(DexEncodedMethod.syntheticBuilder().setMethod(mainMethod).setAccessFlags(MethodAccessFlags.fromSharedAccessFlags(17, false)).setCode(LambdaMainMethodSourceCode.build(this, mainMethod, desugarInvoke)).disableAndroidApiLevelCheck().build());
        for (DexProto bridgeProto : this.descriptor.bridges) {
            DexMethod bridgeMethod = this.appView.dexItemFactory().createMethod(this.type, bridgeProto, this.descriptor.name);
            methods.add(DexEncodedMethod.syntheticBuilder().setMethod(bridgeMethod).setAccessFlags(MethodAccessFlags.fromSharedAccessFlags(4177, false)).setCode(LambdaBridgeMethodSourceCode.build(this, bridgeMethod, mainMethod)).disableAndroidApiLevelCheck().build());
        }
        builder.setVirtualMethods(methods);
    }

    private void synthesizeDirectMethods(SyntheticProgramClassBuilder builder) {
        boolean statelessSingleton = this.isStatelessSingleton();
        ArrayList<DexEncodedMethod> methods = new ArrayList<DexEncodedMethod>(statelessSingleton ? 2 : 1);
        MethodAccessFlags accessFlags = MethodAccessFlags.fromSharedAccessFlags((statelessSingleton ? 2 : 1) | 0x1000, true);
        methods.add(DexEncodedMethod.syntheticBuilder().setMethod(this.constructor).setAccessFlags(accessFlags).setCode(LambdaConstructorSourceCode.build(this)).disableAndroidApiLevelCheck().build());
        if (statelessSingleton) {
            methods.add(DexEncodedMethod.syntheticBuilder().setMethod(this.classConstructor).setAccessFlags(MethodAccessFlags.fromSharedAccessFlags(4104, true)).setCode(LambdaClassConstructorSourceCode.build(this)).disableAndroidApiLevelCheck().build());
            feedback.classInitializerMayBePostponed((DexEncodedMethod)methods.get(1));
        }
        builder.setDirectMethods(methods);
    }

    private void synthesizeInstanceFields(SyntheticProgramClassBuilder builder) {
        DexType[] fieldTypes = this.descriptor.captures.values;
        int fieldCount = fieldTypes.length;
        ArrayList<DexEncodedField> fields = new ArrayList<DexEncodedField>(fieldCount);
        for (int i = 0; i < fieldCount; ++i) {
            fields.add(DexEncodedField.syntheticBuilder().setField(this.getCaptureField(i)).setAccessFlags(this.appView.options().desugarSpecificOptions().lambdaClassFieldsFinal ? FieldAccessFlags.createPublicFinalSynthetic() : FieldAccessFlags.createPublicSynthetic()).disableAndroidApiLevelCheck().build());
        }
        builder.setInstanceFields(fields);
    }

    private void synthesizeStaticFields(SyntheticProgramClassBuilder builder) {
        if (this.isStatelessSingleton()) {
            assert (this.lambdaField != null);
            builder.setStaticFields(Collections.singletonList(DexEncodedField.syntheticBuilder().setField(this.lambdaField).setAccessFlags(FieldAccessFlags.fromSharedAccessFlags(4121)).setStaticValue(DexValue.DexValueNull.NULL).disableAndroidApiLevelCheck().build()));
        }
    }

    public static int getAsmOpcodeForInvokeType(DexMethodHandle.MethodHandleType type) {
        switch (type) {
            case INVOKE_INTERFACE: {
                return 185;
            }
            case INVOKE_STATIC: {
                return 184;
            }
            case INVOKE_DIRECT: {
                return 183;
            }
            case INVOKE_INSTANCE: {
                return 182;
            }
        }
        throw new Unreachable("Unexpected method handle type: " + (Object)((Object)type));
    }

    private Target createTarget(ProgramMethod accessedFrom) {
        switch (this.descriptor.implHandle.type) {
            case INVOKE_SUPER: {
                throw new Unimplemented("Method references to super methods are not yet supported");
            }
            case INVOKE_INTERFACE: {
                return this.createInterfaceMethodTarget(accessedFrom);
            }
            case INVOKE_CONSTRUCTOR: {
                return this.createConstructorTarget(accessedFrom);
            }
            case INVOKE_STATIC: {
                return this.canAccessModifyLambdaImplMethod() ? this.createLambdaImplMethodTarget(accessedFrom) : this.createStaticMethodTarget(accessedFrom);
            }
            case INVOKE_DIRECT: {
                return this.canAccessModifyLambdaImplMethod() ? this.createLambdaImplMethodTarget(accessedFrom) : this.createInstanceMethodTarget(accessedFrom);
            }
            case INVOKE_INSTANCE: {
                return this.createInstanceMethodTarget(accessedFrom);
            }
        }
        throw new Unreachable("Unexpected method handle type in " + this.descriptor.implHandle);
    }

    private boolean doesNotNeedAccessor(ProgramMethod accessedFrom) {
        return this.canAccessModifyLambdaImplMethod() || this.isPrivateOrStaticInterfaceMethodInvokeThatWillBeDesugared() || !this.descriptor.needsAccessor(accessedFrom);
    }

    private boolean isPrivateOrStaticInterfaceMethodInvokeThatWillBeDesugared() {
        return this.appView.options().isInterfaceMethodDesugaringEnabled() && this.descriptor.implHandle.isInterface && (this.descriptor.implHandle.type.isInvokeDirect() || this.descriptor.implHandle.type.isInvokeStatic());
    }

    private boolean canAccessModifyLambdaImplMethod() {
        DexMethodHandle.MethodHandleType invokeType = this.descriptor.implHandle.type;
        return this.appView.options().canAccessModifyLambdaImplementationMethods(this.appView) && !this.isPrivateOrStaticInterfaceMethodInvokeThatWillBeDesugared() && (invokeType.isInvokeDirect() || invokeType.isInvokeStatic()) && this.descriptor.delegatesToLambdaImplMethod(this.appView.dexItemFactory()) && !this.desugaring.isDirectTargetedLambdaImplementationMethod(this.descriptor.implHandle);
    }

    private Target createLambdaImplMethodTarget(ProgramMethod accessedFrom) {
        DexMethodHandle implHandle = this.descriptor.implHandle;
        assert (implHandle != null);
        DexMethod implMethod = implHandle.asMethod();
        assert (this.descriptor.delegatesToLambdaImplMethod(this.appView.dexItemFactory()));
        assert (implMethod.holder == accessedFrom.getHolderType());
        assert (this.descriptor.verifyTargetFoundInClass(accessedFrom.getHolderType()));
        if (implHandle.type.isInvokeStatic()) {
            MethodResolutionResult resolution = this.appView.appInfoForDesugaring().resolveMethod(implMethod, implHandle.isInterface);
            if (resolution.isFailedResolution()) {
                return new InvalidLambdaImplTarget(implMethod, Invoke.Type.STATIC, this.appView.dexItemFactory().icceType, this.descriptor.implHandle.isInterface);
            }
            MethodResolutionResult.SingleResolutionResult result = resolution.asSingleResolution();
            assert (result.getResolvedMethod().isStatic());
            assert (result.getResolvedHolder().isProgramClass());
            return new StaticLambdaImplTarget(new ProgramMethod(result.getResolvedHolder().asProgramClass(), result.getResolvedMethod()), this.descriptor.implHandle.isInterface);
        }
        assert (implHandle.type.isInvokeDirect());
        if (this.appView.definitionFor(implMethod.holder).isInterface()) {
            DexProto implProto = implMethod.proto;
            DexType[] implParams = implProto.parameters.values;
            DexType[] newParams = new DexType[implParams.length + 1];
            newParams[0] = implMethod.holder;
            System.arraycopy(implParams, 0, newParams, 1, implParams.length);
            DexProto newProto = this.appView.dexItemFactory().createProto(implProto.returnType, newParams);
            return new InterfaceLambdaImplTarget(this.descriptor.implHandle.asMethod(), this.descriptor.implHandle.isInterface, this.appView.dexItemFactory().createMethod(implMethod.holder, newProto, implMethod.name), this.appView);
        }
        return new InstanceLambdaImplTarget(this.descriptor.implHandle.asMethod(), this.descriptor.implHandle.isInterface, this.appView.dexItemFactory().createMethod(implMethod.holder, implMethod.proto, DesugarUtils.appendFullyQualifiedHolderToMethodName(implMethod, this.appView.dexItemFactory())), this.appView);
    }

    private Target createInstanceMethodTarget(ProgramMethod accessedFrom) {
        assert (this.descriptor.implHandle.type.isInvokeInstance() || this.descriptor.implHandle.type.isInvokeDirect());
        if (this.doesNotNeedAccessor(accessedFrom)) {
            return new NoAccessorMethodTarget(this.descriptor.implHandle.asMethod(), this.descriptor.implHandle.type.isInvokeDirect() ? Invoke.Type.DIRECT : (this.descriptor.implHandle.type.isInvokeStatic() ? Invoke.Type.STATIC : Invoke.Type.VIRTUAL), this.descriptor.implHandle.isInterface);
        }
        DexMethod implMethod = this.descriptor.implHandle.asMethod();
        DexProto implProto = implMethod.proto;
        DexType[] implParams = implProto.parameters.values;
        DexType[] accessorParams = new DexType[1 + implParams.length];
        accessorParams[0] = this.descriptor.getImplReceiverType();
        System.arraycopy(implParams, 0, accessorParams, 1, implParams.length);
        DexProto accessorProto = this.appView.dexItemFactory().createProto(implProto.returnType, accessorParams);
        DexMethod accessorMethod = this.appView.dexItemFactory().createMethod(accessedFrom.getHolderType(), accessorProto, this.generateUniqueLambdaMethodName());
        return new ClassMethodWithAccessorTarget(this.descriptor.implHandle.asMethod(), this.descriptor.implHandle.isInterface, this.descriptor.implHandle.type, accessorMethod, this.appView);
    }

    private Target createStaticMethodTarget(ProgramMethod accessedFrom) {
        assert (this.descriptor.implHandle.type.isInvokeStatic());
        if (this.doesNotNeedAccessor(accessedFrom)) {
            return new NoAccessorMethodTarget(this.descriptor.implHandle.asMethod(), Invoke.Type.STATIC, this.descriptor.implHandle.isInterface);
        }
        DexMethod accessorMethod = this.appView.dexItemFactory().createMethod(accessedFrom.getHolderType(), this.descriptor.implHandle.asMethod().proto, this.generateUniqueLambdaMethodName());
        return new ClassMethodWithAccessorTarget(this.descriptor.implHandle.asMethod(), this.descriptor.implHandle.isInterface, this.descriptor.implHandle.type, accessorMethod, this.appView);
    }

    private Target createConstructorTarget(ProgramMethod accessedFrom) {
        DexMethodHandle implHandle = this.descriptor.implHandle;
        assert (implHandle != null);
        assert (implHandle.type.isInvokeConstructor());
        if (this.doesNotNeedAccessor(accessedFrom)) {
            return new NoAccessorMethodTarget(this.descriptor.implHandle.asMethod(), Invoke.Type.DIRECT, this.descriptor.implHandle.isInterface);
        }
        DexMethod implMethod = implHandle.asMethod();
        DexType returnType = implMethod.holder;
        DexProto accessorProto = this.appView.dexItemFactory().createProto(returnType, implMethod.proto.parameters.values);
        DexMethod accessorMethod = this.appView.dexItemFactory().createMethod(accessedFrom.getHolderType(), accessorProto, this.generateUniqueLambdaMethodName());
        return new ClassMethodWithAccessorTarget(this.descriptor.implHandle.asMethod(), this.descriptor.implHandle.isInterface, this.descriptor.implHandle.type, accessorMethod, this.appView);
    }

    private Target createInterfaceMethodTarget(ProgramMethod accessedFrom) {
        assert (this.descriptor.implHandle.type.isInvokeInterface());
        assert (this.doesNotNeedAccessor(accessedFrom));
        return new NoAccessorMethodTarget(this.descriptor.implHandle.asMethod(), Invoke.Type.INTERFACE, this.descriptor.implHandle.isInterface);
    }

    private DexString generateUniqueLambdaMethodName() {
        return this.appView.dexItemFactory().createString(R8_LAMBDA_ACCESSOR_METHOD_PREFIX + this.descriptor.uniqueId);
    }

    public final DexProgramClass getLambdaProgramClass() {
        assert (this.clazz != null);
        return this.clazz;
    }

    public DexType getType() {
        return this.type;
    }

    public void setClass(DexProgramClass clazz) {
        assert (this.clazz == null);
        assert (clazz != null);
        assert (this.type == clazz.type);
        this.clazz = clazz;
    }

    final DexField getCaptureField(int index) {
        return this.appView.dexItemFactory().createField(this.type, this.descriptor.captures.values[index], this.appView.dexItemFactory().createString("f$" + index));
    }

    public final boolean isStatelessSingleton() {
        return this.appView.options().createSingletonsForStatelessLambdas && this.descriptor.isStateless();
    }

    private static class ClassMethodWithAccessorTarget
    extends Target {
        private final AppView<?> appView;
        private final DexMethod implMethod;
        private final DexMethodHandle.MethodHandleType type;

        ClassMethodWithAccessorTarget(DexMethod implMethod, boolean isInterface, DexMethodHandle.MethodHandleType type, DexMethod accessorMethod, AppView<?> appView) {
            super(accessorMethod, Invoke.Type.STATIC, isInterface);
            this.appView = appView;
            this.implMethod = implMethod;
            this.type = type;
        }

        @Override
        ProgramMethod ensureAccessibility(ForcefullyMovedLambdaMethodConsumer forcefullyMovedLambdaMethodConsumer, Consumer<ProgramMethod> needsProcessingConsumer) {
            DexProgramClass accessorClass = this.appView.definitionForProgramType(this.callTarget.holder);
            assert (accessorClass != null);
            ProgramMethod existing = accessorClass.lookupProgramMethod(this.callTarget);
            if (existing != null) {
                assert (existing.getAccessFlags().isSynthetic());
                assert (existing.getAccessFlags().isPublic());
                assert (existing.getAccessFlags().isStatic());
                return existing;
            }
            ProgramMethod accessorMethod = new ProgramMethod(accessorClass, DexEncodedMethod.syntheticBuilder().setMethod(this.callTarget).setAccessFlags(MethodAccessFlags.createPublicStaticSynthetic()).setCode(AccessorMethodSourceCode.build(this.implMethod, this.isInterface, this.type, this.callTarget, this.appView)).disableAndroidApiLevelCheck().build());
            accessorClass.addDirectMethod((DexEncodedMethod)accessorMethod.getDefinition());
            if (this.appView.options().isDesugaredLibraryCompilation() || this.appView.options().isGeneratingDex()) {
                needsProcessingConsumer.accept(accessorMethod);
            }
            return accessorMethod;
        }
    }

    private static final class InstanceLambdaImplTarget
    extends D8SpecificTarget {
        private final DexMethod implMethod;
        private final AppView<?> appView;

        InstanceLambdaImplTarget(DexMethod implMethod, boolean isInterface, DexMethod staticMethod, AppView<?> appView) {
            super(staticMethod, Invoke.Type.VIRTUAL, isInterface);
            this.implMethod = implMethod;
            this.appView = appView;
        }

        @Override
        ProgramMethod ensureAccessibility(ForcefullyMovedLambdaMethodConsumer forcefullyMovedLambdaMethodConsumer, Consumer<ProgramMethod> needsProcessingConsumer) {
            DexProgramClass implMethodHolder = this.appView.definitionFor(this.implMethod.holder).asProgramClass();
            DexEncodedMethod replacement = implMethodHolder.getMethodCollection().replaceDirectMethodWithVirtualMethod(this.implMethod, encodedMethod -> {
                assert (encodedMethod.isDirectMethod());
                MethodAccessFlags newAccessFlags = encodedMethod.accessFlags.copy();
                newAccessFlags.unsetPrivate();
                DexEncodedMethod newMethod = DexEncodedMethod.syntheticBuilder().setMethod(this.callTarget).setAccessFlags(newAccessFlags).setGenericSignature(encodedMethod.getGenericSignature()).setAnnotations(encodedMethod.annotations()).setParameterAnnotations(encodedMethod.parameterAnnotationsList).setCode(encodedMethod.getCode()).setApiLevelForDefinition(encodedMethod.getApiLevelForDefinition()).setApiLevelForCode(encodedMethod.getApiLevelForCode()).build();
                newMethod.copyMetadata(this.appView, (DexEncodedMethod)encodedMethod);
                forcefullyMovedLambdaMethodConsumer.acceptForcefullyMovedLambdaMethod((DexMethod)encodedMethod.getReference(), this.callTarget);
                return newMethod;
            });
            if (replacement != null) {
                assert (!this.appView.options().isGeneratingClassFiles() || replacement.getCode().isCfCode());
                assert (!this.appView.options().isGeneratingDex() || replacement.getCode().isDexCode());
                ProgramMethod newMethod = new ProgramMethod(implMethodHolder, replacement);
                if (this.appView.options().isDesugaredLibraryCompilation()) {
                    assert (this.appView.options().isGeneratingClassFiles());
                    needsProcessingConsumer.accept(newMethod);
                }
                return newMethod;
            }
            ProgramMethod modified = implMethodHolder.lookupProgramMethod(this.callTarget);
            assert (modified != null);
            assert (((DexEncodedMethod)modified.getDefinition()).isNonPrivateVirtualMethod());
            return modified;
        }
    }

    static final class InvalidLambdaImplTarget
    extends Target {
        final DexType exceptionType;

        public InvalidLambdaImplTarget(DexMethod callTarget, Invoke.Type invokeType, DexType exceptionType, boolean isInterface) {
            super(callTarget, invokeType, isInterface);
            this.exceptionType = exceptionType;
        }

        @Override
        ProgramMethod ensureAccessibility(ForcefullyMovedLambdaMethodConsumer forcefullyMovedLambdaMethodConsumer, Consumer<ProgramMethod> needsProcessingConsumer) {
            return null;
        }
    }

    private static final class InterfaceLambdaImplTarget
    extends D8SpecificTarget {
        private final AppView<?> appView;
        private final DexMethod implMethod;

        InterfaceLambdaImplTarget(DexMethod implMethod, boolean isInterface, DexMethod staticMethod, AppView<?> appView) {
            super(staticMethod, Invoke.Type.STATIC, isInterface);
            this.implMethod = implMethod;
            this.appView = appView;
        }

        @Override
        ProgramMethod ensureAccessibility(ForcefullyMovedLambdaMethodConsumer forcefullyMovedLambdaMethodConsumer, Consumer<ProgramMethod> needsProcessingConsumer) {
            DexProgramClass implMethodHolder = this.appView.definitionFor(this.implMethod.holder).asProgramClass();
            DexEncodedMethod replacement = implMethodHolder.getMethodCollection().replaceDirectMethod(this.implMethod, encodedMethod -> {
                MethodAccessFlags newAccessFlags = encodedMethod.accessFlags.copy();
                newAccessFlags.setStatic();
                newAccessFlags.unsetPrivate();
                newAccessFlags.setPublic();
                DexEncodedMethod newMethod = DexEncodedMethod.syntheticBuilder().setMethod(this.callTarget).setAccessFlags(newAccessFlags).setGenericSignature(encodedMethod.getGenericSignature()).setAnnotations(encodedMethod.annotations()).setParameterAnnotations(encodedMethod.parameterAnnotationsList).setCode(encodedMethod.getCode()).setApiLevelForDefinition(encodedMethod.getApiLevelForDefinition()).setApiLevelForCode(encodedMethod.getApiLevelForCode()).build();
                newMethod.copyMetadata(this.appView, (DexEncodedMethod)encodedMethod);
                forcefullyMovedLambdaMethodConsumer.acceptForcefullyMovedLambdaMethod((DexMethod)encodedMethod.getReference(), this.callTarget);
                DexEncodedMethod.setDebugInfoWithFakeThisParameter(newMethod.getCode(), this.callTarget.getArity(), this.appView);
                return newMethod;
            });
            if (replacement != null) {
                assert (!this.appView.options().isGeneratingClassFiles() || replacement.getCode().isCfCode());
                assert (!this.appView.options().isGeneratingDex() || replacement.getCode().isDexCode());
                ProgramMethod newMethod = new ProgramMethod(implMethodHolder, replacement);
                if (this.appView.options().isDesugaredLibraryCompilation()) {
                    assert (this.appView.options().isGeneratingClassFiles());
                    needsProcessingConsumer.accept(newMethod);
                }
                return newMethod;
            }
            ProgramMethod modified = implMethodHolder.lookupProgramMethod(this.callTarget);
            assert (modified != null);
            assert (((DexEncodedMethod)modified.getDefinition()).isNonPrivateVirtualMethod());
            return modified;
        }
    }

    private static final class StaticLambdaImplTarget
    extends D8SpecificTarget {
        final ProgramMethod target;

        StaticLambdaImplTarget(ProgramMethod target, boolean isInterface) {
            super((DexMethod)target.getReference(), Invoke.Type.STATIC, isInterface);
            this.target = target;
        }

        @Override
        ProgramMethod ensureAccessibility(ForcefullyMovedLambdaMethodConsumer forcefullyMovedLambdaMethodConsumer, Consumer<ProgramMethod> needsProcessingConsumer) {
            MethodAccessFlags flags = this.target.getAccessFlags();
            flags.unsetPrivate();
            if (this.target.getHolder().isInterface()) {
                flags.setPublic();
            }
            return null;
        }
    }

    public static final class NoAccessorMethodTarget
    extends Target {
        NoAccessorMethodTarget(DexMethod method, Invoke.Type invokeType, boolean isInterface) {
            super(method, invokeType, isInterface);
        }

        @Override
        ProgramMethod ensureAccessibility(ForcefullyMovedLambdaMethodConsumer forcefullyMovedLambdaMethodConsumer, Consumer<ProgramMethod> needsProcessingConsumer) {
            return null;
        }
    }

    public static abstract class D8SpecificTarget
    extends Target {
        D8SpecificTarget(DexMethod callTarget, Invoke.Type invokeType, boolean isInterface) {
            super(callTarget, invokeType, isInterface);
        }
    }

    public static abstract class Target {
        final DexMethod callTarget;
        final Invoke.Type invokeType;
        final boolean isInterface;
        private boolean hasEnsuredAccessibility;

        Target(DexMethod callTarget, Invoke.Type invokeType, boolean isInterface) {
            assert (callTarget != null);
            assert (invokeType != null);
            this.callTarget = callTarget;
            this.invokeType = invokeType;
            this.isInterface = isInterface;
        }

        abstract ProgramMethod ensureAccessibility(ForcefullyMovedLambdaMethodConsumer var1, Consumer<ProgramMethod> var2);

        public final void ensureAccessibilityIfNeeded() {
            this.ensureAccessibilityIfNeeded(ForcefullyMovedLambdaMethodConsumer.emptyForcefullyMovedLambdaMethodConsumer(), ConsumerUtils.emptyConsumer());
        }

        public final void ensureAccessibilityIfNeeded(ForcefullyMovedLambdaMethodConsumer forcefullyMovedLambdaMethodConsumer, Consumer<ProgramMethod> needsProcessingConsumer) {
            if (!this.hasEnsuredAccessibility) {
                this.ensureAccessibility(forcefullyMovedLambdaMethodConsumer, needsProcessingConsumer);
                this.hasEnsuredAccessibility = true;
            }
        }

        boolean isInterface() {
            return this.isInterface;
        }
    }
}

