/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.r8.ir.desugar;

import com.android.tools.r8.cf.code.CfCheckCast;
import com.android.tools.r8.cf.code.CfInstanceFieldRead;
import com.android.tools.r8.cf.code.CfInstruction;
import com.android.tools.r8.cf.code.CfInvoke;
import com.android.tools.r8.cf.code.CfLoad;
import com.android.tools.r8.cf.code.CfNew;
import com.android.tools.r8.cf.code.CfNumberConversion;
import com.android.tools.r8.cf.code.CfReturn;
import com.android.tools.r8.cf.code.CfReturnVoid;
import com.android.tools.r8.cf.code.CfStackInstruction;
import com.android.tools.r8.cf.code.CfThrow;
import com.android.tools.r8.cf.code.CfTryCatch;
import com.android.tools.r8.com.google.common.collect.ImmutableList;
import com.android.tools.r8.com.google.common.collect.Lists;
import com.android.tools.r8.errors.Unreachable;
import com.android.tools.r8.graph.CfCode;
import com.android.tools.r8.graph.DexField;
import com.android.tools.r8.graph.DexItemFactory;
import com.android.tools.r8.graph.DexMethod;
import com.android.tools.r8.graph.DexProto;
import com.android.tools.r8.graph.DexType;
import com.android.tools.r8.ir.code.Invoke;
import com.android.tools.r8.ir.code.NumericType;
import com.android.tools.r8.ir.code.ValueType;
import com.android.tools.r8.ir.desugar.LambdaClass;
import com.android.tools.r8.ir.desugar.LambdaDescriptor;
import com.android.tools.r8.ir.desugar.lambda.LambdaInstructionDesugaring;
import com.android.tools.r8.utils.IntBox;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

final class LambdaMainMethodSourceCode {
    LambdaMainMethodSourceCode() {
    }

    private static boolean checkSignatures(DexType[] captures, DexType[] enforcedParams, DexType enforcedReturnType, List<DexType> implReceiverAndArgs, DexType implReturnType, DexItemFactory factory) {
        ArrayList<DexType> capturesAndParams = new ArrayList<DexType>();
        capturesAndParams.addAll(Lists.newArrayList(captures));
        capturesAndParams.addAll(Lists.newArrayList(enforcedParams));
        int size = capturesAndParams.size();
        if (size != implReceiverAndArgs.size()) assert (false);
        for (int i = 0; i < size; ++i) {
            if (!LambdaMainMethodSourceCode.isSameOrAdaptableTo((DexType)capturesAndParams.get(i), implReceiverAndArgs.get(i), factory)) assert (false);
        }
        if (!enforcedReturnType.isVoidType() && !LambdaMainMethodSourceCode.isSameOrAdaptableTo(implReturnType, enforcedReturnType, factory)) assert (false);
        return true;
    }

    private static DexType getBoxedForPrimitiveType(DexType primitive, DexItemFactory factory) {
        switch (primitive.descriptor.content[0]) {
            case 66: 
            case 67: 
            case 68: 
            case 70: 
            case 73: 
            case 74: 
            case 83: 
            case 90: {
                return factory.getBoxedForPrimitiveType(primitive);
            }
        }
        throw new Unreachable("Invalid primitive type descriptor: " + primitive);
    }

    private static boolean isSameOrAdaptableTo(DexType a, DexType b, DexItemFactory factory) {
        if (a == b) {
            return true;
        }
        if (a.isArrayType()) {
            return b == factory.objectType || b.isArrayType();
        }
        if (b.isArrayType()) {
            return a == factory.objectType;
        }
        if (a.isPrimitiveType()) {
            if (b.isPrimitiveType()) {
                return LambdaMainMethodSourceCode.isSameOrAdaptableTo(a.descriptor.content[0], b.descriptor.content[0]);
            }
            DexType boxedPrimitiveType = LambdaMainMethodSourceCode.getBoxedForPrimitiveType(a, factory);
            if (b == boxedPrimitiveType || b == factory.objectType || b == factory.serializableType || b == factory.comparableType) {
                return true;
            }
            return boxedPrimitiveType != factory.boxedCharType && boxedPrimitiveType != factory.boxedBooleanType && b.descriptor == factory.boxedNumberDescriptor;
        }
        if (b.isPrimitiveType()) {
            if (a == factory.objectType) {
                return true;
            }
            DexType unboxedA = factory.getPrimitiveFromBoxed(a);
            return unboxedA != null && LambdaMainMethodSourceCode.isSameOrAdaptableTo(unboxedA.descriptor.content[0], b.descriptor.content[0]);
        }
        return a.isClassType() && b.isClassType();
    }

    private static boolean isSameOrAdaptableTo(byte from, byte to) {
        if (from == to) {
            return true;
        }
        switch (from) {
            case 66: {
                return to == 83 || to == 73 || to == 74 || to == 70 || to == 68;
            }
            case 67: 
            case 83: {
                return to == 73 || to == 74 || to == 70 || to == 68;
            }
            case 73: {
                return to == 74 || to == 70 || to == 68;
            }
            case 74: {
                return to == 70 || to == 68;
            }
            case 70: {
                return to == 68;
            }
            case 68: 
            case 90: {
                return false;
            }
        }
        throw new Unreachable("Invalid primitive type descriptor: " + from);
    }

    public static CfCode build(LambdaClass lambda, DexMethod mainMethod, LambdaInstructionDesugaring.DesugarInvoke desugarInvoke) {
        ValueType valueType;
        boolean constructorTarget;
        DexItemFactory factory = lambda.appView.dexItemFactory();
        LambdaClass.Target target = lambda.target;
        if (target instanceof LambdaClass.InvalidLambdaImplTarget) {
            LambdaClass.InvalidLambdaImplTarget invalidTarget = (LambdaClass.InvalidLambdaImplTarget)target;
            DexType exceptionType = invalidTarget.exceptionType;
            return LambdaMainMethodSourceCode.buildThrowingCode(mainMethod, exceptionType, factory);
        }
        DexMethod methodToCall = target.callTarget;
        DexType[] capturedTypes = lambda.descriptor.captures.values;
        DexType[] erasedParams = lambda.descriptor.erasedProto.parameters.values;
        DexType erasedReturnType = lambda.descriptor.erasedProto.returnType;
        DexType[] enforcedParams = lambda.descriptor.enforcedProto.parameters.values;
        DexType enforcedReturnType = lambda.descriptor.enforcedProto.returnType;
        boolean bl = constructorTarget = methodToCall.name == factory.constructorMethodName;
        assert (!constructorTarget || target.invokeType == Invoke.Type.DIRECT);
        boolean targetWithReceiver = target.invokeType == Invoke.Type.VIRTUAL || target.invokeType == Invoke.Type.INTERFACE || target.invokeType == Invoke.Type.DIRECT && !constructorTarget;
        ArrayList<DexType> implReceiverAndArgs = new ArrayList<DexType>();
        if (targetWithReceiver) {
            implReceiverAndArgs.add(methodToCall.holder);
        }
        implReceiverAndArgs.addAll(Lists.newArrayList(methodToCall.proto.parameters.values));
        DexType implReturnType = methodToCall.proto.returnType;
        assert (target.invokeType == Invoke.Type.STATIC || target.invokeType == Invoke.Type.VIRTUAL || target.invokeType == Invoke.Type.DIRECT || target.invokeType == Invoke.Type.INTERFACE);
        assert (LambdaMainMethodSourceCode.checkSignatures(capturedTypes, enforcedParams, enforcedReturnType, implReceiverAndArgs, constructorTarget ? target.callTarget.holder : implReturnType, factory));
        int maxStack = 0;
        ImmutableList.Builder<CfInstruction> instructions = ImmutableList.builder();
        if (constructorTarget) {
            instructions.add((Object)new CfNew(methodToCall.holder));
            instructions.add((Object)new CfStackInstruction(CfStackInstruction.Opcode.Dup));
            maxStack += 2;
        }
        int capturedValues = capturedTypes.length;
        for (int i = 0; i < capturedValues; ++i) {
            DexField field = lambda.getCaptureField(i);
            valueType = ValueType.fromDexType(field.type);
            instructions.add((Object)new CfLoad(ValueType.OBJECT, 0));
            instructions.add((Object)new CfInstanceFieldRead(field));
            maxStack += valueType.requiredRegisters();
        }
        int maxLocals = 1;
        for (int i = 0; i < erasedParams.length; ++i) {
            valueType = ValueType.fromDexType(mainMethod.getParameters().values[i]);
            instructions.add((Object)new CfLoad(valueType, maxLocals));
            maxLocals += valueType.requiredRegisters();
            DexType expectedParamType = (DexType)implReceiverAndArgs.get(i + capturedValues);
            maxStack += LambdaMainMethodSourceCode.prepareParameterValue(erasedParams[i], enforcedParams[i], expectedParamType, instructions, factory);
        }
        CfInvoke invoke = new CfInvoke(target.invokeType.getCfOpcode(), methodToCall, target.isInterface());
        if (target instanceof LambdaClass.NoAccessorMethodTarget) {
            IntBox locals = new IntBox();
            IntBox stack = new IntBox();
            Collection<CfInstruction> is = desugarInvoke.desugarInvoke(invoke, locals::getAndIncrement, stack::getAndIncrement);
            if (is != null) {
                instructions.addAll(is);
                maxLocals += locals.get();
                maxStack += stack.get();
            } else {
                instructions.add((Object)invoke);
            }
        } else {
            instructions.add((Object)invoke);
        }
        DexType methodToCallReturnType = methodToCall.getReturnType();
        if (!methodToCallReturnType.isVoidType()) {
            maxStack = Math.max(maxStack, ValueType.fromDexType(methodToCallReturnType).requiredRegisters());
        }
        if (enforcedReturnType.isVoidType()) {
            if (!methodToCallReturnType.isVoidType()) {
                instructions.add((Object)new CfStackInstruction(methodToCallReturnType.isWideType() ? CfStackInstruction.Opcode.Pop2 : CfStackInstruction.Opcode.Pop));
            }
            instructions.add((Object)new CfReturnVoid());
        } else {
            assert (constructorTarget || !methodToCallReturnType.isVoidType());
            maxStack = Math.max(maxStack, LambdaMainMethodSourceCode.prepareReturnValue(erasedReturnType, enforcedReturnType, constructorTarget ? methodToCall.holder : methodToCallReturnType, instructions, factory));
            instructions.add((Object)new CfReturn(ValueType.fromDexType(enforcedReturnType)));
        }
        ImmutableList<CfTryCatch> tryCatchRanges = ImmutableList.of();
        ImmutableList<CfCode.LocalVariableInfo> localVariables = ImmutableList.of();
        CfCode code = new CfCode(mainMethod.holder, maxStack, maxLocals, (List<CfInstruction>)((Object)instructions.build()), tryCatchRanges, localVariables);
        return code;
    }

    private static CfCode buildThrowingCode(DexMethod method, DexType exceptionType, DexItemFactory factory) {
        DexProto initProto = factory.createProto(factory.voidType, new DexType[0]);
        DexMethod initMethod = factory.createMethod(exceptionType, initProto, factory.constructorMethodName);
        int maxStack = 2;
        int maxLocals = 1;
        for (DexType param : method.proto.parameters.values) {
            maxLocals += ValueType.fromDexType(param).requiredRegisters();
        }
        ImmutableList<CfTryCatch> tryCatchRanges = ImmutableList.of();
        ImmutableList<CfCode.LocalVariableInfo> localVariables = ImmutableList.of();
        return new CfCode(method.holder, maxStack, maxLocals, ImmutableList.of(new CfNew(exceptionType), new CfStackInstruction(CfStackInstruction.Opcode.Dup), new CfInvoke(183, initMethod, false), new CfThrow()), tryCatchRanges, localVariables);
    }

    private static int prepareReturnValue(DexType erasedType, DexType enforcedType, DexType actualType, ImmutableList.Builder<CfInstruction> instructions, DexItemFactory factory) {
        assert (LambdaDescriptor.isSameOrDerived(factory, enforcedType, erasedType));
        return LambdaMainMethodSourceCode.adjustType(actualType, enforcedType, true, instructions, factory);
    }

    private static int prepareParameterValue(DexType erasedType, DexType enforcedType, DexType expectedType, ImmutableList.Builder<CfInstruction> instructions, DexItemFactory factory) {
        LambdaMainMethodSourceCode.enforceParameterType(erasedType, enforcedType, instructions, factory);
        return LambdaMainMethodSourceCode.adjustType(enforcedType, expectedType, false, instructions, factory);
    }

    private static void enforceParameterType(DexType paramType, DexType enforcedType, ImmutableList.Builder<CfInstruction> instructions, DexItemFactory factory) {
        if (paramType != enforcedType) {
            assert (LambdaDescriptor.isSameOrDerived(factory, enforcedType, paramType));
            instructions.add((Object)new CfCheckCast(enforcedType));
        }
    }

    private static int adjustType(DexType fromType, DexType toType, boolean returnType, ImmutableList.Builder<CfInstruction> instructions, DexItemFactory factory) {
        LambdaMainMethodSourceCode.internalAdjustType(fromType, toType, returnType, instructions, factory);
        if (fromType == toType) {
            return ValueType.fromDexType(fromType).requiredRegisters();
        }
        DexType fromTypeAsPrimitive = factory.getPrimitiveFromBoxed(fromType);
        return Math.max(ValueType.fromDexType(fromType).requiredRegisters(), Math.max(fromTypeAsPrimitive == null ? 0 : ValueType.fromDexType(fromTypeAsPrimitive).requiredRegisters(), ValueType.fromDexType(toType).requiredRegisters()));
    }

    private static void internalAdjustType(DexType fromType, DexType toType, boolean returnType, ImmutableList.Builder<CfInstruction> instructions, DexItemFactory factory) {
        DexType boxedFromType;
        if (fromType == toType) {
            return;
        }
        boolean fromTypePrimitive = fromType.isPrimitiveType();
        boolean toTypePrimitive = toType.isPrimitiveType();
        if (fromTypePrimitive && toTypePrimitive) {
            LambdaMainMethodSourceCode.addPrimitiveWideningConversion(fromType, toType, instructions);
            return;
        }
        if (toTypePrimitive) {
            DexType fromTypeAsPrimitive;
            DexType boxedType = fromType;
            if (boxedType == factory.objectType) {
                boxedType = LambdaMainMethodSourceCode.getBoxedForPrimitiveType(toType, factory);
                instructions.add((Object)new CfCheckCast(boxedType));
            }
            if ((fromTypeAsPrimitive = factory.getPrimitiveFromBoxed(boxedType)) != null) {
                LambdaMainMethodSourceCode.addPrimitiveUnboxing(boxedType, instructions, factory);
                LambdaMainMethodSourceCode.addPrimitiveWideningConversion(fromTypeAsPrimitive, toType, instructions);
                return;
            }
        }
        if (fromTypePrimitive && (toType == (boxedFromType = LambdaMainMethodSourceCode.getBoxedForPrimitiveType(fromType, factory)) || toType == factory.objectType || toType == factory.serializableType || toType == factory.comparableType || boxedFromType != factory.booleanType && boxedFromType != factory.charType && toType == factory.boxedNumberType)) {
            LambdaMainMethodSourceCode.addPrimitiveBoxing(boxedFromType, instructions, factory);
            return;
        }
        if (fromType.isArrayType() && (toType == factory.objectType || toType.isArrayType())) {
            return;
        }
        if (fromType.isClassType() && toType.isClassType() || fromType == factory.objectType && toType.isArrayType()) {
            if (returnType && toType != factory.objectType) {
                instructions.add((Object)new CfCheckCast(toType));
            }
            return;
        }
        throw new Unreachable("Unexpected type adjustment from " + fromType.toSourceString() + " to " + toType);
    }

    private static void addPrimitiveWideningConversion(DexType fromType, DexType toType, ImmutableList.Builder<CfInstruction> instructions) {
        assert (fromType.isPrimitiveType() && toType.isPrimitiveType());
        if (fromType == toType) {
            return;
        }
        NumericType from = NumericType.fromDexType(fromType);
        NumericType to = NumericType.fromDexType(toType);
        if (from != null && to != null) {
            assert (from != to);
            switch (to) {
                case SHORT: {
                    if (from != NumericType.BYTE) break;
                    instructions.add((Object)new CfNumberConversion(NumericType.INT, to));
                    return;
                }
                case INT: {
                    if (from != NumericType.BYTE && from != NumericType.CHAR && from != NumericType.SHORT) break;
                    return;
                }
                case LONG: {
                    if (from == NumericType.FLOAT || from == NumericType.DOUBLE) break;
                    instructions.add((Object)new CfNumberConversion(NumericType.INT, to));
                    return;
                }
                case FLOAT: {
                    if (from == NumericType.DOUBLE) break;
                    NumericType type = from == NumericType.LONG ? NumericType.LONG : NumericType.INT;
                    instructions.add((Object)new CfNumberConversion(type, to));
                    return;
                }
                case DOUBLE: {
                    NumericType type = from == NumericType.FLOAT || from == NumericType.LONG ? from : NumericType.INT;
                    instructions.add((Object)new CfNumberConversion(type, to));
                    return;
                }
            }
        }
        throw new Unreachable("Type " + fromType.toSourceString() + " cannot be converted to " + toType.toSourceString() + " via primitive widening conversion.");
    }

    private static void addPrimitiveUnboxing(DexType boxType, ImmutableList.Builder<CfInstruction> instructions, DexItemFactory factory) {
        DexMethod method = factory.getUnboxPrimitiveMethod(boxType);
        instructions.add((Object)new CfInvoke(182, method, false));
    }

    private static void addPrimitiveBoxing(DexType boxType, ImmutableList.Builder<CfInstruction> instructions, DexItemFactory factory) {
        DexMethod method = factory.getBoxPrimitiveMethod(boxType);
        instructions.add((Object)new CfInvoke(184, method, false));
    }
}

