/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.r8.ir.desugar;

import com.android.tools.r8.androidapi.AndroidApiLevelCompute;
import com.android.tools.r8.cf.code.CfInstruction;
import com.android.tools.r8.com.google.common.collect.ImmutableSet;
import com.android.tools.r8.com.google.common.collect.Iterables;
import com.android.tools.r8.contexts.CompilationContext;
import com.android.tools.r8.errors.Unreachable;
import com.android.tools.r8.graph.AppView;
import com.android.tools.r8.graph.CfCode;
import com.android.tools.r8.graph.Code;
import com.android.tools.r8.graph.DexEncodedMethod;
import com.android.tools.r8.graph.ProgramMethod;
import com.android.tools.r8.ir.desugar.BackportedMethodRewriter;
import com.android.tools.r8.ir.desugar.BufferCovariantReturnTypeRewriter;
import com.android.tools.r8.ir.desugar.CfInstructionDesugaring;
import com.android.tools.r8.ir.desugar.CfInstructionDesugaringCollection;
import com.android.tools.r8.ir.desugar.CfInstructionDesugaringEventConsumer;
import com.android.tools.r8.ir.desugar.FreshLocalProvider;
import com.android.tools.r8.ir.desugar.InvokeToPrivateRewriter;
import com.android.tools.r8.ir.desugar.LocalStackAllocator;
import com.android.tools.r8.ir.desugar.ProgramAdditions;
import com.android.tools.r8.ir.desugar.apimodel.ApiInvokeOutlinerDesugaring;
import com.android.tools.r8.ir.desugar.constantdynamic.ConstantDynamicInstructionDesugaring;
import com.android.tools.r8.ir.desugar.desugaredlibrary.apiconversion.DesugaredLibraryAPIConverter;
import com.android.tools.r8.ir.desugar.desugaredlibrary.retargeter.DesugaredLibraryRetargeter;
import com.android.tools.r8.ir.desugar.icce.AlwaysThrowingInstructionDesugaring;
import com.android.tools.r8.ir.desugar.invokespecial.InvokeSpecialToSelfDesugaring;
import com.android.tools.r8.ir.desugar.itf.InterfaceMethodProcessorFacade;
import com.android.tools.r8.ir.desugar.itf.InterfaceMethodRewriter;
import com.android.tools.r8.ir.desugar.itf.InterfaceProcessor;
import com.android.tools.r8.ir.desugar.lambda.LambdaInstructionDesugaring;
import com.android.tools.r8.ir.desugar.nest.D8NestBasedAccessDesugaring;
import com.android.tools.r8.ir.desugar.nest.NestBasedAccessDesugaring;
import com.android.tools.r8.ir.desugar.records.RecordDesugaring;
import com.android.tools.r8.ir.desugar.stringconcat.StringConcatInstructionDesugaring;
import com.android.tools.r8.ir.desugar.twr.TwrInstructionDesugaring;
import com.android.tools.r8.position.MethodPosition;
import com.android.tools.r8.utils.IntBox;
import com.android.tools.r8.utils.ListUtils;
import com.android.tools.r8.utils.SetUtils;
import com.android.tools.r8.utils.StringDiagnostic;
import com.android.tools.r8.utils.ThrowingConsumer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.function.Consumer;
import java.util.function.Predicate;

public class NonEmptyCfInstructionDesugaringCollection
extends CfInstructionDesugaringCollection {
    private final AppView<?> appView;
    private final List<CfInstructionDesugaring> desugarings = new ArrayList<CfInstructionDesugaring>();
    private final List<CfInstructionDesugaring> yieldingDesugarings = new ArrayList<CfInstructionDesugaring>();
    private final NestBasedAccessDesugaring nestBasedAccessDesugaring;
    private final RecordDesugaring recordRewriter;
    private final DesugaredLibraryRetargeter desugaredLibraryRetargeter;
    private final InterfaceMethodRewriter interfaceMethodRewriter;
    private final DesugaredLibraryAPIConverter desugaredLibraryAPIConverter;
    private final AndroidApiLevelCompute apiLevelCompute;

    NonEmptyCfInstructionDesugaringCollection(AppView<?> appView, AndroidApiLevelCompute apiLevelCompute) {
        AlwaysThrowingInstructionDesugaring alwaysThrowingInstructionDesugaring;
        this.appView = appView;
        this.apiLevelCompute = apiLevelCompute;
        AlwaysThrowingInstructionDesugaring alwaysThrowingInstructionDesugaring2 = alwaysThrowingInstructionDesugaring = appView.enableWholeProgramOptimizations() ? new AlwaysThrowingInstructionDesugaring(appView.withClassHierarchy()) : null;
        if (alwaysThrowingInstructionDesugaring != null) {
            this.desugarings.add(alwaysThrowingInstructionDesugaring);
        }
        if (appView.options().desugarState.isOff()) {
            this.nestBasedAccessDesugaring = null;
            this.recordRewriter = null;
            this.desugaredLibraryRetargeter = null;
            this.interfaceMethodRewriter = null;
            this.desugaredLibraryAPIConverter = null;
            return;
        }
        this.nestBasedAccessDesugaring = NestBasedAccessDesugaring.create(appView);
        BackportedMethodRewriter backportedMethodRewriter = null;
        DesugaredLibraryRetargeter desugaredLibraryRetargeter = this.desugaredLibraryRetargeter = appView.options().machineDesugaredLibrarySpecification.hasRetargeting() ? new DesugaredLibraryRetargeter(appView) : null;
        if (this.desugaredLibraryRetargeter != null) {
            this.desugarings.add(this.desugaredLibraryRetargeter);
        }
        if (appView.options().enableBackportedMethodRewriting()) {
            backportedMethodRewriter = new BackportedMethodRewriter(appView);
        }
        if (appView.options().apiModelingOptions().enableOutliningOfMethods) {
            this.yieldingDesugarings.add(new ApiInvokeOutlinerDesugaring(appView, apiLevelCompute));
        }
        if (appView.options().enableTryWithResourcesDesugaring()) {
            this.desugarings.add(new TwrInstructionDesugaring(appView));
        }
        if (appView.options().isInterfaceMethodDesugaringEnabled()) {
            this.interfaceMethodRewriter = new InterfaceMethodRewriter(appView, SetUtils.newImmutableSetExcludingNullItems(alwaysThrowingInstructionDesugaring, backportedMethodRewriter, this.desugaredLibraryRetargeter));
            this.desugarings.add(this.interfaceMethodRewriter);
        } else {
            this.interfaceMethodRewriter = null;
        }
        DesugaredLibraryAPIConverter desugaredLibraryAPIConverter = appView.typeRewriter.isRewriting() ? new DesugaredLibraryAPIConverter(appView, SetUtils.newImmutableSetExcludingNullItems(this.interfaceMethodRewriter, this.desugaredLibraryRetargeter, backportedMethodRewriter), this.interfaceMethodRewriter != null ? this.interfaceMethodRewriter.getEmulatedMethods() : ImmutableSet.of()) : (this.desugaredLibraryAPIConverter = null);
        if (this.desugaredLibraryAPIConverter != null) {
            this.desugarings.add(this.desugaredLibraryAPIConverter);
        }
        this.desugarings.add(new LambdaInstructionDesugaring(appView));
        this.desugarings.add(new ConstantDynamicInstructionDesugaring(appView));
        this.desugarings.add(new InvokeSpecialToSelfDesugaring(appView));
        this.desugarings.add(new InvokeToPrivateRewriter());
        this.desugarings.add(new StringConcatInstructionDesugaring(appView));
        this.desugarings.add(new BufferCovariantReturnTypeRewriter(appView));
        if (backportedMethodRewriter != null && backportedMethodRewriter.hasBackports()) {
            this.desugarings.add(backportedMethodRewriter);
        }
        if (this.nestBasedAccessDesugaring != null) {
            this.desugarings.add(this.nestBasedAccessDesugaring);
        }
        this.recordRewriter = RecordDesugaring.create(appView);
        if (this.recordRewriter != null) {
            this.desugarings.add(this.recordRewriter);
        }
    }

    static NonEmptyCfInstructionDesugaringCollection createForCfToCfNonDesugar(AppView<?> appView) {
        assert (appView.options().desugarState.isOff());
        assert (appView.options().isGeneratingClassFiles());
        NonEmptyCfInstructionDesugaringCollection desugaringCollection = new NonEmptyCfInstructionDesugaringCollection(appView, AndroidApiLevelCompute.noAndroidApiLevelCompute());
        desugaringCollection.desugarings.add(new InvokeSpecialToSelfDesugaring(appView));
        return desugaringCollection;
    }

    static NonEmptyCfInstructionDesugaringCollection createForCfToDexNonDesugar(AppView<?> appView) {
        assert (appView.options().desugarState.isOff());
        assert (appView.options().isGeneratingDex());
        NonEmptyCfInstructionDesugaringCollection desugaringCollection = new NonEmptyCfInstructionDesugaringCollection(appView, AndroidApiLevelCompute.noAndroidApiLevelCompute());
        desugaringCollection.desugarings.add(new InvokeSpecialToSelfDesugaring(appView));
        desugaringCollection.desugarings.add(new InvokeToPrivateRewriter());
        return desugaringCollection;
    }

    private void ensureCfCode(ProgramMethod method) {
        if (!((DexEncodedMethod)method.getDefinition()).getCode().isCfCode()) {
            this.appView.options().reporter.error(new StringDiagnostic("Unsupported attempt to desugar non-CF code", method.getOrigin(), MethodPosition.create(method)));
        }
    }

    private boolean noDesugaringBecauseOfImpreciseDesugaring(ProgramMethod method) {
        assert (this.desugarings.stream().anyMatch(desugaring -> !desugaring.hasPreciseNeedsDesugaring())) : "Expected code to be desugared";
        assert (this.needsDesugaring(method));
        boolean foundFalsePositive = false;
        for (CfInstruction instruction : ((DexEncodedMethod)method.getDefinition()).getCode().asCfCode().getInstructions()) {
            for (CfInstructionDesugaring impreciseDesugaring : Iterables.filter(this.desugarings, desugaring -> !desugaring.hasPreciseNeedsDesugaring())) {
                if (!impreciseDesugaring.needsDesugaring(instruction, method)) continue;
                foundFalsePositive = true;
            }
            for (CfInstructionDesugaring preciseDesugaring : Iterables.filter(this.desugarings, desugaring -> desugaring.hasPreciseNeedsDesugaring())) {
                assert (!preciseDesugaring.needsDesugaring(instruction, method));
            }
        }
        assert (foundFalsePositive);
        return true;
    }

    private Collection<CfInstruction> applyDesugaring(CfInstruction instruction, FreshLocalProvider freshLocalProvider, LocalStackAllocator localStackAllocator, CfInstructionDesugaringEventConsumer eventConsumer, ProgramMethod context, CompilationContext.MethodProcessingContext methodProcessingContext, Iterator<CfInstructionDesugaring> iterator2) {
        while (iterator2.hasNext()) {
            CfInstructionDesugaring desugaring = iterator2.next();
            Collection<CfInstruction> replacement = desugaring.desugarInstruction(instruction, freshLocalProvider, localStackAllocator, eventConsumer, context, methodProcessingContext, this, this.appView.dexItemFactory());
            if (replacement == null) continue;
            assert (desugaring.needsDesugaring(instruction, context));
            assert (this.verifyNoOtherDesugaringNeeded(instruction, context, iterator2, desugaring));
            return replacement;
        }
        return null;
    }

    private boolean needsDesugaring(CfInstruction instruction, ProgramMethod context) {
        return Iterables.any(this.desugarings, desugaring -> desugaring.needsDesugaring(instruction, context)) || Iterables.any(this.yieldingDesugarings, desugaring -> desugaring.needsDesugaring(instruction, context));
    }

    private boolean verifyNoOtherDesugaringNeeded(CfInstruction instruction, ProgramMethod context, Iterator<CfInstructionDesugaring> iterator2, CfInstructionDesugaring appliedDesugaring) {
        iterator2.forEachRemaining(desugaring -> {
            boolean alsoApplicable = desugaring.needsDesugaring(instruction, context);
            assert (!alsoApplicable || appliedDesugaring instanceof InterfaceMethodRewriter && (desugaring instanceof InvokeToPrivateRewriter || desugaring instanceof NestBasedAccessDesugaring) || appliedDesugaring instanceof TwrInstructionDesugaring && desugaring instanceof InterfaceMethodRewriter) : "Desugaring of " + instruction + " in method " + context.toSourceString() + " has multiple matches: " + appliedDesugaring.getClass().getName() + " and " + desugaring.getClass().getName();
        });
        return true;
    }

    @Override
    public void prepare(ProgramMethod method, ProgramAdditions programAdditions) {
        this.ensureCfCode(method);
        this.desugarings.forEach(d -> d.prepare(method, programAdditions));
    }

    @Override
    public void scan(ProgramMethod method, CfInstructionDesugaringEventConsumer eventConsumer) {
        this.ensureCfCode(method);
        this.desugarings.forEach(d -> d.scan(method, eventConsumer));
    }

    @Override
    public void desugar(ProgramMethod method, CompilationContext.MethodProcessingContext methodProcessingContext, CfInstructionDesugaringEventConsumer eventConsumer) {
        this.ensureCfCode(method);
        CfCode cfCode = ((DexEncodedMethod)method.getDefinition()).getCode().asCfCode();
        IntBox maxLocalsForCode = new IntBox(cfCode.getMaxLocals());
        IntBox maxLocalsForInstruction = new IntBox(cfCode.getMaxLocals());
        IntBox maxStackForCode = new IntBox(cfCode.getMaxStack());
        IntBox maxStackForInstruction = new IntBox(cfCode.getMaxStack());
        List<CfInstruction> desugaredInstructions = ListUtils.flatMapSameType(cfCode.getInstructions(), instruction -> {
            Collection<CfInstruction> replacement = this.desugarInstruction((CfInstruction)instruction, maxLocalsForInstruction::getAndIncrement, maxStackForInstruction::getAndIncrement, eventConsumer, method, methodProcessingContext);
            if (replacement != null) {
                maxLocalsForCode.setMax(maxLocalsForInstruction.getAndSet(cfCode.getMaxLocals()));
                maxStackForCode.setMax(maxStackForInstruction.getAndSet(cfCode.getMaxStack()));
            } else {
                assert (maxLocalsForInstruction.get() == cfCode.getMaxLocals());
                assert (maxStackForInstruction.get() == cfCode.getMaxStack());
            }
            return replacement;
        }, null);
        if (desugaredInstructions != null) {
            assert (maxLocalsForCode.get() >= cfCode.getMaxLocals());
            assert (maxStackForCode.get() >= cfCode.getMaxStack());
            cfCode.setInstructions(desugaredInstructions);
            cfCode.setMaxLocals(maxLocalsForCode.get());
            cfCode.setMaxStack(maxStackForCode.get());
        } else assert (this.noDesugaringBecauseOfImpreciseDesugaring(method));
    }

    @Override
    public Collection<CfInstruction> desugarInstruction(CfInstruction instruction, FreshLocalProvider freshLocalProvider, LocalStackAllocator localStackAllocator, CfInstructionDesugaringEventConsumer eventConsumer, ProgramMethod context, CompilationContext.MethodProcessingContext methodProcessingContext) {
        Collection<CfInstruction> replacement = this.applyDesugaring(instruction, freshLocalProvider, localStackAllocator, eventConsumer, context, methodProcessingContext, this.desugarings.iterator());
        if (replacement != null) {
            return replacement;
        }
        return this.applyDesugaring(instruction, freshLocalProvider, localStackAllocator, eventConsumer, context, methodProcessingContext, this.yieldingDesugarings.iterator());
    }

    @Override
    public boolean needsDesugaring(ProgramMethod method) {
        if (!((DexEncodedMethod)method.getDefinition()).hasCode()) {
            return false;
        }
        Code code = ((DexEncodedMethod)method.getDefinition()).getCode();
        if (code.isDexCode()) {
            return false;
        }
        if (!code.isCfCode()) {
            throw new Unreachable("Unexpected attempt to determine if non-CF code needs desugaring");
        }
        return Iterables.any(code.asCfCode().getInstructions(), instruction -> this.needsDesugaring((CfInstruction)instruction, method));
    }

    @Override
    public <T extends Throwable> void withD8NestBasedAccessDesugaring(ThrowingConsumer<D8NestBasedAccessDesugaring, T> consumer) throws T {
        if (this.nestBasedAccessDesugaring != null) {
            assert (this.nestBasedAccessDesugaring instanceof D8NestBasedAccessDesugaring);
            consumer.accept((D8NestBasedAccessDesugaring)this.nestBasedAccessDesugaring);
        }
    }

    @Override
    public InterfaceMethodProcessorFacade getInterfaceMethodPostProcessingDesugaringD8(InterfaceMethodRewriter.Flavor flavor, InterfaceProcessor interfaceProcessor) {
        return this.interfaceMethodRewriter != null ? this.interfaceMethodRewriter.getPostProcessingDesugaringD8(flavor, interfaceProcessor) : null;
    }

    @Override
    public InterfaceMethodProcessorFacade getInterfaceMethodPostProcessingDesugaringR8(InterfaceMethodRewriter.Flavor flavor, Predicate<ProgramMethod> isLiveMethod, InterfaceProcessor processor) {
        return this.interfaceMethodRewriter != null ? this.interfaceMethodRewriter.getPostProcessingDesugaringR8(flavor, isLiveMethod, processor) : null;
    }

    @Override
    public void withDesugaredLibraryAPIConverter(Consumer<DesugaredLibraryAPIConverter> consumer) {
        if (this.desugaredLibraryAPIConverter != null) {
            consumer.accept(this.desugaredLibraryAPIConverter);
        }
    }
}

