/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.r8.ir.desugar;

import com.android.tools.r8.graph.AppView;
import com.android.tools.r8.graph.DexProto;
import com.android.tools.r8.graph.DexType;
import com.android.tools.r8.ir.desugar.desugaredlibrary.machinespecification.MachineDesugaredLibrarySpecification;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Consumer;

public abstract class TypeRewriter {
    public static TypeRewriter empty() {
        return new EmptyPrefixRewritingMapper();
    }

    public abstract void rewriteType(DexType var1, DexType var2);

    public abstract DexType rewrittenType(DexType var1, AppView<?> var2);

    public abstract DexType rewrittenContextType(DexType var1);

    public boolean hasRewrittenType(DexType type, AppView<?> appView) {
        return this.rewrittenType(type, appView) != null;
    }

    public boolean hasRewrittenTypeInSignature(DexProto proto, AppView<?> appView) {
        if (this.hasRewrittenType(proto.returnType, appView)) {
            return true;
        }
        for (DexType paramType : proto.parameters.values) {
            if (!this.hasRewrittenType(paramType, appView)) continue;
            return true;
        }
        return false;
    }

    public abstract boolean isRewriting();

    public abstract void forAllRewrittenTypes(Consumer<DexType> var1);

    public static class EmptyPrefixRewritingMapper
    extends TypeRewriter {
        @Override
        public DexType rewrittenType(DexType type, AppView<?> appView) {
            return null;
        }

        @Override
        public DexType rewrittenContextType(DexType type) {
            return null;
        }

        @Override
        public void rewriteType(DexType type, DexType rewrittenType) {
        }

        @Override
        public boolean isRewriting() {
            return false;
        }

        @Override
        public void forAllRewrittenTypes(Consumer<DexType> consumer) {
        }
    }

    public static class MachineDesugarPrefixRewritingMapper
    extends TypeRewriter {
        private final Map<DexType, DexType> rewriteType;
        private final Map<DexType, DexType> rewriteDerivedTypeOnly;

        public MachineDesugarPrefixRewritingMapper(MachineDesugaredLibrarySpecification specification) {
            this.rewriteType = new ConcurrentHashMap<DexType, DexType>(specification.getRewriteType());
            this.rewriteDerivedTypeOnly = specification.getRewriteDerivedTypeOnly();
        }

        @Override
        public DexType rewrittenType(DexType type, AppView<?> appView) {
            if (type.isArrayType()) {
                DexType rewrittenBaseType = this.rewrittenType(type.toBaseType(appView.dexItemFactory()), appView);
                if (rewrittenBaseType == null) {
                    return null;
                }
                return appView.dexItemFactory().createArrayType(type.getNumberOfLeadingSquareBrackets(), rewrittenBaseType);
            }
            return this.rewriteType.get(type);
        }

        @Override
        public DexType rewrittenContextType(DexType context) {
            assert (!context.isArrayType());
            if (this.rewriteType.containsKey(context)) {
                return this.rewriteType.get(context);
            }
            return this.rewriteDerivedTypeOnly.get(context);
        }

        @Override
        public void rewriteType(DexType type, DexType rewrittenType) {
            this.rewriteType.compute(type, (t, val) -> {
                assert (val == null || val == rewrittenType);
                return rewrittenType;
            });
        }

        @Override
        public boolean isRewriting() {
            return true;
        }

        @Override
        public void forAllRewrittenTypes(Consumer<DexType> consumer) {
            this.rewriteType.keySet().forEach(consumer);
        }
    }
}

