/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.r8.ir.desugar.constantdynamic;

import com.android.tools.r8.cf.code.CfCheckCast;
import com.android.tools.r8.cf.code.CfConstClass;
import com.android.tools.r8.cf.code.CfConstDynamic;
import com.android.tools.r8.cf.code.CfConstNull;
import com.android.tools.r8.cf.code.CfConstNumber;
import com.android.tools.r8.cf.code.CfConstString;
import com.android.tools.r8.cf.code.CfFrame;
import com.android.tools.r8.cf.code.CfGoto;
import com.android.tools.r8.cf.code.CfIf;
import com.android.tools.r8.cf.code.CfInstruction;
import com.android.tools.r8.cf.code.CfInvoke;
import com.android.tools.r8.cf.code.CfLabel;
import com.android.tools.r8.cf.code.CfLoad;
import com.android.tools.r8.cf.code.CfMonitor;
import com.android.tools.r8.cf.code.CfReturn;
import com.android.tools.r8.cf.code.CfStackInstruction;
import com.android.tools.r8.cf.code.CfStaticFieldRead;
import com.android.tools.r8.cf.code.CfStaticFieldWrite;
import com.android.tools.r8.cf.code.CfStore;
import com.android.tools.r8.cf.code.CfThrow;
import com.android.tools.r8.cf.code.CfTryCatch;
import com.android.tools.r8.com.google.common.collect.ImmutableList;
import com.android.tools.r8.contexts.CompilationContext;
import com.android.tools.r8.graph.AppView;
import com.android.tools.r8.graph.CfCode;
import com.android.tools.r8.graph.Code;
import com.android.tools.r8.graph.DexEncodedField;
import com.android.tools.r8.graph.DexEncodedMethod;
import com.android.tools.r8.graph.DexField;
import com.android.tools.r8.graph.DexItemFactory;
import com.android.tools.r8.graph.DexMethod;
import com.android.tools.r8.graph.DexMethodHandle;
import com.android.tools.r8.graph.DexProgramClass;
import com.android.tools.r8.graph.DexType;
import com.android.tools.r8.graph.FieldAccessFlags;
import com.android.tools.r8.graph.MethodAccessFlags;
import com.android.tools.r8.graph.MethodResolutionResult;
import com.android.tools.r8.graph.ProgramMethod;
import com.android.tools.r8.ir.code.If;
import com.android.tools.r8.ir.code.Monitor;
import com.android.tools.r8.ir.code.ValueType;
import com.android.tools.r8.ir.desugar.FreshLocalProvider;
import com.android.tools.r8.ir.desugar.LocalStackAllocator;
import com.android.tools.r8.ir.desugar.constantdynamic.ConstantDynamicDesugaringEventConsumer;
import com.android.tools.r8.ir.desugar.constantdynamic.ConstantDynamicInstructionDesugaring;
import com.android.tools.r8.ir.desugar.constantdynamic.ConstantDynamicReference;
import com.android.tools.r8.ir.desugar.itf.InterfaceDesugaringSyntheticHelper;
import com.android.tools.r8.ir.optimize.UtilityMethodsForCodeOptimizations;
import com.android.tools.r8.it.unimi.dsi.fastutil.ints.Int2ReferenceSortedMap;
import com.android.tools.r8.synthesis.SyntheticProgramClassBuilder;
import com.android.tools.r8.utils.AndroidApiLevel;
import com.android.tools.r8.utils.ListUtils;
import com.android.tools.r8.utils.collections.ImmutableDeque;
import com.android.tools.r8.utils.collections.ImmutableInt2ReferenceSortedMap;
import java.util.Collection;
import java.util.List;

public class ConstantDynamicClass {
    public static final String INITIALIZED_FIELD_NAME = "INITIALIZED";
    public static final String CONST_FIELD_NAME = "CONST";
    private final AppView<?> appView;
    private final ConstantDynamicInstructionDesugaring desugaring;
    private final ProgramMethod context;
    public final ConstantDynamicReference reference;
    public final DexField initializedValueField;
    public final DexField constantValueField;
    private final DexMethod getConstMethod;
    private final Behaviour behaviour;
    private DexMethod bootstrapMethodReference;
    private DexMethod finalBootstrapMethodReference;
    private boolean isFinalBootstrapMethodReferenceOnInterface;
    private DexProgramClass clazz = null;

    public ConstantDynamicClass(SyntheticProgramClassBuilder builder, AppView<?> appView, ConstantDynamicInstructionDesugaring desugaring, ProgramMethod context, CfConstDynamic constantDynamic) {
        DexItemFactory factory = appView.dexItemFactory();
        this.appView = appView;
        this.desugaring = desugaring;
        this.context = context;
        this.reference = constantDynamic.getReference();
        this.constantValueField = factory.createField(builder.getType(), constantDynamic.getType(), factory.createString(CONST_FIELD_NAME));
        this.initializedValueField = factory.createField(builder.getType(), factory.booleanType, factory.createString(INITIALIZED_FIELD_NAME));
        this.getConstMethod = factory.createMethod(builder.getType(), factory.createProto(constantDynamic.getType(), new DexType[0]), factory.createString("get"));
        DexMethodHandle bootstrapMethodHandle = this.reference.getBootstrapMethod();
        this.bootstrapMethodReference = bootstrapMethodHandle.asMethod();
        MethodResolutionResult resolution = appView.appInfoForDesugaring().resolveMethod(this.bootstrapMethodReference, bootstrapMethodHandle.isInterface);
        if (resolution.isSingleResolution() && resolution.asSingleResolution().getResolvedMethod().isStatic()) {
            MethodResolutionResult.SingleResolutionResult result = resolution.asSingleResolution();
            if (bootstrapMethodHandle.isInterface && appView.options().isInterfaceMethodDesugaringEnabled()) {
                this.bootstrapMethodReference = this.bootstrapMethodReference.withHolder(InterfaceDesugaringSyntheticHelper.getCompanionClassType(this.bootstrapMethodReference.getHolderType(), factory), factory);
                this.isFinalBootstrapMethodReferenceOnInterface = false;
            } else {
                assert (this.bootstrapMethodReference.getHolderType() == resolution.getResolvedHolder().getType());
                this.isFinalBootstrapMethodReferenceOnInterface = bootstrapMethodHandle.isInterface;
            }
            if (this.shouldRewriteBootstrapMethodSignature()) {
                this.finalBootstrapMethodReference = factory.createMethod(this.bootstrapMethodReference.getHolderType(), factory.createProto(this.bootstrapMethodReference.getReturnType(), factory.objectType, factory.stringType, factory.classType), this.bootstrapMethodReference.getName());
            } else {
                this.finalBootstrapMethodReference = this.bootstrapMethodReference;
                DexEncodedMethod bootstrapMethodImpl = result.getResolvedMethod();
                MethodAccessFlags flags = bootstrapMethodImpl.getAccessFlags();
                flags.unsetPrivate();
                flags.setPublic();
            }
            this.behaviour = Behaviour.CACHE_CONSTANT;
            this.synthesizeConstantDynamicClass(builder);
        } else {
            this.behaviour = resolution.isNoSuchMethodErrorResult(context.getContextClass(), appView.appInfoForDesugaring()) ? Behaviour.THROW_NSME : Behaviour.THROW_ICCE;
        }
    }

    private boolean shouldRewriteBootstrapMethodSignature() {
        return !this.appView.enableWholeProgramOptimizations() && this.appView.options().getMinApiLevel().isLessThan(AndroidApiLevel.O);
    }

    private Collection<CfInstruction> desugarToThrow(UtilityMethodsForCodeOptimizations.MethodSynthesizerConsumer methodSynthesizerConsumer, ConstantDynamicDesugaringEventConsumer eventConsumer, ProgramMethod context, CompilationContext.MethodProcessingContext methodProcessingContext) {
        UtilityMethodsForCodeOptimizations.UtilityMethodForCodeOptimizations throwMethod = methodSynthesizerConsumer.synthesizeMethod(this.appView, methodProcessingContext);
        ProgramMethod throwProgramMethod = throwMethod.uncheckedGetMethod();
        eventConsumer.acceptThrowMethod(throwProgramMethod, context);
        return ImmutableList.of(new CfInvoke(184, (DexMethod)throwProgramMethod.getReference(), false));
    }

    private void synthesizeConstantDynamicClass(SyntheticProgramClassBuilder builder) {
        this.synthesizeStaticFields(builder);
        this.synthesizeDirectMethods(builder);
    }

    private void synthesizeStaticFields(SyntheticProgramClassBuilder builder) {
        builder.setStaticFields(ImmutableList.of(DexEncodedField.syntheticBuilder().setField(this.initializedValueField).setAccessFlags(FieldAccessFlags.createPrivateStaticSynthetic()).disableAndroidApiLevelCheck().build(), DexEncodedField.syntheticBuilder().setField(this.constantValueField).setAccessFlags(FieldAccessFlags.createPrivateStaticSynthetic()).disableAndroidApiLevelCheck().build()));
    }

    private void synthesizeDirectMethods(SyntheticProgramClassBuilder builder) {
        builder.setDirectMethods(ImmutableList.of(DexEncodedMethod.syntheticBuilder().setMethod(this.getConstMethod).setAccessFlags(MethodAccessFlags.createPublicStaticSynthetic()).setCode(this.generateGetterCode(builder)).disableAndroidApiLevelCheck().build()));
    }

    private void invokeBootstrapMethod(ImmutableList.Builder<CfInstruction> instructions) {
        assert (this.reference.getBootstrapMethod().type.isInvokeStatic());
        instructions.add((Object)new CfConstNull());
        instructions.add((Object)new CfConstString(this.reference.getName()));
        instructions.add((Object)new CfConstClass(this.reference.getType()));
        instructions.add((Object)new CfInvoke(184, this.finalBootstrapMethodReference, this.isFinalBootstrapMethodReferenceOnInterface));
        instructions.add((Object)new CfCheckCast(this.reference.getType()));
    }

    private CfCode generateGetterCode(SyntheticProgramClassBuilder builder) {
        int maxStack = 3;
        int maxLocals = 2;
        ImmutableList<CfCode.LocalVariableInfo> localVariables = ImmutableList.of();
        ImmutableList.Builder<CfInstruction> instructions = ImmutableList.builder();
        CfLabel initializedTrue = new CfLabel();
        CfLabel initializedTrueSecond = new CfLabel();
        CfLabel tryCatchStart = new CfLabel();
        CfLabel tryCatchEnd = new CfLabel();
        CfLabel tryCatchTarget = new CfLabel();
        CfLabel tryCatchEndFinally = new CfLabel();
        instructions.add((Object)new CfStaticFieldRead(this.initializedValueField));
        instructions.add((Object)new CfIf(If.Type.NE, ValueType.INT, initializedTrue));
        instructions.add((Object)new CfConstClass(builder.getType()));
        instructions.add((Object)new CfStackInstruction(CfStackInstruction.Opcode.Dup));
        instructions.add((Object)new CfStore(ValueType.OBJECT, 0));
        instructions.add((Object)new CfMonitor(Monitor.Type.ENTER));
        instructions.add((Object)tryCatchStart);
        instructions.add((Object)new CfStaticFieldRead(this.initializedValueField));
        instructions.add((Object)new CfIf(If.Type.NE, ValueType.INT, initializedTrueSecond));
        this.invokeBootstrapMethod(instructions);
        instructions.add((Object)new CfStaticFieldWrite(this.constantValueField));
        instructions.add((Object)new CfConstNumber(1L, ValueType.INT));
        instructions.add((Object)new CfStaticFieldWrite(this.initializedValueField));
        instructions.add((Object)initializedTrueSecond);
        instructions.add((Object)new CfFrame((Int2ReferenceSortedMap<CfFrame.FrameType>)ImmutableInt2ReferenceSortedMap.of(new int[]{0}, new CfFrame.FrameType[]{CfFrame.FrameType.initialized(builder.getFactory().objectType)}), ImmutableDeque.of(new CfFrame.FrameType[0])));
        instructions.add((Object)new CfLoad(ValueType.OBJECT, 0));
        instructions.add((Object)new CfMonitor(Monitor.Type.EXIT));
        instructions.add((Object)tryCatchEnd);
        instructions.add((Object)new CfGoto(initializedTrue));
        instructions.add((Object)tryCatchTarget);
        instructions.add((Object)new CfFrame((Int2ReferenceSortedMap<CfFrame.FrameType>)ImmutableInt2ReferenceSortedMap.of(new int[]{0}, new CfFrame.FrameType[]{CfFrame.FrameType.initialized(builder.getFactory().objectType)}), ImmutableDeque.of(CfFrame.FrameType.initialized(builder.getFactory().throwableType))));
        instructions.add((Object)new CfStore(ValueType.OBJECT, 1));
        instructions.add((Object)new CfLoad(ValueType.OBJECT, 0));
        instructions.add((Object)new CfMonitor(Monitor.Type.EXIT));
        instructions.add((Object)tryCatchEndFinally);
        instructions.add((Object)new CfLoad(ValueType.OBJECT, 1));
        instructions.add((Object)new CfThrow());
        instructions.add((Object)initializedTrue);
        instructions.add((Object)new CfFrame((Int2ReferenceSortedMap<CfFrame.FrameType>)ImmutableInt2ReferenceSortedMap.empty(), ImmutableDeque.of(new CfFrame.FrameType[0])));
        instructions.add((Object)new CfStaticFieldRead(this.constantValueField));
        instructions.add((Object)new CfReturn(ValueType.OBJECT));
        ImmutableList<CfTryCatch> tryCatchRanges = ImmutableList.of(new CfTryCatch(tryCatchStart, tryCatchEnd, ImmutableList.of(builder.getFactory().throwableType), ImmutableList.of(tryCatchTarget)), new CfTryCatch(tryCatchTarget, tryCatchEndFinally, ImmutableList.of(builder.getFactory().throwableType), ImmutableList.of(tryCatchTarget)));
        return new CfCode(builder.getType(), maxStack, maxLocals, (List<CfInstruction>)((Object)instructions.build()), tryCatchRanges, localVariables);
    }

    private DexType mapLookupTypeToObject(DexType type) {
        return type == this.appView.dexItemFactory().lookupType ? this.appView.dexItemFactory().objectType : type;
    }

    private Code adaptCode(DexEncodedMethod method) {
        assert (this.behaviour == Behaviour.CACHE_CONSTANT);
        if (method.getCode().isDexCode()) {
            return method.getCode();
        }
        CfCode code = method.getCode().asCfCode();
        List<CfInstruction> newInstructions = ListUtils.mapOrElse(code.getInstructions(), instruction -> instruction.isFrame() ? instruction.asFrame().map(this::mapLookupTypeToObject) : instruction);
        return code.getInstructions() != newInstructions ? new CfCode(method.getHolderType(), code.getMaxStack(), code.getMaxLocals(), newInstructions, code.getTryCatchRanges(), code.getLocalVariables()) : code;
    }

    public Collection<CfInstruction> desugarConstDynamicInstruction(CfConstDynamic invoke, FreshLocalProvider freshLocalProvider, LocalStackAllocator localStackAllocator, ConstantDynamicDesugaringEventConsumer eventConsumer, ProgramMethod context, CompilationContext.MethodProcessingContext methodProcessingContext) {
        assert (invoke.getReference().equals(this.reference));
        if (this.behaviour == Behaviour.CACHE_CONSTANT) {
            return ImmutableList.of(new CfInvoke(184, this.getConstMethod, false));
        }
        return this.desugarToThrow(this.behaviour == Behaviour.THROW_NSME ? UtilityMethodsForCodeOptimizations::synthesizeThrowNoSuchMethodErrorMethod : UtilityMethodsForCodeOptimizations::synthesizeThrowIncompatibleClassChangeErrorMethod, eventConsumer, context, methodProcessingContext);
    }

    public final DexProgramClass getConstantDynamicProgramClass() {
        assert (this.clazz != null);
        return this.clazz;
    }

    public void setClass(DexProgramClass clazz) {
        assert (this.clazz == null);
        assert (clazz != null);
        this.clazz = clazz;
    }

    public void rewriteBootstrapMethodSignatureIfNeeded() {
        if (!this.shouldRewriteBootstrapMethodSignature() || this.behaviour != Behaviour.CACHE_CONSTANT) {
            return;
        }
        DexProgramClass bootstrapMethodHolder = this.appView.definitionFor(this.bootstrapMethodReference.getHolderType()).asProgramClass();
        DexEncodedMethod replacement = bootstrapMethodHolder.getMethodCollection().replaceDirectMethod(this.bootstrapMethodReference, encodedMethod -> {
            MethodAccessFlags newAccessFlags = encodedMethod.accessFlags.copy();
            newAccessFlags.unsetPrivate();
            newAccessFlags.setPublic();
            DexEncodedMethod newMethod = DexEncodedMethod.syntheticBuilder().setMethod(this.finalBootstrapMethodReference).setAccessFlags(newAccessFlags).setGenericSignature(encodedMethod.getGenericSignature()).setAnnotations(encodedMethod.annotations()).setParameterAnnotations(encodedMethod.parameterAnnotationsList).setCode(this.adaptCode((DexEncodedMethod)encodedMethod)).setApiLevelForDefinition(encodedMethod.getApiLevelForDefinition()).setApiLevelForCode(encodedMethod.getApiLevelForCode()).build();
            newMethod.copyMetadata(this.appView, (DexEncodedMethod)encodedMethod);
            return newMethod;
        });
        if (replacement != null) {
            assert (!this.appView.options().isGeneratingClassFiles() || replacement.getCode().isCfCode());
            assert (!this.appView.options().isGeneratingDex() || replacement.getCode().isDexCode());
        }
        ProgramMethod modified = bootstrapMethodHolder.lookupProgramMethod(this.finalBootstrapMethodReference);
        assert (modified != null);
        assert (((DexEncodedMethod)modified.getDefinition()).isPublicMethod());
    }

    static enum Behaviour {
        CACHE_CONSTANT,
        THROW_NSME,
        THROW_ICCE;

    }
}

