/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.r8.ir.desugar.desugaredlibrary.apiconversion;

import com.android.tools.r8.cf.code.CfArrayLoad;
import com.android.tools.r8.cf.code.CfArrayStore;
import com.android.tools.r8.cf.code.CfCheckCast;
import com.android.tools.r8.cf.code.CfConstNumber;
import com.android.tools.r8.cf.code.CfInstruction;
import com.android.tools.r8.cf.code.CfInvoke;
import com.android.tools.r8.cf.code.CfLoad;
import com.android.tools.r8.cf.code.CfNewArray;
import com.android.tools.r8.cf.code.CfReturn;
import com.android.tools.r8.cf.code.CfStackInstruction;
import com.android.tools.r8.com.google.common.collect.Iterables;
import com.android.tools.r8.com.google.common.collect.Sets;
import com.android.tools.r8.contexts.CompilationContext;
import com.android.tools.r8.graph.AppView;
import com.android.tools.r8.graph.CfCode;
import com.android.tools.r8.graph.DexClass;
import com.android.tools.r8.graph.DexClassAndMethod;
import com.android.tools.r8.graph.DexItemFactory;
import com.android.tools.r8.graph.DexMethod;
import com.android.tools.r8.graph.DexProto;
import com.android.tools.r8.graph.DexString;
import com.android.tools.r8.graph.DexType;
import com.android.tools.r8.graph.MethodAccessFlags;
import com.android.tools.r8.graph.ProgramMethod;
import com.android.tools.r8.ir.code.MemberType;
import com.android.tools.r8.ir.code.ValueType;
import com.android.tools.r8.ir.desugar.CfInstructionDesugaring;
import com.android.tools.r8.ir.desugar.CfInstructionDesugaringCollection;
import com.android.tools.r8.ir.desugar.CfInstructionDesugaringEventConsumer;
import com.android.tools.r8.ir.desugar.FreshLocalProvider;
import com.android.tools.r8.ir.desugar.LocalStackAllocator;
import com.android.tools.r8.ir.desugar.desugaredlibrary.apiconversion.DesugaredLibraryWrapperSynthesizer;
import com.android.tools.r8.ir.desugar.desugaredlibrary.apiconversion.DesugaredLibraryWrapperSynthesizerEventConsumer;
import com.android.tools.r8.ir.synthetic.DesugaredLibraryAPIConversionCfCodeProvider;
import com.android.tools.r8.utils.DescriptorUtils;
import com.android.tools.r8.utils.StringDiagnostic;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Set;

public class DesugaredLibraryAPIConverter
implements CfInstructionDesugaring {
    static final String VIVIFIED_PREFIX = "$-vivified-$.";
    public static final String DESCRIPTOR_VIVIFIED_PREFIX = "L$-vivified-$/";
    private final AppView<?> appView;
    private final DexItemFactory factory;
    private final Set<CfInstructionDesugaring> precedingDesugarings;
    private final Set<DexString> emulatedMethods;
    private final DesugaredLibraryWrapperSynthesizer wrapperSynthesizor;
    private final Set<DexMethod> trackedAPIs;

    public DesugaredLibraryAPIConverter(AppView<?> appView, Set<CfInstructionDesugaring> precedingDesugarings, Set<DexString> emulatedMethods) {
        this.appView = appView;
        this.factory = appView.dexItemFactory();
        this.precedingDesugarings = precedingDesugarings;
        this.emulatedMethods = emulatedMethods;
        this.wrapperSynthesizor = new DesugaredLibraryWrapperSynthesizer(appView);
        this.trackedAPIs = appView.options().testing.trackDesugaredAPIConversions ? Sets.newConcurrentHashSet() : null;
    }

    static boolean isAPIConversionSyntheticType(DexType type, DesugaredLibraryWrapperSynthesizer wrapperSynthesizor, AppView<?> appView) {
        return wrapperSynthesizor.isSyntheticWrapper(type) || appView.getSyntheticItems().isSyntheticOfKind(type, kinds -> kinds.API_CONVERSION);
    }

    public static boolean isVivifiedType(DexType type) {
        return type.descriptor.toString().startsWith(DESCRIPTOR_VIVIFIED_PREFIX);
    }

    private DexClassAndMethod getMethodForDesugaring(CfInvoke invoke, ProgramMethod context) {
        DexMethod invokedMethod = invoke.getMethod();
        return invoke.isInvokeSuper(context.getHolderType()) ? this.appView.appInfoForDesugaring().lookupSuperTarget(invokedMethod, context) : this.appView.appInfoForDesugaring().resolveMethod(invokedMethod, invoke.isInterface()).getResolutionPair();
    }

    private boolean shouldRewriteInvoke(CfInvoke invoke, ProgramMethod context) {
        DexClassAndMethod invokedMethod = this.getMethodForDesugaring(invoke, context);
        if (invokedMethod == null) {
            return false;
        }
        DexType holderType = invokedMethod.getHolderType();
        if (this.appView.typeRewriter.hasRewrittenType(holderType, this.appView) || holderType.isArrayType()) {
            return false;
        }
        DexClass dexClass = this.appView.definitionFor(holderType);
        if (dexClass == null || !dexClass.isLibraryClass()) {
            return false;
        }
        if (this.isEmulatedInterfaceOverride(invokedMethod)) {
            return false;
        }
        if (this.isAlreadyDesugared(invoke, context)) {
            return false;
        }
        return this.appView.typeRewriter.hasRewrittenTypeInSignature(invokedMethod.getProto(), this.appView);
    }

    private boolean isEmulatedInterfaceOverride(DexClassAndMethod invokedMethod) {
        if (!this.emulatedMethods.contains(invokedMethod.getName())) {
            return false;
        }
        DexClassAndMethod interfaceResult = this.appView.appInfoForDesugaring().lookupMaximallySpecificMethod(invokedMethod.getHolder(), (DexMethod)invokedMethod.getReference());
        return interfaceResult != null && this.appView.options().machineDesugaredLibrarySpecification.getEmulatedInterfaces().containsKey(interfaceResult.getHolderType());
    }

    private boolean isAlreadyDesugared(CfInvoke invoke, ProgramMethod context) {
        return Iterables.any(this.precedingDesugarings, desugaring -> desugaring.needsDesugaring(invoke, context));
    }

    public static DexMethod methodWithVivifiedTypeInSignature(DexMethod originalMethod, DexType holder, AppView<?> appView) {
        DexType[] newParameters = (DexType[])originalMethod.proto.parameters.values.clone();
        int index = 0;
        for (DexType param : originalMethod.proto.parameters.values) {
            if (appView.typeRewriter.hasRewrittenType(param, appView)) {
                newParameters[index] = DesugaredLibraryAPIConverter.vivifiedTypeFor(param, appView);
            }
            ++index;
        }
        DexType returnType = originalMethod.proto.returnType;
        DexType newReturnType = appView.typeRewriter.hasRewrittenType(returnType, appView) ? DesugaredLibraryAPIConverter.vivifiedTypeFor(returnType, appView) : returnType;
        DexProto newProto = appView.dexItemFactory().createProto(newReturnType, newParameters);
        return appView.dexItemFactory().createMethod(holder, newProto, originalMethod.name);
    }

    static void generateTrackDesugaredAPIWarnings(Set<DexMethod> tracked, String inner, AppView<?> appView) {
        if (!appView.options().testing.trackDesugaredAPIConversions) {
            return;
        }
        StringBuilder sb = new StringBuilder();
        sb.append("Tracked ").append(inner).append("desugared API conversions: ");
        for (DexMethod method : tracked) {
            sb.append("\n");
            sb.append(method);
        }
        appView.options().reporter.warning(new StringDiagnostic(sb.toString()));
        tracked.clear();
    }

    public static DexType vivifiedTypeFor(DexType type, AppView<?> appView) {
        DexType vivifiedType = appView.dexItemFactory().createSynthesizedType(DescriptorUtils.javaTypeToDescriptor(VIVIFIED_PREFIX + type.toString()));
        appView.typeRewriter.rewriteType(vivifiedType, type);
        return vivifiedType;
    }

    private static DexType invalidType(DexMethod invokedMethod, DexMethod returnConversion, DexMethod[] parameterConversions, AppView<?> appView) {
        DexMethod convertedMethod = DesugaredLibraryAPIConverter.methodWithVivifiedTypeInSignature(invokedMethod, invokedMethod.holder, appView);
        if (invokedMethod.getReturnType() != convertedMethod.getReturnType() && returnConversion == null) {
            return invokedMethod.getReturnType();
        }
        for (int i = 0; i < invokedMethod.getArity(); ++i) {
            if (invokedMethod.getParameter(i) == convertedMethod.getParameter(i) || parameterConversions[i] != null) continue;
            return invokedMethod.getParameter(i);
        }
        return null;
    }

    public static DexMethod getConvertedAPI(DexMethod invokedMethod, DexMethod returnConversion, DexMethod[] parameterConversions, AppView<?> appView) {
        DexType newReturnType = returnConversion != null ? returnConversion.getParameter(0) : invokedMethod.getReturnType();
        DexType[] newParameterTypes = new DexType[parameterConversions.length];
        for (int i = 0; i < parameterConversions.length; ++i) {
            newParameterTypes[i] = parameterConversions[i] != null ? parameterConversions[i].getReturnType() : invokedMethod.getParameter(i);
        }
        DexMethod convertedAPI = appView.dexItemFactory().createMethod(invokedMethod.holder, appView.dexItemFactory().createProto(newReturnType, newParameterTypes), invokedMethod.name);
        assert (convertedAPI == DesugaredLibraryAPIConverter.methodWithVivifiedTypeInSignature(invokedMethod, invokedMethod.holder, appView) || DesugaredLibraryAPIConverter.invalidType(invokedMethod, returnConversion, parameterConversions, appView) != null);
        return convertedAPI;
    }

    private DexMethod computeReturnConversion(DexMethod invokedMethod, DesugaredLibraryWrapperSynthesizerEventConsumer.DesugaredLibraryClasspathWrapperSynthesizeEventConsumer eventConsumer, ProgramMethod context, CompilationContext.MethodProcessingContext methodProcessingContext) {
        DexType returnType = invokedMethod.proto.returnType;
        if (this.wrapperSynthesizor.shouldConvert(returnType, invokedMethod, context)) {
            DexType newReturnType = DesugaredLibraryAPIConverter.vivifiedTypeFor(returnType, this.appView);
            return this.wrapperSynthesizor.ensureConversionMethod(returnType, newReturnType, returnType, eventConsumer, methodProcessingContext::createUniqueContext);
        }
        return null;
    }

    private DexMethod[] computeParameterConversions(DexMethod invokedMethod, DesugaredLibraryWrapperSynthesizerEventConsumer.DesugaredLibraryClasspathWrapperSynthesizeEventConsumer eventConsumer, ProgramMethod context, CompilationContext.MethodProcessingContext methodProcessingContext) {
        DexMethod[] parameterConversions = new DexMethod[invokedMethod.getArity()];
        DexType[] parameters = invokedMethod.proto.parameters.values;
        for (int i = 0; i < parameters.length; ++i) {
            DexType argType = parameters[i];
            if (!this.wrapperSynthesizor.shouldConvert(argType, invokedMethod, context)) continue;
            DexType argVivifiedType = DesugaredLibraryAPIConverter.vivifiedTypeFor(argType, this.appView);
            parameterConversions[i] = this.wrapperSynthesizor.ensureConversionMethod(argType, argType, argVivifiedType, eventConsumer, methodProcessingContext::createUniqueContext);
        }
        return parameterConversions;
    }

    private Collection<CfInstruction> rewriteLibraryInvoke(CfInvoke invoke, CompilationContext.MethodProcessingContext methodProcessingContext, LocalStackAllocator localStackAllocator, CfInstructionDesugaringEventConsumer eventConsumer, ProgramMethod context) {
        DexMethod invokedMethod = invoke.getMethod();
        if (this.trackedAPIs != null) {
            this.trackedAPIs.add(invokedMethod);
        }
        if (this.shouldOutlineAPIConversion(invoke, context)) {
            DexMethod outlinedAPIConversion = this.createOutlinedAPIConversion(invoke, methodProcessingContext, eventConsumer, context);
            return Collections.singletonList(new CfInvoke(184, outlinedAPIConversion, false));
        }
        return this.rewriteLibraryInvokeToInlineAPIConversion(invoke, methodProcessingContext, localStackAllocator, eventConsumer, context);
    }

    private boolean shouldOutlineAPIConversion(CfInvoke invoke, ProgramMethod context) {
        if (invoke.isInvokeSuper(context.getHolderType())) {
            return false;
        }
        if (invoke.getMethod().isInstanceInitializer(this.appView.dexItemFactory())) {
            return false;
        }
        DexClassAndMethod methodForDesugaring = this.getMethodForDesugaring(invoke, context);
        assert (methodForDesugaring != null);
        return methodForDesugaring.getAccessFlags().isPublic();
    }

    private Collection<CfInstruction> rewriteLibraryInvokeToInlineAPIConversion(CfInvoke invoke, CompilationContext.MethodProcessingContext methodProcessingContext, LocalStackAllocator localStackAllocator, CfInstructionDesugaringEventConsumer eventConsumer, ProgramMethod context) {
        DexMethod invokedMethod = invoke.getMethod();
        DexMethod returnConversion = this.computeReturnConversion(invokedMethod, eventConsumer, context, methodProcessingContext);
        DexMethod[] parameterConversions = this.computeParameterConversions(invokedMethod, eventConsumer, context, methodProcessingContext);
        boolean requireOutlinedParameterConversion = false;
        for (int i = 0; i < parameterConversions.length - 2; ++i) {
            requireOutlinedParameterConversion |= parameterConversions[i] != null;
        }
        ArrayList<CfInstruction> cfInstructions = new ArrayList<CfInstruction>();
        if (requireOutlinedParameterConversion) {
            this.addOutlineParameterConversionInstructions(parameterConversions, cfInstructions, methodProcessingContext, invokedMethod, localStackAllocator, eventConsumer);
        } else {
            this.addInlineParameterConversionInstructions(parameterConversions, cfInstructions);
        }
        DexMethod convertedMethod = DesugaredLibraryAPIConverter.getConvertedAPI(invokedMethod, returnConversion, parameterConversions, this.appView);
        cfInstructions.add(new CfInvoke(invoke.getOpcode(), convertedMethod, invoke.isInterface()));
        if (returnConversion != null) {
            cfInstructions.add(new CfInvoke(184, returnConversion, false));
        }
        return cfInstructions;
    }

    private void addOutlineParameterConversionInstructions(DexMethod[] parameterConversions, ArrayList<CfInstruction> cfInstructions, CompilationContext.MethodProcessingContext methodProcessingContext, DexMethod invokedMethod, LocalStackAllocator localStackAllocator, CfInstructionDesugaringEventConsumer eventConsumer) {
        localStackAllocator.allocateLocalStack(4);
        DexProto newProto = this.appView.dexItemFactory().createProto(this.appView.dexItemFactory().objectArrayType, invokedMethod.getParameters().values);
        ProgramMethod parameterConversion = this.appView.getSyntheticItems().createMethod(kinds -> kinds.API_CONVERSION_PARAMETERS, methodProcessingContext.createUniqueContext(), this.appView, builder -> builder.setProto(newProto).setAccessFlags(MethodAccessFlags.createPublicStaticSynthetic()).disableAndroidApiLevelCheck().setCode(methodSignature -> this.computeParameterConversionCfCode(methodSignature.holder, invokedMethod, parameterConversions)));
        eventConsumer.acceptAPIConversion(parameterConversion);
        cfInstructions.add(new CfInvoke(184, (DexMethod)parameterConversion.getReference(), false));
        for (int i = 0; i < parameterConversions.length; ++i) {
            cfInstructions.add(new CfStackInstruction(CfStackInstruction.Opcode.Dup));
            cfInstructions.add(new CfConstNumber(i, ValueType.INT));
            DexType parameterType = parameterConversions[i] != null ? parameterConversions[i].getReturnType() : invokedMethod.getParameter(i);
            cfInstructions.add(new CfArrayLoad(MemberType.OBJECT));
            if (parameterType.isPrimitiveType()) {
                cfInstructions.add(new CfCheckCast(this.factory.getBoxedForPrimitiveType(parameterType)));
                DexMethod method = this.appView.dexItemFactory().getUnboxPrimitiveMethod(parameterType);
                cfInstructions.add(new CfInvoke(182, method, false));
            } else {
                cfInstructions.add(new CfCheckCast(parameterType));
            }
            cfInstructions.add(new CfStackInstruction(CfStackInstruction.Opcode.Swap));
        }
        cfInstructions.add(new CfStackInstruction(CfStackInstruction.Opcode.Pop));
    }

    private CfCode computeParameterConversionCfCode(DexType holder, DexMethod invokedMethod, DexMethod[] parameterConversions) {
        ArrayList<CfInstruction> cfInstructions = new ArrayList<CfInstruction>();
        cfInstructions.add(new CfConstNumber(parameterConversions.length, ValueType.INT));
        cfInstructions.add(new CfNewArray(this.factory.objectArrayType));
        int stackIndex = 0;
        for (int i = 0; i < invokedMethod.getArity(); ++i) {
            cfInstructions.add(new CfStackInstruction(CfStackInstruction.Opcode.Dup));
            cfInstructions.add(new CfConstNumber(i, ValueType.INT));
            DexType param = invokedMethod.getParameter(i);
            cfInstructions.add(new CfLoad(ValueType.fromDexType(param), stackIndex));
            if (parameterConversions[i] != null) {
                cfInstructions.add(new CfInvoke(184, parameterConversions[i], false));
            }
            if (param.isPrimitiveType()) {
                DexMethod method = this.appView.dexItemFactory().getBoxPrimitiveMethod(param);
                cfInstructions.add(new CfInvoke(184, method, false));
            }
            cfInstructions.add(new CfArrayStore(MemberType.OBJECT));
            if (param == this.appView.dexItemFactory().longType || param == this.appView.dexItemFactory().doubleType) {
                ++stackIndex;
            }
            ++stackIndex;
        }
        cfInstructions.add(new CfReturn(ValueType.OBJECT));
        return new CfCode(holder, invokedMethod.getParameters().size() + 4, invokedMethod.getParameters().size(), cfInstructions);
    }

    private void addInlineParameterConversionInstructions(DexMethod[] parameterConversions, ArrayList<CfInstruction> cfInstructions) {
        if (parameterConversions.length > 0 && parameterConversions[parameterConversions.length - 1] != null) {
            cfInstructions.add(new CfInvoke(184, parameterConversions[parameterConversions.length - 1], false));
        }
        if (parameterConversions.length > 1 && parameterConversions[parameterConversions.length - 2] != null) {
            cfInstructions.add(new CfStackInstruction(CfStackInstruction.Opcode.Swap));
            cfInstructions.add(new CfInvoke(184, parameterConversions[parameterConversions.length - 2], false));
            cfInstructions.add(new CfStackInstruction(CfStackInstruction.Opcode.Swap));
        }
    }

    private DexMethod createOutlinedAPIConversion(CfInvoke invoke, CompilationContext.MethodProcessingContext methodProcessingContext, CfInstructionDesugaringEventConsumer eventConsumer, ProgramMethod context) {
        DexMethod invokedMethod = invoke.getMethod();
        DexProto newProto = invoke.isInvokeStatic() ? invokedMethod.proto : this.factory.prependTypeToProto(invokedMethod.getHolderType(), invokedMethod.getProto());
        DexMethod returnConversion = this.computeReturnConversion(invokedMethod, eventConsumer, context, methodProcessingContext);
        DexMethod[] parameterConversions = this.computeParameterConversions(invokedMethod, eventConsumer, context, methodProcessingContext);
        ProgramMethod outline = this.appView.getSyntheticItems().createMethod(kinds -> kinds.API_CONVERSION, methodProcessingContext.createUniqueContext(), this.appView, builder -> builder.setProto(newProto).setAccessFlags(MethodAccessFlags.createPublicStaticSynthetic()).disableAndroidApiLevelCheck().setCode(methodSignature -> new DesugaredLibraryAPIConversionCfCodeProvider.APIConversionCfCodeProvider(this.appView, methodSignature.holder, invoke, returnConversion, parameterConversions).generateCfCode()));
        eventConsumer.acceptAPIConversion(outline);
        return (DexMethod)outline.getReference();
    }

    @Override
    public Collection<CfInstruction> desugarInstruction(CfInstruction instruction, FreshLocalProvider freshLocalProvider, LocalStackAllocator localStackAllocator, CfInstructionDesugaringEventConsumer eventConsumer, ProgramMethod context, CompilationContext.MethodProcessingContext methodProcessingContext, CfInstructionDesugaringCollection desugaringCollection, DexItemFactory dexItemFactory) {
        if (this.needsDesugaring(instruction, context)) {
            assert (instruction.isInvoke());
            return this.rewriteLibraryInvoke(instruction.asInvoke(), methodProcessingContext, localStackAllocator, eventConsumer, context);
        }
        return null;
    }

    @Override
    public boolean needsDesugaring(CfInstruction instruction, ProgramMethod context) {
        if (!instruction.isInvoke()) {
            return false;
        }
        if (DesugaredLibraryAPIConverter.isAPIConversionSyntheticType(context.getHolderType(), this.wrapperSynthesizor, this.appView)) {
            return false;
        }
        return this.shouldRewriteInvoke(instruction.asInvoke(), context);
    }

    public void generateTrackingWarnings() {
        DesugaredLibraryAPIConverter.generateTrackDesugaredAPIWarnings(this.trackedAPIs, "", this.appView);
    }
}

