/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.r8.ir.desugar.desugaredlibrary.apiconversion;

import com.android.tools.r8.com.google.common.collect.Iterables;
import com.android.tools.r8.graph.AppView;
import com.android.tools.r8.graph.DexClass;
import com.android.tools.r8.graph.DexEncodedField;
import com.android.tools.r8.graph.DexItemFactory;
import com.android.tools.r8.graph.DexMethod;
import com.android.tools.r8.graph.DexProgramClass;
import com.android.tools.r8.graph.DexType;
import com.android.tools.r8.graph.MethodAccessFlags;
import com.android.tools.r8.ir.desugar.CfClassSynthesizerDesugaringEventConsumer;
import com.android.tools.r8.ir.desugar.desugaredlibrary.apiconversion.DesugaredLibraryAPIConverter;
import com.android.tools.r8.ir.desugar.desugaredlibrary.apiconversion.DesugaredLibraryWrapperSynthesizerEventConsumer;
import com.android.tools.r8.ir.synthetic.DesugaredLibraryAPIConversionCfCodeProvider;
import com.android.tools.r8.synthesis.SyntheticClasspathClassBuilder;
import com.android.tools.r8.synthesis.SyntheticMethodBuilder;
import com.android.tools.r8.synthesis.SyntheticProgramClassBuilder;

public class DesugaredLibraryEnumConversionSynthesizer {
    private final AppView<?> appView;
    private final DexItemFactory factory;

    public DesugaredLibraryEnumConversionSynthesizer(AppView<?> appView) {
        this.appView = appView;
        this.factory = appView.dexItemFactory();
    }

    private void buildEnumConvert(SyntheticMethodBuilder builder, DexType src, DexType dest, SyntheticMethodBuilder.SyntheticCodeGenerator codeGenerator) {
        builder.setName(this.factory.convertMethodName).setProto(this.factory.createProto(dest, src)).setAccessFlags(MethodAccessFlags.fromCfAccessFlags(4105, false)).disableAndroidApiLevelCheck().setCode(codeGenerator);
    }

    private void buildEnumMethodsWithCode(SyntheticProgramClassBuilder builder, Iterable<DexEncodedField> enumFields, DexType enumType, DexType convertType) {
        ((SyntheticProgramClassBuilder)builder.addMethod(methodBuilder -> this.buildEnumConvert((SyntheticMethodBuilder)methodBuilder, enumType, convertType, codeSynthesizor -> new DesugaredLibraryAPIConversionCfCodeProvider.EnumConversionCfCodeProvider(this.appView, codeSynthesizor.getHolderType(), enumFields, enumType, convertType).generateCfCode()))).addMethod(methodBuilder -> this.buildEnumConvert((SyntheticMethodBuilder)methodBuilder, convertType, enumType, codeSynthesizor -> new DesugaredLibraryAPIConversionCfCodeProvider.EnumConversionCfCodeProvider(this.appView, codeSynthesizor.getHolderType(), enumFields, convertType, enumType).generateCfCode()));
    }

    private void buildEnumMethodsWithoutCode(SyntheticClasspathClassBuilder builder, DexType enumType, DexType convertType) {
        ((SyntheticClasspathClassBuilder)builder.addMethod(methodBuilder -> this.buildEnumConvert((SyntheticMethodBuilder)methodBuilder, enumType, convertType, ignored -> null))).addMethod(methodBuilder -> this.buildEnumConvert((SyntheticMethodBuilder)methodBuilder, convertType, enumType, ignored -> null));
    }

    private DexClass ensureEnumConversionClass(DexClass context, DesugaredLibraryWrapperSynthesizerEventConsumer.DesugaredLibraryClasspathWrapperSynthesizeEventConsumer eventConsumer) {
        assert (eventConsumer != null);
        if (context.isProgramClass()) {
            return this.appView.getSyntheticItems().getExistingFixedClass(kinds -> kinds.ENUM_CONVERSION, context, this.appView);
        }
        DexType type = context.type;
        DexType vivifiedType = DesugaredLibraryAPIConverter.vivifiedTypeFor(context.type, this.appView);
        return this.appView.getSyntheticItems().ensureFixedClasspathClass(kinds -> kinds.ENUM_CONVERSION, context.asClasspathOrLibraryClass(), this.appView, builder -> this.buildEnumMethodsWithoutCode((SyntheticClasspathClassBuilder)builder, type, vivifiedType), eventConsumer::acceptEnumConversionClasspathClass);
    }

    DexMethod ensureEnumConversionMethod(DexClass clazz, DexType srcType, DexType destType, DesugaredLibraryWrapperSynthesizerEventConsumer.DesugaredLibraryClasspathWrapperSynthesizeEventConsumer eventConsumer) {
        DexClass enumConversion = this.ensureEnumConversionClass(clazz, eventConsumer);
        DexMethod method = this.factory.createMethod(enumConversion.type, this.factory.createProto(destType, srcType), this.factory.convertMethodName);
        assert (enumConversion.lookupDirectMethod(method) != null);
        return method;
    }

    DexMethod getExistingProgramEnumConversionMethod(DexClass clazz, DexType srcType, DexType destType) {
        DexProgramClass enumConversion = this.appView.getSyntheticItems().getExistingFixedClass(kinds -> kinds.ENUM_CONVERSION, clazz, this.appView);
        DexMethod method = this.factory.createMethod(enumConversion.type, this.factory.createProto(destType, srcType), this.factory.convertMethodName);
        assert (enumConversion.lookupProgramMethod(method) != null);
        return method;
    }

    DexProgramClass ensureProgramEnumConversionClass(DexClass context, CfClassSynthesizerDesugaringEventConsumer eventConsumer) {
        assert (eventConsumer != null);
        assert (context.isProgramClass());
        DexType type = context.type;
        DexType vivifiedType = DesugaredLibraryAPIConverter.vivifiedTypeFor(context.type, this.appView);
        assert (this.appView.options().isDesugaredLibraryCompilation());
        DexProgramClass programContext = context.asProgramClass();
        Iterable<DexEncodedField> enumFields = Iterables.filter(programContext.staticFields(), DexEncodedField::isEnum);
        return this.appView.getSyntheticItems().ensureFixedClass(kinds -> kinds.ENUM_CONVERSION, programContext, this.appView, builder -> this.buildEnumMethodsWithCode((SyntheticProgramClassBuilder)builder, enumFields, type, vivifiedType), eventConsumer::acceptEnumConversionProgramClass);
    }
}

