/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.r8.ir.desugar.desugaredlibrary.humanspecification;

import com.android.tools.r8.graph.DexApplication;
import com.android.tools.r8.ir.desugar.desugaredlibrary.DesugaredLibrarySpecification;
import com.android.tools.r8.ir.desugar.desugaredlibrary.humanspecification.HumanRewritingFlags;
import com.android.tools.r8.ir.desugar.desugaredlibrary.humanspecification.HumanTopLevelFlags;
import com.android.tools.r8.ir.desugar.desugaredlibrary.machinespecification.MachineDesugaredLibrarySpecification;
import com.android.tools.r8.ir.desugar.desugaredlibrary.specificationconversion.HumanToMachineSpecificationConverter;
import com.android.tools.r8.utils.AndroidApiLevel;
import com.android.tools.r8.utils.InternalOptions;
import com.android.tools.r8.utils.Timing;
import java.io.IOException;
import java.nio.file.Path;
import java.util.List;

public class HumanDesugaredLibrarySpecification
implements DesugaredLibrarySpecification {
    private final boolean libraryCompilation;
    private final HumanTopLevelFlags topLevelFlags;
    private final HumanRewritingFlags rewritingFlags;

    public HumanDesugaredLibrarySpecification(HumanTopLevelFlags topLevelFlags, HumanRewritingFlags rewritingFlags, boolean libraryCompilation) {
        this.libraryCompilation = libraryCompilation;
        this.topLevelFlags = topLevelFlags;
        this.rewritingFlags = rewritingFlags;
    }

    public static HumanDesugaredLibrarySpecification empty() {
        return new HumanDesugaredLibrarySpecification(HumanTopLevelFlags.empty(), HumanRewritingFlags.empty(), false);
    }

    @Override
    public boolean isEmpty() {
        return this.rewritingFlags.isEmpty();
    }

    @Override
    public boolean isHuman() {
        return true;
    }

    public boolean supportAllCallbacksFromLibrary() {
        return this.topLevelFlags.supportAllCallbacksFromLibrary();
    }

    @Override
    public AndroidApiLevel getRequiredCompilationApiLevel() {
        return this.topLevelFlags.getRequiredCompilationAPILevel();
    }

    @Override
    public boolean isLibraryCompilation() {
        return this.libraryCompilation;
    }

    @Override
    public String getSynthesizedLibraryClassesPackagePrefix() {
        return this.topLevelFlags.getSynthesizedLibraryClassesPackagePrefix();
    }

    public HumanTopLevelFlags getTopLevelFlags() {
        return this.topLevelFlags;
    }

    public HumanRewritingFlags getRewritingFlags() {
        return this.rewritingFlags;
    }

    public String getIdentifier() {
        return this.topLevelFlags.getIdentifier();
    }

    @Override
    public List<String> getExtraKeepRules() {
        return this.topLevelFlags.getExtraKeepRules();
    }

    @Override
    public String getJsonSource() {
        return this.topLevelFlags.getJsonSource();
    }

    public boolean isEmptyConfiguration() {
        return this.rewritingFlags.isEmpty();
    }

    @Override
    public MachineDesugaredLibrarySpecification toMachineSpecification(DexApplication app, Timing timing) {
        return new HumanToMachineSpecificationConverter(timing).convert(this, app);
    }

    @Override
    public MachineDesugaredLibrarySpecification toMachineSpecification(InternalOptions options, Path library, Timing timing, Path desugaredJDKLib) throws IOException {
        return new HumanToMachineSpecificationConverter(timing).convertForTesting(this, desugaredJDKLib, library, options);
    }
}

