/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.r8.ir.desugar.desugaredlibrary.humanspecification;

import com.android.tools.r8.StringResource;
import com.android.tools.r8.com.google.common.collect.Sets;
import com.android.tools.r8.com.google.gson.JsonArray;
import com.android.tools.r8.com.google.gson.JsonElement;
import com.android.tools.r8.com.google.gson.JsonObject;
import com.android.tools.r8.com.google.gson.JsonParser;
import com.android.tools.r8.graph.DexItemFactory;
import com.android.tools.r8.graph.DexMethod;
import com.android.tools.r8.graph.DexType;
import com.android.tools.r8.ir.desugar.desugaredlibrary.DesugaredLibrarySpecificationParser;
import com.android.tools.r8.ir.desugar.desugaredlibrary.TopLevelFlagsBuilder;
import com.android.tools.r8.ir.desugar.desugaredlibrary.humanspecification.HumanDesugaredLibrarySpecification;
import com.android.tools.r8.ir.desugar.desugaredlibrary.humanspecification.HumanMethodParser;
import com.android.tools.r8.ir.desugar.desugaredlibrary.humanspecification.HumanRewritingFlags;
import com.android.tools.r8.ir.desugar.desugaredlibrary.humanspecification.HumanTopLevelFlags;
import com.android.tools.r8.origin.Origin;
import com.android.tools.r8.utils.AndroidApiLevel;
import com.android.tools.r8.utils.DescriptorUtils;
import com.android.tools.r8.utils.ExceptionDiagnostic;
import com.android.tools.r8.utils.Reporter;
import com.android.tools.r8.utils.StringDiagnostic;
import java.util.ArrayList;
import java.util.Map;
import java.util.Set;
import java.util.function.Consumer;

public class HumanDesugaredLibrarySpecificationParser {
    public static final int CURRENT_HUMAN_CONFIGURATION_FORMAT_VERSION = 100;
    static final String IDENTIFIER_KEY = "identifier";
    static final String REQUIRED_COMPILATION_API_LEVEL_KEY = "required_compilation_api_level";
    static final String SYNTHESIZED_LIBRARY_CLASSES_PACKAGE_PREFIX_KEY = "synthesized_library_classes_package_prefix";
    static final String COMMON_FLAGS_KEY = "common_flags";
    static final String LIBRARY_FLAGS_KEY = "library_flags";
    static final String PROGRAM_FLAGS_KEY = "program_flags";
    static final String API_LEVEL_BELOW_OR_EQUAL_KEY = "api_level_below_or_equal";
    static final String WRAPPER_CONVERSION_KEY = "wrapper_conversion";
    static final String WRAPPER_CONVERSION_EXCLUDING_KEY = "wrapper_conversion_excluding";
    static final String CUSTOM_CONVERSION_KEY = "custom_conversion";
    static final String REWRITE_PREFIX_KEY = "rewrite_prefix";
    static final String RETARGET_METHOD_KEY = "retarget_method";
    static final String RETARGET_METHOD_EMULATED_DISPATCH_KEY = "retarget_method_with_emulated_dispatch";
    static final String REWRITE_DERIVED_PREFIX_KEY = "rewrite_derived_prefix";
    static final String EMULATE_INTERFACE_KEY = "emulate_interface";
    static final String DONT_REWRITE_KEY = "dont_rewrite";
    static final String DONT_RETARGET_KEY = "dont_retarget";
    static final String BACKPORT_KEY = "backport";
    static final String AMEND_LIBRARY_METHOD_KEY = "amend_library_method";
    static final String SHRINKER_CONFIG_KEY = "shrinker_config";
    static final String SUPPORT_ALL_CALLBACKS_FROM_LIBRARY_KEY = "support_all_callbacks_from_library";
    private final DexItemFactory dexItemFactory;
    private final HumanMethodParser methodParser;
    private final Reporter reporter;
    private final boolean libraryCompilation;
    private final int minAPILevel;
    private Origin origin;
    private JsonObject jsonConfig;

    public HumanDesugaredLibrarySpecificationParser(DexItemFactory dexItemFactory, Reporter reporter, boolean libraryCompilation, int minAPILevel) {
        this.dexItemFactory = dexItemFactory;
        this.methodParser = new HumanMethodParser(dexItemFactory);
        this.reporter = reporter;
        this.minAPILevel = minAPILevel;
        this.libraryCompilation = libraryCompilation;
    }

    private HumanRewritingFlags parseRewritingFlags() {
        HumanRewritingFlags.Builder builder = HumanRewritingFlags.builder(this.reporter, this.origin);
        JsonElement commonFlags = this.required(this.jsonConfig, COMMON_FLAGS_KEY);
        JsonElement libraryFlags = this.required(this.jsonConfig, LIBRARY_FLAGS_KEY);
        JsonElement programFlags = this.required(this.jsonConfig, PROGRAM_FLAGS_KEY);
        this.parseFlagsList(commonFlags.getAsJsonArray(), builder);
        this.parseFlagsList(this.libraryCompilation ? libraryFlags.getAsJsonArray() : programFlags.getAsJsonArray(), builder);
        return builder.build();
    }

    private void parseFlagsList(JsonArray jsonFlags, HumanRewritingFlags.Builder builder) {
        for (JsonElement jsonFlagSet : jsonFlags) {
            JsonObject flag = jsonFlagSet.getAsJsonObject();
            int api_level_below_or_equal = this.required(flag, API_LEVEL_BELOW_OR_EQUAL_KEY).getAsInt();
            if (this.minAPILevel > api_level_below_or_equal) continue;
            this.parseFlags(flag, builder);
        }
    }

    private Set<DexMethod> parseMethods(JsonArray array) {
        Set<DexMethod> methods = Sets.newIdentityHashSet();
        for (JsonElement method : array) {
            methods.add(this.parseMethod(method.getAsString()));
        }
        return methods;
    }

    private DexMethod parseMethod(String signature) {
        this.methodParser.parseMethod(signature);
        return this.methodParser.getMethod();
    }

    private DexType stringDescriptorToDexType(String stringClass) {
        return this.dexItemFactory.createType(DescriptorUtils.javaTypeToDescriptor(stringClass));
    }

    public DexItemFactory dexItemFactory() {
        return this.dexItemFactory;
    }

    public Reporter reporter() {
        return this.reporter;
    }

    public JsonObject getJsonConfig() {
        return this.jsonConfig;
    }

    public Origin getOrigin() {
        assert (this.origin != null);
        return this.origin;
    }

    JsonElement required(JsonObject json, String key) {
        if (!json.has(key)) {
            throw this.reporter.fatalError(new StringDiagnostic("Invalid desugared library configuration. Expected required key '" + key + "'", this.origin));
        }
        return json.get(key);
    }

    public HumanDesugaredLibrarySpecification parse(StringResource stringResource) {
        String jsonConfigString = this.parseJson(stringResource);
        return this.parse(this.origin, jsonConfigString, this.jsonConfig, ignored -> {});
    }

    public HumanDesugaredLibrarySpecification parse(Origin origin, String jsonConfigString, JsonObject jsonConfig) {
        return this.parse(origin, jsonConfigString, jsonConfig, ignored -> {});
    }

    public HumanDesugaredLibrarySpecification parse(Origin origin, String jsonConfigString, JsonObject jsonConfig, Consumer<TopLevelFlagsBuilder<?>> topLevelFlagAmender) {
        if (!DesugaredLibrarySpecificationParser.isHumanSpecification(jsonConfig, this.reporter, origin)) {
            this.reporter.error("Attempt to parse a non desugared library human specification as a human specification.");
        }
        this.origin = origin;
        this.jsonConfig = jsonConfig;
        HumanTopLevelFlags topLevelFlags = this.parseTopLevelFlags(jsonConfigString, topLevelFlagAmender);
        HumanRewritingFlags legacyRewritingFlags = this.parseRewritingFlags();
        HumanDesugaredLibrarySpecification config = new HumanDesugaredLibrarySpecification(topLevelFlags, legacyRewritingFlags, this.libraryCompilation);
        this.origin = null;
        return config;
    }

    String parseJson(StringResource stringResource) {
        String jsonConfigString;
        this.setOrigin(stringResource);
        try {
            jsonConfigString = stringResource.getString();
            JsonParser parser = new JsonParser();
            this.jsonConfig = parser.parse(jsonConfigString).getAsJsonObject();
        }
        catch (Exception e) {
            throw this.reporter.fatalError(new ExceptionDiagnostic(e, this.origin));
        }
        return jsonConfigString;
    }

    void setOrigin(StringResource stringResource) {
        this.origin = stringResource.getOrigin();
        assert (this.origin != null);
    }

    HumanTopLevelFlags parseTopLevelFlags(String jsonConfigString, Consumer<TopLevelFlagsBuilder<?>> topLevelFlagAmender) {
        HumanTopLevelFlags.Builder builder = HumanTopLevelFlags.builder();
        builder.setJsonSource(jsonConfigString);
        JsonElement formatVersionElement = this.required(this.jsonConfig, "configuration_format_version");
        int formatVersion = formatVersionElement.getAsInt();
        if (formatVersion != 100) {
            this.reporter.warning(new StringDiagnostic("Human desugared library specification format version " + formatVersion + " mismatches the parser expected version (" + 100 + "). This is allowed and should happen only while extending the specifications.", this.origin));
        }
        String identifier = this.required(this.jsonConfig, IDENTIFIER_KEY).getAsString();
        builder.setDesugaredLibraryIdentifier(identifier);
        builder.setSynthesizedLibraryClassesPackagePrefix(this.required(this.jsonConfig, SYNTHESIZED_LIBRARY_CLASSES_PACKAGE_PREFIX_KEY).getAsString());
        int required_compilation_api_level = this.required(this.jsonConfig, REQUIRED_COMPILATION_API_LEVEL_KEY).getAsInt();
        builder.setRequiredCompilationAPILevel(AndroidApiLevel.getAndroidApiLevel(required_compilation_api_level));
        if (this.jsonConfig.has(SHRINKER_CONFIG_KEY)) {
            JsonArray jsonKeepRules = this.jsonConfig.get(SHRINKER_CONFIG_KEY).getAsJsonArray();
            ArrayList<String> extraKeepRules = new ArrayList<String>(jsonKeepRules.size());
            for (JsonElement keepRule : jsonKeepRules) {
                extraKeepRules.add(keepRule.getAsString());
            }
            builder.setExtraKeepRules(extraKeepRules);
        }
        if (this.jsonConfig.has(SUPPORT_ALL_CALLBACKS_FROM_LIBRARY_KEY)) {
            boolean supportAllCallbacksFromLibrary = this.jsonConfig.get(SUPPORT_ALL_CALLBACKS_FROM_LIBRARY_KEY).getAsBoolean();
            builder.setSupportAllCallbacksFromLibrary(supportAllCallbacksFromLibrary);
        }
        topLevelFlagAmender.accept(builder);
        return builder.build();
    }

    void parseFlags(JsonObject jsonFlagSet, HumanRewritingFlags.Builder builder) {
        if (jsonFlagSet.has(REWRITE_PREFIX_KEY)) {
            for (Map.Entry<String, JsonElement> entry : jsonFlagSet.get(REWRITE_PREFIX_KEY).getAsJsonObject().entrySet()) {
                builder.putRewritePrefix(entry.getKey(), entry.getValue().getAsString());
            }
        }
        if (jsonFlagSet.has(REWRITE_DERIVED_PREFIX_KEY)) {
            for (Map.Entry<String, JsonElement> entry : jsonFlagSet.get(REWRITE_DERIVED_PREFIX_KEY).getAsJsonObject().entrySet()) {
                for (Map.Entry<String, JsonElement> rewriteRule : entry.getValue().getAsJsonObject().entrySet()) {
                    builder.putRewriteDerivedPrefix(entry.getKey(), rewriteRule.getKey(), rewriteRule.getValue().getAsString());
                }
            }
        }
        if (jsonFlagSet.has(RETARGET_METHOD_KEY)) {
            for (Map.Entry<String, JsonElement> entry : jsonFlagSet.get(RETARGET_METHOD_KEY).getAsJsonObject().entrySet()) {
                builder.retargetMethod(this.parseMethod(entry.getKey()), this.stringDescriptorToDexType(entry.getValue().getAsString()));
            }
        }
        if (jsonFlagSet.has(RETARGET_METHOD_EMULATED_DISPATCH_KEY)) {
            for (Map.Entry<String, JsonElement> entry : jsonFlagSet.get(RETARGET_METHOD_EMULATED_DISPATCH_KEY).getAsJsonObject().entrySet()) {
                builder.retargetMethodEmulatedDispatch(this.parseMethod(entry.getKey()), this.stringDescriptorToDexType(entry.getValue().getAsString()));
            }
        }
        if (jsonFlagSet.has(BACKPORT_KEY)) {
            for (Map.Entry<String, JsonElement> entry : jsonFlagSet.get(BACKPORT_KEY).getAsJsonObject().entrySet()) {
                builder.putLegacyBackport(this.stringDescriptorToDexType(entry.getKey()), this.stringDescriptorToDexType(entry.getValue().getAsString()));
            }
        }
        if (jsonFlagSet.has(EMULATE_INTERFACE_KEY)) {
            for (Map.Entry<String, JsonElement> entry : jsonFlagSet.get(EMULATE_INTERFACE_KEY).getAsJsonObject().entrySet()) {
                builder.putEmulatedInterface(this.stringDescriptorToDexType(entry.getKey()), this.stringDescriptorToDexType(entry.getValue().getAsString()));
            }
        }
        if (jsonFlagSet.has(CUSTOM_CONVERSION_KEY)) {
            for (Map.Entry entry : jsonFlagSet.get(CUSTOM_CONVERSION_KEY).getAsJsonObject().entrySet()) {
                builder.putCustomConversion(this.stringDescriptorToDexType((String)entry.getKey()), this.stringDescriptorToDexType(((JsonElement)entry.getValue()).getAsString()));
            }
        }
        if (jsonFlagSet.has(WRAPPER_CONVERSION_KEY)) {
            for (JsonElement jsonElement : jsonFlagSet.get(WRAPPER_CONVERSION_KEY).getAsJsonArray()) {
                builder.addWrapperConversion(this.stringDescriptorToDexType(jsonElement.getAsString()));
            }
        }
        if (jsonFlagSet.has(WRAPPER_CONVERSION_EXCLUDING_KEY)) {
            for (Map.Entry entry : jsonFlagSet.get(WRAPPER_CONVERSION_EXCLUDING_KEY).getAsJsonObject().entrySet()) {
                builder.addWrapperConversion(this.stringDescriptorToDexType((String)entry.getKey()), this.parseMethods(((JsonElement)entry.getValue()).getAsJsonArray()));
            }
        }
        if (jsonFlagSet.has(DONT_REWRITE_KEY)) {
            JsonArray dontRewrite = jsonFlagSet.get(DONT_REWRITE_KEY).getAsJsonArray();
            for (JsonElement rewrite : dontRewrite) {
                builder.addDontRewriteInvocation(this.parseMethod(rewrite.getAsString()));
            }
        }
        if (jsonFlagSet.has(DONT_RETARGET_KEY)) {
            JsonArray dontRetarget = jsonFlagSet.get(DONT_RETARGET_KEY).getAsJsonArray();
            for (JsonElement rewrite : dontRetarget) {
                builder.addDontRetargetLibMember(this.stringDescriptorToDexType(rewrite.getAsString()));
            }
        }
        if (jsonFlagSet.has(AMEND_LIBRARY_METHOD_KEY)) {
            JsonArray amendLibraryMember = jsonFlagSet.get(AMEND_LIBRARY_METHOD_KEY).getAsJsonArray();
            for (JsonElement amend : amendLibraryMember) {
                this.methodParser.parseMethod(amend.getAsString());
                builder.amendLibraryMethod(this.methodParser.getMethod(), this.methodParser.getFlags());
            }
        }
    }
}

