/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.r8.ir.desugar.desugaredlibrary.humanspecification;

import com.android.tools.r8.graph.DexItemFactory;
import com.android.tools.r8.graph.DexMethod;
import com.android.tools.r8.graph.DexProto;
import com.android.tools.r8.graph.DexString;
import com.android.tools.r8.graph.DexType;
import com.android.tools.r8.graph.MethodAccessFlags;
import com.android.tools.r8.ir.desugar.desugaredlibrary.humanspecification.AbstractMethodParser;
import java.util.ArrayList;
import java.util.List;

public class HumanMethodParser
extends AbstractMethodParser {
    private MethodAccessFlags.Builder flagBuilder;
    private DexType returnType;
    private DexType holder;
    private DexString methodName;
    private List<DexType> argTypes;
    private DexMethod method;
    private MethodAccessFlags flags;

    protected HumanMethodParser(DexItemFactory factory) {
        super(factory);
    }

    private boolean parsingFinished() {
        return this.method != null;
    }

    public DexMethod getMethod() {
        assert (this.parsingFinished());
        return this.method;
    }

    public MethodAccessFlags getFlags() {
        assert (this.parsingFinished());
        return this.flags;
    }

    @Override
    protected void modifier(int access) {
        assert (!this.parsingFinished());
        this.flagBuilder.set(access);
    }

    @Override
    protected void holderType(DexType type) {
        assert (!this.parsingFinished());
        this.holder = type;
    }

    @Override
    protected void methodName(DexString name) {
        assert (!this.parsingFinished());
        this.methodName = name;
    }

    @Override
    protected void methodStart() {
        this.flagBuilder = MethodAccessFlags.builder();
        this.returnType = null;
        this.holder = null;
        this.methodName = null;
        this.argTypes = new ArrayList<DexType>();
        this.method = null;
        this.flags = null;
    }

    @Override
    protected void methodEnd() {
        DexProto proto = this.factory.createProto(this.returnType, this.argTypes);
        this.method = this.factory.createMethod(this.holder, proto, this.methodName);
        this.flags = (MethodAccessFlags)this.flagBuilder.build();
    }

    @Override
    protected void returnType(DexType type) {
        assert (!this.parsingFinished());
        this.returnType = type;
    }

    @Override
    protected void argType(DexType type) {
        assert (!this.parsingFinished());
        this.argTypes.add(type);
    }
}

