/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.r8.ir.desugar.desugaredlibrary.humanspecification;

import com.android.tools.r8.com.google.common.collect.ImmutableMap;
import com.android.tools.r8.com.google.common.collect.ImmutableSet;
import com.android.tools.r8.com.google.common.collect.Sets;
import com.android.tools.r8.graph.DexMethod;
import com.android.tools.r8.graph.DexType;
import com.android.tools.r8.graph.MethodAccessFlags;
import com.android.tools.r8.origin.Origin;
import com.android.tools.r8.utils.Reporter;
import com.android.tools.r8.utils.StringDiagnostic;
import java.util.Collections;
import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;

public class HumanRewritingFlags {
    private final Map<String, String> rewritePrefix;
    private final Map<String, Map<String, String>> rewriteDerivedPrefix;
    private final Map<DexType, DexType> emulatedInterfaces;
    private final Map<DexMethod, DexType> retargetMethod;
    private final Map<DexMethod, DexType> retargetMethodEmulatedDispatch;
    private final Map<DexType, DexType> legacyBackport;
    private final Map<DexType, DexType> customConversions;
    private final Set<DexMethod> dontRewriteInvocation;
    private final Set<DexType> dontRetarget;
    private final Map<DexType, Set<DexMethod>> wrapperConversions;
    private final Map<DexMethod, MethodAccessFlags> amendLibraryMethod;

    HumanRewritingFlags(Map<String, String> rewritePrefix, Map<String, Map<String, String>> rewriteDerivedPrefix, Map<DexType, DexType> emulateLibraryInterface, Map<DexMethod, DexType> retargetMethod, Map<DexMethod, DexType> retargetMethodEmulatedDispatch, Map<DexType, DexType> legacyBackport, Map<DexType, DexType> customConversion, Set<DexMethod> dontRewriteInvocation, Set<DexType> dontRetarget, Map<DexType, Set<DexMethod>> wrapperConversion, Map<DexMethod, MethodAccessFlags> amendLibraryMethod) {
        this.rewritePrefix = rewritePrefix;
        this.rewriteDerivedPrefix = rewriteDerivedPrefix;
        this.emulatedInterfaces = emulateLibraryInterface;
        this.retargetMethod = retargetMethod;
        this.retargetMethodEmulatedDispatch = retargetMethodEmulatedDispatch;
        this.legacyBackport = legacyBackport;
        this.customConversions = customConversion;
        this.dontRewriteInvocation = dontRewriteInvocation;
        this.dontRetarget = dontRetarget;
        this.wrapperConversions = wrapperConversion;
        this.amendLibraryMethod = amendLibraryMethod;
    }

    public static HumanRewritingFlags empty() {
        return new HumanRewritingFlags(ImmutableMap.of(), ImmutableMap.of(), ImmutableMap.of(), ImmutableMap.of(), ImmutableMap.of(), ImmutableMap.of(), ImmutableMap.of(), ImmutableSet.of(), ImmutableSet.of(), ImmutableMap.of(), ImmutableMap.of());
    }

    public static Builder builder(Reporter reporter, Origin origin) {
        return new Builder(reporter, origin);
    }

    public Builder newBuilder(Reporter reporter, Origin origin) {
        return new Builder(reporter, origin, this.rewritePrefix, this.rewriteDerivedPrefix, this.emulatedInterfaces, this.retargetMethod, this.retargetMethodEmulatedDispatch, this.legacyBackport, this.customConversions, this.dontRewriteInvocation, this.dontRetarget, this.wrapperConversions, this.amendLibraryMethod);
    }

    public Map<String, String> getRewritePrefix() {
        return this.rewritePrefix;
    }

    public Map<String, Map<String, String>> getRewriteDerivedPrefix() {
        return this.rewriteDerivedPrefix;
    }

    public Map<DexType, DexType> getEmulatedInterfaces() {
        return this.emulatedInterfaces;
    }

    public Map<DexMethod, DexType> getRetargetMethod() {
        return this.retargetMethod;
    }

    public Map<DexMethod, DexType> getRetargetMethodEmulatedDispatch() {
        return this.retargetMethodEmulatedDispatch;
    }

    public Map<DexType, DexType> getLegacyBackport() {
        return this.legacyBackport;
    }

    public Map<DexType, DexType> getCustomConversions() {
        return this.customConversions;
    }

    public Set<DexMethod> getDontRewriteInvocation() {
        return this.dontRewriteInvocation;
    }

    public Set<DexType> getDontRetarget() {
        return this.dontRetarget;
    }

    public Map<DexType, Set<DexMethod>> getWrapperConversions() {
        return this.wrapperConversions;
    }

    public Map<DexMethod, MethodAccessFlags> getAmendLibraryMethod() {
        return this.amendLibraryMethod;
    }

    public boolean isEmpty() {
        return this.rewritePrefix.isEmpty() && this.rewriteDerivedPrefix.isEmpty() && this.emulatedInterfaces.isEmpty() && this.retargetMethod.isEmpty();
    }

    public static class Builder {
        private final Reporter reporter;
        private final Origin origin;
        private final Map<String, String> rewritePrefix;
        private final Map<String, Map<String, String>> rewriteDerivedPrefix;
        private final Map<DexType, DexType> emulatedInterfaces;
        private final Map<DexMethod, DexType> retargetMethod;
        private final Map<DexMethod, DexType> retargetMethodEmulatedDispatch;
        private final Map<DexType, DexType> legacyBackport;
        private final Map<DexType, DexType> customConversions;
        private final Set<DexMethod> dontRewriteInvocation;
        private final Set<DexType> dontRetarget;
        private final Map<DexType, Set<DexMethod>> wrapperConversions;
        private final Map<DexMethod, MethodAccessFlags> amendLibraryMethod;

        Builder(Reporter reporter, Origin origin) {
            this(reporter, origin, new HashMap<String, String>(), new HashMap<String, Map<String, String>>(), new IdentityHashMap<DexType, DexType>(), new IdentityHashMap<DexMethod, DexType>(), new IdentityHashMap<DexMethod, DexType>(), new IdentityHashMap<DexType, DexType>(), new IdentityHashMap<DexType, DexType>(), Sets.newIdentityHashSet(), Sets.newIdentityHashSet(), new IdentityHashMap<DexType, Set<DexMethod>>(), new IdentityHashMap<DexMethod, MethodAccessFlags>());
        }

        Builder(Reporter reporter, Origin origin, Map<String, String> rewritePrefix, Map<String, Map<String, String>> rewriteDerivedPrefix, Map<DexType, DexType> emulateLibraryInterface, Map<DexMethod, DexType> retargetMethod, Map<DexMethod, DexType> retargetMethodEmulatedDispatch, Map<DexType, DexType> backportCoreLibraryMember, Map<DexType, DexType> customConversions, Set<DexMethod> dontRewriteInvocation, Set<DexType> dontRetargetLibMember, Map<DexType, Set<DexMethod>> wrapperConversions, Map<DexMethod, MethodAccessFlags> amendLibrary) {
            this.reporter = reporter;
            this.origin = origin;
            this.rewritePrefix = new HashMap<String, String>(rewritePrefix);
            this.rewriteDerivedPrefix = new HashMap<String, Map<String, String>>(rewriteDerivedPrefix);
            this.emulatedInterfaces = new IdentityHashMap<DexType, DexType>(emulateLibraryInterface);
            this.retargetMethod = new IdentityHashMap<DexMethod, DexType>(retargetMethod);
            this.retargetMethodEmulatedDispatch = new IdentityHashMap<DexMethod, DexType>(retargetMethodEmulatedDispatch);
            this.legacyBackport = new IdentityHashMap<DexType, DexType>(backportCoreLibraryMember);
            this.customConversions = new IdentityHashMap<DexType, DexType>(customConversions);
            this.dontRewriteInvocation = Sets.newIdentityHashSet();
            this.dontRewriteInvocation.addAll(dontRewriteInvocation);
            this.dontRetarget = Sets.newIdentityHashSet();
            this.dontRetarget.addAll(dontRetargetLibMember);
            this.wrapperConversions = new IdentityHashMap<DexType, Set<DexMethod>>(wrapperConversions);
            this.amendLibraryMethod = new IdentityHashMap<DexMethod, MethodAccessFlags>(amendLibrary);
        }

        private <K, V> void put(Map<K, V> map, K key, V value, String desc) {
            if (map.containsKey(key) && !map.get(key).equals(value)) {
                throw this.reporter.fatalError(new StringDiagnostic("Invalid desugared library configuration.  Duplicate assignment of key: '" + key + "' in sections for '" + desc + "'", this.origin));
            }
            map.put(key, value);
        }

        private void validate() {
            Sets.SetView<DexType> dups = Sets.intersection(this.customConversions.keySet(), this.wrapperConversions.keySet());
            if (!dups.isEmpty()) {
                throw this.reporter.fatalError(new StringDiagnostic("Invalid desugared library configuration. Duplicate types in custom conversions and wrapper conversions: " + String.join((CharSequence)", ", dups.stream().map(DexType::toString).collect(Collectors.toSet())), this.origin));
            }
        }

        public Builder putRewritePrefix(String prefix, String rewrittenPrefix) {
            this.put(this.rewritePrefix, prefix, rewrittenPrefix, "rewrite_prefix");
            return this;
        }

        public Builder putRewriteDerivedPrefix(String prefixToMatch, String prefixToRewrite, String rewrittenPrefix) {
            Map map = this.rewriteDerivedPrefix.computeIfAbsent(prefixToMatch, k -> new HashMap());
            this.put(map, prefixToRewrite, rewrittenPrefix, "rewrite_derived_prefix");
            return this;
        }

        public Builder putEmulatedInterface(DexType interfaceType, DexType rewrittenType) {
            this.put(this.emulatedInterfaces, interfaceType, rewrittenType, "emulate_interface");
            return this;
        }

        public Builder putCustomConversion(DexType dexType, DexType conversionType) {
            this.put(this.customConversions, dexType, conversionType, "custom_conversion");
            return this;
        }

        public Builder addWrapperConversion(DexType dexType) {
            return this.addWrapperConversion(dexType, Collections.emptySet());
        }

        public Builder addWrapperConversion(DexType dexType, Set<DexMethod> excludedMethods) {
            this.wrapperConversions.put(dexType, excludedMethods);
            return this;
        }

        public Builder retargetMethod(DexMethod key, DexType rewrittenType) {
            this.put(this.retargetMethod, key, rewrittenType, "retarget_method");
            return this;
        }

        public Builder retargetMethodEmulatedDispatch(DexMethod key, DexType rewrittenType) {
            this.put(this.retargetMethodEmulatedDispatch, key, rewrittenType, "retarget_method_with_emulated_dispatch");
            return this;
        }

        public Builder putLegacyBackport(DexType backportType, DexType rewrittenBackportType) {
            this.put(this.legacyBackport, backportType, rewrittenBackportType, "backport");
            return this;
        }

        public Builder addDontRewriteInvocation(DexMethod dontRewrite) {
            this.dontRewriteInvocation.add(dontRewrite);
            return this;
        }

        public Builder addDontRetargetLibMember(DexType dontRetargetLibMember) {
            this.dontRetarget.add(dontRetargetLibMember);
            return this;
        }

        public Builder amendLibraryMethod(DexMethod member, MethodAccessFlags flags) {
            this.amendLibraryMethod.put(member, flags);
            return this;
        }

        public HumanRewritingFlags build() {
            this.validate();
            return new HumanRewritingFlags(ImmutableMap.copyOf(this.rewritePrefix), ImmutableMap.copyOf(this.rewriteDerivedPrefix), ImmutableMap.copyOf(this.emulatedInterfaces), ImmutableMap.copyOf(this.retargetMethod), ImmutableMap.copyOf(this.retargetMethodEmulatedDispatch), ImmutableMap.copyOf(this.legacyBackport), ImmutableMap.copyOf(this.customConversions), ImmutableSet.copyOf(this.dontRewriteInvocation), ImmutableSet.copyOf(this.dontRetarget), ImmutableMap.copyOf(this.wrapperConversions), ImmutableMap.copyOf(this.amendLibraryMethod));
        }
    }
}

