/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.r8.ir.desugar.desugaredlibrary.humanspecification;

import com.android.tools.r8.graph.DexItem;
import com.android.tools.r8.graph.DexMethod;
import com.android.tools.r8.graph.DexType;
import com.android.tools.r8.graph.MethodAccessFlags;
import com.android.tools.r8.ir.desugar.desugaredlibrary.humanspecification.HumanRewritingFlags;
import com.android.tools.r8.ir.desugar.desugaredlibrary.humanspecification.MultiAPILevelHumanDesugaredLibrarySpecification;
import com.android.tools.r8.it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import com.android.tools.r8.it.unimi.dsi.fastutil.ints.IntArraySet;
import com.android.tools.r8.origin.Origin;
import com.android.tools.r8.utils.Reporter;
import java.util.Map;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Consumer;

public class MultiAPILevelHumanDesugaredLibrarySpecificationFlagDeduplicator {
    public static void deduplicateFlags(MultiAPILevelHumanDesugaredLibrarySpecification specification, Reporter reporter) {
        IntArraySet apis = new IntArraySet();
        apis.addAll(specification.getCommonFlags().keySet());
        apis.addAll(specification.getLibraryFlags().keySet());
        apis.addAll(specification.getProgramFlags().keySet());
        for (Integer api : apis) {
            MultiAPILevelHumanDesugaredLibrarySpecificationFlagDeduplicator.deduplicateFlags(specification, reporter, api);
        }
    }

    private static void deduplicateFlags(MultiAPILevelHumanDesugaredLibrarySpecification specification, Reporter reporter, int api) {
        Int2ObjectMap<HumanRewritingFlags> commonFlags = specification.getCommonFlags();
        Int2ObjectMap<HumanRewritingFlags> libraryFlags = specification.getLibraryFlags();
        Int2ObjectMap<HumanRewritingFlags> programFlags = specification.getProgramFlags();
        HumanRewritingFlags library = (HumanRewritingFlags)libraryFlags.get(api);
        HumanRewritingFlags program = (HumanRewritingFlags)programFlags.get(api);
        if (library == null || program == null) {
            return;
        }
        Origin origin = specification.getOrigin();
        HumanRewritingFlags.Builder commonBuilder = commonFlags.get(api) == null ? HumanRewritingFlags.builder(reporter, origin) : ((HumanRewritingFlags)commonFlags.get(api)).newBuilder(reporter, origin);
        HumanRewritingFlags.Builder libraryBuilder = HumanRewritingFlags.builder(reporter, origin);
        HumanRewritingFlags.Builder programBuilder = HumanRewritingFlags.builder(reporter, origin);
        MultiAPILevelHumanDesugaredLibrarySpecificationFlagDeduplicator.deduplicateFlags(library, program, commonBuilder, libraryBuilder);
        MultiAPILevelHumanDesugaredLibrarySpecificationFlagDeduplicator.deduplicateFlags(program, library, commonBuilder, programBuilder);
        MultiAPILevelHumanDesugaredLibrarySpecificationFlagDeduplicator.putNewFlags(api, commonFlags, commonBuilder);
        MultiAPILevelHumanDesugaredLibrarySpecificationFlagDeduplicator.putNewFlags(api, libraryFlags, libraryBuilder);
        MultiAPILevelHumanDesugaredLibrarySpecificationFlagDeduplicator.putNewFlags(api, programFlags, programBuilder);
    }

    private static void putNewFlags(int api, Int2ObjectMap<HumanRewritingFlags> flags, HumanRewritingFlags.Builder builder) {
        HumanRewritingFlags build = builder.build();
        if (build.isEmpty()) {
            flags.remove(api);
        } else {
            flags.put(api, build);
        }
    }

    private static void deduplicateFlags(HumanRewritingFlags flags, HumanRewritingFlags otherFlags, HumanRewritingFlags.Builder commonBuilder, HumanRewritingFlags.Builder builder) {
        MultiAPILevelHumanDesugaredLibrarySpecificationFlagDeduplicator.deduplicateRewritePrefix(flags, otherFlags, commonBuilder, builder);
        MultiAPILevelHumanDesugaredLibrarySpecificationFlagDeduplicator.deduplicateRewriteDifferentPrefix(flags, otherFlags, commonBuilder, builder);
        MultiAPILevelHumanDesugaredLibrarySpecificationFlagDeduplicator.deduplicateFlags(flags.getEmulatedInterfaces(), otherFlags.getEmulatedInterfaces(), commonBuilder::putEmulatedInterface, builder::putEmulatedInterface);
        MultiAPILevelHumanDesugaredLibrarySpecificationFlagDeduplicator.deduplicateFlags(flags.getRetargetMethod(), otherFlags.getRetargetMethod(), commonBuilder::retargetMethod, builder::retargetMethod);
        MultiAPILevelHumanDesugaredLibrarySpecificationFlagDeduplicator.deduplicateFlags(flags.getRetargetMethodEmulatedDispatch(), otherFlags.getRetargetMethodEmulatedDispatch(), commonBuilder::retargetMethodEmulatedDispatch, builder::retargetMethodEmulatedDispatch);
        MultiAPILevelHumanDesugaredLibrarySpecificationFlagDeduplicator.deduplicateFlags(flags.getLegacyBackport(), otherFlags.getLegacyBackport(), commonBuilder::putLegacyBackport, builder::putLegacyBackport);
        MultiAPILevelHumanDesugaredLibrarySpecificationFlagDeduplicator.deduplicateFlags(flags.getCustomConversions(), otherFlags.getCustomConversions(), commonBuilder::putCustomConversion, builder::putCustomConversion);
        MultiAPILevelHumanDesugaredLibrarySpecificationFlagDeduplicator.deduplicateFlags(flags.getDontRewriteInvocation(), otherFlags.getDontRewriteInvocation(), commonBuilder::addDontRewriteInvocation, builder::addDontRewriteInvocation);
        MultiAPILevelHumanDesugaredLibrarySpecificationFlagDeduplicator.deduplicateFlags(flags.getDontRetarget(), otherFlags.getDontRetarget(), commonBuilder::addDontRetargetLibMember, builder::addDontRetargetLibMember);
        MultiAPILevelHumanDesugaredLibrarySpecificationFlagDeduplicator.deduplicateWrapperFlags(flags, otherFlags, commonBuilder, builder);
        MultiAPILevelHumanDesugaredLibrarySpecificationFlagDeduplicator.deduplicateAmendLibraryMemberFlags(flags, otherFlags, commonBuilder, builder);
    }

    private static void deduplicateWrapperFlags(HumanRewritingFlags flags, HumanRewritingFlags otherFlags, HumanRewritingFlags.Builder commonBuilder, HumanRewritingFlags.Builder builder) {
        Map<DexType, Set<DexMethod>> other = otherFlags.getWrapperConversions();
        flags.getWrapperConversions().forEach((wrapperType, excludedMethods) -> {
            if (other.containsKey(wrapperType)) {
                assert (excludedMethods.equals(other.get(wrapperType)));
                commonBuilder.addWrapperConversion((DexType)wrapperType, (Set<DexMethod>)excludedMethods);
            } else {
                builder.addWrapperConversion((DexType)wrapperType, (Set<DexMethod>)excludedMethods);
            }
        });
    }

    private static void deduplicateAmendLibraryMemberFlags(HumanRewritingFlags flags, HumanRewritingFlags otherFlags, HumanRewritingFlags.Builder commonBuilder, HumanRewritingFlags.Builder builder) {
        Map<DexMethod, MethodAccessFlags> other = otherFlags.getAmendLibraryMethod();
        flags.getAmendLibraryMethod().forEach((k, v) -> {
            if (other.get(k) == v) {
                commonBuilder.amendLibraryMethod((DexMethod)k, (MethodAccessFlags)v);
            } else {
                builder.amendLibraryMethod((DexMethod)k, (MethodAccessFlags)v);
            }
        });
    }

    private static void deduplicateRewriteDifferentPrefix(HumanRewritingFlags flags, HumanRewritingFlags otherFlags, HumanRewritingFlags.Builder commonBuilder, HumanRewritingFlags.Builder builder) {
        flags.getRewriteDerivedPrefix().forEach((prefixToMatch, rewriteRules) -> {
            if (!otherFlags.getRewriteDerivedPrefix().containsKey(prefixToMatch)) {
                rewriteRules.forEach((k, v) -> builder.putRewriteDerivedPrefix((String)prefixToMatch, (String)k, (String)v));
            } else {
                Map<String, String> otherMap = otherFlags.getRewriteDerivedPrefix().get(prefixToMatch);
                rewriteRules.forEach((k, v) -> {
                    if (otherMap.containsKey(k) && ((String)otherMap.get(k)).equals(v)) {
                        commonBuilder.putRewriteDerivedPrefix((String)prefixToMatch, (String)k, (String)v);
                    } else {
                        builder.putRewriteDerivedPrefix((String)prefixToMatch, (String)k, (String)v);
                    }
                });
            }
        });
    }

    private static void deduplicateRewritePrefix(HumanRewritingFlags flags, HumanRewritingFlags otherFlags, HumanRewritingFlags.Builder commonBuilder, HumanRewritingFlags.Builder builder) {
        flags.getRewritePrefix().forEach((k, v) -> {
            if (otherFlags.getRewritePrefix().containsKey(k) && otherFlags.getRewritePrefix().get(k).equals(v)) {
                commonBuilder.putRewritePrefix((String)k, (String)v);
            } else {
                builder.putRewritePrefix((String)k, (String)v);
            }
        });
    }

    private static <T extends DexItem> void deduplicateFlags(Map<T, DexType> flags, Map<T, DexType> otherFlags, BiConsumer<T, DexType> common, BiConsumer<T, DexType> specific) {
        flags.forEach((k, v) -> {
            if (otherFlags.get(k) == v) {
                common.accept((Object)k, (DexType)v);
            } else {
                specific.accept((Object)k, (DexType)v);
            }
        });
    }

    private static <T extends DexItem> void deduplicateFlags(Set<T> flags, Set<T> otherFlags, Consumer<T> common, Consumer<T> specific) {
        flags.forEach(e -> {
            if (otherFlags.contains(e)) {
                common.accept(e);
            } else {
                specific.accept(e);
            }
        });
    }
}

