/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.r8.ir.desugar.desugaredlibrary.humanspecification;

import com.android.tools.r8.DiagnosticsHandler;
import com.android.tools.r8.StringConsumer;
import com.android.tools.r8.com.google.gson.Gson;
import com.android.tools.r8.errors.Unreachable;
import com.android.tools.r8.graph.DexItem;
import com.android.tools.r8.graph.DexMethod;
import com.android.tools.r8.graph.DexType;
import com.android.tools.r8.graph.MethodAccessFlags;
import com.android.tools.r8.ir.desugar.desugaredlibrary.humanspecification.HumanRewritingFlags;
import com.android.tools.r8.ir.desugar.desugaredlibrary.humanspecification.MultiAPILevelHumanDesugaredLibrarySpecification;
import com.android.tools.r8.it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;

public class MultiAPILevelHumanDesugaredLibrarySpecificationJsonExporter {
    public static void export(MultiAPILevelHumanDesugaredLibrarySpecification specification, StringConsumer output) {
        new MultiAPILevelHumanDesugaredLibrarySpecificationJsonExporter().internalExport(specification, output);
    }

    private void internalExport(MultiAPILevelHumanDesugaredLibrarySpecification humanSpec, StringConsumer output) {
        LinkedHashMap<String, Object> toJson = new LinkedHashMap<String, Object>();
        toJson.put("identifier", humanSpec.getTopLevelFlags().getIdentifier());
        toJson.put("configuration_format_version", 100);
        toJson.put("required_compilation_api_level", humanSpec.getTopLevelFlags().getRequiredCompilationAPILevel().getLevel());
        toJson.put("synthesized_library_classes_package_prefix", humanSpec.getTopLevelFlags().getSynthesizedLibraryClassesPackagePrefix().replace('/', '.'));
        toJson.put("support_all_callbacks_from_library", humanSpec.getTopLevelFlags().supportAllCallbacksFromLibrary());
        toJson.put("common_flags", this.rewritingFlagsToString(humanSpec.getCommonFlags()));
        toJson.put("program_flags", this.rewritingFlagsToString(humanSpec.getProgramFlags()));
        toJson.put("library_flags", this.rewritingFlagsToString(humanSpec.getLibraryFlags()));
        toJson.put("shrinker_config", humanSpec.getTopLevelFlags().getExtraKeepRules());
        Gson gson = new Gson();
        String export = gson.toJson(toJson);
        output.accept(export, new DiagnosticsHandler(){});
    }

    private List<Object> rewritingFlagsToString(Int2ObjectMap<HumanRewritingFlags> rewritingFlagsMap) {
        ArrayList<Object> list = new ArrayList<Object>();
        ArrayList<Integer> apis = new ArrayList<Integer>(rewritingFlagsMap.keySet());
        apis.sort(Comparator.reverseOrder());
        for (int apiBelowOrEqual : apis) {
            HumanRewritingFlags flags = (HumanRewritingFlags)rewritingFlagsMap.get(apiBelowOrEqual);
            LinkedHashMap<String, Object> toJson = new LinkedHashMap<String, Object>();
            toJson.put("api_level_below_or_equal", apiBelowOrEqual);
            if (!flags.getRewritePrefix().isEmpty()) {
                toJson.put("rewrite_prefix", new TreeMap<String, String>(flags.getRewritePrefix()));
            }
            if (!flags.getRewriteDerivedPrefix().isEmpty()) {
                TreeMap rewriteDerivedPrefix = new TreeMap();
                flags.getRewriteDerivedPrefix().forEach((k, v) -> {
                    Map cfr_ignored_0 = rewriteDerivedPrefix.put(k, new TreeMap(v));
                });
                toJson.put("rewrite_derived_prefix", rewriteDerivedPrefix);
            }
            if (!flags.getEmulatedInterfaces().isEmpty()) {
                toJson.put("emulate_interface", this.mapToString(flags.getEmulatedInterfaces()));
            }
            if (!flags.getDontRewriteInvocation().isEmpty()) {
                toJson.put("dont_rewrite", this.setToString(flags.getDontRewriteInvocation()));
            }
            if (!flags.getRetargetMethod().isEmpty()) {
                toJson.put("retarget_method", this.mapToString(flags.getRetargetMethod()));
            }
            if (!flags.getRetargetMethodEmulatedDispatch().isEmpty()) {
                toJson.put("retarget_method_with_emulated_dispatch", this.mapToString(flags.getRetargetMethodEmulatedDispatch()));
            }
            if (!flags.getDontRetarget().isEmpty()) {
                toJson.put("dont_retarget", this.setToString(flags.getDontRetarget()));
            }
            if (!flags.getLegacyBackport().isEmpty()) {
                toJson.put("backport", this.mapToString(flags.getLegacyBackport()));
            }
            if (!flags.getWrapperConversions().isEmpty()) {
                this.registerWrapperConversions(toJson, flags.getWrapperConversions());
            }
            if (!flags.getCustomConversions().isEmpty()) {
                toJson.put("custom_conversion", this.mapToString(flags.getCustomConversions()));
            }
            if (!flags.getAmendLibraryMethod().isEmpty()) {
                toJson.put("amend_library_method", this.amendLibraryToString(flags.getAmendLibraryMethod()));
            }
            list.add(toJson);
        }
        return list;
    }

    private void registerWrapperConversions(Map<String, Object> toJson, Map<DexType, Set<DexMethod>> wrapperConversions) {
        ArrayList stringSet = new ArrayList();
        TreeMap stringMap = new TreeMap();
        wrapperConversions.forEach((k, v) -> {
            if (v.isEmpty()) {
                stringSet.add(this.toString((DexItem)k));
            } else {
                stringMap.put(this.toString((DexItem)k), this.setToString((Set<? extends DexItem>)v));
            }
        });
        toJson.put("wrapper_conversion", stringSet);
        toJson.put("wrapper_conversion_excluding", stringMap);
    }

    private List<String> amendLibraryToString(Map<DexMethod, MethodAccessFlags> amendLibraryMembers) {
        ArrayList<String> stringSet = new ArrayList<String>();
        amendLibraryMembers.forEach((member, flags) -> stringSet.add(flags.toString() + " " + this.toString((DexItem)member)));
        return stringSet;
    }

    private List<String> setToString(Set<? extends DexItem> set) {
        ArrayList<String> stringSet = new ArrayList<String>();
        set.forEach(e -> stringSet.add(this.toString((DexItem)e)));
        return stringSet;
    }

    private Map<String, String> mapToString(Map<? extends DexItem, ? extends DexItem> map) {
        TreeMap<String, String> stringMap = new TreeMap<String, String>();
        map.forEach((k, v) -> stringMap.put(this.toString((DexItem)k), this.toString((DexItem)v)));
        return stringMap;
    }

    private String toString(DexItem o) {
        if (o instanceof DexType) {
            return o.toString();
        }
        if (o instanceof DexMethod) {
            DexMethod method = (DexMethod)o;
            StringBuilder sb = new StringBuilder().append(method.getReturnType()).append(" ").append(method.getHolderType()).append("#").append(method.getName()).append("(");
            for (int i = 0; i < method.getParameters().size(); ++i) {
                sb.append(method.getParameter(i));
                if (i == method.getParameters().size() - 1) continue;
                sb.append(", ");
            }
            sb.append(")");
            return sb.toString();
        }
        throw new Unreachable();
    }
}

