/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.r8.ir.desugar.desugaredlibrary.legacyspecification;

import com.android.tools.r8.com.google.common.collect.ImmutableList;
import com.android.tools.r8.com.google.common.collect.ImmutableMap;
import com.android.tools.r8.com.google.common.collect.ImmutableSet;
import com.android.tools.r8.com.google.common.collect.Sets;
import com.android.tools.r8.errors.CompilationError;
import com.android.tools.r8.graph.DexItemFactory;
import com.android.tools.r8.graph.DexString;
import com.android.tools.r8.graph.DexType;
import com.android.tools.r8.origin.Origin;
import com.android.tools.r8.utils.DescriptorUtils;
import com.android.tools.r8.utils.Pair;
import com.android.tools.r8.utils.Reporter;
import com.android.tools.r8.utils.StringDiagnostic;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;

public class LegacyRewritingFlags {
    private final Map<String, String> rewritePrefix;
    private final Map<DexType, DexType> emulateLibraryInterface;
    private final Map<DexString, Map<DexType, DexType>> retargetCoreLibMember;
    private final Map<DexType, DexType> backportCoreLibraryMember;
    private final Map<DexType, DexType> customConversions;
    private final List<Pair<DexType, DexString>> dontRewriteInvocation;
    private final Set<DexType> dontRetargetLibMember;
    private final Set<DexType> wrapperConversions;

    LegacyRewritingFlags(Map<String, String> rewritePrefix, Map<DexType, DexType> emulateLibraryInterface, Map<DexString, Map<DexType, DexType>> retargetCoreLibMember, Map<DexType, DexType> backportCoreLibraryMember, Map<DexType, DexType> customConversions, List<Pair<DexType, DexString>> dontRewriteInvocation, Set<DexType> dontRetargetLibMember, Set<DexType> wrapperConversions) {
        this.rewritePrefix = rewritePrefix;
        this.emulateLibraryInterface = emulateLibraryInterface;
        this.retargetCoreLibMember = retargetCoreLibMember;
        this.backportCoreLibraryMember = backportCoreLibraryMember;
        this.customConversions = customConversions;
        this.dontRewriteInvocation = dontRewriteInvocation;
        this.dontRetargetLibMember = dontRetargetLibMember;
        this.wrapperConversions = wrapperConversions;
    }

    public static LegacyRewritingFlags empty() {
        return new LegacyRewritingFlags(ImmutableMap.of(), ImmutableMap.of(), ImmutableMap.of(), ImmutableMap.of(), ImmutableMap.of(), ImmutableList.of(), ImmutableSet.of(), ImmutableSet.of());
    }

    public static Builder builder(DexItemFactory dexItemFactory, Reporter reporter, Origin origin) {
        return new Builder(dexItemFactory, reporter, origin);
    }

    public Builder newBuilder(DexItemFactory dexItemFactory, Reporter reporter, Origin origin) {
        return new Builder(dexItemFactory, reporter, origin, this.rewritePrefix, this.emulateLibraryInterface, this.retargetCoreLibMember, this.backportCoreLibraryMember, this.customConversions, this.dontRewriteInvocation, this.dontRetargetLibMember, this.wrapperConversions);
    }

    public Map<String, String> getRewritePrefix() {
        return this.rewritePrefix;
    }

    public Map<DexType, DexType> getEmulateLibraryInterface() {
        return this.emulateLibraryInterface;
    }

    public Map<DexString, Map<DexType, DexType>> getRetargetCoreLibMember() {
        return this.retargetCoreLibMember;
    }

    public Map<DexType, DexType> getBackportCoreLibraryMember() {
        return this.backportCoreLibraryMember;
    }

    public Map<DexType, DexType> getCustomConversions() {
        return this.customConversions;
    }

    public List<Pair<DexType, DexString>> getDontRewriteInvocation() {
        return this.dontRewriteInvocation;
    }

    public Set<DexType> getDontRetargetLibMember() {
        return this.dontRetargetLibMember;
    }

    public Set<DexType> getWrapperConversions() {
        return this.wrapperConversions;
    }

    public boolean isEmpty() {
        return this.rewritePrefix.isEmpty() && this.emulateLibraryInterface.isEmpty() && this.retargetCoreLibMember.isEmpty();
    }

    public static class Builder {
        private final DexItemFactory factory;
        private final Reporter reporter;
        private final Origin origin;
        private final Map<String, String> rewritePrefix;
        private final Map<DexType, DexType> emulateLibraryInterface;
        private final Map<DexString, Map<DexType, DexType>> retargetCoreLibMember;
        private final Map<DexType, DexType> backportCoreLibraryMember;
        private final Map<DexType, DexType> customConversions;
        private final List<Pair<DexType, DexString>> dontRewriteInvocation;
        private final Set<DexType> dontRetargetLibMember;
        private final Set<DexType> wrapperConversions;

        Builder(DexItemFactory factory, Reporter reporter, Origin origin) {
            this(factory, reporter, origin, new HashMap<String, String>(), new IdentityHashMap<DexType, DexType>(), new IdentityHashMap<DexString, Map<DexType, DexType>>(), new IdentityHashMap<DexType, DexType>(), new IdentityHashMap<DexType, DexType>(), new ArrayList<Pair<DexType, DexString>>(), Sets.newIdentityHashSet(), Sets.newIdentityHashSet());
        }

        Builder(DexItemFactory factory, Reporter reporter, Origin origin, Map<String, String> rewritePrefix, Map<DexType, DexType> emulateLibraryInterface, Map<DexString, Map<DexType, DexType>> retargetCoreLibMember, Map<DexType, DexType> backportCoreLibraryMember, Map<DexType, DexType> customConversions, List<Pair<DexType, DexString>> dontRewriteInvocation, Set<DexType> dontRetargetLibMember, Set<DexType> wrapperConversions) {
            this.factory = factory;
            this.reporter = reporter;
            this.origin = origin;
            this.rewritePrefix = new HashMap<String, String>(rewritePrefix);
            this.emulateLibraryInterface = new IdentityHashMap<DexType, DexType>(emulateLibraryInterface);
            this.retargetCoreLibMember = new IdentityHashMap<DexString, Map<DexType, DexType>>(retargetCoreLibMember);
            this.backportCoreLibraryMember = new IdentityHashMap<DexType, DexType>(backportCoreLibraryMember);
            this.customConversions = new IdentityHashMap<DexType, DexType>(customConversions);
            this.dontRewriteInvocation = new ArrayList<Pair<DexType, DexString>>(dontRewriteInvocation);
            this.dontRetargetLibMember = Sets.newIdentityHashSet();
            this.dontRetargetLibMember.addAll(dontRetargetLibMember);
            this.wrapperConversions = Sets.newIdentityHashSet();
            this.wrapperConversions.addAll(wrapperConversions);
        }

        private <K, V> void put(Map<K, V> map, K key, V value, String desc) {
            if (map.containsKey(key)) {
                throw this.reporter.fatalError(new StringDiagnostic("Invalid desugared library configuration.  Duplicate assignment of key: '" + key + "' in sections for '" + desc + "'", this.origin));
            }
            map.put(key, value);
        }

        private int sharpIndex(String typeAndSelector, String descr) {
            int index = typeAndSelector.lastIndexOf(35);
            if (index <= 0 || index >= typeAndSelector.length() - 1) {
                throw new CompilationError("Invalid " + descr + " specification (# position) in " + typeAndSelector + ".");
            }
            return index;
        }

        private DexType stringClassToDexType(String stringClass) {
            return this.factory.createType(DescriptorUtils.javaTypeToDescriptor(stringClass));
        }

        private void validate() {
            Sets.SetView<DexType> dups = Sets.intersection(this.customConversions.keySet(), this.wrapperConversions);
            if (!dups.isEmpty()) {
                throw this.reporter.fatalError(new StringDiagnostic("Invalid desugared library configuration. Duplicate types in custom conversions and wrapper conversions: " + String.join((CharSequence)", ", dups.stream().map(DexType::toString).collect(Collectors.toSet())), this.origin));
            }
        }

        public Builder putRewritePrefix(String prefix, String rewrittenPrefix) {
            this.put(this.rewritePrefix, prefix, rewrittenPrefix, "rewrite_prefix");
            return this;
        }

        public Builder putEmulateLibraryInterface(String emulateLibraryItf, String rewrittenEmulateLibraryItf) {
            DexType interfaceType = this.stringClassToDexType(emulateLibraryItf);
            DexType rewrittenType = this.stringClassToDexType(rewrittenEmulateLibraryItf);
            this.put(this.emulateLibraryInterface, interfaceType, rewrittenType, "emulate_interface");
            return this;
        }

        public Builder putCustomConversion(String type, String conversionHolder) {
            DexType dexType = this.stringClassToDexType(type);
            DexType conversionType = this.stringClassToDexType(conversionHolder);
            this.put(this.customConversions, dexType, conversionType, "custom_conversion");
            return this;
        }

        public Builder addWrapperConversion(String type) {
            DexType dexType = this.stringClassToDexType(type);
            this.wrapperConversions.add(dexType);
            return this;
        }

        public Builder putRetargetCoreLibMember(String retarget, String rewrittenRetarget) {
            int index = this.sharpIndex(retarget, "retarget core library member");
            DexString methodName = this.factory.createString(retarget.substring(index + 1));
            this.retargetCoreLibMember.putIfAbsent(methodName, new IdentityHashMap());
            Map<DexType, DexType> typeMap = this.retargetCoreLibMember.get(methodName);
            DexType originalType = this.stringClassToDexType(retarget.substring(0, index));
            DexType finalType = this.stringClassToDexType(rewrittenRetarget);
            assert (!typeMap.containsKey(originalType));
            this.put(typeMap, originalType, finalType, "retarget_lib_member");
            return this;
        }

        public Builder putBackportCoreLibraryMember(String backport, String rewrittenBackport) {
            DexType backportType = this.stringClassToDexType(backport);
            DexType rewrittenBackportType = this.stringClassToDexType(rewrittenBackport);
            this.put(this.backportCoreLibraryMember, backportType, rewrittenBackportType, "backport");
            return this;
        }

        public Builder addDontRewriteInvocation(String dontRewriteInvocation) {
            int index = this.sharpIndex(dontRewriteInvocation, "don't rewrite");
            this.dontRewriteInvocation.add(new Pair<DexType, DexString>(this.stringClassToDexType(dontRewriteInvocation.substring(0, index)), this.factory.createString(dontRewriteInvocation.substring(index + 1))));
            return this;
        }

        public Builder addDontRetargetLibMember(String dontRetargetLibMember) {
            this.dontRetargetLibMember.add(this.stringClassToDexType(dontRetargetLibMember));
            return this;
        }

        public LegacyRewritingFlags build() {
            this.validate();
            return new LegacyRewritingFlags(ImmutableMap.copyOf(this.rewritePrefix), ImmutableMap.copyOf(this.emulateLibraryInterface), ImmutableMap.copyOf(this.retargetCoreLibMember), ImmutableMap.copyOf(this.backportCoreLibraryMember), ImmutableMap.copyOf(this.customConversions), ImmutableList.copyOf(this.dontRewriteInvocation), ImmutableSet.copyOf(this.dontRetargetLibMember), ImmutableSet.copyOf(this.wrapperConversions));
        }
    }
}

