/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.r8.ir.desugar.desugaredlibrary.machinespecification;

import com.android.tools.r8.graph.DexMethod;
import com.android.tools.r8.graph.DexReference;
import com.android.tools.r8.graph.DexType;
import com.android.tools.r8.graph.MethodAccessFlags;
import com.android.tools.r8.ir.desugar.desugaredlibrary.machinespecification.CustomConversionDescriptor;
import com.android.tools.r8.ir.desugar.desugaredlibrary.machinespecification.EmulatedDispatchMethodDescriptor;
import com.android.tools.r8.ir.desugar.desugaredlibrary.machinespecification.EmulatedInterfaceDescriptor;
import com.android.tools.r8.ir.desugar.desugaredlibrary.machinespecification.MachineRewritingFlags;
import com.android.tools.r8.ir.desugar.desugaredlibrary.machinespecification.MachineTopLevelFlags;
import com.android.tools.r8.utils.AndroidApiLevel;
import com.android.tools.r8.utils.SemanticVersion;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Consumer;

public class MachineDesugaredLibrarySpecification {
    private final boolean libraryCompilation;
    private final MachineTopLevelFlags topLevelFlags;
    private final MachineRewritingFlags rewritingFlags;
    private int leadingVersionNumberCache = -1;

    public static MachineDesugaredLibrarySpecification empty() {
        return new MachineDesugaredLibrarySpecification(false, MachineTopLevelFlags.empty(), MachineRewritingFlags.builder().build()){

            @Override
            public boolean isSupported(DexReference reference) {
                return false;
            }
        };
    }

    public static MachineDesugaredLibrarySpecification withOnlyRewriteTypeForTesting(Map<DexType, DexType> rewriteTypeForTesting) {
        MachineRewritingFlags.Builder builder = MachineRewritingFlags.builder();
        rewriteTypeForTesting.forEach(builder::rewriteType);
        return new MachineDesugaredLibrarySpecification(true, MachineTopLevelFlags.empty(), builder.build());
    }

    public MachineDesugaredLibrarySpecification(boolean libraryCompilation, MachineTopLevelFlags topLevelFlags, MachineRewritingFlags rewritingFlags) {
        this.libraryCompilation = libraryCompilation;
        this.topLevelFlags = topLevelFlags;
        this.rewritingFlags = rewritingFlags;
    }

    private int getLeadingVersionNumber() {
        if (this.leadingVersionNumberCache != -1) {
            return this.leadingVersionNumberCache;
        }
        String[] split = this.topLevelFlags.getIdentifier().split(":");
        this.leadingVersionNumberCache = SemanticVersion.parse(split[split.length - 1]).getMajor();
        return this.leadingVersionNumberCache;
    }

    public boolean isLibraryCompilation() {
        return this.libraryCompilation;
    }

    public AndroidApiLevel getRequiredCompilationAPILevel() {
        return this.topLevelFlags.getRequiredCompilationAPILevel();
    }

    public String getSynthesizedLibraryClassesPackagePrefix() {
        return this.topLevelFlags.getSynthesizedLibraryClassesPackagePrefix();
    }

    public String getIdentifier() {
        return this.topLevelFlags.getIdentifier();
    }

    public String getJsonSource() {
        return this.topLevelFlags.getJsonSource();
    }

    public boolean supportAllCallbacksFromLibrary() {
        return this.topLevelFlags.supportAllCallbacksFromLibrary();
    }

    public List<String> getExtraKeepRules() {
        return this.topLevelFlags.getExtraKeepRules();
    }

    public Map<DexType, DexType> getRewriteType() {
        return this.rewritingFlags.getRewriteType();
    }

    public Map<DexType, DexType> getRewriteDerivedTypeOnly() {
        return this.rewritingFlags.getRewriteDerivedTypeOnly();
    }

    public Map<DexMethod, DexMethod> getStaticRetarget() {
        return this.rewritingFlags.getStaticRetarget();
    }

    public Map<DexMethod, DexMethod> getNonEmulatedVirtualRetarget() {
        return this.rewritingFlags.getNonEmulatedVirtualRetarget();
    }

    public Map<DexMethod, EmulatedDispatchMethodDescriptor> getEmulatedVirtualRetarget() {
        return this.rewritingFlags.getEmulatedVirtualRetarget();
    }

    public Map<DexMethod, DexMethod> getEmulatedVirtualRetargetThroughEmulatedInterface() {
        return this.rewritingFlags.getEmulatedVirtualRetargetThroughEmulatedInterface();
    }

    public void forEachRetargetMethod(Consumer<DexMethod> consumer) {
        this.rewritingFlags.forEachRetargetMethod(consumer);
    }

    public Map<DexType, EmulatedInterfaceDescriptor> getEmulatedInterfaces() {
        return this.rewritingFlags.getEmulatedInterfaces();
    }

    public EmulatedDispatchMethodDescriptor getEmulatedInterfaceEmulatedDispatchMethodDescriptor(DexMethod method) {
        return this.rewritingFlags.getEmulatedInterfaceEmulatedDispatchMethodDescriptor(method);
    }

    public boolean isCustomConversionRewrittenType(DexType type) {
        return this.rewritingFlags.isCustomConversionRewrittenType(type);
    }

    public boolean isEmulatedInterfaceRewrittenType(DexType type) {
        return this.rewritingFlags.isEmulatedInterfaceRewrittenType(type);
    }

    public Map<DexType, List<DexMethod>> getWrappers() {
        return this.rewritingFlags.getWrappers();
    }

    public Map<DexType, DexType> getLegacyBackport() {
        return this.rewritingFlags.getLegacyBackport();
    }

    public Set<DexType> getDontRetarget() {
        return this.rewritingFlags.getDontRetarget();
    }

    public Map<DexType, CustomConversionDescriptor> getCustomConversions() {
        return this.rewritingFlags.getCustomConversions();
    }

    public Map<DexMethod, MethodAccessFlags> getAmendLibraryMethods() {
        return this.rewritingFlags.getAmendLibraryMethod();
    }

    public boolean hasRetargeting() {
        return this.rewritingFlags.hasRetargeting();
    }

    public boolean hasEmulatedInterfaces() {
        return this.rewritingFlags.hasEmulatedInterfaces();
    }

    public boolean isSupported(DexReference reference) {
        if (this.rewritingFlags.getRewriteType().containsKey(reference.getContextType())) {
            return true;
        }
        if (!reference.isDexMethod()) {
            return false;
        }
        DexMethod dexMethod = reference.asDexMethod();
        if (this.getStaticRetarget().containsKey(dexMethod) || this.getNonEmulatedVirtualRetarget().containsKey(dexMethod) || this.getEmulatedVirtualRetarget().containsKey(dexMethod)) {
            return true;
        }
        for (EmulatedInterfaceDescriptor descriptor : this.getEmulatedInterfaces().values()) {
            if (!descriptor.getEmulatedMethods().containsKey(dexMethod)) continue;
            return true;
        }
        return false;
    }

    public AndroidApiLevel getRequiredCompilationApiLevel() {
        return this.topLevelFlags.getRequiredCompilationAPILevel();
    }

    public boolean includesJDK11Methods() {
        return this.getLeadingVersionNumber() >= 2;
    }
}

